/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.config;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.print.config.AbstractXmlTranslate;
import com.kingdee.cosmic.ctrl.print.config.IConfigModel;
import com.kingdee.cosmic.ctrl.print.config.IXmlTranslate;
import com.kingdee.cosmic.ctrl.print.config.PrintJobConfig;
import java.util.Map;

public class PrintJobConfigXml
extends AbstractXmlTranslate {
    public static String NAME = "printjob";
    public static String CHILD_DynamicPaper = "dynamicpaper";

    public PrintJobConfigXml(IConfigModel model) {
        super(model);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public IXmlElement toXmlElement() {
        this.createRoot(this.model);
        int pageCount = ((PrintJobConfig)this.model).printJob.getPageCount();
        PrintJobConfigXml.setAttribute(this.rootElement, "pageCount", pageCount);
        this.toChildModelXmlElement();
        this.toDynamicPaper(((PrintJobConfig)this.model).isDynamicPaper());
        return this.rootElement;
    }

    private void toChildModelXmlElement() {
        PrintJobConfig printModel = (PrintJobConfig)this.model;
        Map configPanes = printModel.getConfigPanes();
        for (Map.Entry entry : configPanes.entrySet()) {
            IXmlTranslate xmlranslate;
            PrintJobConfig.OneConfigPage page = (PrintJobConfig.OneConfigPage)entry.getValue();
            IConfigModel model = page.getConfigModel();
            if (model == null || !page.isVisible() || (xmlranslate = model.createXmlTrans()) == null) continue;
            IXmlElement childElement = xmlranslate.toXmlElement();
            this.rootElement.addChild(childElement);
        }
    }

    private void toDynamicPaper(boolean isFrugal) {
        IXmlElement e = PrintJobConfigXml.createElement(CHILD_DynamicPaper);
        e.addCData(String.valueOf(isFrugal));
        this.rootElement.addChild(e);
    }

    @Override
    public Object fromXmlElement(IXmlElement element) {
        if (element == null) {
            return null;
        }
        if (!element.getName().equals(NAME)) {
            element = element.getChild(NAME);
        }
        if (!element.getName().equals(NAME)) {
            element = element.getChild(NAME);
            return null;
        }
        PrintJobConfig printModel = (PrintJobConfig)this.model;
        this.fromDynamicPaper(PrintJobConfigXml.getChild(element, CHILD_DynamicPaper));
        Map configPanes = printModel.getConfigPanes();
        for (Map.Entry entry : configPanes.entrySet()) {
            IXmlElement child;
            IXmlTranslate xmlranslate;
            PrintJobConfig.OneConfigPage page = (PrintJobConfig.OneConfigPage)entry.getValue();
            IConfigModel model = page.getConfigModel();
            if (model == null) {
                page.createModel();
            }
            if ((model = page.getConfigModel()) == null || !page.isVisible() || (xmlranslate = model.createXmlTrans()) == null || (child = PrintJobConfigXml.getChild(element, xmlranslate.getName())) == null) continue;
            xmlranslate.fromXmlElement(child);
        }
        return this;
    }

    private void fromDynamicPaper(IXmlElement child) {
        PrintJobConfig configModel = (PrintJobConfig)this.model;
        if (child == null) {
            configModel.setDynamicPaper(false);
        } else {
            String text = child.getText();
            if (text != null) {
                configModel.setDynamicPaper(text.equals("true"));
            }
        }
    }
}

