/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.config.extendui;

import com.kingdee.cosmic.ctrl.print.config.IConfigModel;
import com.kingdee.cosmic.ctrl.print.config.extendui.ImageSetupModel;
import com.kingdee.cosmic.ctrl.print.config.ui.AbstractConfigUI;
import com.kingdee.cosmic.ctrl.print.config.ui.SunPrintConfigDialog;
import com.kingdee.cosmic.ctrl.print.resource.Resources;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDRadioButton;
import com.kingdee.cosmic.ctrl.swing.KDTextArea;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;

public class ImageSetupUI
extends AbstractConfigUI {
    private static final long serialVersionUID = 3404727756002159610L;
    private static final int PAGE_W = 410;
    private static final int GAP = 5;
    private KDRadioButton fit_Paper;
    private KDRadioButton fact_Size;
    private KDRadioButton auto_Cut;
    private KDTextArea promptLabel;
    private KDComboBox hAlignCombo;
    private KDComboBox vAlignCombo;
    private static final String[] hStaticAlignNames = new String[]{ImageSetupUI.getMsg("comobox.hLeft"), ImageSetupUI.getMsg("comobox.hCenter"), ImageSetupUI.getMsg("comobox.hRight")};
    private static final String[] vStaticAlignNames = new String[]{ImageSetupUI.getMsg("comobox.vTop"), ImageSetupUI.getMsg("comobox.vCenter"), ImageSetupUI.getMsg("comobox.vBottom")};

    public ImageSetupUI() {
        this.setLayout(null);
        ImagePanel pnlOrder = new ImagePanel();
        this.add((Component)((Object)pnlOrder));
        int x = 5;
        int y = 5;
        int h = pnlOrder.getPreferredSize().height;
        int w = 400;
        pnlOrder.setBounds(x, y, w, h);
        y = y + h + 5;
        AlignPanel pnlAlign = new AlignPanel();
        h = pnlAlign.getPreferredSize().height;
        pnlAlign.setBounds(x, y, w, h);
        this.add((Component)((Object)pnlAlign));
        this.setPreferredSize(new Dimension(425, 350));
    }

    @Override
    public IConfigModel createConfigModel() {
        return new ImageSetupModel();
    }

    @Override
    public void updateConfigToUI() {
        ImageSetupModel model = (ImageSetupModel)this.config;
        int mode = model.getMode();
        if (mode == 0) {
            this.fit_Paper.setSelected(true);
            this.promptLabel.setText(ImageSetupUI.getMsg("label.fitpaper"));
        } else if (mode == 1) {
            this.fact_Size.setSelected(true);
            this.promptLabel.setText(ImageSetupUI.getMsg("label.factsize"));
        } else if (mode == 2) {
            this.auto_Cut.setSelected(true);
            this.promptLabel.setText(ImageSetupUI.getMsg("label.autocut"));
        }
        int hAlign = model.getHorizontalAlignment();
        int vAlign = model.getVerticalAlignment();
        this.hAlignCombo.setSelectedIndex(hAlign);
        this.vAlignCombo.setSelectedIndex(vAlign);
    }

    @Override
    public void approve() {
        ImageSetupModel model = (ImageSetupModel)this.config;
        int last = model.getMode();
        int lastHalign = model.getHorizontalAlignment();
        int lastValign = model.getVerticalAlignment();
        if (this.fit_Paper.isSelected()) {
            model.setMode(0);
        } else if (this.fact_Size.isSelected()) {
            model.setMode(1);
        }
        if (this.auto_Cut.isSelected()) {
            model.setMode(2);
        }
        int hAlign = this.hAlignCombo.getSelectedIndex();
        model.setHorizontalAlignment(hAlign);
        int vAlign = this.vAlignCombo.getSelectedIndex();
        model.setVerticalAlignment(vAlign);
        this.manager.setChange(model.getMode() != last || lastHalign != model.getHorizontalAlignment() || lastValign != model.getVerticalAlignment());
    }

    private static String getMsg(String key) {
        return Resources.getMsg(key);
    }

    private class AlignPanel
    extends KDPanel {
        private static final long serialVersionUID = 352766590390225808L;

        public AlignPanel() {
            this.setOpaque(false);
            this.setLayout(SunPrintConfigDialog.LineLayout.LIGHTWEIGHT);
            this.setBorder(BorderFactory.createTitledBorder(ImageSetupUI.getMsg("border.alignName")));
            Object[] hAlignNames = hStaticAlignNames;
            ImageSetupUI.this.hAlignCombo = new KDComboBox(hAlignNames);
            String str = ImageSetupUI.getMsg("label.hAlign");
            SunPrintConfigDialog.LinedLabel lineHalign = SunPrintConfigDialog.L(str, (JComponent)ImageSetupUI.this.hAlignCombo);
            this.add((Component)((Object)lineHalign));
            Object[] vAlignNames = vStaticAlignNames;
            ImageSetupUI.this.vAlignCombo = new KDComboBox(vAlignNames);
            str = ImageSetupUI.getMsg("label.vAlign");
            SunPrintConfigDialog.LinedLabel lineValign = SunPrintConfigDialog.L(str, (JComponent)ImageSetupUI.this.vAlignCombo);
            this.add((Component)((Object)lineValign));
        }
    }

    private class ImagePanel
    extends KDPanel
    implements ActionListener {
        private static final long serialVersionUID = 7706391734904682584L;

        public ImagePanel() {
            this.setOpaque(false);
            this.setLayout(null);
            this.setBorder(BorderFactory.createTitledBorder(ImageSetupUI.getMsg("border.imageMode")));
            ButtonGroup bg = new ButtonGroup();
            ImageSetupUI.this.fit_Paper = new KDRadioButton(ImageSetupUI.getMsg("radiobutton.fitpaper"));
            ImageSetupUI.this.fact_Size = new KDRadioButton(ImageSetupUI.getMsg("radiobutton.factsize"));
            ImageSetupUI.this.auto_Cut = new KDRadioButton(ImageSetupUI.getMsg("radiobutton.autocut"));
            ImageSetupUI.this.fit_Paper.addActionListener((ActionListener)this);
            ImageSetupUI.this.fact_Size.addActionListener((ActionListener)this);
            ImageSetupUI.this.auto_Cut.addActionListener((ActionListener)this);
            bg.add((AbstractButton)ImageSetupUI.this.fit_Paper);
            bg.add((AbstractButton)ImageSetupUI.this.fact_Size);
            bg.add((AbstractButton)ImageSetupUI.this.auto_Cut);
            this.add((Component)ImageSetupUI.this.fit_Paper);
            this.add((Component)ImageSetupUI.this.fact_Size);
            this.add((Component)ImageSetupUI.this.auto_Cut);
            int width = 100;
            int oneHeight = ((ImageSetupUI)ImageSetupUI.this).fit_Paper.getPreferredSize().height;
            int y = 25;
            ImageSetupUI.this.fit_Paper.setBounds(10, y, width, oneHeight);
            y = y + 5 + oneHeight;
            ImageSetupUI.this.fact_Size.setBounds(10, y, width, oneHeight);
            y = y + 5 + oneHeight;
            ImageSetupUI.this.auto_Cut.setBounds(10, y, width, oneHeight);
            y = y + 5 + oneHeight;
            ImageSetupUI.this.promptLabel = new KDTextArea();
            ImageSetupUI.this.promptLabel.setOpaque(false);
            ImageSetupUI.this.promptLabel.setLineWrap(true);
            ImageSetupUI.this.promptLabel.setBorder(null);
            ImageSetupUI.this.promptLabel.setBounds(10, y, width + 150, 20);
            this.add((Component)ImageSetupUI.this.promptLabel);
            this.setPreferredSize(new Dimension(410, 120));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == ImageSetupUI.this.fit_Paper) {
                ImageSetupUI.this.promptLabel.setText(ImageSetupUI.getMsg("label.fitpaper"));
            } else if (source == ImageSetupUI.this.fact_Size) {
                ImageSetupUI.this.promptLabel.setText(ImageSetupUI.getMsg("label.factsize"));
            } else if (source == ImageSetupUI.this.auto_Cut) {
                ImageSetupUI.this.promptLabel.setText(ImageSetupUI.getMsg("label.autocut"));
            }
        }
    }
}

