/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.config.extendui;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.print.config.AbstractXmlTranslate;
import com.kingdee.cosmic.ctrl.print.config.IConfigModel;
import com.kingdee.cosmic.ctrl.print.config.extendui.ImageSetupModel;

public class ImageSetupXmlTrans
extends AbstractXmlTranslate {
    public static String NAME = "imageSetup";
    public static String CHILD_MODE = "mode";
    public static String CHILD_HALIGN = "h_align";
    public static String CHILD_VALIGN = "v_align";

    public ImageSetupXmlTrans(IConfigModel model) {
        super(model);
    }

    @Override
    public IXmlElement toXmlElement() {
        ImageSetupModel configModel = (ImageSetupModel)this.model;
        ImageSetupXmlTrans.setAttribute(this.rootElement, CHILD_MODE, configModel.getMode());
        ImageSetupXmlTrans.setAttribute(this.rootElement, CHILD_HALIGN, configModel.getHorizontalAlignment());
        ImageSetupXmlTrans.setAttribute(this.rootElement, CHILD_VALIGN, configModel.getVerticalAlignment());
        return this.rootElement;
    }

    @Override
    public Object fromXmlElement(IXmlElement element) {
        super.fromXmlElement(element);
        if (element == null) {
            return null;
        }
        if (!element.getName().equals(NAME)) {
            return null;
        }
        ImageSetupModel configModel = (ImageSetupModel)this.model;
        String mode = ImageSetupXmlTrans.getAttributeValue(element, CHILD_MODE);
        if (!"".equals(mode)) {
            configModel.setMode(Integer.parseInt(mode));
        }
        String hAlign = ImageSetupXmlTrans.getAttributeValue(element, CHILD_HALIGN);
        String vAlign = ImageSetupXmlTrans.getAttributeValue(element, CHILD_VALIGN);
        if (!"".equals(hAlign)) {
            configModel.setHorizontalAlignment(Integer.parseInt(hAlign));
        }
        if (!"".equals(vAlign)) {
            configModel.setVerticalAlignment(Integer.parseInt(vAlign));
        }
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

