/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.config.ui;

import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootDesignerPane;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.cosmic.ctrl.print.config.IConfigModel;
import com.kingdee.cosmic.ctrl.print.config.PrintJobConfig;
import com.kingdee.cosmic.ctrl.print.config.ui.AbstractConfigUI;
import com.kingdee.cosmic.ctrl.print.config.ui.HeadFootPreviewPane;
import com.kingdee.cosmic.ctrl.print.config.ui.HeaderFooterModel;
import com.kingdee.cosmic.ctrl.print.resource.Resources;
import com.kingdee.cosmic.ctrl.swing.KDTabbedPane;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HeadFootUI
extends AbstractConfigUI {
    private static final long serialVersionUID = 1945478495065015391L;
    public static final int PAGE_W = 405;
    public static final int PAGE_H = 304;
    protected KDTabbedPane tabbedPane;
    protected HeadFootDesignerPane head;
    protected HeadFootDesignerPane foot;
    protected HeadFootPreviewPane preview;

    @Override
    public void init(PrintJobConfig manager, String uniqueName) {
        super.init(manager, uniqueName);
        this.tabbedPane = new KDTabbedPane();
        this.tabbedPane.setPreferredSize(new Dimension(405, 304));
        this.head = new HeadFootDesignerPane(manager.getHeadFootPreList());
        this.foot = new HeadFootDesignerPane(manager.getHeadFootPreList());
        this.preview = new HeadFootPreviewPane();
        this.tabbedPane.add(Resources.getMsg("tab.header"), (Component)((Object)this.head));
        this.tabbedPane.add(Resources.getMsg("tab.footer"), (Component)((Object)this.foot));
        this.tabbedPane.add(Resources.getMsg("tab.preview"), (Component)((Object)this.preview));
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (((KDTabbedPane)e.getSource()).getSelectedIndex() == 2) {
                    HeadFootUI.this.preview.setHeadModel(HeadFootUI.this.head.getModel());
                    HeadFootUI.this.preview.setFootModel(HeadFootUI.this.foot.getModel());
                }
            }
        });
        this.add((Component)this.tabbedPane);
    }

    @Override
    public IConfigModel createConfigModel() {
        return new HeaderFooterModel();
    }

    @Override
    public void updateConfigToUI() {
        HeaderFooterModel model = (HeaderFooterModel)this.config;
        if (model.getHeaderModel() != null) {
            this.head.setModel((HeadFootModel)model.getHeaderModel().clone());
        }
        if (model.getFooterModel() != null) {
            this.foot.setModel((HeadFootModel)model.getFooterModel().clone());
        }
        this.preview.setPainterInfo(this.manager.getPrintJob().getPrintPainterInfo());
    }

    @Override
    public void approve() {
        HeaderFooterModel model = (HeaderFooterModel)this.config;
        if (!this.isModeEqual(model.getHeaderModel(), this.head.getModel())) {
            this.manager.setChange(true);
        }
        if (this.head.getModel() != null) {
            model.setHeaderModel(this.head.getModel());
        } else {
            model.setHeaderModel(null);
        }
        if (!this.isModeEqual(model.getFooterModel(), this.foot.getModel())) {
            this.manager.setChange(true);
        }
        if (this.foot.getModel() != null) {
            model.setFooterModel(this.foot.getModel());
        } else {
            model.setFooterModel(null);
        }
    }

    private boolean isModeEqual(HeadFootModel model, HeadFootModel model2) {
        return model == null && model2 == null || model != null && model2 != null && model.equals(model2);
    }
}

