/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.config.ui;

import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.print.PropertyConfig;
import com.kingdee.cosmic.ctrl.print.config.IConfigModel;
import com.kingdee.cosmic.ctrl.print.config.IXmlTranslate;
import com.kingdee.cosmic.ctrl.print.config.PrintJobConfig;
import com.kingdee.cosmic.ctrl.print.config.ui.AbstractStartLocationModel;
import com.kingdee.cosmic.ctrl.print.config.ui.PaperAdjustModel;
import java.util.Map;
import java.util.StringTokenizer;

public class PaperStartLocationModel
extends AbstractStartLocationModel {
    public PaperStartLocationModel() {
        this.load();
    }

    private void load() {
        String config = PropertyConfig.getPaper_Location();
        this.startContent.clear();
        if (config != null && !config.equals("")) {
            StringTokenizer st = new StringTokenizer(config, ":");
            while (st.hasMoreTokens()) {
                String oneConfig = st.nextToken();
                StringTokenizer stOne = new StringTokenizer(oneConfig, ",");
                String key = stOne.nextToken();
                key = key.replaceAll(PaperAdjustModel.REPLACER, ":");
                float x = Float.parseFloat(stOne.nextToken());
                float y = Float.parseFloat(stOne.nextToken());
                this.startContent.put(key, new float[]{x, y});
            }
        }
    }

    @Override
    public void save() {
        PropertyConfig.setPaper_Location(this.toSaveString());
    }

    private String toSaveString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.startContent.entrySet()) {
            String printer = (String)entry.getKey();
            float[] values = (float[])entry.getValue();
            float x = values[0];
            float y = values[1];
            if (ArrayUtil.isEqual((Float)Float.valueOf(x), (Float)Float.valueOf(0.0f)) && ArrayUtil.isEqual((Float)Float.valueOf(y), (Float)Float.valueOf(0.0f))) continue;
            printer = printer.replaceAll(":", PaperAdjustModel.REPLACER);
            sb.append(printer).append(',').append(x).append(',').append(y);
            sb.append(':');
        }
        return sb.toString();
    }

    @Override
    public Object clone() {
        return "";
    }

    @Override
    public IXmlTranslate createXmlTrans() {
        return null;
    }

    @Override
    public void set(IConfigModel from) {
    }

    @Override
    public void setDefault() {
    }

    @Override
    public String getID() {
        return null;
    }

    @Override
    public void installManager(PrintJobConfig manager) {
    }
}

