/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.config.xml;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleParser;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.print.config.AbstractXmlTranslate;
import com.kingdee.cosmic.ctrl.print.config.IConfigModel;
import com.kingdee.cosmic.ctrl.print.config.ui.HeaderFooterModel;
import com.kingdee.cosmic.ctrl.print.ui.component.Canvas;
import com.kingdee.cosmic.ctrl.print.ui.component.HeaderFooter;
import com.kingdee.cosmic.ctrl.print.ui.io.Painter2Xml;
import com.kingdee.cosmic.ctrl.print.ui.io.Xml2Painter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HeaderFooterConfigTranslate
extends AbstractXmlTranslate {
    public static String NAME = "headerfooter";
    public static String E_header = "header";
    public static String E_footer = "footer";
    public static String A_TYPE = "type";
    public static String TYPE_THREE = "three";
    public static String TYPE_CANVAS = "canvas";

    public HeaderFooterConfigTranslate(IConfigModel model) {
        super(model);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Object fromXmlElement(IXmlElement element) {
        super.fromXmlElement(element);
        IXmlElement headerElement = HeaderFooterConfigTranslate.getChild(element, E_header);
        IXmlElement footerElement = HeaderFooterConfigTranslate.getChild(element, E_footer);
        this.fromHeaderFooter(headerElement, E_header);
        this.fromHeaderFooter(footerElement, E_footer);
        return this;
    }

    private void fromHeaderFooter(IXmlElement element, String name) {
        if (element != null) {
            String type;
            HeaderFooterModel headerModel = (HeaderFooterModel)this.model;
            HeadFootModel header = null;
            if (name.equals(E_header)) {
                header = headerModel.getHeaderModel();
                if (header == null) {
                    header = new HeadFootModel();
                    headerModel.setHeaderModel(header);
                }
            } else {
                header = headerModel.getFooterModel();
                if (header == null) {
                    header = new HeadFootModel();
                    headerModel.setFooterModel(header);
                }
            }
            if ((type = element.getAttribute(A_TYPE)) == null || type.equals(TYPE_THREE)) {
                element.setName("HeadFootModel");
                header.readFromXmlNode(element);
            } else {
                HashMap styles = new HashMap();
                this.loadStyles(element.getChild("Styles"), styles);
                Xml2Painter x2p = new Xml2Painter(styles);
                Canvas canvas = (Canvas)x2p.parsePainter((IXmlElement)element.getChildren().get(0));
                if (name.equals(E_header)) {
                    headerModel.setHeader(canvas);
                } else {
                    headerModel.setFooter(canvas);
                }
            }
        }
    }

    private void loadStyles(IXmlElement element, Map styles) {
        if (element == null) {
            return;
        }
        List sList = element.searchChildren("Style");
        int length = sList.size();
        for (int i = 0; i < length; ++i) {
            IXmlElement s = (IXmlElement)sList.get(i);
            StyleAttributes sa = StyleParser.parseSA((IXmlElement)s);
            Style style = Styles.getStyle((ShareStyleAttributes)sa);
            styles.put(s.getAttribute("id"), style);
        }
    }

    @Override
    public IXmlElement toXmlElement() {
        if (this.model != null) {
            Canvas headerCanvas = ((HeaderFooterModel)this.model).getHeader();
            this.createHeaderFooter(headerCanvas, E_header);
            Canvas footerCanvas = ((HeaderFooterModel)this.model).getFooter();
            this.createHeaderFooter(footerCanvas, E_footer);
        }
        return this.rootElement;
    }

    private void createHeaderFooter(Canvas canvas, String name) {
        if (canvas != null) {
            if (canvas instanceof HeaderFooter) {
                this.toHeaderFooter(canvas, name);
            } else {
                this.toHeaderFooter2(canvas, name);
            }
        }
    }

    private void toHeaderFooter2(Canvas headerCanvas, String name) {
        Painter2Xml pxml = new Painter2Xml();
        IXmlElement canvas = pxml.makePainter(headerCanvas);
        IXmlElement header = HeaderFooterConfigTranslate.createElement(name);
        header.addChild(canvas);
        IXmlElement nodeStyles = HeaderFooterConfigTranslate.createElement("Styles");
        Iterator iter = pxml.getStyles().entrySet().iterator();
        StyleParser.writeStyles((IXmlElement)nodeStyles, iter);
        header.addChild(nodeStyles);
        header.setAttribute(A_TYPE, TYPE_CANVAS);
        this.rootElement.addChild(header);
    }

    private void toHeaderFooter(Canvas headerCanvas, String name) {
        HeadFootModel header = ((HeaderFooter)headerCanvas).getModel();
        if (header != null) {
            IXmlElement element = header.writeToXmlNode("");
            element.setAttribute("id", null);
            element.setName(name);
            element.setAttribute(A_TYPE, TYPE_THREE);
            this.rootElement.addChild(element);
        }
    }
}

