/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.config.xml;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.print.config.IConfigModel;
import com.kingdee.cosmic.ctrl.print.config.ui.PrintConfigModel;
import com.kingdee.cosmic.ctrl.print.config.xml.AbstractPrintAttributeTranslate;
import javax.print.PrintService;

public class PrintGeneralTranslate
extends AbstractPrintAttributeTranslate {
    public static String NAME = "printer";
    public static String CHILD_DynamicPaper = "dynamicpaper";

    public PrintGeneralTranslate(IConfigModel model) {
        super(model);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Object fromXmlElement(IXmlElement element) {
        super.fromXmlElement(element);
        if (element == null) {
            return null;
        }
        if (!element.getName().equals(NAME)) {
            return null;
        }
        this.fromPrinter(PrintGeneralTranslate.getChild(element, "printerName"));
        this.fromDynamicPaper(PrintGeneralTranslate.getChild(element, CHILD_DynamicPaper));
        return this;
    }

    private void fromDynamicPaper(IXmlElement child) {
        PrintConfigModel configModel = (PrintConfigModel)this.model;
        if (child == null) {
            configModel.setDynamicPaper(false);
        } else {
            String text = child.getText();
            if (text != null) {
                configModel.setDynamicPaper(text.equals("true"));
            }
        }
    }

    private void fromPrinter(IXmlElement child) {
        if (child != null) {
            String printer = child.getText();
            PrintConfigModel configModel = (PrintConfigModel)this.model;
            configModel.setCurrentServiceByName(printer);
        }
    }

    @Override
    public IXmlElement toXmlElement() {
        PrintConfigModel configModel = (PrintConfigModel)this.model;
        this.toPrinter(configModel.getPrintServiceDirect());
        this.toDynamicPaper(configModel.isDynamicPaper());
        return this.rootElement;
    }

    private void toDynamicPaper(boolean isFrugal) {
        IXmlElement e = PrintGeneralTranslate.createElement(CHILD_DynamicPaper);
        e.addCData(String.valueOf(isFrugal));
        this.rootElement.addChild(e);
    }

    private void toPrinter(PrintService printer) {
        IXmlElement printerElement = null;
        String name = null;
        if (printer != null) {
            name = printer.getName();
        }
        if (!StringUtil.isEmptyString(name)) {
            printerElement = PrintGeneralTranslate.createElement("printerName");
            printerElement.addCData(name);
        }
        if (printerElement != null) {
            this.rootElement.addChild(printerElement);
        }
    }
}

