/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.control;

import com.kingdee.cosmic.ctrl.print.ui.component.DimensionFloat;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;

public class PaperInfo {
    private Dimension paperSize = new Dimension();
    private Rectangle2D.Float pageRect = new Rectangle2D.Float();
    private Rectangle2D.Float pageHeadRect = new Rectangle2D.Float();
    private Rectangle2D.Float pageFootRect = new Rectangle2D.Float();
    private double scale = 1.0;
    private DimensionFloat paintableSize = new DimensionFloat();
    private DimensionFloat paintableSize2 = new DimensionFloat();
    private int minUnitHeight = 60;
    private int blockSpace = 0;
    private int tableSpace = 0;
    private boolean isUseFrugalPaintable = false;
    boolean isDynamicPaper = false;
    private float lastPagHeight = -1.0f;

    public void setIsDynamicPaper(boolean is) {
        this.isDynamicPaper = is;
    }

    public void setPaperSize(int width, int height) {
        this.paperSize.setSize(width, height);
    }

    public void setPaperSize(Dimension dim) {
        this.paperSize = dim;
    }

    public void setPageBounds(int x, int y, int width, int height) {
        this.pageRect.x = x;
        this.pageRect.y = y;
        this.pageRect.width = (int)((double)(width * 1) / this.scale);
        this.pageRect.height = (int)((double)(height * 1) / this.scale);
        this.updatePaintableSize();
    }

    public void setPageHeadBounds(int x, int y, int width, int height) {
        this.pageHeadRect.x = x;
        this.pageHeadRect.y = y;
        this.pageHeadRect.width = (int)((double)(width * 1) / this.scale);
        this.pageHeadRect.height = (int)((double)(height * 1) / this.scale);
    }

    public void setPageFootBounds(int x, int y, int width, int height) {
        this.pageFootRect.x = x;
        this.pageFootRect.y = y;
        this.pageFootRect.width = (int)((double)(width * 1) / this.scale);
        this.pageFootRect.height = (int)((double)(height * 1) / this.scale);
    }

    public Dimension getPaperSize() {
        return this.paperSize;
    }

    public Rectangle2D.Float getPageBounds() {
        return this.pageRect;
    }

    public boolean isPaintableSizeEquals(PaperInfo info) {
        if (info == null) {
            return false;
        }
        DimensionFloat ps = info.getPaintableSize();
        DimensionFloat mps = this.getPaintableSize();
        return ps.width == mps.width && ps.height == mps.height;
    }

    public DimensionFloat getPaintableSize() {
        if (this.isUseFrugalPaintable && this.lastPagHeight > -1.0f) {
            float spareHeight = this.paintableSize.height - this.lastPagHeight;
            if (spareHeight > (float)this.minUnitHeight) {
                this.paintableSize2.setSize(this.paintableSize);
                this.paintableSize2.height = spareHeight;
                return this.paintableSize2;
            }
            this.lastPagHeight = this.tableSpace;
        }
        if (this.isDynamicPaper) {
            return new DimensionFloat(this.paintableSize.getWidth(), 9999999.0);
        }
        return this.paintableSize;
    }

    public DimensionFloat getPaintableSize2() {
        if (this.isDynamicPaper) {
            return new DimensionFloat(this.paintableSize.getWidth(), 9999999.0);
        }
        return this.paintableSize;
    }

    public void setMinUnitHeight(int height) {
        this.minUnitHeight = height;
    }

    public Rectangle2D.Float getPageHeadBounds() {
        return this.pageHeadRect;
    }

    public Rectangle2D.Float getPageFootBounds() {
        return this.pageFootRect;
    }

    public String toString() {
        return "Page bounds[" + this.pageRect + "] PageHead bounds[" + this.pageHeadRect + "] PageFoot bounds" + this.pageFootRect + "]";
    }

    public void setScale(double scale) {
        this.scale = scale;
        this.updatePaintableSize();
    }

    public double getScale() {
        return this.scale;
    }

    private void updatePaintableSize() {
        this.paintableSize.setSize(this.pageRect.width, this.pageRect.height);
    }

    public void addLastPageHeight(float height, boolean isLastPage) {
        int pSpace = isLastPage ? this.tableSpace : this.blockSpace;
        this.lastPagHeight = this.lastPagHeight + (float)pSpace + height;
        float spareHeight = this.paintableSize.height - this.lastPagHeight;
        if (spareHeight <= (float)this.minUnitHeight) {
            this.lastPagHeight = this.tableSpace;
        }
    }

    public void setLastPageHeight(float height) {
        this.lastPagHeight = height;
    }

    public void resetLastPageHeight() {
        this.lastPagHeight = -1.0f;
    }

    public void setUseFrugalPaintable(boolean is) {
        this.isUseFrugalPaintable = is;
    }

    public boolean isUseFrugalPaintable() {
        return this.isUseFrugalPaintable;
    }

    public int getBlockSpace() {
        return this.blockSpace;
    }

    public void setBlockSpace(int blockSpace) {
        this.blockSpace = blockSpace;
    }

    public int getTableSpace() {
        return this.tableSpace;
    }

    public void setTableSpace(int tableSpace) {
        this.tableSpace = tableSpace;
    }
}

