/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.io;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.print.io.BadDataFormatException;
import com.kingdee.cosmic.ctrl.print.io.IndexAccessFile;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IndexsElement {
    Map indexMap = new HashMap();
    public static final String INDEX_INDEX = "indexOfIndex";
    public static final String NAME = "indexs";
    public static final String INDEX_NAME = "index";
    public static final String ATTRI_KEY = "key";
    public static final String ATTRI_START = "start";
    public static final String ATTRI_LENGTH = "length";

    public IndexsElement(IndexAccessFile fileWriter) throws IOException, BadDataFormatException {
        this.loadIndexs(fileWriter);
    }

    public void clear() {
        this.indexMap.clear();
    }

    private void loadIndexs(IndexAccessFile fileWriter) throws IOException, BadDataFormatException {
        if (fileWriter.length() <= 0L) {
            return;
        }
        String indexOfIndex = fileWriter.readLine();
        boolean isFind = false;
        for (int maxRow = 0; indexOfIndex != null && maxRow < 10; ++maxRow) {
            if (indexOfIndex.indexOf(INDEX_INDEX) >= 0) {
                isFind = true;
                break;
            }
            indexOfIndex = fileWriter.readLine();
        }
        if (isFind) {
            try {
                int startIndex = indexOfIndex.indexOf(ATTRI_START);
                startIndex = startIndex + ATTRI_START.length() + 2;
                String startPositon = indexOfIndex.substring(startIndex, startIndex + 32);
                int lendthIndex = indexOfIndex.indexOf(ATTRI_LENGTH);
                lendthIndex = lendthIndex + ATTRI_LENGTH.length() + 2;
                String lengthStr = indexOfIndex.substring(lendthIndex, lendthIndex + 32);
                int sp = Integer.parseInt(startPositon);
                int sl = Integer.parseInt(lengthStr);
                IXmlElement indexElement = fileWriter.read(sp, sl);
                List children = indexElement.getChildren();
                int length = children.size();
                for (int i = 0; i < length; ++i) {
                    IXmlElement child = (IXmlElement)children.get(i);
                    this.add(child);
                }
            }
            catch (Exception e) {
                throw new BadDataFormatException(e.getMessage(), e);
            }
        } else {
            throw new BadDataFormatException("Bad file format,not find indexOfindex.");
        }
    }

    private void add(IXmlElement child) {
        if (child == null) {
            return;
        }
        String name = child.getName();
        if (!name.equals(INDEX_NAME)) {
            return;
        }
        String key = child.getAttribute(ATTRI_KEY);
        String start = child.getAttribute(ATTRI_START);
        String length = child.getAttribute(ATTRI_LENGTH);
        this.add(key, Integer.parseInt(start), Integer.parseInt(length));
    }

    public int[] get(String key) {
        Pair pair = (Pair)this.indexMap.get(key);
        if (pair != null) {
            int[] pairs = new int[]{pair.pos, pair.length};
            return pairs;
        }
        return new int[0];
    }

    public void add(String key, int pos, int length) {
        this.indexMap.put(key, new Pair(pos, length));
    }

    public void add(String id, int pos) {
        this.add(id, pos, -1);
    }

    public boolean isEmpty() {
        return this.indexMap.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" <indexs>");
        sb.append(this.newLine());
        for (Map.Entry entry : this.indexMap.entrySet()) {
            Pair pair = (Pair)entry.getValue();
            sb.append("  <index");
            sb.append("  key=\"" + entry.getKey() + "\"");
            if (pair.pos >= 0) {
                sb.append(" start=\"" + pair.pos + "\"");
            }
            if (pair.length >= 0) {
                sb.append(" length=\"" + pair.length + "\"");
            }
            sb.append("/>");
            sb.append(this.newLine());
        }
        sb.append(" </indexs>");
        sb.append(this.newLine());
        return sb.toString();
    }

    private String newLine() {
        return "\r\n";
    }

    static class Pair {
        public int pos = -1;
        public int length = -1;

        public Pair(int pos, int length) {
            this.pos = pos;
            this.length = length;
        }
    }
}

