/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.io;

import com.kingdee.cosmic.ctrl.common.util.StreamUtil;
import com.kingdee.cosmic.ctrl.print.io.KDFontMapper;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.FontMapper;
import java.awt.Font;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class KDFontMapperPlus
implements FontMapper {
    private static final Logger logger = Logger.getLogger(KDFontMapper.class);
    private HashMap aliases = new HashMap();
    private HashMap mapper = new HashMap();
    public BaseFont defaultFont;
    private static final String DEFAULT_FONT_PATH = "/com/kingdee/cosmic/ctrl/print/io/resources/msyh.ttf";
    private static final String DEFAULT_FONT_NAME = "Microsoft YaHei";
    private static final int BUFFER_SIZE = 30720;

    public KDFontMapperPlus() {
        String userHome;
        String windir;
        String easHome;
        String prop = System.getProperty("eas.properties.dir");
        if (prop != null) {
            this.insertDirectory(prop);
        }
        if ((easHome = System.getProperty("EAS_HOME")) != null) {
            this.insertDirectory(easHome + "/client/bin");
        }
        if ((windir = System.getenv("windir")) != null && !windir.isEmpty()) {
            windir = windir.endsWith("\\") || windir.endsWith("/") ? windir : windir + File.separator;
            this.insertDirectory(windir + "Fonts");
        }
        if ((userHome = System.getProperty("user.home")) != null && !userHome.isEmpty()) {
            userHome = userHome.endsWith("\\") || userHome.endsWith("/") ? userHome : userHome + File.separator;
            this.insertDirectory(userHome + ".fonts");
        }
        this.registerEmbedFont();
        this.insertDirectory("/usr/share/fonts");
        this.insertDirectory("/usr/local/share/fonts");
        this.insertDirectory("/usr/X/lib/X11/fonts/TrueType");
        this.insertDirectory("/usr/openwin/lib/X11/fonts/TrueType");
        this.insertDirectory("/usr/share/fonts/default/TrueType");
        this.insertDirectory("/usr/X11R6/lib/X11/fonts/ttf");
        this.insertDirectory("/usr/lpp/X11/lib/X11/fonts");
        this.insertDirectory("/usr/lib/X11/fonts");
        this.insertDirectory("/usr/lpp/X11/lib/X11");
        this.insertDirectory("/usr/X11R6/lib/X11/fonts");
        this.insertDirectory("/System/Library/Fonts");
        this.insertDirectory("/Library/Fonts");
        try {
            BaseFontParameters p = this.getBaseFontParameters(DEFAULT_FONT_NAME);
            this.defaultFont = BaseFont.createFont((String)p.fontName, (String)p.encoding, (boolean)p.embedded, (boolean)p.cached, (byte[])p.ttfAfm, (byte[])p.pfb);
        }
        catch (DocumentException e) {
            logger.error((Object)("---KDFontMapperPlus----" + e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)("---KDFontMapperPlus----" + e.getMessage()), (Throwable)e);
        }
        catch (Throwable e) {
            logger.error((Object)("---KDFontMapperPlus----" + e.getMessage()), e);
        }
    }

    public BaseFont awtToPdf(Font font) {
        try {
            BaseFontParameters p = this.getBaseFontParameters(font.getFontName());
            if (p != null) {
                return BaseFont.createFont((String)p.fontName, (String)p.encoding, (boolean)p.embedded, (boolean)p.cached, (byte[])p.ttfAfm, (byte[])p.pfb);
            }
            if (this.defaultFont != null) {
                BaseFont basefont = this.defaultFont;
                return basefont;
            }
            throw new ExceptionConverter(new Exception(String.valueOf(String.valueOf(new StringBuffer("Can't find any font named [").append(font.getFontName()).append(" ] installed in your system, default font is not Available too.")))));
        }
        catch (Exception e) {
            if (this.defaultFont != null) {
                return this.defaultFont;
            }
            logger.error((Object)("---KDFontMapperPlus----" + e.getMessage()), (Throwable)e);
            throw new ExceptionConverter(e);
        }
    }

    public Font pdfToAwt(BaseFont font, int size) {
        String finalName;
        String[][] names = font.getFullFontName();
        if (names.length == 1) {
            return new Font(names[0][3], 0, size);
        }
        String name10 = null;
        String name3x = null;
        for (int k = 0; k < names.length; ++k) {
            String[] name = names[k];
            if (name[0].equals("1") && name[1].equals("0")) {
                name10 = name[3];
                continue;
            }
            if (!name[2].equals("1033")) continue;
            name3x = name[3];
            break;
        }
        if ((finalName = name3x) == null) {
            finalName = name10;
        }
        if (finalName == null) {
            finalName = names[0][3];
        }
        return new Font(finalName, 0, size);
    }

    public void putName(String awtName, BaseFontParameters parameters) {
        this.mapper.put(awtName, parameters);
    }

    public void putAlias(String alias, String awtName) {
        this.aliases.put(alias, awtName);
    }

    public BaseFontParameters getBaseFontParameters(String name) {
        String alias = (String)this.aliases.get(name);
        if (alias == null) {
            return (BaseFontParameters)this.mapper.get(name);
        }
        BaseFontParameters p = (BaseFontParameters)this.mapper.get(alias);
        if (p == null) {
            return (BaseFontParameters)this.mapper.get(name);
        }
        return p;
    }

    protected void insertNames(String[][] names, String path) {
        String main = null;
        for (int k = 0; k < names.length; ++k) {
            String[] name = names[k];
            if (!name[2].equals("1033")) continue;
            main = name[3];
            break;
        }
        if (main == null) {
            main = names[0][3];
        }
        BaseFontParameters p = new BaseFontParameters(path);
        this.mapper.put(main, p);
        for (int k = 0; k < names.length; ++k) {
            this.aliases.put(names[k][3], main);
        }
    }

    public int insertDirectory(String dir) {
        File file = new File(FilenameUtils.normalize((String)dir));
        if (!file.exists() || !file.isDirectory()) {
            return 0;
        }
        File[] files = file.listFiles();
        if (files == null) {
            return 0;
        }
        int count = 0;
        for (int k = 0; k < files.length; ++k) {
            file = files[k];
            if (file.isDirectory()) {
                this.insertDirectory(file.getPath());
                continue;
            }
            String name = file.getPath().toLowerCase(Locale.ENGLISH);
            try {
                if (name.endsWith(".ttf") || name.endsWith(".otf") || name.endsWith(".afm")) {
                    String[][] names = BaseFont.getFullFontName((String)file.getPath(), (String)"Cp1252", null);
                    this.insertNames(names, file.getPath());
                    ++count;
                    continue;
                }
                if (!name.endsWith(".ttc")) continue;
                String[] ttcs = BaseFont.enumerateTTCNames((String)file.getPath());
                for (int j = 0; j < ttcs.length; ++j) {
                    String nt = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(file.getPath()))).append(",").append(j)));
                    String[][] names = BaseFont.getFullFontName((String)nt, (String)"Cp1252", null);
                    this.insertNames(names, nt);
                }
                ++count;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerEmbedFont() {
        block9: {
            InputStream is = null;
            FileOutputStream out = null;
            try {
                is = KDFontMapperPlus.class.getResourceAsStream(DEFAULT_FONT_PATH);
                String property = System.getProperty("java.io.tmpdir");
                String filePath = property + File.separator + "msyh.ttf";
                File file = new File(FilenameUtils.normalize((String)filePath));
                if (!file.exists()) {
                    try {
                        out = new FileOutputStream(FilenameUtils.normalize((String)filePath));
                        StreamUtil.copy((InputStream)is, (OutputStream)out, (int)30720);
                    }
                    catch (FileNotFoundException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (IOException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                this.insertDirectory(property + File.separator);
                StreamUtil.closeStream((InputStream)is);
            }
            catch (Exception e) {
                logger.error((Object)"registerEmbedFont error", (Throwable)e);
                break block9;
            }
            finally {
                StreamUtil.closeStream((InputStream)is);
                StreamUtil.closeStream(out);
            }
            StreamUtil.closeStream((OutputStream)out);
        }
    }

    public HashMap getMapper() {
        return this.mapper;
    }

    public HashMap getAliases() {
        return this.aliases;
    }

    public static class BaseFontParameters {
        public String fontName;
        public String encoding;
        public boolean embedded;
        public boolean cached;
        public byte[] ttfAfm;
        public byte[] pfb;

        public BaseFontParameters(String fontName) {
            this.fontName = fontName;
            this.encoding = "Identity-H";
            this.embedded = true;
            this.cached = true;
        }
    }
}

