/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.io;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.print.io.KDPFile;
import com.kingdee.cosmic.ctrl.print.printjob.AbstractPrintJob;
import com.kingdee.cosmic.ctrl.print.ui.component.Page;
import com.kingdee.cosmic.ctrl.print.ui.component.Paper;
import java.io.IOException;
import org.apache.log4j.Logger;

public class KDPPrintJob
extends AbstractPrintJob {
    private static final Logger logger = LogUtil.getPackageLogger(KDPPrintJob.class);
    KDPFile kdp;

    public KDPPrintJob(String id) {
        super(id);
    }

    @Override
    public Page getPage(int index) {
        Page page = super.getPage(index);
        if (page == null) {
            page = this.kdp.getPage(index, this.getID());
        }
        if (page != null) {
            page.setIndex(index);
        }
        return page;
    }

    @Override
    public Paper getPaper(int index) {
        return this.createPaper(index);
    }

    public void setContent(KDPFile file) {
        this.kdp = file;
    }

    @Override
    public boolean isEmpty() {
        return this.getPage(0) == null;
    }

    @Override
    public void removeNotify() {
        try {
            this.kdp.close();
        }
        catch (IOException e) {
            logger.error((Object)"err", (Throwable)e);
        }
    }

    @Override
    public void clear() {
        this.changedPageBuffer = null;
    }
}

