/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.preview;

import com.kingdee.cosmic.ctrl.print.KDPrinter;
import com.kingdee.cosmic.ctrl.print.config.ui.AbstractDialog;
import com.kingdee.cosmic.ctrl.print.config.ui.FixedLayout;
import com.kingdee.cosmic.ctrl.print.config.ui.SunPrintConfigDialog;
import com.kingdee.cosmic.ctrl.print.resource.Resources;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDRadioButton;
import com.kingdee.cosmic.ctrl.swing.KDSpinner;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class PrintTestDialog
extends AbstractDialog
implements ActionListener {
    private static final long serialVersionUID = -3528543639688508008L;
    public static final int PAGE_W = 255;
    private JPanel panel;
    private String title;
    private KDPrinter printer;
    KDRadioButton singleTest;
    KDRadioButton muliTest;
    KDSpinner spinCopies;

    public PrintTestDialog(KDPrinter printer, Frame owner) {
        super(owner, true);
        this.printer = printer;
        this.initDialog();
        this.setLocationRelativeTo(owner);
    }

    public PrintTestDialog(KDPrinter printer, Dialog owner) {
        super(owner, true);
        this.printer = printer;
        this.initDialog();
        this.setLocationRelativeTo(owner);
    }

    private void initDialog() {
        this.title = Resources.getMsg("button.printTest");
        this.setTitle(this.title);
        this.setPreviewing(true);
        this.panel = this.createPrintTestConfigPanel();
        JPanel cp = (JPanel)this.getContentPane();
        KDPanel separater = new KDPanel((LayoutManager)FixedLayout.ONE());
        separater.setBorder(BorderFactory.createEtchedBorder());
        JPanel applyPane = this.initApplyPane();
        cp.setLayout(null);
        cp.add(this.panel);
        cp.add((Component)separater);
        cp.add(applyPane);
        int w = 420;
        int h = this.panel.getPreferredSize().height + 40;
        int x = 0;
        int y = 0;
        this.panel.setBounds(x, y, 255, h);
        y = y + h + 5;
        separater.setBounds(-2, y, w + 4, 2);
        h = applyPane.getPreferredSize().height;
        applyPane.setBounds(0, y + 5, 255, h);
        h = y + 5 + h + 5;
        cp.setPreferredSize(new Dimension(255, h));
        this.setResizable(false);
        this.pack();
    }

    private JPanel createPrintTestConfigPanel() {
        KDPanel panel = new KDPanel();
        panel.setOpaque(false);
        panel.setLayout((LayoutManager)SunPrintConfigDialog.LineLayout.LIGHTWEIGHT);
        ButtonGroup bg = new ButtonGroup();
        SunPrintConfigDialog.FixedPanel singlePanel = new SunPrintConfigDialog.FixedPanel();
        this.singleTest = SunPrintConfigDialog.createRadioButton("radiobutton.printtestSingle", this);
        this.singleTest.setSelected(true);
        bg.add((AbstractButton)this.singleTest);
        singlePanel.add((Component)this.singleTest);
        panel.add((Component)((Object)singlePanel));
        SunPrintConfigDialog.FixedPanel multiPanel = new SunPrintConfigDialog.FixedPanel();
        this.muliTest = SunPrintConfigDialog.createRadioButton("radiobutton.printtestmulti", this);
        this.muliTest.setSelected(true);
        bg.add((AbstractButton)this.muliTest);
        multiPanel.add((Component)this.muliTest);
        SpinnerNumberModel snModel = new SpinnerNumberModel(3, 1, 20000, 1);
        this.spinCopies = new KDSpinner((SpinnerModel)snModel);
        this.spinCopies.setEnabled(false);
        multiPanel.add((Component)this.spinCopies);
        panel.add((Component)((Object)multiPanel));
        return panel;
    }

    @Override
    protected void approve() {
        super.approve();
        if (this.singleTest.isSelected()) {
            this.printer.getControlPrint().doPrintTest();
        } else if (this.muliTest.isSelected()) {
            this.printer.getControlPrint().doMultiPaperPrintTest(((Number)this.spinCopies.getValue()).intValue());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.singleTest) {
            if (this.singleTest.isSelected()) {
                this.spinCopies.setEnabled(false);
            }
        } else if (source == this.muliTest && this.muliTest.isSelected()) {
            this.spinCopies.setEnabled(true);
        }
    }
}

