/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.printjob.table;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.print.config.extendui.TablePageSetupModel;
import com.kingdee.cosmic.ctrl.print.control.PaperInfo;
import com.kingdee.cosmic.ctrl.print.printjob.BufferPrintJob;
import com.kingdee.cosmic.ctrl.print.printjob.IPageProvider;
import com.kingdee.cosmic.ctrl.print.printjob.IPainterProvider;
import com.kingdee.cosmic.ctrl.print.ui.component.DimensionFloat;
import com.kingdee.cosmic.ctrl.print.ui.component.IPainter;
import com.kingdee.cosmic.ctrl.print.ui.component.Page;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class TableImagePrintJob
extends BufferPrintJob
implements IPageProvider {
    private static final Logger logger = LogUtil.getPackageLogger(TableImagePrintJob.class);
    Object[] printData;
    Map providerClassMap = new HashMap();
    Map providerMap = new HashMap();
    Object currentData;
    int currentIndex = 0;
    int currentDataIndex = 0;
    int space = 20;
    protected TablePageSetupModel configmodel;
    public static int minHeight = 20;

    public TableImagePrintJob(Object[] printData, int space, TablePageSetupModel configmodel) {
        this.printData = printData;
        this.space = space;
        this.configmodel = configmodel;
        this.currentData = printData[0];
        this.currentIndex = 0;
        this.setPageProvider(this);
    }

    public void addCanvasProvider(Class dataType, String provider_className) throws ClassNotFoundException {
        Class<?> provider_Class = Class.forName(provider_className);
        this.providerClassMap.put(dataType, provider_Class);
    }

    @Override
    public boolean isEmpty() {
        return this.printData == null || this.printData.length == 0;
    }

    private IPainterProvider getCanvasProvider(Object printData) {
        Class providerClass;
        IPainterProvider provider = (IPainterProvider)this.providerMap.get(printData);
        if (provider == null && (providerClass = (Class)this.getProvider(printData.getClass())) != null) {
            try {
                provider = (IPainterProvider)providerClass.newInstance();
                provider.setData(printData);
                provider.setConfigModel(this.configmodel);
                this.providerMap.put(printData, provider);
            }
            catch (Exception e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }
        return provider;
    }

    private Object getProvider(Class key) {
        Object provider = null;
        Class theKey = key;
        while ((provider = this.providerClassMap.get(theKey)) == null && (theKey = theKey.getSuperclass()) != null) {
        }
        return provider;
    }

    @Override
    public void preparePagination() {
        super.preparePagination();
        this.calculatePageCount(this.getPaperInfo());
    }

    @Override
    public void rePagination() {
        super.rePagination();
        this.isBuffered = true;
    }

    private void calculatePageCount(PaperInfo info) {
        if (!info.isUseFrugalPaintable() && this.getPageCount() == -1) {
            this.bufferPrint();
            int pageCount = this.getPageCount();
            this.setPageCount(pageCount);
        }
    }

    @Override
    public Page get(int index, PaperInfo info) {
        if (this.currentData == null) {
            return null;
        }
        Page page = new Page();
        DimensionFloat size = info.getPaintableSize();
        IPainterProvider data = this.getCanvasProvider(this.currentData);
        IPainter canvas = data != null ? data.get(this.currentIndex, (int)size.width, (int)size.height) : null;
        float y = 0.0f;
        if (canvas == null) {
            if (!this.nextData()) {
                return null;
            }
            return this.get(index, info);
        }
        page.addPainter(canvas);
        float pageWidth = canvas.getWidth();
        float pageHeight = canvas.getHeight();
        IPainter canvas2 = data.get(this.currentIndex + 1, (int)size.width, (int)size.height);
        if (canvas2 != null) {
            ++this.currentIndex;
            this.setPageSize(page, pageWidth, pageHeight);
            return page;
        }
        if (!this.nextData()) {
            this.setPageSize(page, pageWidth, pageHeight);
            return page;
        }
        float spareHeight = size.height - canvas.getHeight() - (float)this.space;
        y = canvas.getHeight() + (float)this.space;
        int newIndex = 0;
        while (spareHeight > (float)minHeight) {
            IPainterProvider provider = this.getCanvasProvider(this.currentData);
            IPainter iPainter = canvas = provider != null ? provider.get(newIndex, (int)size.width, (int)spareHeight) : null;
            if (provider == null || canvas == null && provider.isNoEnoughHeight()) {
                this.setPageSize(page, pageWidth, pageHeight);
                return page;
            }
            if (canvas == null) {
                if (!this.nextData()) {
                    this.setPageSize(page, pageWidth, pageHeight);
                    return page;
                }
                newIndex = 0;
                continue;
            }
            canvas.setPainterLocation(0.0f, y);
            y = y + canvas.getHeight() + (float)this.space;
            pageHeight = pageHeight + canvas.getHeight() + (float)this.space;
            pageWidth = canvas.getWidth() > pageWidth ? canvas.getWidth() : pageWidth;
            page.addPainter(canvas);
            spareHeight = spareHeight - canvas.getHeight() - (float)this.space;
            this.currentIndex = ++newIndex;
        }
        this.setPageSize(page, pageWidth, pageHeight);
        return page;
    }

    private void setPageSize(Page page, float width, float height) {
        page.setWidth(width);
        page.setHeight(height);
    }

    private boolean nextData() {
        ++this.currentDataIndex;
        if (this.currentDataIndex >= this.printData.length) {
            this.currentData = null;
            return false;
        }
        this.currentData = this.printData[this.currentDataIndex];
        this.currentIndex = 0;
        return true;
    }

    @Override
    public void clear() {
        super.clear();
        this.currentDataIndex = 0;
        this.currentData = this.printData[this.currentDataIndex];
        this.currentIndex = 0;
        for (IPainterProvider provider : this.providerMap.values()) {
            provider.clear();
        }
    }
}

