/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.printjob.table;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlPrintMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.util.render.CurrencyEditorRenderer;
import com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle.AbstractTableSplitRectInfo;
import com.kingdee.cosmic.ctrl.kdf.util.style.LineStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.Pattern;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.print.config.extendui.TablePageSetupModel;
import com.kingdee.cosmic.ctrl.print.config.extendui.TablePrintSetupModel;
import com.kingdee.cosmic.ctrl.print.config.ui.PrintConfigModel;
import com.kingdee.cosmic.ctrl.print.control.PaperInfo;
import com.kingdee.cosmic.ctrl.print.printjob.table.ITableForPrint;
import com.kingdee.cosmic.ctrl.print.printjob.table.PlugablePaginationAdvice;
import com.kingdee.cosmic.ctrl.print.printjob.table.TableColumnsInfo;
import com.kingdee.cosmic.ctrl.print.ui.component.BasicPainter;
import com.kingdee.cosmic.ctrl.print.ui.component.Canvas;
import com.kingdee.cosmic.ctrl.print.ui.component.CurrencyCell;
import com.kingdee.cosmic.ctrl.print.ui.component.DimensionFloat;
import com.kingdee.cosmic.ctrl.print.ui.component.IPainter;
import com.kingdee.cosmic.ctrl.print.ui.component.LabelCell;
import com.kingdee.cosmic.ctrl.print.ui.component.LineBorder;
import com.kingdee.cosmic.ctrl.print.ui.component.LineCell;
import com.kingdee.cosmic.ctrl.print.ui.component.MergeCell;
import com.kingdee.cosmic.ctrl.print.ui.component.Page;
import com.kingdee.cosmic.ctrl.print.ui.component.PainterCell;
import com.kingdee.cosmic.ctrl.print.ui.component.StyleCell;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JComponent;

public class TablePrintPagination {
    protected ITableForPrint sheet;
    protected PrintConfigModel printmode;
    protected TablePageSetupModel configmodel;
    HashMap pageScopeList = new HashMap(3);
    protected SheetPoint scopeStart;
    protected SheetPoint scopeEnd;
    protected List selectBlocks;
    protected int currentBlockIndex = 0;
    protected LineBorder linnBorder = new LineBorder();
    protected int linepageCount = -1;
    protected int topTitleRowsHeight = -1;
    protected int leftTitleColumnsWidth = -1;
    protected int[] titleColumnsIndexs;
    protected int[] titleRowsIndexs;
    protected int pageIndex = 0;
    private boolean forr1 = false;

    public TablePrintPagination() {
    }

    public TablePrintPagination(ITableForPrint sheet, PrintConfigModel printmode, TablePageSetupModel configmodel) {
        JComponent comp;
        this.sheet = sheet;
        this.printmode = printmode;
        this.configmodel = configmodel;
        this.addPageScope(-1, new SheetPoint(-1, -1), new SheetPoint(-1, -1));
        if ((sheet.getType() == 1 || sheet.getType() == 2) && (comp = (JComponent)sheet.getTable()) != null) {
            Object r1str = comp.getClientProperty("forr1report");
            this.forr1 = "true".equals(r1str);
        }
    }

    public Page getPage(int index, DimensionFloat rect) {
        this.pageIndex = index;
        this.initCofigModel();
        Page page = new Page();
        page = (Page)this.create(index, page, rect);
        return page;
    }

    public Canvas getCanvas(int index, DimensionFloat rect) {
        this.pageIndex = index;
        Canvas page = new Canvas();
        page = this.create(index, page, rect);
        return page;
    }

    public Canvas create(int index, Canvas canvas, DimensionFloat rect) {
        this.initCofigModel();
        if (this.scopeEnd.x < 0 || this.scopeEnd.y < 0) {
            if (index == 0) {
                return canvas;
            }
            return null;
        }
        Canvas page = canvas;
        BasicPainter body = null;
        if (!this.sheet.isEmpty()) {
            if (this.isTopRowTitleOut(this.sheet, rect.getHeight()) || this.iseftColumTitleOut(this.sheet, rect.getWidth())) {
                body = new Canvas();
                body.setPainterBounds(0.0f, 0.0f, 300.0f, 300.0f);
                LabelCell cell = new LabelCell(CtrlPrintMessages.getMLS("table.TablePagination.headerBeyondPaperSize", ""));
                StyleAttributes sa = Styles.getEmptySA();
                sa.setWrapText(true);
                sa.setFontSize(16);
                sa.setFontColor(Color.RED);
                Style style = Styles.getStyle((ShareStyleAttributes)sa);
                cell.setStyle(style);
                cell.setPainterBounds(0.0f, 0.0f, 300.0f, 300.0f);
                ((Canvas)body).addPainter(cell);
                page.addPainter(body);
                page.setPainterBounds(0.0f, 0.0f, 300.0f, 300.0f);
                return page;
            }
            body = this.createBody(rect, index);
            page.addPainter(body);
        }
        if (body == null) {
            page = null;
        } else {
            page.setUserObject(body.getUserObject());
            page.setPainterBounds(0.0f, 0.0f, body.getPainterLocation().x + (float)body.getPainterSize().getWidth(), body.getPainterLocation().y + (float)body.getPainterSize().getHeight());
            Canvas topTitleRows = this.getTopTitleRows(this.sheet, index);
            page.addPainter(topTitleRows);
            Canvas leftTitleColumns = this.getLeftTitleColumns(this.sheet, index);
            page.addPainter(leftTitleColumns);
            int isNeed = this.isNeedTopTitleRowORLeftTitleColumn(index);
            if (isNeed == 3) {
                Canvas titleCorner = this.getTitleCorner(this.sheet, index);
                page.addPainter(titleCorner);
            }
            int rowHeaderWidth = this.sheet.getRowHeaderWidth();
            int colHeaderHeight = this.sheet.getColumnHeaderHeight();
            SheetPoint p1 = new SheetPoint();
            SheetPoint p2 = new SheetPoint();
            this.getPageScope(index, p1, p2);
            Canvas titleRow = this.createRowIndexArea(this.sheet, p1, p2, index);
            page.addPainter(titleRow);
            Canvas titleColumnIndex = this.createColumnIndexArea(this.sheet, p1, p2, index);
            page.addPainter(titleColumnIndex);
            if (this.configmodel.isColumnIndex() && this.configmodel.isRowIndex()) {
                this.createTopLeftCornet(page, rowHeaderWidth, colHeaderHeight);
            }
            if (this.configmodel.isColumnIndex() || this.configmodel.isRowIndex()) {
                LineBorder border;
                if (titleRow != null) {
                    border = new LineBorder();
                    border.setType(4);
                    titleRow.setDecorate(border);
                }
                if (topTitleRows != null) {
                    border = new LineBorder();
                    border.setType(4);
                    topTitleRows.setDecorate(border);
                }
                if (leftTitleColumns != null) {
                    border = new LineBorder();
                    border.setType(8);
                    leftTitleColumns.setDecorate(border);
                }
                border = new LineBorder();
                if (topTitleRows != null && leftTitleColumns != null) {
                    border.setType(12);
                } else if (topTitleRows != null) {
                    border.setType(13);
                } else if (leftTitleColumns != null) {
                    border.setType(14);
                }
                body.setDecorate(border);
            }
        }
        return page;
    }

    public Canvas createPrintBody(ITableForPrint sheet, SheetPoint pStart, SheetPoint pEnd) {
        return this.createPrintBody(sheet, pStart, pEnd, this.isPaintGrid(), false);
    }

    public Canvas createPrintBody(ITableForPrint sheet, SheetPoint pStart, SheetPoint pEnd, boolean isPaintgrid, boolean hasLineBorder) {
        HashSet<ITableForPrint.IBlock> theMergeBlocks = new HashSet<ITableForPrint.IBlock>();
        HashSet<ITableForPrint.IBlock> tempMergeBlocks = new HashSet<ITableForPrint.IBlock>();
        Canvas canvas = new Canvas();
        canvas.setClipBounds(true);
        if (isPaintgrid || hasLineBorder) {
            canvas.setDecorate(this.linnBorder);
        }
        int x = 0;
        int y = 0;
        ArrayList<PainterCell> cellList = new ArrayList<PainterCell>();
        int rowSpace = sheet.getRowSpacing();
        int columnSpace = sheet.getColumnSpacing();
        for (int i = pStart.x; i <= pEnd.x; ++i) {
            int height = sheet.getRowHeight(i);
            if (height < 0) continue;
            x = 0;
            for (int j = pStart.y; j <= pEnd.y; ++j) {
                int j2 = j;
                int width = sheet.getColumnWidth(j);
                if (width <= -1) continue;
                Style style = sheet.getCellStyle(i, j);
                ITableForPrint.ICell cell = sheet.getCell(i, j, false);
                ITableForPrint.IBlock cellMerge = sheet.getMergerBlock(i, j);
                if (cellMerge != null) {
                    Iterator iter = theMergeBlocks.iterator();
                    boolean hasMerge = false;
                    while (iter.hasNext()) {
                        ITableForPrint.IBlock m = (ITableForPrint.IBlock)iter.next();
                        if (!this.contain(cellMerge, m)) continue;
                        if (m.equals(cellMerge)) {
                            hasMerge = true;
                            break;
                        }
                        tempMergeBlocks.add(m);
                        break;
                    }
                    if (!hasMerge) {
                        theMergeBlocks.add(cellMerge);
                    }
                }
                theMergeBlocks.removeAll(tempMergeBlocks);
                tempMergeBlocks.clear();
                if (cellMerge == null && this.isNeedCell(cell, style) || cellMerge == null && this.isHasBorder(cell, style)) {
                    CurrencyCell cCell;
                    CurrencyEditorRenderer.Body cRender;
                    Object render;
                    Object object = render = cell == null ? null : cell.getRender();
                    if (render instanceof CurrencyEditorRenderer.Body) {
                        cRender = (CurrencyEditorRenderer.Body)render;
                        cCell = new CurrencyCell();
                        cCell.setTitle(false);
                        cCell.setValue(cell.getValue());
                        cCell.setIntegerDigitCount(cRender.getIntegerDigitCount());
                        cCell.setDecimalDigitCount(cRender.getDecimalDigitCount());
                        cCell.setPainterBounds(x, y, width + 2, height + 2);
                        cellList.add(cCell);
                    } else if (render instanceof CurrencyEditorRenderer.Title) {
                        cRender = (CurrencyEditorRenderer.Title)render;
                        cCell = new CurrencyCell();
                        cCell.setTitle(true);
                        cCell.setValue(cell.getValue());
                        cCell.setIntegerDigitCount(cRender.getIntegerDigitCount());
                        cCell.setDecimalDigitCount(cRender.getDecimalDigitCount());
                        cCell.setPainterBounds(x, y, width + 2, height + 2);
                        cellList.add(cCell);
                    } else {
                        StyleCell borderCell = this.createStyleCell(sheet, cell, x, y, width, height, i, j, cellMerge, pEnd);
                        if (hasLineBorder) {
                            borderCell.setDecorate(this.linnBorder);
                        }
                        cellList.add(borderCell);
                    }
                } else if (cellMerge != null) {
                    j2 = pEnd.y > cellMerge.getCol2() ? cellMerge.getCol2() : pEnd.y;
                }
                for (int mj = j2; mj >= j; --mj) {
                    width = sheet.getColumnWidth(mj);
                    x = x + width + rowSpace;
                }
                j = j2;
            }
            y = y + height + columnSpace;
        }
        int bodyWidth = x + columnSpace;
        int bodyHeight = y + columnSpace;
        x = 0;
        y = 0;
        ArrayList<LineCell> gridList = new ArrayList<LineCell>();
        if (isPaintgrid) {
            Color gridColor = Color.BLACK;
            if (!this.configmodel.isSingleColor()) {
                gridColor = this.sheet.getGridColor();
            }
            if (sheet.isHorizonGridLineVisible()) {
                for (int i = pStart.x; i <= pEnd.x + 1; ++i) {
                    LineCell horizon_line = new LineCell(x, y, x + bodyWidth - 1, y, true);
                    horizon_line.setColor(gridColor);
                    gridList.add(horizon_line);
                    if (i >= pEnd.x + 1) continue;
                    int height = sheet.getRowHeight(i);
                    y = y + height + rowSpace;
                }
            }
            x = 0;
            y = 0;
            if (sheet.isVerticalGridLineVisible()) {
                for (int j = pStart.y; j <= pEnd.y + 1; ++j) {
                    LineCell ver_line = new LineCell(x, y, x, y + bodyHeight - 1, true);
                    ver_line.setColor(gridColor);
                    gridList.add(ver_line);
                    if (j >= pEnd.y + 1) continue;
                    int width = sheet.getColumnWidth(j);
                    x = x + width + columnSpace;
                }
            }
        }
        int count = theMergeBlocks.size();
        ArrayList<StyleCell> mergBlockCells = new ArrayList<StyleCell>(count);
        ArrayList<LineCell> mergGridBrushCells = new ArrayList<LineCell>();
        Iterator iter = theMergeBlocks.iterator();
        for (int i = count - 1; i >= 0; --i) {
            ITableForPrint.IBlock mergeBlock = (ITableForPrint.IBlock)iter.next();
            int row = mergeBlock.getRow();
            int col = mergeBlock.getCol();
            Style style = sheet.getCellStyle(row, col);
            ITableForPrint.ICell cell = sheet.getCell(row, col, false);
            Rectangle2D mergeRect = this.getBlockRect(sheet, pStart, mergeBlock);
            int mx = (int)mergeRect.getX();
            int my = (int)mergeRect.getY();
            int width = (int)mergeRect.getWidth();
            int height = (int)mergeRect.getHeight();
            int toRow = mergeBlock.getRow2();
            int toCol = mergeBlock.getCol2();
            StyleCell sCell = this.createStyleCell(sheet, cell, mx, my, width, height, row, col, mergeBlock, pEnd);
            sCell.setStyle(style);
            if (hasLineBorder) {
                sCell.setDecorate(this.linnBorder);
            }
            mergBlockCells.add(sCell);
            int bx = mx;
            int by = my;
            for (int ir = mergeBlock.getRow(); ir < toRow; ++ir) {
                by = by + sheet.getRowHeight(ir) + 1;
                bx = mx;
                for (int ic = mergeBlock.getCol(); ic <= toCol; ++ic) {
                    bx = bx + sheet.getColumnWidth(ic) + 1;
                }
                if (ir < toRow && sheet.getRowHeight(ir + 1) <= 0) continue;
                LineCell horizon_line = new LineCell(mx + 1, by, bx - 1, by, true);
                horizon_line.setColor(Color.WHITE);
                mergGridBrushCells.add(horizon_line);
            }
            bx = mx;
            by = my;
            for (int ic = mergeBlock.getCol(); ic < toCol; ++ic) {
                bx = bx + sheet.getColumnWidth(ic) + 1;
                by = my;
                for (int ir = mergeBlock.getRow(); ir <= toRow; ++ir) {
                    by = by + sheet.getRowHeight(ir) + 1;
                }
                if (ic < toCol && sheet.getColumnWidth(ic + 1) <= 0) continue;
                LineCell horizon_line = new LineCell(bx, my + 1, bx, by - 1, true);
                horizon_line.setColor(Color.WHITE);
                mergGridBrushCells.add(horizon_line);
            }
        }
        this.addToCanvas(gridList, canvas);
        this.addToCanvas(mergGridBrushCells, canvas);
        this.addToCanvas(cellList, canvas);
        this.addToCanvas(mergBlockCells, canvas);
        canvas.setPainterSize(bodyWidth, bodyHeight);
        return canvas;
    }

    private boolean contain(ITableForPrint.IBlock cellMerge, ITableForPrint.IBlock m) {
        return cellMerge.getRow() <= m.getRow() && cellMerge.getRow2() >= m.getRow2() && cellMerge.getCol() <= m.getCol() && cellMerge.getCol2() >= m.getCol2();
    }

    protected Rectangle2D getBlockRect(ITableForPrint asheet, SheetPoint start, ITableForPrint.IBlock mergeBlock) {
        int i;
        int i2;
        int height;
        int i3;
        int rowSpace = asheet.getRowSpacing();
        int columnSpace = asheet.getColumnSpacing();
        int fromRow = 0;
        int toRow = 0;
        int y = 0;
        if (start.x < mergeBlock.getRow()) {
            fromRow = start.x;
            toRow = mergeBlock.getRow();
            for (i3 = fromRow; i3 < toRow; ++i3) {
                height = asheet.getRowHeight(i3);
                y = y + height + columnSpace;
            }
        } else if (start.x > mergeBlock.getRow()) {
            fromRow = mergeBlock.getRow();
            toRow = start.x;
            for (i3 = fromRow; i3 < toRow; ++i3) {
                height = asheet.getRowHeight(i3);
                y = y - height - columnSpace;
            }
        }
        int fromCol = 0;
        int toCol = 0;
        int x = 0;
        if (start.y < mergeBlock.getCol()) {
            fromCol = start.y;
            toCol = mergeBlock.getCol();
            for (i2 = fromCol; i2 < toCol; ++i2) {
                int getColumnWidth = asheet.getColumnWidth(i2);
                x = x + getColumnWidth + rowSpace;
            }
        } else if (start.y > mergeBlock.getCol()) {
            fromCol = mergeBlock.getCol();
            toCol = start.y;
            for (i2 = fromCol; i2 < toCol; ++i2) {
                int width = asheet.getColumnWidth(i2);
                x = x - width - rowSpace;
            }
        }
        float mWidth = 0.0f;
        float mHeight = 0.0f;
        for (i = mergeBlock.getRow(); i <= mergeBlock.getRow2(); ++i) {
            int height2 = asheet.getRowHeight(i);
            if (height2 <= 0) continue;
            mHeight = mHeight + (float)height2 + (float)columnSpace;
        }
        mHeight -= (float)columnSpace;
        for (i = mergeBlock.getCol(); i <= mergeBlock.getCol2(); ++i) {
            int width = asheet.getColumnWidth(i);
            if (width <= 0) continue;
            mWidth = mWidth + (float)width + (float)rowSpace;
        }
        Rectangle2D.Float rect = new Rectangle2D.Float(x, y, mWidth -= (float)rowSpace, mHeight);
        return rect;
    }

    protected void addToCanvas(List arrayList, Canvas canvas) {
        int size = arrayList.size();
        for (int i = 0; i < size; ++i) {
            canvas.addPainter((IPainter)arrayList.get(i));
        }
    }

    private StyleCell createStyleCell(ITableForPrint asheet, ITableForPrint.ICell theCell, int x, int y, int width, int height, int row, int col, SheetPoint pEnd) {
        StyleCell cell = new StyleCell();
        if (theCell != null && theCell.isDiagonalCell()) {
            cell.setDiagonalInfo((AbstractTableSplitRectInfo)theCell.getDiagonalHeader());
        } else {
            String text = this.getCellText(theCell);
            cell.setText(text);
        }
        Style style = asheet.getCellStyle(row, col);
        Paint paint = style.getFillPaint();
        if (paint != null && paint.equals(Color.WHITE) && style.getPattern() == Pattern.Solid && !this.configmodel.isSingleColor()) {
            StyleAttributes ssa = Styles.getSA((ShareStyleAttributes)style);
            ssa.setBackground(Styles.getNullColor());
            style = Styles.getStyle((ShareStyleAttributes)ssa);
        }
        cell.setStyle(style);
        cell.setBlackWhite(this.configmodel.isSingleColor());
        cell.setBorderSpace(asheet.getRowSpacing());
        cell.setPainterExtend(8.0f);
        cell.setPainterBounds(x, y, width + 2, height + 2);
        for (Styles.Dir dir : StyleCell.StylesDir) {
            cell.setAroundStyles(dir, asheet.getVirtualCellStyle(row, col, dir));
        }
        if (row == pEnd.x || col == pEnd.y) {
            if (row == pEnd.x && col == pEnd.y) {
                cell.setBorderMode(3);
            } else if (row == pEnd.x) {
                cell.setBorderMode(2);
            } else {
                cell.setBorderMode(3);
            }
        }
        return cell;
    }

    protected StyleCell createStyleCell(ITableForPrint asheet, ITableForPrint.ICell theCell, int x, int y, int width, int height, int row, int col, ITableForPrint.IBlock mb, SheetPoint pEnd) {
        StyleCell cell;
        if (asheet.getType() > 0) {
            return this.createStyleCell(asheet, theCell, x, y, width, height, row, col, pEnd);
        }
        if (mb != null) {
            MergeCell mcell = new MergeCell();
            mcell.setSheet(asheet);
            mcell.setMergeBlock(mb);
            cell = mcell;
        } else {
            cell = new StyleCell();
        }
        if (theCell != null && theCell.isDiagonalCell()) {
            cell.setDiagonalInfo((AbstractTableSplitRectInfo)theCell.getDiagonalHeader());
        } else {
            cell.setText(this.getCellText(theCell));
        }
        Style style = asheet.getCellStyle(row, col);
        Paint paint = style.getFillPaint();
        if (paint != null && paint.equals(Color.WHITE) && style.getPattern() == Pattern.Solid && !this.configmodel.isSingleColor()) {
            StyleAttributes ssa = Styles.getSA((ShareStyleAttributes)style);
            ssa.setBackground(Styles.getNullColor());
            style = Styles.getStyle((ShareStyleAttributes)ssa);
        }
        cell.setStyle(style);
        cell.setBlackWhite(this.configmodel.isSingleColor());
        cell.setBorderSpace(asheet.getRowSpacing());
        cell.setTextSpace(asheet.getTextSpace());
        cell.setPainterExtend(8.0f);
        cell.setPainterBounds(x, y, width + 2, height + 2);
        if (mb == null) {
            for (Styles.Dir dir : StyleCell.StylesDir) {
                cell.setAroundStyles(dir, asheet.getVirtualCellStyle(row, col, dir));
            }
        }
        cell.setBorderMode(3);
        return cell;
    }

    private String getCellText(ITableForPrint.ICell theCell) {
        return theCell != null ? theCell.getText() : null;
    }

    protected boolean isNeedCell(ITableForPrint.ICell cell, Style style) {
        boolean isNeedPaint = false;
        boolean isNeedPaint2 = false;
        if (cell != null && (!StringUtil.isEmptyString((String)cell.getText()) || cell.isDiagonalCell())) {
            isNeedPaint = true;
        }
        if (style != null) {
            isNeedPaint2 = style.getPattern() != Pattern.None;
        }
        return isNeedPaint || isNeedPaint2;
    }

    protected boolean isHasBorder(ITableForPrint.ICell cell, Style style) {
        boolean isNeedPaint = false;
        if (cell != null && cell.getMerge() != null) {
            return false;
        }
        if (style == null) {
            return false;
        }
        boolean isNeed2 = style.getBorderLineStyle(Styles.Position.TOP) != LineStyle.NULL_LINE;
        boolean isNeed3 = style.getBorderLineStyle(Styles.Position.LEFT) != LineStyle.NULL_LINE;
        boolean isNeed4 = style.getBorderLineStyle(Styles.Position.RIGHT) != LineStyle.NULL_LINE;
        boolean isNeed5 = style.getBorderLineStyle(Styles.Position.BOTTOM) != LineStyle.NULL_LINE;
        isNeedPaint = isNeed2 || isNeed3 || isNeed4 || isNeed5;
        return isNeedPaint;
    }

    public boolean isEmpty() {
        return this.sheet.isEmpty();
    }

    public boolean isPrinArea() {
        return this.printmode != null && this.printmode instanceof TablePrintSetupModel && ((TablePrintSetupModel)this.printmode).getPrintContentType() == 0 || this.configmodel.getPrintAreas() != null;
    }

    protected boolean isPaintGrid() {
        return this.configmodel.isGrid();
    }

    public int pageCount(PaperInfo info) {
        boolean isPrintArea;
        if (this.scopeEnd.x < 0 || this.scopeEnd.y < 0) {
            this.currentBlockIndex = 0;
            return 0;
        }
        boolean bl = isPrintArea = this.printmode != null && ((TablePrintSetupModel)this.printmode).getPrintContentType() == 0 || this.configmodel.getPrintAreas() != null;
        if (!isPrintArea) {
            DimensionFloat rect;
            DimensionFloat bodyrect;
            boolean hasNext;
            int thePageCount = 0;
            while (hasNext = this.computeNextPageRect(bodyrect = this.computeBodyRect(rect = info.getPaintableSize(), thePageCount), thePageCount)) {
                ++thePageCount;
            }
            this.currentBlockIndex = 0;
            return thePageCount;
        }
        return -1;
    }

    public void addPageScope(int index, SheetPoint p1, SheetPoint p2) {
        this.pageScopeList.put(index, new Pair(p1, p2, null));
    }

    private void addPageScope(int index, SheetPoint p1, SheetPoint p2, RepeatRow rRow) {
        this.pageScopeList.put(index, new Pair(p1, p2, rRow));
    }

    public int[] getColPaginationPointsSnapshot() {
        Iterator it = this.pageScopeList.entrySet().iterator();
        TreeSet<Integer> ts = new TreeSet<Integer>();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (entry.getKey().equals(Integer.valueOf("-1"))) continue;
            ts.add(((Pair)((Pair)entry.getValue())).p2.y);
        }
        int count = ts.size();
        int[] colPaginationPoints = new int[count + 1];
        it = ts.iterator();
        int i = 1;
        while (it.hasNext()) {
            colPaginationPoints[i++] = (Integer)((Object)it.next());
        }
        return colPaginationPoints;
    }

    public int[] getRowPaginationPointsSnapshot() {
        Iterator it = this.pageScopeList.entrySet().iterator();
        TreeSet<Integer> ts = new TreeSet<Integer>();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (entry.getKey().equals(Integer.valueOf("-1"))) continue;
            ts.add(((Pair)((Pair)entry.getValue())).p2.x);
        }
        int count = ts.size();
        int[] rowPaginationPoints = new int[count + 1];
        it = ts.iterator();
        int i = 1;
        while (it.hasNext()) {
            rowPaginationPoints[i++] = (Integer)((Object)it.next());
        }
        return rowPaginationPoints;
    }

    public boolean getPageScope(int index, SheetPoint p1, SheetPoint p2) {
        return this.getPageScope(index, p1, p2, null);
    }

    public boolean getPageScope(int index, SheetPoint p1, SheetPoint p2, RepeatRow rRow) {
        Pair pair = (Pair)this.pageScopeList.get(index);
        if (pair != null) {
            p1.set(pair.getFirst());
            p2.set(pair.getSecond());
            if (rRow != null && pair.getRepeatRow() != null) {
                rRow.set(pair.getRepeatRow());
            }
            return true;
        }
        return false;
    }

    public void initCofigModel() {
        SheetPoint p1 = new SheetPoint();
        SheetPoint p2 = new SheetPoint();
        if (this.pageIndex == 0) {
            this.currentBlockIndex = 0;
        }
        if (!this.getPageScope(0, p1, p2)) {
            this.scopeStart = new SheetPoint(0, 0);
            this.scopeEnd = new SheetPoint();
            this.scopeEnd.x = this.sheet.getMaxRowIndex();
            this.scopeEnd.y = this.sheet.getMaxColIndex();
            if (this.configmodel.getOrder()) {
                p1 = new SheetPoint(-1, 0);
                p2 = new SheetPoint(-1, 0);
            } else {
                p1 = new SheetPoint(0, -1);
                p2 = new SheetPoint(0, -1);
            }
            this.addPageScope(-1, p1, p2);
            if (this.printmode != null && this.printmode instanceof TablePrintSetupModel && ((TablePrintSetupModel)this.printmode).getPrintContentType() == 0 || this.configmodel.getPrintAreas() != null) {
                if (this.printmode instanceof TablePrintSetupModel && ((TablePrintSetupModel)this.printmode).getPrintContentType() == 0) {
                    Iterator iter = this.sheet.getSelectIterator(true);
                    ArrayList theselectBlocks = new ArrayList(5);
                    while (iter.hasNext()) {
                        theselectBlocks.add(iter.next());
                    }
                    this.selectBlocks = theselectBlocks;
                } else if (this.configmodel.getPrintAreas() != null) {
                    this.selectBlocks = this.configmodel.printAreasToList();
                }
            }
        }
    }

    public void setTablePageSetupModel(TablePageSetupModel configmodel) {
        this.configmodel = configmodel;
    }

    public void clear() {
        this.pageScopeList.clear();
        SheetPoint p1 = new SheetPoint(-1, 0);
        SheetPoint p2 = new SheetPoint(-1, 0);
        this.addPageScope(-1, p1, p2);
        this.currentBlockIndex = 0;
        this.linepageCount = -1;
        this.topTitleRowsHeight = -1;
        this.leftTitleColumnsWidth = -1;
        this.titleColumnsIndexs = null;
        this.titleRowsIndexs = null;
        if (this.selectBlocks != null) {
            this.selectBlocks.clear();
        }
    }

    private void createTopLeftCornet(Canvas page, int rowHeaderWidth, int colHeaderHeight) {
        LabelCell cornerCell = new LabelCell();
        cornerCell.setDecorate(this.linnBorder);
        cornerCell.setStyle(this.getTopLeftCornerStyle());
        cornerCell.setPainterBounds(0.0f, 0.0f, rowHeaderWidth, colHeaderHeight);
        page.addPainter(cornerCell);
    }

    protected Style getTopLeftCornerStyle() {
        return null;
    }

    private Canvas getLeftTitleColumns(ITableForPrint sheet, int index) {
        int isNeed = this.isNeedTopTitleRowORLeftTitleColumn(index);
        if (isNeed != 2 && isNeed != 3) {
            return null;
        }
        int[] indexArray = this.getLeftTitleColumnsIndexs();
        if (indexArray[0] > indexArray[1]) {
            return null;
        }
        Canvas canvas = new Canvas();
        SheetPoint p1 = new SheetPoint();
        SheetPoint p2 = new SheetPoint();
        this.getPageScope(index, p1, p2);
        int tx = 0;
        float height = 0.0f;
        SheetPoint c1 = new SheetPoint(p1.x, indexArray[0]);
        SheetPoint c2 = new SheetPoint(p2.x, indexArray[1]);
        Canvas titleArea = this.createPrintBody(sheet, c1, c2);
        height = (float)titleArea.getPainterSize().getHeight();
        canvas.addPainter(titleArea);
        titleArea.setPainterLocation(tx, 0.0f);
        for (int i = indexArray[0]; i <= indexArray[1]; ++i) {
            tx = tx + sheet.getColumnWidth(i) + sheet.getColumnSpacing();
        }
        canvas.setPainterSize(tx, height);
        int x = 0;
        int y = 0;
        if (this.configmodel.isColumnIndex()) {
            y = sheet.getColumnHeaderHeight() - 1;
        }
        if (this.configmodel.isRowIndex()) {
            x = sheet.getRowHeaderWidth() - 1;
        }
        if (isNeed == 3) {
            int topTitleRowHeight = this.getHeightOFRows(sheet);
            y += topTitleRowHeight;
        }
        canvas.setPainterLocation(x, y);
        return canvas;
    }

    private Canvas getTopTitleRows(ITableForPrint sheet, int index) {
        int isNeed = this.isNeedTopTitleRowORLeftTitleColumn(index);
        if (isNeed != 1 && isNeed != 3) {
            return null;
        }
        int[] indexArray = this.getTopTitleRowsIndexs();
        if (indexArray[0] > indexArray[1]) {
            return null;
        }
        Canvas canvas = new Canvas();
        SheetPoint p1 = new SheetPoint();
        SheetPoint p2 = new SheetPoint();
        this.getPageScope(index, p1, p2);
        int ty = 0;
        float width = 0.0f;
        SheetPoint c1 = new SheetPoint(indexArray[0], p1.y);
        SheetPoint c2 = new SheetPoint(indexArray[1], p2.y);
        Canvas titleArea = this.createPrintBody(sheet, c1, c2);
        width = (float)titleArea.getPainterSize().getWidth();
        canvas.addPainter(titleArea);
        titleArea.setPainterLocation(0.0f, ty);
        for (int i = indexArray[0]; i <= indexArray[1]; ++i) {
            ty = ty + sheet.getRowHeight(i) + sheet.getRowSpacing();
        }
        canvas.setPainterSize(width, ty);
        int x = 0;
        int y = 0;
        if (this.configmodel.isColumnIndex()) {
            y = sheet.getColumnHeaderHeight() - 1;
        }
        if (this.configmodel.isRowIndex()) {
            x = sheet.getRowHeaderWidth() - 1;
        }
        if (isNeed == 3) {
            int topTitleRowHeight = this.getWidthOFColumns(sheet);
            x += topTitleRowHeight;
        }
        canvas.setPainterLocation(x, y);
        return canvas;
    }

    private Canvas getTitleCorner(ITableForPrint sheet, int index) {
        int[] titleColumns = this.getLeftTitleColumnsIndexs();
        int[] titleRows = this.getTopTitleRowsIndexs();
        if (titleColumns[0] > titleColumns[1]) {
            return null;
        }
        if (titleRows[0] > titleRows[1]) {
            return null;
        }
        Canvas canvas = new Canvas();
        float x = 0.0f;
        float y = 0.0f;
        float width = 0.0f;
        SheetPoint t1 = new SheetPoint(titleRows[0], titleColumns[0]);
        SheetPoint t2 = new SheetPoint(titleRows[1], titleColumns[1]);
        Canvas oneRow = this.createPrintBody(sheet, t1, t2);
        width = (float)oneRow.getPainterSize().getWidth();
        oneRow.setPainterLocation(x, y);
        canvas.addPainter(oneRow);
        for (int i = titleRows[0]; i <= titleRows[1]; ++i) {
            y = y + (float)oneRow.getPainterSize().getHeight() - 1.0f;
        }
        float height = y;
        x = 0.0f;
        y = 0.0f;
        if (this.configmodel.isColumnIndex()) {
            y = (float)sheet.getColumnHeaderHeight() - 1.0f;
        }
        if (this.configmodel.isRowIndex()) {
            x = (float)sheet.getRowHeaderWidth() - 1.0f;
        }
        canvas.setPainterBounds(x, y, width, height);
        return canvas;
    }

    protected int[] getLeftTitleColumnsIndexs() {
        if (this.titleColumnsIndexs == null) {
            this.titleColumnsIndexs = TablePrintPagination.getLeftTitleColumnsIndex(this.configmodel.getLeftTitleColumnList());
        }
        return this.titleColumnsIndexs;
    }

    private int[] getTopTitleRowsIndexs() {
        if (this.titleRowsIndexs == null) {
            this.titleRowsIndexs = TablePrintPagination.getTopTitleRowsIndex(this.configmodel.getTopTileRowList());
        }
        return this.titleRowsIndexs;
    }

    private Canvas createBody(Dimension2D rect, int pageIndex) {
        DimensionFloat bodyrect = this.computeBodyRect(rect, pageIndex);
        boolean hasNext = this.computeNextPageRect(bodyrect, pageIndex);
        bodyrect = this.computeBodyRect(rect, pageIndex);
        if (hasNext) {
            SheetPoint p1 = new SheetPoint();
            SheetPoint p2 = new SheetPoint();
            RepeatRow rRow = new RepeatRow();
            this.getPageScope(pageIndex, p1, p2, rRow);
            if (rRow.getHeight() != 0) {
                SheetPoint r1 = new SheetPoint();
                SheetPoint r2 = new SheetPoint();
                r1.set(p1);
                r2.set(p2);
                r1.x = rRow.getRow1();
                r2.x = rRow.getRow2();
                Canvas page1 = this.createPrintBody(this.sheet, r1, r2);
                page1.setPainterLocation(0.0f, 0.0f);
                Canvas page = this.createPrintBody(this.sheet, p1, p2);
                page.setPainterLocation(0.0f, rRow.getHeight());
                TableColumnsInfo columnsInfo = new TableColumnsInfo(this.sheet, p1.y, p2.y);
                page.setUserObject(columnsInfo);
                float x = (float)(rect.getWidth() - (double)bodyrect.width);
                float y = (float)(rect.getHeight() - (double)bodyrect.height);
                if (this.configmodel.isColumnIndex()) {
                    y -= 1.0f;
                }
                if (this.configmodel.isRowIndex()) {
                    x -= 1.0f;
                }
                columnsInfo.setStartPosition(x);
                page.setPainterLocation(x, y);
                return page;
            }
            Canvas page = this.createPrintBody(this.sheet, p1, p2);
            TableColumnsInfo columnsInfo = new TableColumnsInfo(this.sheet, p1.y, p2.y);
            page.setUserObject(columnsInfo);
            float x = (float)(rect.getWidth() - (double)bodyrect.width);
            float y = (float)(rect.getHeight() - (double)bodyrect.height);
            if (this.configmodel.isColumnIndex()) {
                y -= 1.0f;
            }
            if (this.configmodel.isRowIndex()) {
                x -= 1.0f;
            }
            columnsInfo.setStartPosition(x);
            page.setPainterLocation(x, y);
            return page;
        }
        return null;
    }

    private boolean computeNextPageRect(DimensionFloat rect, int thePageIndex) {
        if (this.printmode != null && this.printmode instanceof TablePrintSetupModel && ((TablePrintSetupModel)this.printmode).getPrintContentType() == 0 || this.configmodel.getPrintAreas() != null) {
            if (!this.configmodel.isAutoConnect()) {
                return this.computeNextPageByArea(rect, thePageIndex);
            }
            return this.computeNextPage(rect, this.scopeStart, this.scopeEnd, thePageIndex);
        }
        return this.computeNextPage(rect, this.scopeStart, this.scopeEnd, thePageIndex);
    }

    private boolean computeNextPageByArea(DimensionFloat rect, int pageIndex) {
        int size = 0;
        if (this.selectBlocks != null) {
            size = this.selectBlocks.size();
        }
        if (this.currentBlockIndex > size - 1 || this.selectBlocks == null) {
            return false;
        }
        ITableForPrint.IBlock block = (ITableForPrint.IBlock)this.selectBlocks.get(this.currentBlockIndex);
        if (block == null) {
            return false;
        }
        int x1 = 0;
        int x2 = 0;
        int y1 = 0;
        int y2 = 0;
        if (block.getMode() == 2) {
            x1 = block.getRow();
            x2 = block.getRow2();
            y1 = this.scopeStart.y;
            y2 = this.scopeEnd.y;
        } else if (block.getMode() == 4) {
            x1 = this.scopeStart.x;
            x2 = this.scopeEnd.x;
            y1 = block.getCol();
            y2 = block.getCol2();
        } else if (block.getMode() == 8) {
            x1 = block.getRow();
            x2 = this.scopeEnd.x;
            y1 = block.getCol();
            y2 = this.scopeEnd.y;
        } else {
            x1 = block.getRow();
            x2 = block.getRow2();
            y1 = block.getCol();
            y2 = block.getCol2();
        }
        SheetPoint theScopeStart = new SheetPoint(x1, y1);
        SheetPoint theScopeEnd = new SheetPoint(x2, y2);
        this.computeNextPage(rect, theScopeStart, theScopeEnd, pageIndex);
        SheetPoint p1 = new SheetPoint();
        SheetPoint p2 = new SheetPoint();
        boolean getScope = this.getPageScope(pageIndex, p1, p2);
        if (x2 == p2.x && y2 == p2.y) {
            ++this.currentBlockIndex;
        }
        return getScope;
    }

    private boolean computeNextPage(DimensionFloat rect, SheetPoint thescopeStart, SheetPoint thescopeEnd, int thePageIndex) {
        Pair pair;
        if (!this.forr1 && (pair = (Pair)this.pageScopeList.get(thePageIndex)) != null) {
            return true;
        }
        SheetPoint p1 = new SheetPoint();
        SheetPoint p2 = new SheetPoint();
        boolean isGet = this.getPageScope(thePageIndex - 1, p1, p2);
        if (!isGet) {
            return false;
        }
        if (p2.x >= thescopeEnd.x && p2.y >= thescopeEnd.y) {
            return false;
        }
        SheetPoint startPoint = new SheetPoint();
        if (this.configmodel == null || this.configmodel.getOrder()) {
            if (this.isFirstPage(thePageIndex) || !this.isIn(p1, p2, thescopeStart, thescopeEnd)) {
                startPoint.x = thescopeStart.x;
                startPoint.y = thescopeStart.y;
            } else if (p2.x + 1 > thescopeEnd.x) {
                startPoint.x = thescopeStart.x;
                startPoint.y = p2.y + 1;
            } else {
                startPoint.x = p2.x + 1;
                startPoint.y = p1.y;
            }
        } else if (this.isFirstPage(thePageIndex) || !this.isIn(p1, p2, thescopeStart, thescopeEnd)) {
            startPoint.x = thescopeStart.x;
            startPoint.y = thescopeStart.y;
        } else if (p2.y + 1 > thescopeEnd.y) {
            startPoint.x = p2.x + 1;
            startPoint.y = thescopeStart.y;
        } else {
            startPoint.x = p1.x;
            startPoint.y = p2.y + 1;
        }
        p1 = startPoint;
        float width = (float)rect.getWidth();
        float height = (float)rect.getHeight();
        int maxIndex = thescopeEnd.x;
        RepeatRow rRow = this.computeRepeatRow(startPoint.x, maxIndex);
        if (rRow != null) {
            if (startPoint.x >= rRow.getRow1() && startPoint.x <= rRow.getRow2()) {
                startPoint.x = rRow.getRow2() + 1;
            }
            height -= (float)rRow.getHeight();
        }
        p2.x = this.computeRowColumnIndex(height, startPoint.x, true, maxIndex);
        maxIndex = thescopeEnd.y;
        p2.y = this.computeRowColumnIndex(width, startPoint.y, false, maxIndex);
        if (this.linepageCount < 0) {
            if (this.configmodel.getOrder()) {
                if (p2.x == thescopeEnd.x) {
                    this.linepageCount = thePageIndex + 1;
                }
            } else if (p2.y == thescopeEnd.y) {
                this.linepageCount = thePageIndex + 1;
            }
        }
        this.addPageScope(thePageIndex, p1, p2, rRow);
        return true;
    }

    private boolean isIn(SheetPoint sp1, SheetPoint sp2, SheetPoint thescopeStart, SheetPoint thescopeEnd) {
        boolean isIn1 = sp1.x >= thescopeStart.x && sp1.x <= thescopeEnd.x && sp1.y >= thescopeStart.y && sp1.y <= thescopeEnd.y;
        boolean isIn2 = sp2.x >= thescopeStart.x && sp2.x <= thescopeEnd.x && sp2.y >= thescopeStart.y && sp2.y <= thescopeEnd.y;
        return isIn1 && isIn2;
    }

    private boolean isFirstPage(int pageIndex) {
        SheetPoint p1 = new SheetPoint();
        SheetPoint p2 = new SheetPoint();
        this.getPageScope(pageIndex - 1, p1, p2);
        return p1.x < 0 || p1.y < 0 || p2.x < 0 || p2.y < 0;
    }

    protected int[] getRepeatRowIndexs(int startPosition, int maxIndex) {
        return null;
    }

    private RepeatRow computeRepeatRow(int startPosition, int maxIndex) {
        int[] rIndexs = this.getRepeatRowIndexs(startPosition, maxIndex);
        if (rIndexs != null) {
            RepeatRow rRow = new RepeatRow();
            rRow.setRow1(rIndexs[0]);
            rRow.setRow2(rIndexs[1]);
            int h = 0;
            for (int i = rIndexs[0]; i <= rIndexs[1]; ++i) {
                h += this.getRowHeightOrColumnWidth(startPosition, true);
            }
            rRow.setHeight(h);
            return rRow;
        }
        return null;
    }

    private int computeRowColumnIndex(float scope, int startPosition, boolean isRow, int maxIndex) {
        int index;
        block10: {
            block11: {
                int minuseEiminate;
                index = this.getNextRow(startPosition, isRow);
                int temp = 1 + this.getRowHeightOrColumnWidth(index, isRow);
                PlugablePaginationAdvice ppa = this.sheet.getPlugablePaginationAdvice();
                if (ppa == null) break block11;
                do {
                    if (isRow ? ppa.isRowShrinkedBreak(index) : ppa.isColShrinkedBreak(index)) {
                        return index;
                    }
                    if ((index = this.getNextRow(index, isRow) + 1) > maxIndex) {
                        return --index;
                    }
                    minuseEiminate = this.getRowHeightOrColumnWidth(index, isRow);
                    if (minuseEiminate != -1) continue;
                    minuseEiminate = 0;
                } while (!((float)(temp += minuseEiminate) > scope + 1.0f));
                --index;
                while (this.getRowHeightOrColumnWidth(index, isRow) == -1) {
                    --index;
                }
                boolean hasExtendedBreak = false;
                int tempIndex = index + 1;
                temp = 1 + this.getRowHeightOrColumnWidth(tempIndex, isRow);
                do {
                    if (isRow) {
                        if (ppa.isRowExtendedBreak(tempIndex)) {
                            hasExtendedBreak = true;
                            break;
                        }
                    } else if (ppa.isColExtendedBreak(tempIndex)) {
                        hasExtendedBreak = true;
                        break;
                    }
                    if (++tempIndex > maxIndex) break;
                    minuseEiminate = this.getRowHeightOrColumnWidth(tempIndex, isRow);
                    if (minuseEiminate != -1) continue;
                    minuseEiminate = 0;
                } while (!((float)(temp += minuseEiminate) > scope + 1.0f));
                if (!hasExtendedBreak) break block10;
                index = tempIndex;
                break block10;
            }
            do {
                if ((index = this.getNextRow(index, isRow) + 1) <= maxIndex) continue;
                --index;
                break block10;
            } while (!((float)(temp += this.getRowHeightOrColumnWidth(index, isRow)) > scope + 1.0f));
            --index;
        }
        return index;
    }

    private int getNextRow(int index, boolean isRow) {
        if (isRow) {
            int[] rows = this.getTopTitleRowsIndexs();
            if (index == rows[0]) {
                return rows[rows.length - 1] + 1;
            }
        } else {
            int[] cols = this.getLeftTitleColumnsIndexs();
            if (index == cols[0]) {
                return cols[cols.length - 1] + 1;
            }
        }
        return index;
    }

    private int getRowHeightOrColumnWidth(int index, boolean type) {
        if (type) {
            int h = this.sheet.getRowHeight(index) + this.sheet.getRowSpacing(index);
            if (h < 0) {
                h = 0;
            }
            return h;
        }
        int w = this.sheet.getColumnWidth(index) + this.sheet.getColumnSpacing(index);
        if (w < 0) {
            w = 0;
        }
        return w;
    }

    private DimensionFloat computeBodyRect(Dimension2D rect, int pageIndex) {
        int isNeed;
        DimensionFloat bodyRect = new DimensionFloat(rect.getWidth(), rect.getHeight());
        if (this.configmodel == null) {
            return bodyRect;
        }
        if (this.configmodel.isColumnIndex()) {
            int titleRowheight = this.sheet.getColumnHeaderHeight();
            bodyRect.setHeight(rect.getHeight() - (double)titleRowheight);
        }
        if (this.configmodel.isRowIndex()) {
            int titleColumnWidth = this.sheet.getRowHeaderWidth();
            bodyRect.setWidth(rect.getWidth() - (double)titleColumnWidth);
        }
        if ((isNeed = this.isNeedTopTitleRowORLeftTitleColumn(pageIndex)) == 1) {
            bodyRect = this.minusHeightByTitleRows(bodyRect);
        } else if (isNeed == 2) {
            bodyRect = this.minusWidthByTitleColumns(bodyRect);
        } else if (isNeed == 3) {
            bodyRect = this.minusHeightByTitleRows(bodyRect);
            bodyRect = this.minusWidthByTitleColumns(bodyRect);
        }
        return bodyRect;
    }

    private DimensionFloat minusWidthByTitleColumns(DimensionFloat bodyRect) {
        int titleColumnWidth = this.getLeftTitleColumnsWidth();
        bodyRect.setWidth(bodyRect.getWidth() - (double)titleColumnWidth);
        return bodyRect;
    }

    private DimensionFloat minusHeightByTitleRows(DimensionFloat bodyRect) {
        int titleRowsHeight = this.getTopTitleRowsHeight();
        bodyRect.setHeight(bodyRect.getHeight() - (double)titleRowsHeight);
        return bodyRect;
    }

    private boolean isPaperOnBorder(int pageIndex) {
        int pos;
        boolean isOn = false;
        int i = 1;
        while ((pos = pageIndex - this.linepageCount * i) >= 0) {
            if (pos == 0) {
                isOn = true;
                break;
            }
            ++i;
        }
        return isOn;
    }

    private int getTopTitleRowsHeight() {
        if (this.topTitleRowsHeight < 0) {
            this.topTitleRowsHeight = this.getHeightOFRows(this.sheet);
        }
        return this.topTitleRowsHeight;
    }

    private int getLeftTitleColumnsWidth() {
        if (this.leftTitleColumnsWidth < 0) {
            this.leftTitleColumnsWidth = this.getWidthOFColumns(this.sheet);
        }
        return this.leftTitleColumnsWidth;
    }

    protected int isNeedTopTitleRowORLeftTitleColumn(int paperIndex) {
        boolean hasTopTitleRows;
        int result = 0;
        boolean hasLeftTitleColumns = this.configmodel.getLeftTitleColumns() != null;
        boolean bl = hasTopTitleRows = this.configmodel.getTopTitleRows() != null;
        if (hasLeftTitleColumns || hasTopTitleRows) {
            Pair pair = (Pair)this.pageScopeList.get(paperIndex);
            if (pair != null) {
                SheetPoint start = pair.getFirst();
                SheetPoint end = pair.getSecond();
                int[] cols = this.getLeftTitleColumnsIndexs();
                int[] rows = this.getTopTitleRowsIndexs();
                hasLeftTitleColumns = hasLeftTitleColumns && end.y >= cols[0] && (start.y > cols[0] || cols[cols.length - 1] > end.y);
                boolean bl2 = hasTopTitleRows = hasTopTitleRows && end.x >= rows[0] && (start.x > rows[0] || rows[rows.length - 1] > end.x);
            }
            if (hasLeftTitleColumns && hasTopTitleRows) {
                result = 3;
            } else if (hasLeftTitleColumns) {
                result = 2;
            } else if (hasTopTitleRows) {
                result = 1;
            }
        }
        return result;
    }

    private Canvas createColumnIndexArea(ITableForPrint sheet, SheetPoint pStart, SheetPoint pEnd, int pageIndex) {
        if (!this.configmodel.isRowIndex()) {
            return null;
        }
        if (sheet.getRowHeaderWidth() <= 0) {
            return null;
        }
        Canvas canvas = new Canvas();
        boolean x = false;
        int y = 0;
        int endRowX = pEnd.x;
        int isNeed = this.isNeedTopTitleRowORLeftTitleColumn(pageIndex);
        if (isNeed == 1 || isNeed == 3) {
            int[] indexs = this.getTopTitleRowsIndexs();
            for (int i = indexs[0]; i <= indexs[1]; ++i) {
                int colIndex = i;
                int height = sheet.getRowHeight(colIndex) + 2;
                if (height == 2) continue;
                LabelCell labCell = new LabelCell("" + (colIndex + 1));
                labCell.setDecorate(this.linnBorder);
                labCell.setStyle(this.getColumnIndexStyle());
                labCell.setPainterBounds((float)x, y, sheet.getRowHeaderWidth(), height);
                canvas.addPainter(labCell);
                y = y + height - 1;
            }
        }
        for (int i = pStart.x; i <= endRowX; ++i) {
            int height = sheet.getRowHeight(i) + 2;
            if (height == 2) continue;
            LabelCell labCell = new LabelCell("" + (i + 1));
            labCell.setDecorate(this.linnBorder);
            labCell.setStyle(this.getColumnIndexStyle());
            labCell.setPainterBounds((float)x, y, sheet.getRowHeaderWidth(), height);
            canvas.addPainter(labCell);
            y = y + height - 1;
        }
        canvas.setPainterSize(sheet.getRowHeaderWidth(), y + 1);
        int pY = 0;
        if (this.configmodel.isColumnIndex()) {
            pY = sheet.getColumnHeaderHeight() - 1;
        }
        canvas.setPainterLocation(0.0f, pY);
        return canvas;
    }

    protected Style getColumnIndexStyle() {
        return null;
    }

    protected Canvas createRowIndexArea(ITableForPrint sheet, SheetPoint pStart, SheetPoint pEnd, int pageIndex) {
        if (!this.configmodel.isColumnIndex()) {
            return null;
        }
        Canvas canvas = new Canvas();
        int x = 0;
        boolean y = false;
        int endColY = pEnd.y;
        int isNeed = this.isNeedTopTitleRowORLeftTitleColumn(pageIndex);
        if (isNeed == 2 || isNeed == 3) {
            int[] indexs = this.getLeftTitleColumnsIndexs();
            for (int i = indexs[0]; i <= indexs[1]; ++i) {
                int colIndex = i;
                int width = sheet.getColumnWidth(colIndex) + 2;
                if (width == 2) continue;
                LabelCell labCell = new LabelCell(sheet.getColumnName(colIndex));
                labCell.setPainterBounds(x, (float)y, width, sheet.getColumnHeaderHeight());
                labCell.setDecorate(this.linnBorder);
                canvas.addPainter(labCell);
                x = x + width - 1;
            }
        }
        for (int j = pStart.y; j <= endColY; ++j) {
            int width = sheet.getColumnWidth(j) + 2;
            if (width == 2) continue;
            LabelCell labCell = new LabelCell(sheet.getColumnName(j));
            labCell.setPainterBounds(x, (float)y, width, sheet.getColumnHeaderHeight());
            labCell.setDecorate(this.linnBorder);
            canvas.addPainter(labCell);
            x = x + width - 1;
        }
        canvas.setPainterSize(x + 1, sheet.getColumnHeaderHeight());
        int pX = 0;
        if (this.configmodel.isRowIndex()) {
            pX = sheet.getRowHeaderWidth() - 1;
        }
        canvas.setPainterLocation(pX, 0.0f);
        return canvas;
    }

    public static int[] getLeftTitleColumnsIndex(List titleColumns) {
        int[] indexs = new int[2];
        if (titleColumns.size() <= 0) {
            indexs[0] = 0;
            indexs[1] = -1;
        } else {
            ITableForPrint.IBlock block = (ITableForPrint.IBlock)titleColumns.get(0);
            indexs[0] = block.getCol();
            indexs[1] = block.getCol2();
        }
        return indexs;
    }

    public static int[] getTopTitleRowsIndex(List titleRows) {
        int[] indexs = new int[2];
        if (titleRows.size() <= 0) {
            indexs[0] = 0;
            indexs[1] = -1;
        } else {
            ITableForPrint.IBlock block = (ITableForPrint.IBlock)titleRows.get(0);
            indexs[0] = block.getRow();
            indexs[1] = block.getRow2();
        }
        return indexs;
    }

    public int getWidthOFColumns(ITableForPrint sheet) {
        int[] titleColumns = this.getLeftTitleColumnsIndexs();
        int width = 0;
        if (titleColumns == null || titleColumns.length == 0) {
            width = 0;
        } else {
            int colSpace = sheet.getColumnSpacing();
            for (int i = titleColumns[0]; i <= titleColumns[1]; ++i) {
                if (sheet.getColumnWidth(i) <= 0) {
                    titleColumns[1] = titleColumns[1] + 1;
                }
                width += sheet.getColumnWidth(i);
                width += colSpace;
            }
        }
        return width;
    }

    public int getHeightOFRows(ITableForPrint sheet) {
        int[] titleRows = this.getTopTitleRowsIndexs();
        int height = 0;
        if (titleRows == null || titleRows.length == 0) {
            height = 0;
        } else {
            int rowSpace = sheet.getRowSpacing();
            for (int i = titleRows[0]; i <= titleRows[1]; ++i) {
                if (sheet.getRowHeight(i) <= 0) {
                    titleRows[1] = titleRows[1] + 1;
                }
                height += sheet.getRowHeight(i);
                height += rowSpace;
            }
        }
        return height;
    }

    private boolean iseftColumTitleOut(ITableForPrint sheet, double bodyHeight) {
        int[] titleColumns = this.getLeftTitleColumnsIndexs();
        if (titleColumns == null || titleColumns.length == 0) {
            return false;
        }
        int colSpace = sheet.getColumnSpacing();
        int width = 0;
        int i = titleColumns[0];
        while (i <= titleColumns[1]) {
            int col = i++;
            width += sheet.getColumnWidth(col);
            if (!((double)(width += colSpace) > bodyHeight)) continue;
            return true;
        }
        return false;
    }

    private boolean isTopRowTitleOut(ITableForPrint sheet, double bodyHeight) {
        int[] titleRows = this.getTopTitleRowsIndexs();
        if (titleRows == null || titleRows.length == 0) {
            return false;
        }
        int height = 0;
        int rowSpace = sheet.getRowSpacing();
        int i = titleRows[0];
        while (i <= titleRows[1]) {
            int rowIndex = i++;
            height += sheet.getRowHeight(rowIndex);
            if (!((double)(height += rowSpace) > bodyHeight)) continue;
            return true;
        }
        return false;
    }

    public void setPageIndex(int pageIndex2) {
        this.pageIndex = pageIndex2;
    }

    public static class Pair {
        private SheetPoint p1;
        private SheetPoint p2;
        private RepeatRow rRow;

        public Pair(SheetPoint p1, SheetPoint p2, RepeatRow rRow) {
            this.p1 = p1;
            this.p2 = p2;
            this.rRow = rRow;
        }

        public SheetPoint getFirst() {
            return this.p1;
        }

        public SheetPoint getSecond() {
            return this.p2;
        }

        public RepeatRow getRepeatRow() {
            return this.rRow;
        }
    }

    public static class SheetPoint {
        public int x = 0;
        public int y = 0;

        public SheetPoint() {
        }

        public SheetPoint(int i, int j) {
            this.x = i;
            this.y = j;
        }

        public void set(SheetPoint p) {
            this.x = p.x;
            this.y = p.y;
        }

        public String toString() {
            return "p:x=" + this.x + ",y=" + this.y;
        }

        public boolean equals(Object p) {
            if (p instanceof SheetPoint) {
                SheetPoint pp = (SheetPoint)p;
                return this.x == pp.x && this.y == pp.y;
            }
            return false;
        }
    }

    public static class RepeatRow {
        private int row1 = 0;
        private int row2 = 0;
        private int height = 0;

        public int getRow1() {
            return this.row1;
        }

        public void setRow1(int row1) {
            this.row1 = row1;
        }

        public int getRow2() {
            return this.row2;
        }

        public void setRow2(int row2) {
            this.row2 = row2;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public void set(RepeatRow rRow) {
            this.row1 = rRow.row1;
            this.row2 = rRow.row2;
            this.height = rRow.height;
        }
    }
}

