/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.ui.component;

import com.kingdee.cosmic.ctrl.print.config.IXmlTranslate;
import com.kingdee.cosmic.ctrl.print.ui.component.BasicPainter;
import com.kingdee.cosmic.ctrl.print.ui.component.IPainter;
import com.kingdee.cosmic.ctrl.print.ui.view.BasicPainterView;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Canvas
extends BasicPainter {
    protected boolean clipBounds = false;

    public Canvas() {
        this.updateView();
    }

    protected List createCollection() {
        return new ArrayList();
    }

    private Map getChildMap() {
        if (this.childrenMap == null) {
            this.childrenMap = new TreeMap();
        }
        return this.childrenMap;
    }

    @Override
    public void addPainter(IPainter painter) {
        if (painter != null) {
            this.addPainter(painter, painter.getLayer());
        }
    }

    @Override
    public void addPainter(IPainter painter, int layer) {
        if (painter != null) {
            Integer layerKey = layer;
            List list = (List)this.getChildMap().get(layerKey);
            if (list == null) {
                list = this.createCollection();
                this.getChildMap().put(layerKey, list);
            }
            if (painter.getParent() != null) {
                painter.getParent().removePainter(painter);
            }
            painter.setParent(this);
            list.add(painter);
            Collections.sort(list, new Comparator(){

                public int compare(Object a, Object b) {
                    if (a instanceof BasicPainter && b instanceof BasicPainter) {
                        BasicPainter ap = (BasicPainter)a;
                        BasicPainter bp = (BasicPainter)b;
                        return ap.getZIndex() - bp.getZIndex();
                    }
                    return 0;
                }
            });
        }
    }

    @Override
    public List getAllPainter() {
        ArrayList<IPainter> list = new ArrayList<IPainter>(4);
        if (this.childrenMap == null) {
            return list;
        }
        for (Integer key : this.getChildMap().keySet()) {
            List children = (List)this.getChildMap().get(key);
            int len = children.size();
            for (int i = 0; i < len; ++i) {
                IPainter child = (IPainter)children.get(i);
                list.add(child);
            }
        }
        return list;
    }

    @Override
    public void removePainter(IPainter painter) {
        int layer = painter.getLayer();
        if (this.childrenMap == null) {
            return;
        }
        List list = (List)this.getChildMap().get(layer);
        if (list != null) {
            list.remove(painter);
            painter.setParent(null);
        }
    }

    public void removeAllPainter() {
        if (this.childrenMap != null) {
            this.childrenMap.clear();
            this.childrenMap = null;
        }
    }

    @Override
    public void updateView() {
        this.setPainterView(BasicPainterView.createPainterView());
    }

    @Override
    public IXmlTranslate createXmlTrans() {
        return null;
    }

    public float getContentHeight() {
        return this.getPainterBounds().height;
    }

    @Override
    protected Graphics createGraphicsByRect(Graphics g, Rectangle2D.Float rect, float extend) {
        if (!this.isClipBounds()) {
            return super.createGraphicsByRect(g, rect, extend);
        }
        float childX = rect.x;
        float childY = rect.y;
        float childW = rect.width;
        float childH = rect.height;
        Graphics realGra = this.createGraphics(g, childX, childY, childW, childH, extend);
        return realGra;
    }

    private Graphics createGraphics(Graphics g, float x, float y, float width, float height, float extend) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.translate(x - extend, y - extend);
        g2d.create(0, 0, (int)(width + 2.0f * extend), (int)(height + 2.0f * extend));
        g2d.clipRect(0, 0, (int)(width + 2.0f * extend), (int)(height + 2.0f * extend));
        g2d.translate(extend, extend);
        return g2d;
    }

    public boolean isClipBounds() {
        return this.clipBounds;
    }

    public void setClipBounds(boolean clipBounds) {
        this.clipBounds = clipBounds;
    }
}

