/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.ui.io;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.common.util.ObjectUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle.AbstractTableSplitRectInfo;
import com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle.TableSplitRectInfoXml;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.print.config.IXmlTranslate;
import com.kingdee.cosmic.ctrl.print.config.IXmlTranslate2;
import com.kingdee.cosmic.ctrl.print.ui.component.BasicPainter;
import com.kingdee.cosmic.ctrl.print.ui.component.Canvas;
import com.kingdee.cosmic.ctrl.print.ui.component.IDecorate;
import com.kingdee.cosmic.ctrl.print.ui.component.IPainter;
import com.kingdee.cosmic.ctrl.print.ui.component.ImageCell;
import com.kingdee.cosmic.ctrl.print.ui.component.LabelCell;
import com.kingdee.cosmic.ctrl.print.ui.component.LineBorder;
import com.kingdee.cosmic.ctrl.print.ui.component.LineCell;
import com.kingdee.cosmic.ctrl.print.ui.component.Page;
import com.kingdee.cosmic.ctrl.print.ui.component.Paper;
import com.kingdee.cosmic.ctrl.print.ui.component.StyleCell;
import com.kingdee.cosmic.ctrl.print.ui.component.TableCell;
import com.kingdee.cosmic.ctrl.print.ui.component.VariantLabelCell;
import com.kingdee.cosmic.ctrl.print.util.KDPrinterUtils;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;

public class Painter2Xml {
    public static final String T_PAPER = "Paper";
    public static final String T_TABLE = "Table";
    public static final String T_CELL = "cell";
    public static final String T_MERGEBLOCK = "mergeblock";
    public static final String T_HEADER = "Header";
    public static final String T_FOOTER = "Footer";
    public static final String T_PAGE = "page";
    public static final String T_CANVAS = "Canvas";
    public static final String T_LABEL = "Label";
    public static final String T_VARIANT_LABEL = "VariantLabel";
    public static final String T_StyleCell = "StyleCell";
    public static final String T_LINE = "Line";
    public static final String T_POINT = "Point";
    public static final String T_IMAGE = "ImageCell";
    public static final String T_STYLES = "Styles";
    public static final String T_STYLE = "Style";
    public static final String A_STYLES = "styles";
    public static final String A_STYLE = "style";
    public static final String A_X = "x";
    public static final String A_Y = "y";
    public static final String A_WIDTH = "width";
    public static final String A_HEIGHT = "height";
    public static final String A_ZINDEX = "z-index";
    public static final String A_ROTATE = "rotate";
    public static final String A_LAYER = "layer";
    public static final String A_ALIGN = "horiAlign";
    public static final String A_ID = "id";
    public static final String A_BACKGROUND = "background";
    public static final String A_FORCEGROUND = "color";
    public static final String A_BLACKWHITE = "isBlackWhite";
    public static final String A_BORDERSPACE = "borderspace";
    public static final String A_BORDERMODE = "bordermode";
    public static final String A_AROUNDSTYLE = "aroundstyle";
    public static final String A_DECORATE = "decorate";
    public static final String A_EXTEND = "extend";
    public static final String A_SCALE = "scale";
    public static final String A_X1 = "x1";
    public static final String A_Y1 = "y1";
    public static final String A_X2 = "x2";
    public static final String A_Y2 = "y2";
    public static final String A_GRID = "grid";
    public static final String A_ROWS = "rows";
    public static final String A_COLUMNS = "columns";
    public static final String A_ROW = "row";
    public static final String A_COLUMN = "column";
    private Map styles;
    private StringBuffer pageStyleIds = new StringBuffer();
    private boolean reInFlag = false;

    public Painter2Xml() {
        this.styles = new HashMap();
    }

    public Painter2Xml(Map styles) {
        this.styles = styles;
    }

    public IXmlElement makePainter(IPainter pnt) {
        Class<?> cls = pnt.getClass();
        if (Canvas.class.equals(cls)) {
            return this.makeCanvas((Canvas)pnt);
        }
        if (LabelCell.class.equals(cls)) {
            return this.makeLabel((LabelCell)pnt);
        }
        if (VariantLabelCell.class.equals(cls)) {
            return this.makeVariantLabel((VariantLabelCell)pnt);
        }
        if (StyleCell.class.equals(cls)) {
            return this.makeStyleCell((StyleCell)pnt);
        }
        if (ImageCell.class.equals(cls)) {
            return this.makeImage((ImageCell)pnt);
        }
        if (LineCell.class.equals(cls)) {
            return this.makeLine((LineCell)pnt);
        }
        if (Page.class.equals(cls)) {
            return this.makePage((Page)pnt);
        }
        if (Paper.class.equals(cls)) {
            return this.makePaper((Paper)pnt);
        }
        if (TableCell.class.equals(cls)) {
            return this.makeTable((TableCell)pnt);
        }
        IXmlElement e = null;
        IXmlTranslate xmlTrans = pnt.createXmlTrans();
        if (xmlTrans instanceof IXmlTranslate2) {
            ((IXmlTranslate2)xmlTrans).setPainter2Xml(this);
            e = xmlTrans.toXmlElement();
        } else if (xmlTrans instanceof IXmlTranslate) {
            e = xmlTrans.toXmlElement();
        }
        return e;
    }

    private void makeChildren(Canvas cv, IXmlElement xml) {
        List children = cv.getAllPainter();
        int len = children.size();
        for (int i = 0; i < len; ++i) {
            IXmlElement xmlPnt = this.makePainter((IPainter)children.get(i));
            if (xmlPnt == null) continue;
            xml.addChild(xmlPnt);
        }
    }

    public void makeCommon(IPainter pnt, IXmlElement xml) {
        IDecorate decorate;
        Color backColor;
        float extend;
        Rectangle2D.Float rc = pnt.getPainterBounds();
        xml.setAttribute(A_X, this.Float2String(rc.x));
        xml.setAttribute(A_Y, this.Float2String(rc.y));
        xml.setAttribute(A_WIDTH, this.Float2String(rc.width));
        xml.setAttribute(A_HEIGHT, this.Float2String(rc.height));
        if (pnt instanceof BasicPainter) {
            BasicPainter bpnt = (BasicPainter)pnt;
            xml.setAttribute(A_ZINDEX, String.valueOf(bpnt.getZIndex()));
            xml.setAttribute(A_ROTATE, String.valueOf(bpnt.getRotate()));
        }
        if (pnt.getLayer() != 50) {
            xml.setAttribute(A_LAYER, "" + pnt.getLayer());
        }
        if (!ArrayUtil.isEqual((Float)Float.valueOf(extend = pnt.getPainterExtend()), (Float)Float.valueOf(BasicPainter.DEFAULT_EXTEND))) {
            xml.setAttribute(A_EXTEND, this.Float2String(extend));
        }
        if ((backColor = pnt.getBackGround()) != null) {
            String colorStr = KDPrinterUtils.colorToHex(backColor);
            xml.setAttribute(A_BACKGROUND, colorStr);
        }
        Style style = pnt.getStyle();
        Style dStyle = Styles.getDefaultStyle();
        if (style != null && style != dStyle) {
            xml.setAttribute(A_STYLE, String.valueOf(style.getUID()));
            this.addStyle(style);
        }
        if ((decorate = pnt.getDecorate()) instanceof LineBorder) {
            xml.setAttribute(A_DECORATE, LineBorder.getName() + ":" + ((LineBorder)decorate).getType());
        }
    }

    private IXmlElement makeStyleCell(StyleCell cell) {
        IXmlElement xml = XmlUtil.createNode((String)T_StyleCell);
        this.makeCommon(cell, xml);
        Style[] aroundStyles = cell.getAroundStyles();
        if (aroundStyles != null) {
            for (int i = 0; i < aroundStyles.length; ++i) {
                Style style = aroundStyles[i];
                if (style == null) continue;
                this.addStyle(style);
                String id = String.valueOf(style.getUID());
                xml.setAttribute(A_AROUNDSTYLE + i, id);
            }
        }
        xml.setAttribute(A_BLACKWHITE, String.valueOf(cell.isBlackWhite()));
        if (cell.getBorderSpace() != StyleCell.BORDER_SPACE_DEFUALT) {
            xml.setAttribute(A_BORDERSPACE, String.valueOf(cell.getBorderSpace()));
        }
        xml.setAttribute(A_BORDERMODE, String.valueOf(cell.getBorderMode()));
        if (cell.getDiagonalInfo() != null) {
            AbstractTableSplitRectInfo info = cell.getDiagonalInfo();
            ArrayList styles = new ArrayList();
            IXmlElement splitInfoElement = TableSplitRectInfoXml.toXml((AbstractTableSplitRectInfo)info, styles);
            xml.addChild(splitInfoElement);
            int size = styles.size();
            for (int i = 0; i < size; ++i) {
                this.addStyle((Style)styles.get(i));
            }
        } else {
            xml.addCData(cell.getText());
        }
        return xml;
    }

    public IXmlElement makeLabel(LabelCell lbl) {
        IXmlElement xml = XmlUtil.createNode((String)T_LABEL);
        this.makeCommon(lbl, xml);
        xml.setAttribute(A_BLACKWHITE, String.valueOf(lbl.isBlackWhite()));
        String text = lbl.getText();
        if (text == null) {
            text = "";
        }
        xml.addCData(text);
        return xml;
    }

    public IXmlElement makeVariantLabel(VariantLabelCell lbl) {
        IXmlElement xml = XmlUtil.createNode((String)T_VARIANT_LABEL);
        this.makeCommon(lbl, xml);
        String text = lbl.getText();
        if (text == null) {
            text = "";
        }
        xml.addCData(text);
        return xml;
    }

    public IXmlElement makeLine(LineCell ln) {
        IXmlElement xml = XmlUtil.createNode((String)T_LINE);
        this.makeCommon(ln, xml);
        Color color = ln.getColor();
        if (color != null) {
            xml.setAttribute(A_FORCEGROUND, KDPrinterUtils.colorToHex(color));
        }
        float x1 = ln.getX1();
        float y1 = ln.getY1();
        float x2 = ln.getX2();
        float y2 = ln.getY2();
        xml.setAttribute(A_X1, this.Float2String(x1));
        xml.setAttribute(A_Y1, this.Float2String(y1));
        xml.setAttribute(A_X2, this.Float2String(x2));
        xml.setAttribute(A_Y2, this.Float2String(y2));
        xml.setAttribute(A_X, null);
        xml.setAttribute(A_Y, null);
        xml.setAttribute(A_WIDTH, null);
        xml.setAttribute(A_HEIGHT, null);
        return xml;
    }

    public IXmlElement makeImage(ImageCell img) {
        IXmlElement xml = XmlUtil.createNode((String)T_IMAGE);
        this.makeCommon(img, xml);
        if (img.getImage() != null) {
            ImageIcon imageIcon = new ImageIcon(img.getImage());
            String text = ObjectUtil.objectToString((Object)imageIcon);
            xml.addCData(text);
        } else {
            String text = ObjectUtil.objectToString((Object)img.getContent());
            xml.addCData("OTHER|" + img.getFileType() + "|" + text);
        }
        xml.setAttribute(A_SCALE, String.valueOf(img.getScale()));
        return xml;
    }

    public IXmlElement makePage(Page pg) {
        boolean need_restore_reInFlag = !this.reInFlag;
        this.reInFlag = true;
        IXmlElement xml = XmlUtil.createNode((String)"T_PAGE");
        this.makeCommon(pg, xml);
        this.makeChildren(pg, xml);
        int z = this.pageStyleIds.length();
        if (z > 0) {
            this.pageStyleIds.setLength(z - 1);
        }
        xml.setAttribute(A_STYLES, this.pageStyleIds.toString());
        if (need_restore_reInFlag) {
            this.pageStyleIds.setLength(0);
            this.reInFlag = false;
        }
        return xml;
    }

    public IXmlElement makeCanvas(Canvas pg) {
        IXmlElement xml = XmlUtil.createNode((String)T_CANVAS);
        this.makeCommon(pg, xml);
        this.makeChildren(pg, xml);
        return xml;
    }

    public IXmlElement makePaper(Paper pp) {
        IXmlElement xml = XmlUtil.createNode((String)T_PAPER);
        this.makeCommon(pp, xml);
        this.makeChildren(pp, xml);
        return xml;
    }

    private IXmlElement makeTable(TableCell table) {
        IXmlElement xml = XmlUtil.createNode((String)T_TABLE);
        this.makeCommon(table, xml);
        xml.setAttribute(A_GRID, "" + table.isGrid());
        String rows = StringUtil.array2String((float[])table.getRows(), (String)",");
        xml.setAttribute(A_ROWS, rows);
        String cols = StringUtil.array2String((float[])table.getColumns(), (String)",");
        xml.setAttribute(A_COLUMNS, cols);
        int rowCount = table.getRowCount();
        int colCount = table.getcolumnCount();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                StyleCell painter = table.getCell(i, j);
                if (painter == null) continue;
                IXmlElement cell = XmlUtil.createNode((String)T_CELL);
                cell.setAttribute(A_ROW, "" + i);
                cell.setAttribute(A_COLUMN, "" + j);
                cell.addChild(this.makePainter(painter));
                xml.addChild(cell);
            }
        }
        Iterator mergs = table.getMerges().iterator();
        while (mergs.hasNext()) {
            TableCell.MergeBlock block = (TableCell.MergeBlock)mergs.next();
            IXmlElement mBlock = XmlUtil.createNode((String)T_MERGEBLOCK);
            mBlock.setAttribute(A_ROW, "" + block.getRow());
            mBlock.setAttribute("col", "" + block.getCol());
            mBlock.setAttribute("row2", "" + block.getRow2());
            mBlock.setAttribute("col2", "" + block.getCol2());
            xml.addChild(mBlock);
        }
        return xml;
    }

    private void addStyle(Style ssa) {
        String id = String.valueOf(ssa.getUID());
        this.styles.put(id, ssa);
        if (this.pageStyleIds != null) {
            this.pageStyleIds.append(id);
            this.pageStyleIds.append(',');
        }
    }

    public Map getStyles() {
        return this.styles;
    }

    private String Float2String(float value) {
        String str = Float.toString(value);
        int length = str.length();
        if (str.endsWith(".0") && length > 2) {
            str = str.substring(0, length - 2);
        }
        return str;
    }
}

