/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.ui.view;

import com.kingdee.cosmic.ctrl.kdf.util.render.BorderRender;
import com.kingdee.cosmic.ctrl.kdf.util.render.IBorderHolder;
import com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle.AbstractTableSplitRectInfo;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.print.printjob.table.ITableForPrint;
import com.kingdee.cosmic.ctrl.print.ui.component.IPainter;
import com.kingdee.cosmic.ctrl.print.ui.component.MergeCell;
import com.kingdee.cosmic.ctrl.print.ui.component.PainterInfo;
import com.kingdee.cosmic.ctrl.print.ui.view.BasicPainterView;
import com.kingdee.cosmic.ctrl.print.ui.view.StyleRender;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public class MergeCellView
extends BasicPainterView {
    protected static MergeCellView labelUI = new MergeCellView();

    public static BasicPainterView createPainterView() {
        return labelUI;
    }

    private Rectangle2D.Float getCellRect(Rectangle2D.Float srcRect, int borderSpace) {
        Rectangle2D.Float rect = new Rectangle2D.Float();
        float spp = 0.9999f;
        rect.x = srcRect.x + (float)borderSpace + spp;
        rect.y = srcRect.y + (float)borderSpace + spp;
        rect.width = srcRect.width - (float)(2 * borderSpace) - spp;
        rect.height = srcRect.height - (float)(2 * borderSpace) - spp;
        return rect;
    }

    @Override
    public void paint(Graphics g, IPainter painter, PainterInfo graInfo) {
        int tw;
        int c;
        Style tempStyle;
        int th;
        int r;
        MergeCell mcell = (MergeCell)painter;
        Rectangle2D.Float borderRect = new Rectangle2D.Float(0.0f, 0.0f, (float)mcell.getPainterSize().getWidth(), (float)mcell.getPainterSize().getHeight());
        Rectangle2D.Float theCellRect = this.getCellRect(borderRect, mcell.getBorderSpace());
        Color backColor = painter.getBackGround();
        if (backColor != null && backColor.getAlpha() == 255) {
            Color old = g.getColor();
            g.setColor(backColor);
            ((Graphics2D)g).fill(theCellRect);
            g.setColor(old);
        }
        boolean isBlackWhite = mcell.isBlackWhite();
        StyleRender.setBlackWhite(isBlackWhite);
        Graphics2D g2d = (Graphics2D)g;
        Style style = painter.getStyle();
        if (style == null) {
            style = Styles.getDefaultStyle();
        }
        StyleRender.getCellBackRender().draw((Graphics)g2d, (Shape)borderRect, null, style);
        int space = 2;
        theCellRect.setRect(theCellRect.getX() + (double)space, theCellRect.getY(), theCellRect.getWidth() - (double)(2 * space), theCellRect.getHeight());
        StyleRender.drawText(g, theCellRect, mcell.getDisplayText(graInfo), style, graInfo.getEncode());
        AbstractTableSplitRectInfo splitInfo = mcell.getDiagonalInfo();
        if (splitInfo != null) {
            StyleRender.drawSplitRectText(g2d, borderRect, splitInfo);
        }
        BorderRender br = StyleRender.getBorderRender2();
        br.setHolder((IBorderHolder)mcell);
        ITableForPrint sheet = mcell.getSheet();
        ITableForPrint.IBlock block = mcell.getMergeBlock();
        int row1 = block.getRow();
        int row2 = block.getRow2();
        int col1 = block.getCol();
        int col2 = block.getCol2();
        int pageStartRow = mcell.getPageStartRow();
        int pageStartCol = mcell.getPageStartCol();
        int pageEndRow = mcell.getPageEndRow();
        int pageEndCol = mcell.getPageEndCol();
        BorderRender.BorderInfo bi = new BorderRender.BorderInfo();
        bi.set(row1, col1, 48);
        br.draw(g, (Shape)borderRect, (Object)bi, style);
        float bx = borderRect.x;
        float by = borderRect.y;
        float bw = borderRect.width;
        float bh = borderRect.height;
        if (pageEndRow > row1 && pageEndRow < row2) {
            row2 = pageEndRow;
        }
        if (pageEndCol > col1 && pageEndCol < col2) {
            col2 = pageEndCol;
        }
        if (pageStartRow > row1) {
            row1 = pageStartRow;
        }
        if (pageStartCol > col1) {
            col1 = pageStartCol;
        }
        float leftW = sheet.getColumnWidth(col1) + 2;
        float leftY = by;
        for (r = row1; r <= row2; ++r) {
            th = sheet.getRowHeight(r) + 2;
            borderRect.setRect(bx, leftY, leftW, th);
            tempStyle = mcell.getCellStyle(r, col1);
            bi.set(r, col1, 1);
            br.draw(g, (Shape)borderRect, (Object)bi, tempStyle);
            leftY += (float)(th - 1);
        }
        float topH = sheet.getRowHeight(row1) + 2;
        float topX = bx;
        for (c = col1; c <= col2; ++c) {
            tw = sheet.getColumnWidth(c) + 2;
            borderRect.setRect(topX, by, tw, topH);
            tempStyle = mcell.getCellStyle(row1, c);
            bi.set(row1, c, 2);
            br.draw(g, (Shape)borderRect, (Object)bi, tempStyle);
            topX += (float)(tw - 1);
        }
        float rightW = sheet.getColumnWidth(col2) + 2;
        float rightY = by;
        for (r = row1; r <= row2; ++r) {
            th = sheet.getRowHeight(r) + 2;
            borderRect.setRect(bx + bw - rightW, rightY, rightW, th);
            tempStyle = mcell.getCellStyle(r, col2);
            bi.set(r, col2, 4);
            br.draw(g, (Shape)borderRect, (Object)bi, tempStyle);
            rightY += (float)(th - 1);
        }
        float bomH = sheet.getRowHeight(row2) + 2;
        float bomX = bx;
        for (c = col1; c <= col2; ++c) {
            tw = sheet.getColumnWidth(c) + 2;
            borderRect.setRect(bomX, by + bh - bomH, tw, bomH);
            tempStyle = mcell.getCellStyle(row2, c);
            bi.set(row2, c, 8);
            br.draw(g, (Shape)borderRect, (Object)bi, tempStyle);
            bomX += (float)(tw - 1);
        }
    }
}

