/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.xls.output;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlPrintMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.print.xls.exception.OutOfSizeException;
import com.kingdee.cosmic.ctrl.print.xls.exobject.APaper;
import com.kingdee.cosmic.ctrl.print.xls.exobject.BasicCell;
import com.kingdee.cosmic.ctrl.print.xls.output.LinesList;
import com.kingdee.cosmic.ctrl.print.xls.output.Location;
import com.kingdee.cosmic.ctrl.print.xls.output.PaperHelper;
import com.kingdee.cosmic.ctrl.print.xls.output.XlsHelper;
import com.kingdee.cosmic.ctrl.print.xls.output.XlsNodeContainer;
import com.kingdee.cosmic.ctrl.print.xls.widget.XlsPaper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public class OutputHelper {
    private static final int MAXROW = 20000;
    boolean[][] _takenMap;
    private APaper _outputPaper;
    private int _offset = 0;
    private LinesList _verticalLines;
    private Workbook _book;
    private Sheet _sheet;
    private HashMap _styleMap;
    private Logger _log = LogUtil.getLogger(this.getClass());
    private XlsNodeContainer _container = new XlsNodeContainer(20);
    private PaperHelper _paperHelper;
    private PrintSetup _sp;
    private XlsHelper _xlsHelper;
    private Map conStyleMap;

    public OutputHelper(Workbook wb) {
        this._book = wb;
        this._verticalLines = new LinesList(255);
        this._styleMap = new HashMap();
        this.conStyleMap = new HashMap();
        CellStyle cellstyle = this._book.createCellStyle();
        cellstyle.setAlignment(HorizontalAlignment.CENTER);
        cellstyle.setVerticalAlignment(VerticalAlignment.CENTER);
        this._styleMap.put("cellstyleisnull!!!", cellstyle);
    }

    public void nextPaper(XlsPaper paper, int heightIndention, int widthIndention) {
        boolean isSuccess = false;
        this._log.info((Object)(CtrlPrintMessages.getMLS("addNewPage", "\u6dfb\u52a0\u65b0\u9875\u9762\uff1a") + paper.getId()));
        try {
            LinesList lines = paper.getVerticalLines();
            if (lines != null) {
                isSuccess = this._verticalLines.add(lines);
            }
            lines = null;
            this._offset += paper.getHorizonLines().size();
            if (!isSuccess || this._offset >= 20000) {
                if (this._container.size() == 0) {
                    this._log.error((Object)CtrlPrintMessages.getMLS("columnCountExceedsLimit256", "\u4e00\u9875\u7684\u5217\u6570\u5df2\u7ecf\u8d85\u8fc7256\u5217\uff01\uff01\uff01\u65e0\u6cd5\u5bfc\u51fa"));
                } else {
                    this.outputOnce(heightIndention, widthIndention);
                    this.nextPaper(paper, heightIndention, widthIndention);
                }
            } else {
                this._container.add(paper);
            }
        }
        catch (OutOfSizeException e) {
            this._log.error((Object)CtrlPrintMessages.getMLS("errorBatchAddingPageBorder", "\u6279\u91cf\u6dfb\u52a0\u4e00\u4e2a\u9875\u9762\u7684\u8fb9\u6846\u65f6\u51fa\u9519\uff01\uff01\uff01"));
        }
    }

    public void endOutput(int heightIndention, int widthIndention) {
        this.outputOnce(heightIndention, widthIndention);
    }

    public void outputOnce(int heightIndention, int widthIndention) {
        this.beforeOutputPapers();
        this._offset = 0;
        Iterator iter = this._container.iterator();
        while (iter.hasNext()) {
            XlsPaper outputPaper = (XlsPaper)iter.next();
            this._log.info((Object)(CtrlPrintMessages.getMLS("startOutput", "\u5f00\u59cb\u8f93\u51fa") + outputPaper.getId()));
            this.process(outputPaper, heightIndention, widthIndention);
            iter.remove();
            this._log.info((Object)(CtrlPrintMessages.getMLS("outputAndRemoved", "\u5df2\u8f93\u51fa\u5e76\u79fb\u9664") + outputPaper.getId()));
        }
        this.afterOutputPapers();
    }

    private void beforeOutputPapers() {
        Collections.sort(this._verticalLines);
        this._sheet = this._book.createSheet();
        this._paperHelper = new PaperHelper(this._book, this._verticalLines, this._styleMap);
        this._xlsHelper = new XlsHelper();
        this._xlsHelper.updateSheet(this._sheet, this.conStyleMap);
        this._sp = this._sheet.getPrintSetup();
        this._sp.setHeaderMargin(0.0);
        this._sp.setFooterMargin(0.0);
        this._sheet.setMargin((short)2, 0.0);
        this._sheet.setMargin((short)3, 0.0);
        this._sheet.setMargin((short)0, 0.0);
        this._sheet.setMargin((short)1, 0.0);
    }

    private void afterOutputPapers() {
        this._offset = 0;
        this._verticalLines = new LinesList(255);
        this._paperHelper = null;
        this._sheet = null;
        this._takenMap = null;
        this._container.clear();
    }

    private void process(XlsPaper paper, int heightIndention, int widthIndention) {
        if (paper.getChildren() == null || paper.getChildren().size() == 0) {
            this.drawEmptyPage();
            return;
        }
        this.initMap(paper);
        Collections.sort(paper.getHorizonLines());
        this._outputPaper = this.exprotPaper(paper);
        this.init(paper, heightIndention, widthIndention);
        this.drawSheet();
        this._offset += paper.getHorizonLines().size();
    }

    private APaper exprotPaper(XlsPaper paper) {
        APaper returnPaper = this._paperHelper.exportPaper(paper);
        return returnPaper;
    }

    private void init(XlsPaper paper, int heightIndetion, int widthIndection) {
        float[] margins = this.doIndent(paper, heightIndetion, widthIndection);
        this._xlsHelper.initRows(this._offset, margins[0], margins[1], margins[4], this._outputPaper, paper.getHorizonLines());
        this._xlsHelper.initCols(margins[2], margins[3], margins[5], this._verticalLines);
    }

    private void drawSheet() {
        HashMap children = this._outputPaper.getChildren();
        ArrayList keys = new ArrayList(children.keySet());
        Collections.sort(keys);
        for (Integer key : keys) {
            List childArray = (List)this._outputPaper.getChildren().get(key);
            for (int i = 0; i < childArray.size(); ++i) {
                BasicCell toOutput = (BasicCell)childArray.get(i);
                this._xlsHelper.outputCell(toOutput, this._takenMap, this._offset, 0, 0);
            }
        }
    }

    private void initMap(XlsPaper paper) {
        this._takenMap = new boolean[paper.getHorizonLines().size()][this._verticalLines.size()];
        for (int i = 0; i < this._takenMap.length; ++i) {
            boolean[] row = this._takenMap[i];
            for (int j = 0; j < row.length; ++j) {
                this._takenMap[i][j] = false;
            }
        }
    }

    private float[] doIndent(XlsPaper paper, int heightIndention, int widthIndention) {
        float reduce;
        LinesList horizonLines = paper.getHorizonLines();
        float height = heightIndention;
        float width = widthIndention;
        float contentHeight = horizonLines.getChild(0).getValue();
        float contentWidth = this._verticalLines.getChild(0).getValue();
        float topMargin = contentHeight;
        float bottomMargin = paper.getHeight() - horizonLines.getChild(horizonLines.size() - 1).getValue();
        float leftMargin = contentWidth;
        float rightMargin = paper.getWidth() - this._verticalLines.getChild(this._verticalLines.size() - 1).getValue();
        contentHeight = horizonLines.getChild(horizonLines.size() - 1).getValue();
        contentWidth = this._verticalLines.getChild(this._verticalLines.size() - 1).getValue();
        if (topMargin + bottomMargin >= height) {
            reduce = height / 2.0f;
            if (topMargin >= reduce && bottomMargin >= reduce) {
                topMargin -= reduce;
                bottomMargin -= reduce;
            } else if (topMargin >= reduce) {
                topMargin -= height - bottomMargin;
                bottomMargin = 0.0f;
            } else {
                bottomMargin -= height - topMargin;
                topMargin = 0.0f;
            }
            height = 1.0f;
        } else {
            float x = contentHeight - (height -= topMargin + bottomMargin);
            float y = contentHeight;
            height = x / y;
            topMargin = 0.0f;
            bottomMargin = 0.0f;
        }
        if (leftMargin + rightMargin >= width) {
            reduce = width / 2.0f;
            if (leftMargin >= reduce && rightMargin >= reduce) {
                leftMargin -= reduce;
                rightMargin -= reduce;
            } else if (leftMargin >= reduce) {
                leftMargin -= width - rightMargin;
                rightMargin = 0.0f;
            } else {
                rightMargin -= width - leftMargin;
                leftMargin = 0.0f;
            }
            width = 1.0f;
        } else {
            width -= leftMargin + rightMargin;
            width = (contentWidth - width) / contentWidth;
            leftMargin = 0.0f;
            rightMargin = 0.0f;
        }
        float[] result = new float[]{topMargin, bottomMargin, leftMargin, rightMargin, height, width};
        return result;
    }

    private void drawEmptyPage() {
        LinesList hLines = new LinesList(2);
        try {
            hLines.add(new Location(10.0f));
            hLines.add(new Location(30.0f));
        }
        catch (OutOfSizeException outOfSizeException) {
            // empty catch block
        }
        this._xlsHelper.initRows(this._offset, 0.0f, 0.0f, 0.9f, this._outputPaper, hLines);
        ++this._offset;
    }

    public void clearStyleMap() {
        this._styleMap.clear();
        this._xlsHelper.conStyleMap.clear();
    }
}

