/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.digitalstyle;

import com.kingdee.cosmic.ctrl.common.digitalstyle.Format;
import com.kingdee.cosmic.ctrl.common.digitalstyle.FormatResult;
import com.kingdee.cosmic.ctrl.common.digitalstyle.GeneralFormat;
import com.kingdee.cosmic.ctrl.common.variant.Variant;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import java.util.ArrayList;

class CompositeFormat
extends Format {
    private ArrayList _formats;

    CompositeFormat() {
    }

    void addFormat(Format format) {
        if (this._formats == null) {
            this._formats = new ArrayList();
        }
        this._formats.add(format);
    }

    int size() {
        return this._formats == null ? 0 : this._formats.size();
    }

    Format getFormat(int index) {
        return (Format)this._formats.get(index);
    }

    @Override
    public FormatResult format(Variant obj, boolean parse) {
        if (null == obj || this._formats == null || this._formats.size() == 0) {
            return FormatResult.NullResult;
        }
        int size = this._formats.size();
        for (int i = 0; i < size; ++i) {
            Format format = (Format)this._formats.get(i);
            FormatResult result = format.format(obj, parse);
            if (result == FormatResult.NullResult) continue;
            return result;
        }
        return GeneralFormat.defaultInstance.format(obj, parse);
    }

    @Override
    public boolean formatStyle(Variant obj, StyleAttributes retSa, boolean parse) {
        if (null != obj || this._formats != null) {
            int size = this._formats.size();
            for (int i = 0; i < size; ++i) {
                Format format = (Format)this._formats.get(i);
                boolean b = format.formatStyle(obj, retSa, parse);
                if (!b) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String toStringFormat() {
        StringBuilder sb = new StringBuilder();
        if (this._formats != null) {
            int size = this._formats.size();
            for (int i = 0; i < size; ++i) {
                Format format = (Format)this._formats.get(i);
                sb.append(format.toStringFormat()).append(';');
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public FormatResult format4Print(Variant obj, boolean parse) {
        if (null == obj || this._formats == null || this._formats.size() == 0) {
            return FormatResult.NullResult;
        }
        int size = this._formats.size();
        for (int i = 0; i < size; ++i) {
            Format format = (Format)this._formats.get(i);
            FormatResult result = format.format4Print(obj, parse);
            if (result == null || result.getText() == null || "".equals(result.getText())) continue;
            return result;
        }
        return GeneralFormat.defaultInstance.format(obj, parse);
    }
}

