/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.editor;

import com.kingdee.cosmic.ctrl.common.editor.ICellEditor;
import com.kingdee.cosmic.ctrl.common.editor.ICellEditorListener;
import java.util.EventObject;
import javax.swing.event.EventListenerList;

public abstract class AbstractCellEditor
implements ICellEditor {
    protected EventListenerList listenerList = new EventListenerList();

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ICellEditorListener.class) continue;
            ((ICellEditorListener)listeners[i + 1]).editingStopped();
        }
    }

    protected void fireEditingCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ICellEditorListener.class) continue;
            ((ICellEditorListener)listeners[i + 1]).editingCanceled();
        }
    }

    protected void fireEditingChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ICellEditorListener.class) continue;
            ((ICellEditorListener)listeners[i + 1]).editingChanged();
        }
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean isDisplayable() {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public void addCellEditorListener(ICellEditorListener l) {
        this.listenerList.add(ICellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(ICellEditorListener l) {
        this.listenerList.remove(ICellEditorListener.class, l);
    }

    @Override
    public void releaseComponent() {
    }
}

