/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.ui;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.common.layout.table.Table;
import com.kingdee.cosmic.ctrl.common.layout.table.TableLayout;
import com.kingdee.cosmic.ctrl.common.ui.ListView;
import com.kingdee.cosmic.ctrl.common.ui.WindowUtil;
import com.kingdee.cosmic.ctrl.res.Resource;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDList;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;

public abstract class NormalSelector
extends KDPanel {
    private KDPanel panBigSupply;
    private KDLabel labSuply;
    private KDPanel panSuply;
    protected ListView lvSelected;
    protected KDWorkButton btnSelect;
    protected KDWorkButton btnSelectAll;
    protected KDWorkButton btnDelete;
    protected KDWorkButton btnDeleteAll;
    private boolean isChanged;

    public void enableSelect(boolean is) {
        this.btnSelect.setEnabled(is);
    }

    public void enableSelectAll(boolean is) {
        this.btnSelectAll.setEnabled(is);
    }

    public void enableDelete(boolean is) {
        this.btnDelete.setEnabled(is);
    }

    public void enableDeleteAll(boolean is) {
        this.btnDeleteAll.setEnabled(is);
    }

    public NormalSelector() {
        this.setOpaque(false);
        this.init();
        this.installListener();
    }

    private void init() {
        this.panBigSupply = new KDPanel();
        this.labSuply = new KDLabel();
        this.panSuply = new KDPanel();
        this.lvSelected = new ListView(){

            @Override
            public void syncBtn() {
                super.syncBtn();
                if (NormalSelector.this.lvSelected != null) {
                    NormalSelector.this.syncListViewButton();
                }
            }
        };
        this.btnSelect = new KDWorkButton((Icon)Resource.ICON_MOVE_LEFT);
        this.btnSelectAll = new KDWorkButton((Icon)Resource.ICON_MOVEALL_RIGHT);
        this.btnDelete = new KDWorkButton((Icon)Resource.ICON_MOVE_RIGHT);
        this.btnDeleteAll = new KDWorkButton((Icon)Resource.ICON_MOVEALL_LEFT);
        this.labSuply.setPreferredSize(new Dimension(200, 21));
        TableLayout tlSupply = TableLayout.split((int)2, (int)1);
        tlSupply.rowStyle(0).setHeight(20);
        tlSupply.rowStyle(1).setPriY(1);
        this.panBigSupply.setLayout((LayoutManager)tlSupply);
        this.panBigSupply.add((Component)this.labSuply, (Object)tlSupply.cell(0, 0));
        this.panBigSupply.add((Component)this.panSuply, (Object)tlSupply.cell(1, 0));
        TableLayout tl = TableLayout.split((int)1, (int)3);
        tl.colStyle(0).setWidth(-50);
        tl.colStyle(0).setPriX(1);
        tl.colStyle(1).setMargin(3, 0, 3, 0);
        tl.colStyle(1).setWidth(28);
        tl.colStyle(2).setWidth(-50);
        tl.colStyle(2).setPriX(1);
        Table col1 = tl.cell(1).split(7, 1);
        col1.rowStyle(0).setPriY(1);
        for (int i = 1; i < 6; ++i) {
            col1.rowStyle(i).setHeight(21);
            col1.rowStyle(i).setMarginBottom(3);
        }
        col1.rowStyle(6).setPriY(1);
        this.setLayout((LayoutManager)tl);
        this.add((Component)this.panBigSupply, tl.cell(0, 0));
        this.add((Component)this.btnSelect, col1.cell(1, 0));
        this.add((Component)this.btnSelectAll, col1.cell(2, 0));
        this.add((Component)this.btnDelete, col1.cell(4, 0));
        this.add((Component)this.btnDeleteAll, col1.cell(5, 0));
        this.add((Component)((Object)this.lvSelected), tl.cell(0, 2));
    }

    private void installListener() {
        ActionHandler actionHandler = new ActionHandler();
        this.btnSelect.addActionListener((ActionListener)actionHandler);
        this.btnSelectAll.addActionListener((ActionListener)actionHandler);
        this.btnDelete.addActionListener((ActionListener)actionHandler);
        this.btnDeleteAll.addActionListener((ActionListener)actionHandler);
        this.lvSelected.addItemChangedListener(new ListView.ItemChangedListener(){

            @Override
            public void itemChanged(ListView.ItemChangedEvent e) {
                NormalSelector.this.setChanged(true);
            }
        });
    }

    protected void syncListViewButton() {
        if (this.lvSelected.getList().getSelectedIndex() == -1) {
            this.btnDelete.setEnabled(false);
        } else {
            this.btnDelete.setEnabled(true);
        }
        if (this.lvSelected.getList().getElementCount() > 0) {
            this.btnDeleteAll.setEnabled(true);
        } else {
            this.btnDeleteAll.setEnabled(false);
        }
    }

    protected abstract void onSelect();

    protected void onSelectAll() {
    }

    protected boolean onDelete() {
        int[] idxs = this.lvSelected.getList().getSelectedIndices();
        if (idxs.length == 0) {
            return false;
        }
        if (!WindowUtil.msgboxYesNo((Component)((Object)this), CtrlCommonUIMessages.getMLS("deletePrompt", "\u786e\u5b9e\u8981\u5220\u9664\u6240\u9009\u5185\u5bb9\u5417\uff1f"), CtrlCommonUIMessages.getMLS("deleteTitle", "\u786e\u8ba4\u5220\u9664"))) {
            return false;
        }
        for (int i = idxs.length - 1; i >= 0; --i) {
            this.lvSelected.getList().removeElementAt(idxs[i]);
        }
        if (idxs[0] < this.lvSelected.getList().getElementCount()) {
            this.lvSelected.getList().setSelectedIndex(idxs[0]);
        } else {
            this.lvSelected.getList().setSelectedIndex(this.lvSelected.getList().getElementCount() - 1);
        }
        return true;
    }

    protected boolean onDeleteAll() {
        if (WindowUtil.msgboxYesNo((Component)((Object)this), CtrlCommonUIMessages.getMLS("deletePrompt", "\u786e\u5b9e\u8981\u5220\u9664\u6240\u9009\u5185\u5bb9\u5417\uff1f"), CtrlCommonUIMessages.getMLS("deleteTitle", "\u786e\u8ba4\u5220\u9664"))) {
            this.lvSelected.getList().removeAllElements();
            return true;
        }
        return false;
    }

    public ListView getSelected() {
        return this.lvSelected;
    }

    public KDList getSelectedList() {
        return this.lvSelected.getList();
    }

    public void setSupplyTitle(String text) {
        this.labSuply.setText(text);
    }

    public void setSelectedTitle(String text) {
        this.lvSelected.setTitle(text);
    }

    public void setSupplyCtrl(JComponent comp) {
        this.panSuply.removeAll();
        this.panSuply.setLayout((LayoutManager)new BorderLayout());
        this.panSuply.setCustomInsets(new Insets(1, 1, 1, 1));
        KDScrollPane scp = new KDScrollPane((Component)comp);
        scp.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.panSuply.add((Component)scp, (Object)"Center");
    }

    public void setSupplyCtrlNoScroll(JComponent comp) {
        this.panSuply.removeAll();
        this.panSuply.setLayout((LayoutManager)new BorderLayout());
        this.panSuply.add((Component)comp, (Object)"Center");
    }

    public void setBigSupplyCtrl(JComponent comp) {
        this.panBigSupply.removeAll();
        this.panBigSupply.setLayout((LayoutManager)new BorderLayout());
        this.panBigSupply.add((Component)comp, (Object)"Center");
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NormalSelector.this.setChanged(true);
            Object source = e.getSource();
            if (source == NormalSelector.this.btnSelect) {
                NormalSelector.this.onSelect();
            } else if (source == NormalSelector.this.btnSelectAll) {
                NormalSelector.this.onSelectAll();
            } else if (source == NormalSelector.this.btnDelete) {
                NormalSelector.this.onDelete();
            } else if (source == NormalSelector.this.btnDeleteAll) {
                NormalSelector.this.onDeleteAll();
            }
            NormalSelector.this.syncListViewButton();
        }
    }
}

