/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.ui.editor;

import com.kingdee.cosmic.ctrl.common.ui.editor.DefaultEditorStyleModel;
import com.kingdee.cosmic.ctrl.common.ui.editor.EditorStyleModel;
import com.kingdee.cosmic.ctrl.common.ui.editor.Lexer;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.swing.KDTextPane;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class StyledEditor
extends KDTextPane {
    private static final Logger logger = LogUtil.getPackageLogger(StyledEditor.class);
    private static final long serialVersionUID = -8622322772673585191L;
    private boolean modified = false;
    private EditorStyleModel cs = null;

    public StyledEditor() {
        this(new DefaultEditorStyleModel());
    }

    public StyledEditor(EditorStyleModel cs) {
        this.setStyleModel(cs);
        this.init();
    }

    public void setStyleModel(EditorStyleModel cs) {
        this.cs = cs;
        this.setFont(cs.getFont());
    }

    public EditorStyleModel getStyleModel() {
        return this.cs;
    }

    private void init() {
        this.setBorder(new EtchedBorder());
        this.getCaret().setBlinkRate(500);
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                StyledEditor.this.modified = true;
                SwingUtilities.invokeLater(new UpdateDocumentAttributeThread(e.getOffset(), e.getLength()));
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                StyledEditor.this.modified = true;
                SwingUtilities.invokeLater(new UpdateDocumentAttributeThread(e.getOffset(), 0));
            }
        });
    }

    private int getLineHeadPos(int offset) throws BadLocationException {
        String s = this.getDocument().getText(0, offset);
        for (int i = offset - 1; i >= 0; --i) {
            char ch = s.charAt(i);
            if (ch != '\r' && ch != '\n') continue;
            return i + 1;
        }
        return 0;
    }

    private int getLineEndPos(int offset) throws BadLocationException {
        String s = this.getDocument().getText(offset, this.getDocument().getLength() - offset);
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char ch = s.charAt(i);
            if (ch != '\r' && ch != '\n') continue;
            return offset + i;
        }
        return offset + n;
    }

    public void setText(String s) {
        super.setText(s);
        this.modified = true;
    }

    public void loadFrom(InputStream is) throws Exception {
        String line;
        String LINE_END = "\r\n";
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder s = new StringBuilder();
        while ((line = br.readLine()) != null) {
            s.append(line).append("\r\n");
        }
        this.setText(s.toString());
        this.setCaretPosition(0);
    }

    public void loadFrom(String fileName) throws Exception {
        try (FileInputStream is = new FileInputStream(FilenameUtils.normalize((String)fileName));){
            this.loadFrom(is);
        }
        this.modified = false;
    }

    public void saveTo(String fileName) throws Exception {
        try (FileWriter fw = new FileWriter(FilenameUtils.normalize((String)fileName));){
            fw.write(this.getText());
            fw.flush();
        }
        this.modified = false;
    }

    public void insertStringAtCurrent(String s) {
        try {
            int i = this.getCaretPosition();
            this.getDocument().insertString(i, s, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setText(String s, boolean simpleFormat) {
        if (simpleFormat) {
            this.setText(new SimpleMdxFormater().format(s));
        } else {
            this.setText(s);
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean b) {
        this.modified = b;
    }

    public Point getLinePos(int line) {
        char[] chs = this.getText().toCharArray();
        int cur = 1;
        Point pos = new Point(-1, -1);
        int n = chs.length;
        for (int i = 0; i < n; ++i) {
            char ch = chs[i];
            if (ch != '\n') continue;
            if (line == 1) {
                pos.x = 0;
                pos.y = i - 1;
                break;
            }
            if (++cur == line) {
                pos.x = i + 1 - (cur - 1);
                continue;
            }
            if (cur != line + 1) continue;
            pos.y = i - (cur - 1);
        }
        if (pos.x != -1) {
            return pos;
        }
        return null;
    }

    class SimpleMdxFormater {
        SimpleMdxFormater() {
        }

        String format(String s) {
            String[] lineWrapKeys = StyledEditor.this.cs.getWrapLineKeys();
            if (lineWrapKeys == null || lineWrapKeys.length == 0) {
                return s;
            }
            Lexer lex = new Lexer(s);
            ArrayList<String> list = new ArrayList<String>(8);
            while (!lex.eof()) {
                list.add(lex.nextToken());
            }
            HashSet<String> wrapWordSet = new HashSet<String>(Arrays.asList(lineWrapKeys));
            StringBuilder sb = new StringBuilder();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                String lt;
                String t = (String)list.get(i);
                if (i != n - 1 && ",".equals(list.get(i + 1))) {
                    t = t + ',';
                    ++i;
                }
                if (wrapWordSet.contains(lt = t.toLowerCase(Locale.ENGLISH))) {
                    sb.append(t).append("\r\n");
                    continue;
                }
                sb.append(t);
            }
            return sb.toString();
        }
    }

    class UpdateDocumentAttributeThread
    implements Runnable {
        int offset;
        int len;

        UpdateDocumentAttributeThread(int offset, int len) {
            this.offset = offset;
            this.len = len;
        }

        @Override
        public void run() {
            try {
                Token t;
                if (this.offset + this.len > StyledEditor.this.getDocument().getLength() || this.offset + this.len == 0) {
                    return;
                }
                int ffrom = StyledEditor.this.getLineHeadPos(this.offset);
                int fto = StyledEditor.this.getLineEndPos(this.offset + this.len);
                StyledDocument sd = StyledEditor.this.getStyledDocument();
                Lexer lex = new Lexer(StyledEditor.this.getDocument().getText(ffrom, fto - ffrom));
                StyledEditor.this.cs.beforeRun(lex);
                ArrayList<Token> list = new ArrayList<Token>(8);
                while (!lex.eof()) {
                    t = new Token();
                    t.from = lex.pos() + ffrom;
                    t.token = lex.nextToken();
                    t.len = t.token.length();
                    list.add(t);
                }
                boolean setted = true;
                int n = list.size();
                block3: for (int i = 0; i < n; ++i) {
                    Token et;
                    setted = false;
                    t = (Token)list.get(i);
                    if (t.isEmpty()) continue;
                    if ("/".equals(t.token) && this.match("/", list, i + 1)) {
                        int to = StyledEditor.this.getLineEndPos(t.from + t.len);
                        sd.setCharacterAttributes(t.from, to - t.from, StyledEditor.this.cs.getSingleLineCommentAttributeSet(), true);
                        for (int j = i + 1; j < n; ++j) {
                            et = (Token)list.get(j);
                            if (et.from + et.len < to) continue;
                            i = j;
                            continue block3;
                        }
                        continue;
                    }
                    if ("/".equals(t.token) && this.match("*", list, i + 1)) {
                        int ei = i + 1;
                        while ((ei = this.searchNextToken("*", list, ei + 1)) != -1) {
                            if (!this.match("/", list, ei + 1)) continue;
                            et = (Token)list.get(ei + 1);
                            sd.setCharacterAttributes(t.from, et.from + et.len - t.from, StyledEditor.this.cs.getMultiLineCommentAttributeSet(), true);
                            i = ei + 1;
                            setted = true;
                            break;
                        }
                    }
                    if (setted) continue;
                    sd.setCharacterAttributes(t.from, t.len, StyledEditor.this.cs.getAttributeSet(t.token), true);
                }
            }
            catch (Exception e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }

        private boolean match(String token, List ts, int index) {
            return ts.size() > index && token.equals(((Token)ts.get((int)index)).token);
        }

        private int searchNextToken(String token, List ts, int from) {
            int n = ts.size();
            for (int i = from; i < n; ++i) {
                Token t = (Token)ts.get(i);
                if (!token.equals(t.token)) continue;
                return i;
            }
            return -1;
        }

        class Token {
            String token;
            int from;
            int len;

            Token() {
            }

            boolean isEmpty() {
                return this.token.trim().length() == 0;
            }

            public String toString() {
                return this.token;
            }
        }
    }
}

