/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.ui.editor.styled;

import com.kingdee.cosmic.ctrl.common.ui.editor.DefaultEditorStyleModel;
import com.kingdee.cosmic.ctrl.common.ui.editor.Lexer;
import com.kingdee.cosmic.ctrl.common.ui.editor.MatchedToken;
import com.kingdee.cosmic.ctrl.common.ui.editor.StyledEditor;
import com.kingdee.cosmic.ctrl.script.scriptql.ScriptQLConst;
import java.awt.Color;
import java.util.Arrays;
import java.util.Set;

public class SQLStyledEditor
extends StyledEditor {
    public SQLStyledEditor() {
        this(new SQLStyleModel());
    }

    public SQLStyledEditor(SQLStyleModel cs) {
        super(cs);
    }

    static class SQLStyleModel
    extends DefaultEditorStyleModel {
        public SQLStyleModel() {
            this.initStyle();
        }

        @Override
        public void beforeRun(Lexer lex) {
            lex.delSpecialChar("[]._");
        }

        private void initStyle() {
            this.addStyle(new MatchedToken(){

                @Override
                public boolean match(String token) {
                    return token.matches("'.*'") || token.matches("\".*\"");
                }
            }, this.createSimpleAttributeSet(Color.RED));
            this.addStyle(new MatchedToken(){

                @Override
                public boolean match(String token) {
                    return token.matches("[\\d]+(([Ll])|(\\.[\\d]+([DdFf])?))?");
                }
            }, this.createSimpleAttributeSet(Color.RED));
            this.addStyle(new MatchedToken(){

                @Override
                public boolean match(String token) {
                    return token.matches("(t|T)\\_[\\w\\d]+");
                }
            }, this.createSimpleAttributeSet(Color.BLUE.darker()));
            String keys = "sum,count,avg";
            Set s = ScriptQLConst.getSysFuncNameSet();
            s.addAll(Arrays.asList(keys.split(",")));
            this.addStyle(s.toArray(new String[0]), this.createSimpleAttributeSet(new Color(0xFF00FF)));
            this.addStyle(ScriptQLConst.getKeyWords(), this.createSimpleAttributeSet(Color.BLUE));
            keys = "~`!@#$%^&*()-=_+[]{};':\",./<>?\\|";
            this.addStyle(keys.split(""), this.createSimpleAttributeSet(Color.GRAY));
        }
    }
}

