/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.ui.stepwizard;

import com.kingdee.cosmic.ctrl.common.layout.table.TableLayout;
import com.kingdee.cosmic.ctrl.common.ui.stepwizard.IWizardStep;
import com.kingdee.cosmic.ctrl.common.ui.stepwizard.WizardDialog;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDList;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDTextArea;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AWizardTypeChooser
implements IWizardStep {
    private WizardDialog.StepsManager manager;
    private KDPanel panContent;
    private KDTextArea txaPrompt;
    private KDLabel labTypeTitle;
    private KDList lstType;

    public AWizardTypeChooser() {
        this.init();
        this.installListener();
    }

    private void init() {
        this.panContent = new KDPanel();
        this.txaPrompt = new KDTextArea();
        this.labTypeTitle = new KDLabel();
        this.lstType = new KDList();
        this.panContent.setOpaque(false);
        this.txaPrompt.setEditable(false);
        this.txaPrompt.setFocusable(false);
        WizardTypeElement[] eles = this.initListElement();
        if (eles != null) {
            for (int i = 0; i < eles.length; ++i) {
                this.addListElement(eles[i], eles[i].getIcon());
            }
        }
        TableLayout tl = TableLayout.split((int)3, (int)1);
        tl.rowStyle(0).setHeight(80);
        tl.rowStyle(0).setMarginBottom(8);
        tl.rowStyle(1).setHeight(20);
        tl.rowStyle(1).setMarginBottom(3);
        tl.rowStyle(2).setPriY(1);
        this.panContent.setLayout((LayoutManager)tl);
        this.panContent.add((Component)this.txaPrompt, (Object)tl.cell(0));
        this.panContent.add((Component)this.labTypeTitle, (Object)tl.cell(1));
        this.panContent.add((Component)this.lstType, (Object)tl.cell(2));
    }

    private void installListener() {
        this.lstType.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (evt.getValueIsAdjusting()) {
                    return;
                }
                WizardTypeElement selectedValue = AWizardTypeChooser.this.getSelectedValue();
                if (selectedValue != null) {
                    AWizardTypeChooser.this.txaPrompt.setText(selectedValue.getPrompt());
                }
                AWizardTypeChooser.this.syncBtn();
            }
        });
    }

    protected abstract WizardTypeElement[] initListElement();

    protected abstract Object createNextStep(String var1);

    private void syncBtn() {
        this.manager.setNextStepEnabled(this.getSelectedValue() != null);
    }

    @Override
    public JComponent getContent() {
        return this.panContent;
    }

    @Override
    public void intoThisStep(IWizardStep prevStep, boolean isOppose) {
        this.syncBtn();
    }

    @Override
    public IWizardStep outThisStep(boolean isOppose) {
        WizardTypeElement selected = this.getSelectedValue();
        if (selected == null) {
            return null;
        }
        Object obj = this.createNextStep(selected.getNextStepClassname());
        if (obj instanceof IWizardStep) {
            return (IWizardStep)obj;
        }
        return null;
    }

    @Override
    public boolean isReturnable() {
        return true;
    }

    @Override
    public void initStep(WizardDialog.StepsManager manager) {
        this.manager = manager;
        manager.setFinishEnabled(false);
    }

    @Override
    public void destroy(boolean isFinished) {
    }

    public void addListElement(WizardTypeElement obj, Icon icon) {
        this.lstType.addElement((Object)obj);
        if (icon != null) {
            this.lstType.setElementIcon(icon, (Object)obj);
        }
    }

    public void setTypeTitle(String title) {
        this.labTypeTitle.setText(title);
    }

    private WizardTypeElement getSelectedValue() {
        Object obj = this.lstType.getSelectedValue();
        if (obj == null) {
            return null;
        }
        return (WizardTypeElement)obj;
    }

    public static class WizardTypeElement {
        private String name;
        private String prompt;
        private String nextStepClassname;
        private Icon icon;

        public WizardTypeElement(String name, String nextStepClassname) {
            this(name, null, nextStepClassname);
        }

        public WizardTypeElement(String name, String prompt, String nextStepClassname) {
            this.name = name;
            this.prompt = prompt;
            this.nextStepClassname = nextStepClassname;
        }

        public String toString() {
            return this.name;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNextStepClassname() {
            return this.nextStepClassname;
        }

        public void setNextStepClassname(String nextStepClassname) {
            this.nextStepClassname = nextStepClassname;
        }

        public String getPrompt() {
            return this.prompt;
        }

        public void setPrompt(String prompt) {
            this.prompt = prompt;
        }
    }
}

