/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.ui.textfield;

import com.kingdee.cosmic.ctrl.common.ResourceManager;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class SearchTextField
extends KDTextField {
    private String _niceNote;
    private String _tips;
    private int _status = 0;
    public static final int NONE_TEXT = 0;
    public static final int NONE_TEXT_FOCUS = 1;
    public static final int HAVE_TEXT = 2;
    public static final int HAVE_TEXT_FOCUS = 3;
    private static final Image _sIcon;
    private static final Image _sfIcon;
    private static final Image _eIcon;
    private static final Image _efIcon;
    private Rectangle _iconArea;

    public SearchTextField(String suggestNote) {
        this._niceNote = suggestNote;
        this.installCustomListeners();
        this.setText(this._niceNote);
        this.setCustomForegroundColor(Color.gray);
        this.setCustomInsets(new Insets(1, 1, 1, 23));
        if (this._tips == null) {
            this.setTooltips(this._niceNote);
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this._iconArea = this.calcIconPosition();
        Graphics2D g2d = (Graphics2D)g;
        switch (this._status) {
            case 0: {
                g2d.drawImage(_sIcon, (int)this._iconArea.getX(), (int)this._iconArea.getY(), (int)this._iconArea.getWidth(), (int)this._iconArea.getHeight(), null);
                break;
            }
            case 1: {
                g2d.drawImage(_sfIcon, (int)this._iconArea.getX(), (int)this._iconArea.getY(), (int)this._iconArea.getWidth(), (int)this._iconArea.getHeight(), null);
                break;
            }
            case 2: {
                g2d.drawImage(_eIcon, (int)this._iconArea.getX(), (int)this._iconArea.getY(), (int)this._iconArea.getWidth(), (int)this._iconArea.getHeight(), null);
                break;
            }
            case 3: {
                g2d.drawImage(_efIcon, (int)this._iconArea.getX(), (int)this._iconArea.getY(), (int)this._iconArea.getWidth(), (int)this._iconArea.getHeight(), null);
            }
        }
    }

    private void installCustomListeners() {
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (SearchTextField.this._niceNote.equals(SearchTextField.this.getText())) {
                    SearchTextField.this.setCustomForegroundColor(Color.black);
                    SearchTextField.this.setText(null);
                    SearchTextField.this._status = 2;
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if ("".equals(SearchTextField.this.getText())) {
                    SearchTextField.this.setCustomForegroundColor(Color.gray);
                    SearchTextField.this.setText(SearchTextField.this._niceNote);
                    SearchTextField.this._status = 0;
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (SearchTextField.this.InIconArea(e.getPoint())) {
                    if (SearchTextField.this._status == 2) {
                        SearchTextField.this._status = 3;
                    } else if (SearchTextField.this._status == 0) {
                        SearchTextField.this._status = 1;
                    }
                    SearchTextField.this.setCursor(Cursor.getPredefinedCursor(0));
                    SearchTextField.this.revalidate();
                    SearchTextField.this.repaint();
                } else {
                    if (SearchTextField.this._status == 1) {
                        SearchTextField.this._status = 0;
                    } else if (SearchTextField.this._status == 3) {
                        SearchTextField.this._status = 2;
                    }
                    SearchTextField.this.setCursor(Cursor.getPredefinedCursor(2));
                    SearchTextField.this.revalidate();
                    SearchTextField.this.repaint();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){
            private boolean _isPress;

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SearchTextField.this.InIconArea(e.getPoint())) {
                    SearchTextField.this.revalidate();
                    SearchTextField.this.repaint();
                    SearchTextField.this.clearAction(SearchTextField.this);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (SearchTextField.this.InIconArea(e.getPoint())) {
                    this._isPress = true;
                    Graphics2D g = (Graphics2D)SearchTextField.this.getGraphics();
                    g.setColor(Color.GRAY);
                    BasicStroke dashStroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{1.0f}, 0.0f);
                    g.setStroke(dashStroke);
                    g.drawRect(((SearchTextField)SearchTextField.this)._iconArea.x + 1, ((SearchTextField)SearchTextField.this)._iconArea.y + 1, ((SearchTextField)SearchTextField.this)._iconArea.width - 1, ((SearchTextField)SearchTextField.this)._iconArea.height - 1);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this._isPress) {
                    this._isPress = false;
                    SearchTextField.this.repaint();
                }
            }
        });
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SearchTextField.this.searchAction(SearchTextField.this);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SearchTextField.this.searchAction(SearchTextField.this);
            }
        });
    }

    public abstract void clearAction(SearchTextField var1);

    public abstract void searchAction(SearchTextField var1);

    private boolean InIconArea(Point p) {
        int h;
        int X = p.x;
        int Y = p.y;
        int w = (int)this.getSize().getWidth();
        if ((w | (h = (int)this.getSize().getHeight())) < 0) {
            return false;
        }
        int x = w - 20;
        int y = 0;
        if (X < x || Y < y) {
            return false;
        }
        h += y;
        return !((w += x) >= x && w <= X || h >= y && h <= Y);
    }

    private Rectangle calcIconPosition() {
        Dimension cmpSize = this.getSize();
        double height = cmpSize.getHeight();
        double width = cmpSize.getWidth();
        int x = (int)width - 20;
        int y = 3;
        double iconWidth = 16.0;
        double iconHeight = height - 6.0;
        return new Rectangle(x, y, (int)iconWidth, (int)iconHeight);
    }

    public void setTooltips(String tooltips) {
        this._tips = tooltips;
        this.setToolTipText(tooltips);
    }

    public String getNiceNote() {
        return this._niceNote;
    }

    public void setNiceNote(String niceNote) {
        this._niceNote = niceNote;
        this.setText(this._niceNote);
        if (this._tips == null) {
            this.setTooltips(this._niceNote);
        }
    }

    static {
        String packageName = SearchTextField.class.getPackage().getName();
        _sIcon = ResourceManager.getImage(packageName, "search.png");
        _sfIcon = ResourceManager.getImage(packageName, "search_focus.png");
        _eIcon = ResourceManager.getImage(packageName, "erase.png");
        _efIcon = ResourceManager.getImage(packageName, "erase_focus.png");
    }
}

