/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.render;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.common.util.FontUtil;
import com.kingdee.cosmic.ctrl.kdf.util.render.TextDetail;
import com.kingdee.cosmic.ctrl.kdf.util.render.formatparser.HtmlFormatParser;
import com.kingdee.cosmic.ctrl.kdf.util.render.formatparser.IParser;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.swing.KDFont;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.geom.Line2D;
import java.text.AttributedString;
import sun.font.FontDesignMetrics;

public class TextRender {
    public static TextRender instance;
    private String source;
    private IParser parser;
    private TextDetail cell = new TextDetail();
    private boolean flagSimple = true;
    private boolean flagStyle = true;
    private Style cellStyle;
    protected boolean isBlackWhite = false;

    public static synchronized TextRender sharedInstance() {
        if (instance == null) {
            instance = new TextRender();
        }
        return instance;
    }

    public TextRender() {
        this.parser = new HtmlFormatParser();
        this.cellStyle = Styles.getDefaultStyle();
    }

    public TextRender(String source, Style cellStyle) {
        this();
        this.source = source;
        if (cellStyle == null) {
            throw new IllegalArgumentException(CtrlCommonUIMessages.getMLS("formatSetCannotBeNull", "\u4f20\u5165\u7684\u683c\u5f0f\u96c6\u4e0d\u80fd\u4e3anull"));
        }
        this.cellStyle = cellStyle;
    }

    public void setBlackWhite(boolean isBlackWhite) {
        this.isBlackWhite = isBlackWhite;
    }

    public boolean isBlackWhite() {
        return this.isBlackWhite;
    }

    public TextRender(String source, Style cellStyle, IParser parser) {
        this(source, cellStyle);
        this.parser = parser;
    }

    public void draw(Graphics g, Shape clip) {
        TextRender.draw(this, g, clip);
    }

    private AttributedString parseStyleToAttributes() {
        if (this.source == null || this.source.length() < 1) {
            return null;
        }
        AttributedString as = new AttributedString(this.source);
        as.addAttribute(TextAttribute.FONT, this.cellStyle.getKDFont().getFont());
        Color fontColor = this.cellStyle.getFontColor();
        if (!this.isBlackWhite() || fontColor.getBlue() == fontColor.getRed() && fontColor.getBlue() == fontColor.getGreen()) {
            as.addAttribute(TextAttribute.FOREGROUND, fontColor);
        } else {
            as.addAttribute(TextAttribute.FOREGROUND, Color.BLACK);
        }
        if (this.cellStyle.isUnderline()) {
            as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (this.cellStyle.isStrikeThrough()) {
            as.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        return as;
    }

    public void draw(Graphics g, Shape clip, String source) {
        this.setSource(source);
        this.draw(g, clip);
    }

    public void draw(Graphics g, Shape clip, String source, Style cellStyle) {
        this.setSource(source);
        Graphics2D g2d = (Graphics2D)g;
        if (null == cellStyle) {
            this.draw(g2d, clip);
            return;
        }
        this.setCellStyle(cellStyle);
        if (Styles.HorizontalAlignment.LEFT == cellStyle.getHorizontalAlign()) {
            Rectangle rect = clip.getBounds();
            if (cellStyle.getIndentation() > 0) {
                int fontStyle = 0;
                if (cellStyle.isBold()) {
                    ++fontStyle;
                }
                if (cellStyle.isItalic()) {
                    fontStyle += 2;
                }
                Font f = new Font(cellStyle.getFontName(), fontStyle, cellStyle.getFontSize());
                FontDesignMetrics fm = FontDesignMetrics.getMetrics(f);
                rect.x += ((FontMetrics)fm).charWidth('A') * cellStyle.getIndentation();
            }
            clip = rect;
        }
        if (cellStyle.isVerticalText() && null != this.getSource() && this.getSource().length() > 0) {
            this.drawVerticalText(g, clip);
        } else {
            this.draw(g2d, clip);
        }
    }

    private void drawVerticalText(Graphics g, Shape clip) {
        Rectangle rect = clip.getBounds();
        KDFont f = this.cellStyle.getKDFont();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.cellStyle.getFontColor());
        g2d.setFont((Font)f);
        LineMetrics lm = f.getLineMetrics(this.getSource(), g2d.getFontRenderContext());
        FontMetrics fontMetrics = g2d.getFontMetrics((Font)f);
        double fontHeight = lm.getAscent() + lm.getDescent();
        double x = 0.0;
        double y = 0.0;
        double lineX = 0.0;
        double lineY = 0.0;
        Styles.HorizontalAlignment hAlign = this.cellStyle.getHorizontalAlign();
        if (hAlign == Styles.HorizontalAlignment.CENTER) {
            double clipCenter = rect.getWidth() / 2.0;
            double fontCenter = fontHeight / 2.0;
            x = (double)rect.x + clipCenter - fontCenter;
            lineX = (double)rect.x + rect.getWidth() / 2.0;
        } else if (hAlign == Styles.HorizontalAlignment.RIGHT) {
            x = (double)rect.x + rect.getWidth() - 1.0 - fontHeight;
            lineX = (double)rect.x + rect.getWidth() - fontHeight / 2.0;
        } else {
            x = rect.x + 1;
            lineX = (double)rect.x + fontHeight / 2.0;
        }
        int sourceHeight = (int)(fontHeight * (double)this.getSource().length());
        Styles.VerticalAlignment vAlign = this.cellStyle.getVerticalAlign();
        if (vAlign == Styles.VerticalAlignment.TOP) {
            y = (float)rect.y + lm.getAscent();
            lineY = rect.y;
        } else if (vAlign == Styles.VerticalAlignment.BOTTOM) {
            y = rect.getY() + rect.getHeight() - 1.0 - (double)lm.getDescent() - (double)sourceHeight + fontHeight;
            lineY = (double)rect.y + rect.getHeight() - 1.0 - (double)sourceHeight;
        } else {
            double clipCenter = rect.getHeight() / 2.0;
            double fontCenter = (double)sourceHeight / 2.0;
            y = (double)rect.y + (clipCenter - fontCenter) + (double)lm.getAscent() - 1.0;
            lineY = (double)rect.y + rect.getHeight() / 2.0 - fontCenter;
        }
        int length = this.getSource().length();
        for (int i = 0; i < length; ++i) {
            String text = String.valueOf(this.getSource().charAt(i));
            int textWidht = fontMetrics.stringWidth(text);
            g2d.drawString(text, (int)(x + fontHeight / 2.0 - (double)textWidht / 2.0), (int)y);
            y += fontHeight;
        }
        double lineYEnd = lineY + (double)sourceHeight;
        if (this.cellStyle.isStrikeThrough()) {
            Stroke saveStroke = g2d.getStroke();
            g2d.setStroke(new BasicStroke(lm.getStrikethroughThickness()));
            g2d.draw(new Line2D.Double(lineX, lineY, lineX, lineYEnd));
            g2d.setStroke(saveStroke);
        }
    }

    public void draw(Graphics g, Shape clip, String source, Style cellStyle, IParser parser) {
        this.setSource(source);
        this.setParser(parser);
        this.setCellStyle(cellStyle);
        this.draw(g, clip);
    }

    public IParser getParser() {
        return this.parser;
    }

    public String getSource() {
        return this.source;
    }

    public void setParser(IParser parser) {
        this.parser = parser;
    }

    public Style getCellStyle() {
        return this.cellStyle;
    }

    public void setCellStyle(Style style) {
        if (style == null) {
            throw new IllegalArgumentException(CtrlCommonUIMessages.getMLS("styleParamCannotBeNull", "\u4f20\u5165\u7684Style\u53c2\u6570\u4e0d\u80fd\u4e3anull"));
        }
        this.cellStyle = style;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public boolean isFlagSimple() {
        return this.flagSimple;
    }

    public void setFlagSimple(boolean b) {
        this.flagSimple = b;
    }

    public boolean isFlagStyle() {
        return this.flagStyle;
    }

    public void setFlagStyle(boolean flagStyle) {
        this.flagStyle = flagStyle;
    }

    private static synchronized void draw(TextRender render, Graphics g, Shape clip) {
        if (render.isFlagSimple()) {
            if (null == render.source || render.source.trim().length() == 0) {
                return;
            }
            if (render.isFlagStyle()) {
                AttributedString as = render.parseStyleToAttributes();
                render.cell.setText(FontUtil.validateFont((AttributedString)as));
            } else {
                render.cell.setSource(render.source);
            }
        } else {
            AttributedString as = render.parser.parse(render.source, render.getCellStyle());
            if (null == as) {
                return;
            }
            render.cell.setText(as);
        }
        render.cell.setCellStyle(render.cellStyle);
        render.cell.draw((Graphics2D)g, clip);
    }
}

