/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.render.layout;

import com.kingdee.cosmic.ctrl.kdf.util.render.exception.LayoutException;
import com.kingdee.cosmic.ctrl.kdf.util.render.layout.IRowBreaker;
import com.kingdee.cosmic.ctrl.kdf.util.render.layout.SureRow;
import com.kingdee.cosmic.ctrl.kdf.util.render.layout.SureTextLayout;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.font.TextMeasurer;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashSet;

public class TextLayoutBreaker
implements IRowBreaker {
    private String source;
    private char[] chars;
    private TextMeasurer measurer;
    private AttributedString text;
    private int pos;
    private float lineLength;
    private FontRenderContext frc;

    public TextLayoutBreaker(AttributedString text, FontRenderContext frc) {
        this(text, frc, 100);
    }

    public TextLayoutBreaker(AttributedString text, FontRenderContext frc, int lineLength) {
        this.frc = frc;
        this.text = text;
        this.measurer = new TextMeasurer(this.text.getIterator(), this.frc);
        this.setPos(0);
        this.setLineLength(lineLength);
        StringBuilder sb = new StringBuilder();
        AttributedCharacterIterator aci = this.text.getIterator();
        for (int i = 0; i < aci.getEndIndex(); ++i) {
            sb.append(aci.current());
            aci.next();
        }
        this.source = sb.toString();
        this.chars = this.source.toCharArray();
    }

    public AttributedString getText() {
        return this.text;
    }

    @Override
    public long getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        if (pos < 0 || pos > this.text.getIterator().getEndIndex()) {
            throw new IllegalArgumentException("Position is out of range.");
        }
        this.pos = pos;
    }

    public float getLineLength() {
        return this.lineLength;
    }

    @Override
    public void setLineLength(float length) {
        this.lineLength = length;
    }

    @Override
    public SureRow nextRow(float length) {
        AttributedString as;
        TextLayout result = null;
        int endIndex = 0;
        try {
            endIndex = this.measurer.getLineBreakIndex(this.pos, length);
            if (endIndex <= this.pos) {
                endIndex = this.pos + 1;
            }
            if (this.isInWord(endIndex)) {
                endIndex = this.getPreWordBreak(endIndex);
            }
            int wrapIndex = this.checkForWrap(endIndex);
            result = this.measurer.getLayout(this.pos, wrapIndex);
            as = new AttributedString(this.text.getIterator(), this.pos, wrapIndex);
            this.pos = wrapIndex;
            if (wrapIndex == endIndex) {
                if (this.pos <= this.chars.length - 2) {
                    if (this.chars[this.pos] == ' ' && this.chars[this.pos + 1] != ' ') {
                        ++this.pos;
                    }
                } else if (this.pos == this.chars.length - 1 && this.chars[this.pos] == ' ') {
                    ++this.pos;
                }
            }
        }
        catch (Exception err) {
            throw new LayoutException("Line wrap error:baseline is too short", err);
        }
        return new SureTextLayout(as, result);
    }

    private int checkForWrap(int endIndex) {
        for (int i = this.pos; i < endIndex; ++i) {
            if (this.chars[i] != '\n') continue;
            return i + 1;
        }
        return endIndex;
    }

    private int getPreWordBreak(int fromIndex) {
        int i = fromIndex - 1;
        while ((long)i > this.getPos()) {
            if (!this.isInWord(i)) {
                return i;
            }
            --i;
        }
        return fromIndex;
    }

    private boolean isInWord(int index) {
        if (index <= 0 || index >= this.source.length()) {
            return false;
        }
        char c = this.chars[index];
        char pc = this.chars[index - 1];
        if (this.isCJKCharacter(pc)) {
            return this.isPunctuation(c);
        }
        if (this.isCJKCharacter(c)) {
            return false;
        }
        return !Character.isWhitespace(c) && !Character.isWhitespace(pc);
    }

    private boolean isPunctuation(char c) {
        int type = Character.getType(c);
        HashSet<Integer> punctuationTypes = new HashSet<Integer>();
        punctuationTypes.add(23);
        punctuationTypes.add(20);
        punctuationTypes.add(22);
        punctuationTypes.add(30);
        punctuationTypes.add(29);
        punctuationTypes.add(24);
        punctuationTypes.add(21);
        boolean isPunctuation = punctuationTypes.contains(type);
        return isPunctuation;
    }

    private boolean isCJKCharacter(char c) {
        Character.UnicodeBlock[] cjkBlocks;
        int[][] cjkUnicodeRanges;
        for (int[] range : cjkUnicodeRanges = new int[][]{{12288, 40959}, {11904, 12031}, {12032, 12245}, {11904, 12019}, {63744, 64217}, {59413, 59503}, {58368, 58856}, {58880, 59087}, {12272, 12287}, {65040, 65055}, {44032, 55215}, {4352, 4607}}) {
            if (range[0] > c || c > range[1]) continue;
            return true;
        }
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
        for (Character.UnicodeBlock cjkBlock : cjkBlocks = new Character.UnicodeBlock[]{Character.UnicodeBlock.CJK_COMPATIBILITY, Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS, Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS, Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT, Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT, Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION, Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS, Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A, Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B}) {
            if (!cjkBlock.equals(unicodeBlock)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SureRow nextRow() {
        return this.nextRow(this.lineLength);
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.text.getIterator().getEndIndex();
    }
}

