/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.kdf.util.render.AbstractBasicRender;
import com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle.ISplitRectInfo;
import com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle.TriangleInfo;
import com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle.TriangleTextRender;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public class SplitRectTextRender
extends AbstractBasicRender {
    private static TriangleTextRender triangleTextRender = new TriangleTextRender();

    @Override
    public void draw(Graphics g, Shape clip, Object o, Style style) {
        if (o == null || !(o instanceof ISplitRectInfo)) {
            throw new IllegalArgumentException(CtrlCommonUIMessages.getMLS("objectMustBeISplitRectangleInfo", "object\u5fc5\u987b\u662fISplitRectangleInfo\u7c7b\u578b"));
        }
        ISplitRectInfo info = (ISplitRectInfo)o;
        Rectangle2D rect = clip.getBounds2D();
        int size = info.size();
        for (int i = 0; i < size - 1; ++i) {
            TriangleInfo ti = info.getTriangleInfo(rect, i);
            triangleTextRender.draw(g, clip, ti, style);
            Style st = ti.getStyle();
            g.setColor(this.getLineColor(st));
            ((Graphics2D)g).draw(info.getLine(rect, i));
        }
        triangleTextRender.draw(g, clip, info.getTriangleInfo(rect, size - 1), style);
    }

    private Color getLineColor(Style style) {
        if (style != null && !style.isNullBorder(Styles.Position.LEFT)) {
            return style.getBorderColor(Styles.Position.LEFT);
        }
        return Color.black;
    }
}

