/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.style;

import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.util.regex.PatternSyntaxException;

public class Rect {
    private int _left;
    private int _top;
    private int _right;
    private int _bottom;

    public static Rect valueOf(String str) {
        int l = 0;
        int t = 0;
        int r = 0;
        int b = 0;
        try {
            String[] astr = str.split(",");
            if (astr.length == 4) {
                l = Integer.parseInt(astr[0]);
                t = Integer.parseInt(astr[1]);
                r = Integer.parseInt(astr[2]);
                b = Integer.parseInt(astr[3]);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return new Rect(l, t, r, b);
    }

    public Rect(int left, int top, int right, int bottom) {
        this._left = left;
        this._top = top;
        this._right = right;
        this._bottom = bottom;
    }

    public Rect getCopy() {
        return new Rect(this._left, this._top, this._right, this._bottom);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Rect) {
            Rect rc = (Rect)obj;
            return this._left == rc._left && this._top == rc._top && this._right == rc._right && this._bottom == rc._bottom;
        }
        return false;
    }

    public int get(Styles.Dir dir) {
        switch (dir.getIndex()) {
            case 4: {
                return this._left;
            }
            case 8: {
                return this._top;
            }
            case 1: {
                return this._right;
            }
        }
        return this._bottom;
    }

    public boolean set(Styles.Dir dir, int v) {
        boolean changed = false;
        switch (dir.getIndex()) {
            case 4: {
                if (this._left == v) break;
                this._left = v;
                changed = true;
                break;
            }
            case 8: {
                if (this._top == v) break;
                this._top = v;
                changed = true;
                break;
            }
            case 1: {
                if (this._right == v) break;
                this._right = v;
                changed = true;
                break;
            }
            default: {
                if (this._bottom == v) break;
                this._bottom = v;
                changed = true;
            }
        }
        return changed;
    }

    public int getLeft() {
        return this._left;
    }

    public boolean setLeft(int left) {
        if (this._left != left) {
            this._left = left;
            return true;
        }
        return false;
    }

    public int getTop() {
        return this._top;
    }

    public boolean setTop(int top) {
        if (this._top != top) {
            this._top = top;
            return true;
        }
        return false;
    }

    public int getRight() {
        return this._right;
    }

    public boolean setRight(int right) {
        if (this._right != right) {
            this._right = right;
            return true;
        }
        return false;
    }

    public int getBottom() {
        return this._bottom;
    }

    public boolean setBottom(int bottom) {
        if (this._bottom != bottom) {
            this._bottom = bottom;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toString(this._left));
        sb.append(',');
        sb.append(Integer.toString(this._top));
        sb.append(',');
        sb.append(Integer.toString(this._right));
        sb.append(',');
        sb.append(Integer.toString(this._bottom));
        return sb.toString();
    }
}

