/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.kdf.util.render.TextRender;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.StyleDesignerUtil;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.packing.IStylePane;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDSeparator;
import com.kingdee.cosmic.ctrl.swing.KDSpinner;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AlignmentPane
extends KDPanel
implements IStylePane {
    private static final long serialVersionUID = 1153891207067014510L;
    private StyleAttributes sa;
    private KDComboBox cmbVertical = new KDComboBox();
    private KDComboBox cmbHorizontal = new KDComboBox();
    private KDLabelContainer lbcHorizontal = new KDLabelContainer((JComponent)this.cmbHorizontal);
    private KDLabelContainer lbcVertical = new KDLabelContainer((JComponent)this.cmbVertical);
    private KDCheckBox chkWrapText = new KDCheckBox();
    private KDCheckBox chkShrink = new KDCheckBox();
    private KDCheckBox chkClip = new KDCheckBox();
    private KDSpinner indent = new KDSpinner();
    private KDLabelContainer lbcIndent = new KDLabelContainer((JComponent)this.indent);
    private KDSpinner spnLineSpacing = new KDSpinner();
    private KDSpinner spnWordSpacing = new KDSpinner();
    private KDSpinner spnCharSpacing = new KDSpinner();
    private KDSpinner spnLineSpan = new KDSpinner();
    private KDSpinner spnCharSpan = new KDSpinner();
    private KDSpinner spnRotate = new KDSpinner();
    private KDCheckBox chkVerticalText = new KDCheckBox();
    private PreviewPanel panPreviewRotate;
    private HashMap mapVertical = new HashMap();
    private HashMap mapHorizontal = new HashMap();
    private Styles.VerticalAlignment[] attVertical = new Styles.VerticalAlignment[]{Styles.VerticalAlignment.TOP, Styles.VerticalAlignment.MIDDLE, Styles.VerticalAlignment.BOTTOM};
    private Styles.HorizontalAlignment[] attHorizontal = new Styles.HorizontalAlignment[]{Styles.HorizontalAlignment.LEFT, Styles.HorizontalAlignment.CENTER, Styles.HorizontalAlignment.RIGHT};
    private boolean flagIsShowValueFireMe;
    private StyleAttributes sa4Paint = Styles.getDefaultSA();
    private Style style4Paint = Styles.getStyle(this.sa4Paint);
    private boolean is4Printing = true;

    public AlignmentPane() {
        this.initCompoments();
        this.installCompoments();
        this.installListener();
    }

    @Override
    public void setSA(StyleAttributes sa) {
        this.flagIsShowValueFireMe = true;
        this.sa = sa;
        this.sa4Paint.setFontSize(18);
        this.refreshStyle4Paint(sa);
        this.showValue();
        this.flagIsShowValueFireMe = false;
    }

    public void setTextConrolEnable(boolean enal) {
        this.chkClip.setEnabled(enal);
        this.chkShrink.setEnabled(enal);
        this.chkWrapText.setEnabled(enal);
        this.chkVerticalText.setEnabled(enal);
    }

    public void setAlignEnable(boolean enal) {
        this.cmbVertical.setEnabled(enal);
        this.cmbHorizontal.setEnabled(enal);
    }

    private void initCompoments() {
        Object[] sVertical = new String[]{this.getMLS("verticalValue1", "\u4e0a\u5bf9\u9f50"), this.getMLS("verticalValue2", "\u5c45\u4e2d"), this.getMLS("verticalValue3", "\u4e0b\u5bf9\u9f50")};
        for (int i = this.attVertical.length - 1; i >= 0; --i) {
            this.mapVertical.put(this.attVertical[i], sVertical[i]);
        }
        Object[] sHorizontal = new String[]{this.getMLS("horizontalValue1", "\u5de6\u5bf9\u9f50"), this.getMLS("horizontalValue2", "\u5c45\u4e2d"), this.getMLS("horizontalValue3", "\u53f3\u5bf9\u9f50")};
        for (int i = this.attHorizontal.length - 1; i >= 0; --i) {
            this.mapHorizontal.put(this.attHorizontal[i], sHorizontal[i]);
        }
        this.cmbVertical.addItems(sVertical);
        this.cmbHorizontal.addItems(sHorizontal);
        this.chkWrapText.setSwitch(false);
        this.chkShrink.setSwitch(false);
        this.chkClip.setSwitch(false);
        this.panPreviewRotate = new PreviewPanel();
        this.panPreviewRotate.setOpaque(true);
        this.panPreviewRotate.setBackground(Color.WHITE);
        this.panPreviewRotate.setBorder(BorderFactory.createLineBorder(Color.BLACK));
    }

    public void reDefineCompomentsLayout() {
        this.lbcHorizontal.setBounds(30, 30, 125, 40);
        this.lbcVertical.setBounds(30, 73, 125, 40);
        this.indent.setModel((SpinnerModel)new SpinnerNumberModel(0, 0, 100, 1));
        this.lbcIndent.setBounds(180, 30, 55, 40);
        this.lbcIndent.setBoundLabelAlignment(8);
        this.lbcIndent.setVisible(true);
    }

    private void installCompoments() {
        KDSeparator sprTextAlign = new KDSeparator();
        KDSeparator sprTextControl = new KDSeparator();
        KDSeparator sprSpace = new KDSeparator();
        KDLabel labTextAlign = new KDLabel(this.getMLS("titleAlignment", "\u5bf9\u9f50\u65b9\u5f0f"));
        KDLabel labTextControl = new KDLabel(this.getMLS("titleTextControl", "\u6587\u672c\u63a7\u5236"));
        KDLabel labSpace = new KDLabel(this.getMLS("titleSpacingSet", "\u95f4\u8ddd\u8bbe\u7f6e"));
        KDLabelContainer lbcLineSpacing = new KDLabelContainer((JComponent)this.spnLineSpacing);
        KDLabelContainer lbcWordSpacing = new KDLabelContainer((JComponent)this.spnWordSpacing);
        KDLabelContainer lbcCharSpacing = new KDLabelContainer((JComponent)this.spnCharSpacing);
        KDLabelContainer lbcLineSpan = new KDLabelContainer((JComponent)this.spnLineSpan);
        KDLabelContainer lbcCharSpan = new KDLabelContainer((JComponent)this.spnCharSpan);
        KDLabelContainer lbcRotate = new KDLabelContainer((JComponent)this.spnRotate);
        this.lbcIndent.setBoundLabelText(this.getMLS("indent", "\u7f29\u8fdb\u91cf"));
        this.lbcVertical.setBoundLabelText(this.getMLS("vertical", "\u5782\u76f4\u5bf9\u9f50"));
        this.lbcHorizontal.setBoundLabelText(this.getMLS("horizontal", "\u6c34\u5e73\u5bf9\u9f50"));
        lbcLineSpacing.setBoundLabelText(this.getMLS("lineSpacing", "\u884c\u95f4\u8ddd(pt)"));
        lbcWordSpacing.setBoundLabelText(this.getMLS("wordSpacing", "\u8bcd\u95f4\u8ddd(pt)"));
        lbcCharSpacing.setBoundLabelText(this.getMLS("charSpacing", "\u5b57\u95f4\u8ddd(pt)"));
        lbcLineSpan.setBoundLabelText(this.getMLS("lineSpan", "\u884c\u8de8\u8ddd(pt)"));
        lbcCharSpan.setBoundLabelText(this.getMLS("charSpan", "\u5b57\u8de8\u8ddd(pt)"));
        lbcRotate.setBoundLabelText(this.getMLS("rotateUnit", "\u5ea6"));
        this.chkWrapText.setText(this.getMLS("wrapText", "\u81ea\u52a8\u6362\u884c"));
        this.chkShrink.setText(this.getMLS("shrink", "\u7f29\u653e\u6587\u5b57"));
        this.chkClip.setText(this.getMLS("clip", "\u4e0d\u88c1\u526a"));
        this.chkVerticalText.setText(this.getMLS("verticalText", "\u6587\u5b57\u7ad6\u6392"));
        this.lbcVertical.setBoundLabelAlignment(8);
        this.lbcHorizontal.setBoundLabelAlignment(8);
        lbcRotate.setBoundLabelAlignment(3);
        lbcRotate.getBoundLabel().setHorizontalAlignment(2);
        lbcLineSpacing.setBoundLabelUnderline(true);
        lbcWordSpacing.setBoundLabelUnderline(true);
        lbcCharSpacing.setBoundLabelUnderline(true);
        lbcLineSpan.setBoundLabelUnderline(true);
        lbcCharSpan.setBoundLabelUnderline(true);
        KDPanel panRotate = new KDPanel(null);
        panRotate.setBorder((Border)new TitledBorder(BorderFactory.createEtchedBorder(), this.getMLS("titleRotate", CtrlCommonUIMessages.getMLS("titleRotate", "\u65cb\u8f6c"))));
        panRotate.setOpaque(false);
        panRotate.add((Component)lbcRotate);
        panRotate.add((Component)this.chkVerticalText);
        panRotate.add((Component)((Object)this.panPreviewRotate));
        this.add((Component)this.lbcIndent);
        this.add((Component)this.lbcVertical);
        this.add((Component)this.lbcHorizontal);
        this.add((Component)this.chkWrapText);
        this.add((Component)this.chkShrink);
        this.add((Component)panRotate);
        this.add((Component)labTextAlign);
        this.add((Component)sprTextAlign);
        this.add((Component)labTextControl);
        this.add((Component)sprTextControl);
        this.setLayout(null);
        labTextAlign.setBounds(8, 8, 100, 20);
        sprTextAlign.setBounds(100, 18, 160, 2);
        this.lbcVertical.setBoundLabelLength(19);
        this.lbcIndent.setBoundLabelLength(19);
        this.lbcHorizontal.setBoundLabelLength(19);
        this.lbcHorizontal.setBounds(30, 30, 150, 40);
        this.lbcVertical.setBounds(30, 73, 150, 40);
        this.lbcIndent.setVisible(false);
        panRotate.setBounds(240, 10, 210, 194);
        labTextControl.setBounds(8, 120, 100, 20);
        sprTextControl.setBounds(100, 130, 160, 2);
        this.chkWrapText.setBounds(30, 142, 200, 21);
        this.chkShrink.setBounds(30, 163, 100, 21);
        this.chkClip.setBounds(130, 142, 100, 21);
        labSpace.setBounds(8, 190, 60, 20);
        sprSpace.setBounds(60, 200, 160, 2);
        lbcLineSpacing.setBounds(30, 215, 160, 19);
        lbcCharSpacing.setBounds(30, 237, 160, 19);
        lbcWordSpacing.setBounds(30, 259, 160, 19);
        lbcLineSpan.setBounds(240, 215, 160, 19);
        lbcCharSpan.setBounds(240, 237, 160, 19);
        lbcLineSpacing.setBoundLabelLength(70);
        lbcWordSpacing.setBoundLabelLength(70);
        lbcCharSpacing.setBoundLabelLength(70);
        lbcLineSpan.setBoundLabelLength(70);
        lbcCharSpan.setBoundLabelLength(70);
        this.panPreviewRotate.setBounds(10, 20, 190, 140);
        lbcRotate.setBounds(10, 165, 100, 19);
        lbcRotate.setBoundLabelLength(55);
        this.chkVerticalText.setBounds(100, 165, 90, 19);
        lbcLineSpacing.getBoundLabel().setEnabled(false);
        lbcLineSpacing.getBoundEditor().setEnabled(false);
        lbcWordSpacing.getBoundLabel().setEnabled(false);
        lbcWordSpacing.getBoundEditor().setEnabled(false);
        lbcCharSpacing.getBoundLabel().setEnabled(false);
        lbcCharSpacing.getBoundEditor().setEnabled(false);
        lbcLineSpan.getBoundLabel().setEnabled(false);
        lbcLineSpan.getBoundEditor().setEnabled(false);
        lbcCharSpan.getBoundLabel().setEnabled(false);
        lbcCharSpan.getBoundEditor().setEnabled(false);
    }

    public Dimension getPreferredSize() {
        return new Dimension(454, 286);
    }

    private void installListener() {
        ActionHandler actionHandler = new ActionHandler();
        this.cmbVertical.addActionListener((ActionListener)actionHandler);
        this.cmbHorizontal.addActionListener((ActionListener)actionHandler);
        this.chkWrapText.addActionListener((ActionListener)actionHandler);
        this.chkShrink.addActionListener((ActionListener)actionHandler);
        this.chkClip.addActionListener((ActionListener)actionHandler);
        this.chkVerticalText.addActionListener((ActionListener)actionHandler);
        ChangeHandler changeHandler = new ChangeHandler();
        this.indent.addChangeListener((ChangeListener)changeHandler);
        this.spnLineSpacing.addChangeListener((ChangeListener)changeHandler);
        this.spnWordSpacing.addChangeListener((ChangeListener)changeHandler);
        this.spnCharSpacing.addChangeListener((ChangeListener)changeHandler);
        this.spnLineSpan.addChangeListener((ChangeListener)changeHandler);
        this.spnCharSpan.addChangeListener((ChangeListener)changeHandler);
        this.spnRotate.addChangeListener((ChangeListener)changeHandler);
    }

    private void showValue() {
        if (this.sa.isUnsureValue(StyleAttributes.VERTICAL_ALIGN)) {
            this.cmbVertical.setSelectedIndex(-1);
        } else {
            this.cmbVertical.setSelectedItem(this.mapVertical.get(this.sa.getVerticalAlign()));
        }
        if (!this.sa.hasHorizontalAlign() || this.sa.isUnsureValue(StyleAttributes.HORIZONTAL_ALIGN)) {
            this.cmbHorizontal.setSelectedIndex(-1);
        } else {
            this.cmbHorizontal.setSelectedItem(this.mapHorizontal.get(this.sa.getHorizontalAlign()));
        }
        if (this.sa.isUnsureValue(StyleAttributes.WRAP_TEXT)) {
            this.chkWrapText.setSelected(64);
        } else {
            this.chkWrapText.setSelected(this.sa.isWrapText() ? 32 : 16);
        }
        if (this.sa.isUnsureValue(StyleAttributes.SHRINK_TEXT)) {
            this.chkShrink.setSelected(64);
        } else {
            this.chkShrink.setSelected(this.sa.isShrinkText() ? 32 : 16);
        }
        if (this.sa.isUnsureValue(StyleAttributes.AUTO_CLIP)) {
            this.chkClip.setSelected(64);
        } else {
            this.chkClip.setSelected(!this.sa.isClip() ? 32 : 16);
        }
        if (this.sa.isUnsureValue(StyleAttributes.ROTATION)) {
            this.spnRotate.setValue((Object)0);
        } else {
            this.spnRotate.setValue((Object)this.sa.getRotation());
        }
        if (this.sa.isUnsureValue(StyleAttributes.LINE_SPACING)) {
            this.spnLineSpacing.setValue((Object)Float.valueOf(0.0f));
        } else {
            this.spnLineSpacing.setValue((Object)Float.valueOf(this.sa.getLinespacing()));
        }
        if (this.sa.isUnsureValue(StyleAttributes.VERTICAL_TEXT)) {
            this.chkVerticalText.setSelected(64);
        } else {
            this.chkVerticalText.setSelected(this.sa.isVerticalText() ? 32 : 16);
        }
    }

    private String getMLS(String key, String defaultValue) {
        return CtrlCommonUIMessages.getMLS(key, defaultValue);
    }

    private void refreshStyle4Paint(StyleAttributes sa) {
        StyleDesignerUtil.copyAttr(sa, this.sa4Paint, StyleAttributes.ROTATION);
        StyleDesignerUtil.copyAttr(sa, this.sa4Paint, StyleAttributes.VERTICAL_TEXT);
        this.style4Paint = Styles.getStyle(this.sa4Paint);
    }

    public KDSpinner getIndent() {
        return this.indent;
    }

    public void setIndent(KDSpinner indent) {
        this.indent = indent;
    }

    public KDComboBox getCmbHorizontal() {
        return this.cmbHorizontal;
    }

    public void setCmbHorizontal(KDComboBox cmbHorizontal) {
        this.cmbHorizontal = cmbHorizontal;
    }

    public boolean isIs4Printing() {
        return this.is4Printing;
    }

    public void setIs4Printing(boolean is4Printing) {
        this.is4Printing = is4Printing;
    }

    private class PreviewPanel
    extends KDPanel {
        private static final long serialVersionUID = 1L;
        private TextRender tr;

        public PreviewPanel() {
            this.tr = new TextRender(AlignmentPane.this.getMLS("previewString", "\u8f7b\u62a5\u8868"), AlignmentPane.this.style4Paint);
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (AlignmentPane.this.sa.isUnsureValue(StyleAttributes.ROTATION)) {
                return;
            }
            this.tr.setCellStyle(AlignmentPane.this.style4Paint);
            if (AlignmentPane.this.sa.isVerticalText()) {
                this.tr.draw(g, new Rectangle(0, 0, this.getWidth(), this.getHeight()), CtrlCommonUIMessages.getMLS("previewString", "\u8f7b\u62a5\u8868"), AlignmentPane.this.style4Paint);
            } else {
                this.tr.draw(g, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            }
        }
    }

    private class ChangeHandler
    implements ChangeListener {
        private ChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (AlignmentPane.this.flagIsShowValueFireMe) {
                return;
            }
            Object source = e.getSource();
            if (source.equals(AlignmentPane.this.spnLineSpacing)) {
                AlignmentPane.this.sa.setLinespacing(Float.parseFloat(AlignmentPane.this.spnLineSpacing.getValue().toString()));
            } else if (source.equals(AlignmentPane.this.spnRotate)) {
                int value = Integer.parseInt(AlignmentPane.this.spnRotate.getValue().toString());
                if (value != 0) {
                    AlignmentPane.this.chkVerticalText.setSelected(false);
                    AlignmentPane.this.sa.setVerticalText(false);
                }
                if (value > 90) {
                    value = 90;
                    AlignmentPane.this.spnRotate.setValue((Object)value);
                } else if (value < -90) {
                    value = -90;
                    AlignmentPane.this.spnRotate.setValue((Object)value);
                }
                AlignmentPane.this.sa.setRotation(value);
                AlignmentPane.this.refreshStyle4Paint(AlignmentPane.this.sa);
                AlignmentPane.this.panPreviewRotate.repaint();
            } else if (source.equals(AlignmentPane.this.indent)) {
                AlignmentPane.this.sa.setIndentation((Integer)AlignmentPane.this.indent.getValue());
            }
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AlignmentPane.this.flagIsShowValueFireMe) {
                return;
            }
            Object source = e.getSource();
            if (source.equals(AlignmentPane.this.cmbVertical)) {
                int index = AlignmentPane.this.cmbVertical.getSelectedIndex();
                AlignmentPane.this.sa.setVerticalAlign(AlignmentPane.this.attVertical[index]);
            } else if (source.equals(AlignmentPane.this.cmbHorizontal)) {
                int index = AlignmentPane.this.cmbHorizontal.getSelectedIndex();
                AlignmentPane.this.sa.setHorizontalAlign(AlignmentPane.this.attHorizontal[index]);
                if (Styles.HorizontalAlignment.LEFT.equals(AlignmentPane.this.attHorizontal[index])) {
                    AlignmentPane.this.lbcIndent.setVisible(true);
                } else {
                    AlignmentPane.this.lbcIndent.setVisible(false);
                }
            } else if (source.equals(AlignmentPane.this.chkWrapText)) {
                AlignmentPane.this.sa.setWrapText(AlignmentPane.this.chkWrapText.isSelected());
                if (!AlignmentPane.this.is4Printing) {
                    if (AlignmentPane.this.chkWrapText.isSelected()) {
                        AlignmentPane.this.chkShrink.setSelected(false);
                    }
                    AlignmentPane.this.sa.setShrinkText(AlignmentPane.this.chkShrink.isSelected());
                }
            } else if (source.equals(AlignmentPane.this.chkShrink)) {
                AlignmentPane.this.sa.setShrinkText(AlignmentPane.this.chkShrink.isSelected());
                if (!AlignmentPane.this.is4Printing) {
                    if (AlignmentPane.this.chkShrink.isSelected()) {
                        AlignmentPane.this.chkWrapText.setSelected(false);
                    }
                    AlignmentPane.this.sa.setWrapText(AlignmentPane.this.chkWrapText.isSelected());
                }
            } else if (source.equals(AlignmentPane.this.chkVerticalText)) {
                AlignmentPane.this.sa.setVerticalText(AlignmentPane.this.chkVerticalText.isSelected());
                AlignmentPane.this.spnRotate.setValue((Object)0);
                AlignmentPane.this.sa.setRotation(0);
                this.refreshStyle4VerticalText(AlignmentPane.this.sa);
                AlignmentPane.this.panPreviewRotate.repaint();
            } else if (source.equals(AlignmentPane.this.chkClip)) {
                AlignmentPane.this.sa.setClip(!AlignmentPane.this.chkClip.isSelected());
            }
        }

        private void refreshStyle4VerticalText(StyleAttributes sa) {
            StyleDesignerUtil.copyAttr(sa, AlignmentPane.this.sa4Paint, StyleAttributes.VERTICAL_TEXT);
            AlignmentPane.this.style4Paint = Styles.getStyle(AlignmentPane.this.sa4Paint);
        }
    }
}

