/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner;

import com.kingdee.bos.qing.common.i18n.untrans.QingConstellationUntrans;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.LazyStyleDesigner;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.MultiColorListCellRenderer;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.MultiColorListElement;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.packing.IStylePane;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDList;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDSpinner;
import com.kingdee.cosmic.ctrl.swing.KDTextArea;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DigitFormatPane
extends KDPanel
implements IStylePane {
    static final String ITEM = "ITEM";
    static final String TYPE = "TYPE";
    static final String DECIMAL_DIGITS = "DECIMAL_DIGITS";
    static final String MONEY_SYMBOL = "MONEY_SYMBOL";
    static final String KILLO_SEPARATOR = "KILLO_SEPARATOR";
    static final String FORMAT_STRING = "FORMAT_STRING";
    static final String NORMAL = "NORMAL";
    static final String NUMBER = "NUMBER";
    static final String MONEY = "MONEY";
    static final String ACCOUNT = "ACCOUNT";
    static final String DATE = "DATE";
    static final String TIME = "TIME";
    static final String PERCENT = "PERCENT";
    static final String FRACTION = "FRACTION";
    static final String SCIENCE = "SCIENCE";
    static final String TEXT = "TEXT";
    static final String SPECIAL = "SPECIAL";
    static final String CUSTOM = "CUSTOM";
    static final String YEAR = "YEAR";
    static final String MONTH = "MONTH";
    static final String DAY = "DAY";
    static final String WEEK = "WEEK";
    static final String HOUR = "HOUR";
    static final String MINUTE = "MINUTE";
    static final String SECOND = "SECOND";
    static final String ONE = "ONE";
    static final String TWO = "TWO";
    static final String THREE = "THREE";
    static final String FOUR = "FOUR";
    static final String FIVE = "FIVE";
    static final String SIX = "SIX";
    static final String SEVEN = "SEVEN";
    static final String EIGHT = "EIGHT";
    static final String NINE = "NINE";
    static final String TEN = "TEN";
    static final String POSTALCODE = "POSTALCODE";
    static final String CHINESE_CAPITAL_NUMBER = "CHINESE_CAPITAL_NUMBER";
    static final String CHINESE_MINUSCULE_NUMBER = "CHINESE_MINUSCULE_NUMBER";
    static final String DENOMINATOR = "DENOMINATOR";
    private StyleAttributes _sa;
    private DataModel model;
    private KDList typeList;
    private CardLayout cardLayout = new CardLayout();
    private KDPanel paneCard = new KDPanel((LayoutManager)this.cardLayout);
    private KDTextArea promptText = new KDTextArea();
    private KDSpinner decimalSpn = new KDSpinner();
    private KDCheckBox groupSepCheck = new KDCheckBox();
    private KDComboBox currencyComb;
    private KDTextField _zeroField;
    private KDLabelContainer _zeroLBC;
    private KDList negativeList;
    private KDLabelContainer negativeLBC;
    private KDList fractionList;
    private KDList dateList;
    private KDList timeList;
    private KDList specialList;
    private KDTextField customText = new KDTextField();

    public DigitFormatPane() {
        this.model = new DataModel();
        this.initModels();
        this.installCompoments();
        this.installListener();
    }

    public Dimension getPreferredSize() {
        return new Dimension(454, 290);
    }

    @Override
    public void setSA(StyleAttributes sa) {
        this._sa = sa;
        this.model.setRelatedSA(sa);
        if (sa.isUnsureValue(StyleAttributes.NUMBER_FORMAT)) {
            this.typeList.setSelectedIndex(-1);
        } else {
            this.model.applyPattern(sa.getNumberFormat());
            this.updateStates();
        }
    }

    private void updateStates() {
        this.decimalSpn.setValue((Object)this.model.getDecNums());
        this.groupSepCheck.setSelected(this.model.hasGroupSep());
        this.currencyComb.setSelectedIndex(this.model.getCurrencyIndex());
        this.negativeList.setSelectedIndex(this.model.getNegativeIndex());
        this.fractionList.setSelectedIndex(this.model.getFractionIndex());
        this.dateList.setSelectedIndex(this.model.getDateIndex());
        this.timeList.setSelectedIndex(this.model.getTimeIndex());
        this.specialList.setSelectedIndex(this.model.getSpecialIndex());
        this._zeroField.setText(this.removeQuote(this.model.getZeroString()));
        this.typeList.setSelectedIndex(this.model.getType());
        if (this.model.getType() == 11) {
            this.customText.setText(this.model.getPattern());
        }
        this.repaint();
    }

    private String removeQuote(String src) {
        if (StringUtil.isEmptyString((String)src)) {
            return src;
        }
        if (src.charAt(0) == '\"' && src.charAt(src.length() - 1) == '\"') {
            return src.substring(1, src.length() - 1);
        }
        return src;
    }

    private String addQuote(String src) {
        if (StringUtil.isEmptyString((String)src)) {
            return src;
        }
        StringBuilder sb = new StringBuilder(src.length() + 2);
        sb.append('\"');
        sb.append(src);
        sb.append('\"');
        return sb.toString();
    }

    private void initModels() {
        this.typeList = new KDList((Object[])DataModel.typeTexts);
        this.typeList.setSelectedIndex(this.model.getType());
        this.initNegativeList(2, false);
        this.fractionList = new KDList((Object[])DataModel.fractionTexts);
        this.fractionList.setSelectedIndex(this.model.getFractionIndex());
        this.dateList = new KDList((Object[])DataModel.dateTexts);
        this.dateList.setSelectedIndex(this.model.getDateIndex());
        this.timeList = new KDList((Object[])DataModel.timeTexts);
        this.timeList.setSelectedIndex(this.model.getTimeIndex());
        this.specialList = new KDList((Object[])DataModel.specialTexts);
        this.specialList.setSelectedIndex(this.model.getSpecialIndex());
        this.currencyComb = new KDComboBox((Object[])DataModel.currencyTexts);
        this.currencyComb.setSelectedIndex(this.model.getCurrencyIndex());
        this.promptText.setOpaque(false);
        this.promptText.setEditable(false);
        this.promptText.setBorder(BorderFactory.createEmptyBorder());
        this.decimalSpn.setModel((SpinnerModel)new SpinnerNumberModel(2, 0, 30, 1));
        this.paneCard.setOpaque(false);
        this.customText.setEnabledPopup(false);
    }

    private void initNegativeList(int decimal, boolean group) {
        String str;
        String dd = "";
        StringBuilder sdec = new StringBuilder();
        for (int i = decimal - 1; i >= 0; --i) {
            int n = i;
            if (n >= 10) {
                n %= 10;
            }
            sdec.append(n);
        }
        if (sdec.length() > 0) {
            sdec.insert(0, ".");
            dd = sdec.toString();
        }
        String string = str = group ? "1,234" : "1234";
        if (this.negativeList == null) {
            this.negativeList = new KDList();
            this.negativeList.setCellRenderer((ListCellRenderer)((Object)new MultiColorListCellRenderer()));
        }
        this.negativeList.removeAllElements();
        String e = '(' + str + dd + ')';
        MultiColorListElement element = new MultiColorListElement();
        element.setElement(e);
        element.setForegroud(Color.RED);
        this.negativeList.addElement((Object)element);
        element = new MultiColorListElement();
        element.setElement(e);
        this.negativeList.addElement((Object)element);
        e = str + dd;
        element = new MultiColorListElement();
        element.setElement(e);
        element.setForegroud(Color.RED);
        this.negativeList.addElement((Object)element);
        e = '-' + e;
        element = new MultiColorListElement();
        element.setElement(e);
        this.negativeList.addElement((Object)element);
        element = new MultiColorListElement();
        element.setElement(e);
        element.setForegroud(Color.RED);
        this.negativeList.addElement((Object)element);
        this.negativeList.setSelectedIndex(0);
    }

    private void installCompoments() {
        KDPanel panInCardNormal = new KDPanel(null);
        KDPanel panInCardNumber = new KDPanel(null);
        KDPanel panInCardFraction = new KDPanel(null);
        KDPanel panInCardDate = new KDPanel(null);
        KDPanel panInCardTime = new KDPanel(null);
        KDPanel panInCardText = new KDPanel(null);
        KDPanel panInCardSpecial = new KDPanel(null);
        KDPanel panInCardCustom = new KDPanel(null);
        panInCardNormal.setOpaque(false);
        panInCardFraction.setOpaque(false);
        panInCardNumber.setOpaque(false);
        panInCardDate.setOpaque(false);
        panInCardTime.setOpaque(false);
        panInCardText.setOpaque(false);
        panInCardSpecial.setOpaque(false);
        panInCardCustom.setOpaque(false);
        this.paneCard.add((Component)panInCardNormal, (Object)DataModel.cardTypes[0]);
        this.paneCard.add((Component)panInCardFraction, (Object)DataModel.cardTypes[7]);
        this.paneCard.add((Component)panInCardNumber, (Object)DataModel.cardTypes[1]);
        this.paneCard.add((Component)panInCardDate, (Object)DataModel.cardTypes[4]);
        this.paneCard.add((Component)panInCardTime, (Object)DataModel.cardTypes[5]);
        this.paneCard.add((Component)panInCardText, (Object)DataModel.cardTypes[9]);
        this.paneCard.add((Component)panInCardSpecial, (Object)DataModel.cardTypes[10]);
        this.paneCard.add((Component)panInCardCustom, (Object)DataModel.cardTypes[11]);
        KDScrollPane scpFormatType = new KDScrollPane((Component)this.typeList);
        scpFormatType.setVerticalScrollBarPolicy(22);
        KDScrollPane scpFractionType = new KDScrollPane((Component)this.fractionList);
        scpFractionType.setVerticalScrollBarPolicy(22);
        KDScrollPane scpDateType = new KDScrollPane((Component)this.dateList);
        scpDateType.setVerticalScrollBarPolicy(22);
        KDScrollPane scpTimeType = new KDScrollPane((Component)this.timeList);
        scpTimeType.setVerticalScrollBarPolicy(22);
        KDScrollPane scpSpecialType = new KDScrollPane((Component)this.specialList);
        scpSpecialType.setVerticalScrollBarPolicy(22);
        KDScrollPane scpNegative = new KDScrollPane((Component)this.negativeList);
        scpNegative.setVerticalScrollBarPolicy(22);
        KDLabelContainer lbcFormatType = new KDLabelContainer((JComponent)scpFormatType);
        lbcFormatType.setBoundLabelText(DataModel.getMLS("formatItem", "\u5206\u7c7b"));
        lbcFormatType.setBoundLabelAlignment(8);
        lbcFormatType.setBoundLabelLength(20);
        KDLabelContainer lbcFractionType = new KDLabelContainer((JComponent)scpFractionType);
        lbcFractionType.setBoundLabelText(DataModel.getMLS("formatType", "\u7c7b\u578b"));
        lbcFractionType.setBoundLabelAlignment(8);
        lbcFractionType.setBoundLabelLength(20);
        KDLabelContainer lbcDateType = new KDLabelContainer((JComponent)scpDateType);
        lbcDateType.setBoundLabelText(DataModel.getMLS("formatType", "\u7c7b\u578b"));
        lbcDateType.setBoundLabelAlignment(8);
        lbcDateType.setBoundLabelLength(20);
        KDLabelContainer lbcTimeType = new KDLabelContainer((JComponent)scpTimeType);
        lbcTimeType.setBoundLabelText(DataModel.getMLS("formatType", "\u7c7b\u578b"));
        lbcTimeType.setBoundLabelAlignment(8);
        lbcTimeType.setBoundLabelLength(20);
        KDLabelContainer lbcSpecialType = new KDLabelContainer((JComponent)scpSpecialType);
        lbcSpecialType.setBoundLabelText(DataModel.getMLS("formatType", "\u7c7b\u578b"));
        lbcSpecialType.setBoundLabelAlignment(8);
        lbcSpecialType.setBoundLabelLength(20);
        KDLabelContainer lbcDecimal = new KDLabelContainer((JComponent)this.decimalSpn);
        lbcDecimal.setBoundLabelText(DataModel.getMLS("decimalDigits", "\u5c0f\u6570\u4f4d\u6570"));
        lbcDecimal.setBoundLabelLength(105);
        lbcDecimal.setBoundLabelUnderline(true);
        KDLabelContainer lbcCurrency = new KDLabelContainer((JComponent)this.currencyComb);
        lbcCurrency.setBoundLabelText(DataModel.getMLS("moneySymbol", "\u8d27\u5e01\u7b26\u53f7"));
        lbcCurrency.setBoundLabelLength(105);
        lbcCurrency.setBoundLabelUnderline(true);
        lbcCurrency.setAlignmentX(0.0f);
        this.groupSepCheck.setText(DataModel.getMLS("kiloSeparator", "\u5343\u4f4d\u5206\u9694\u7b26\uff08\uff0c\uff09"));
        KDLabelContainer lbcCustom = new KDLabelContainer((JComponent)this.customText);
        lbcCustom.setBoundLabelText(DataModel.getMLS("formatString", "\u683c\u5f0f\u5316\u4e32"));
        lbcCustom.setBoundLabelAlignment(8);
        lbcCustom.setBoundLabelLength(20);
        this.negativeLBC = new KDLabelContainer((JComponent)scpNegative);
        this.negativeLBC.setBoundLabelText(DataModel.getMLS("negative", "\u8d1f\u6570"));
        this.negativeLBC.setBoundLabelLength(20);
        this.negativeLBC.setBoundLabelAlignment(8);
        this._zeroField = new KDTextField();
        this._zeroLBC = new KDLabelContainer((JComponent)this._zeroField);
        this._zeroLBC.setBoundLabelText(DataModel.getMLS("zeroDisplay", "\u96f6\u503c\u663e\u793a\u4e3a") + ":");
        this._zeroLBC.setBoundLabelAlignment(8);
        panInCardNumber.add((Component)lbcDecimal);
        panInCardNumber.add((Component)this.groupSepCheck);
        panInCardNumber.add((Component)lbcCurrency);
        panInCardNumber.add((Component)this.negativeLBC);
        panInCardNumber.add((Component)this._zeroLBC);
        panInCardFraction.add((Component)lbcFractionType);
        panInCardDate.add((Component)lbcDateType);
        panInCardTime.add((Component)lbcTimeType);
        panInCardSpecial.add((Component)lbcSpecialType);
        panInCardCustom.add((Component)lbcCustom);
        this.add((Component)lbcFormatType);
        this.add((Component)this.paneCard);
        this.setLayout(null);
        lbcFormatType.setBounds(10, 10, 140, 270);
        this.paneCard.setBounds(160, 10, 290, 260);
        lbcDecimal.setBounds(20, 20, 160, 21);
        this.groupSepCheck.setBounds(20, 50, 190, 21);
        lbcCurrency.setBounds(20, 50, 160, 21);
        this.negativeLBC.setBounds(20, 80, 160, 100);
        this._zeroLBC.setBounds(20, 185, 230, 42);
        lbcFractionType.setBounds(0, 0, 290, 160);
        lbcDateType.setBounds(0, 0, 290, 160);
        lbcTimeType.setBounds(0, 0, 290, 160);
        lbcSpecialType.setBounds(0, 0, 290, 160);
        lbcCustom.setBounds(0, 20, 290, 41);
    }

    private void installListener() {
        ActionHandler actionHandler = new ActionHandler();
        this.typeList.addListSelectionListener((ListSelectionListener)actionHandler);
        this.fractionList.addListSelectionListener((ListSelectionListener)actionHandler);
        this.dateList.addListSelectionListener((ListSelectionListener)actionHandler);
        this.timeList.addListSelectionListener((ListSelectionListener)actionHandler);
        this.specialList.addListSelectionListener((ListSelectionListener)actionHandler);
        this.negativeList.addListSelectionListener((ListSelectionListener)actionHandler);
        this.decimalSpn.addChangeListener((ChangeListener)actionHandler);
        this.groupSepCheck.addActionListener((ActionListener)actionHandler);
        this.currencyComb.addActionListener((ActionListener)actionHandler);
        this.customText.addFocusListener((FocusListener)actionHandler);
        this._zeroField.getDocument().addDocumentListener(actionHandler);
    }

    public static class DataModel {
        static final int GENERAL = 0;
        static final int NUMBER = 1;
        static final int CURRENCY = 2;
        static final int ACCOUNT = 3;
        static final int DATE = 4;
        static final int TIME = 5;
        static final int PERCENT = 6;
        static final int FRACTION = 7;
        static final int SCIENCE = 8;
        static final int TEXT = 9;
        static final int SPECIAL = 10;
        static final int CUSTOM = 11;
        static final String[] typeTexts = new String[]{DataModel.getMLS("itemNormal", "\u5e38\u89c4"), DataModel.getMLS("itemNumber", "\u6570\u503c"), DataModel.getMLS("itemMoney", "\u8d27\u5e01"), DataModel.getMLS("itemAccountant", "\u4f1a\u8ba1\u4e13\u7528"), DataModel.getMLS("itemDate", "\u65e5\u671f"), DataModel.getMLS("itemTime", "\u65f6\u95f4"), DataModel.getMLS("itemPercent", "\u767e\u5206\u6bd4"), DataModel.getMLS("itemFraction", "\u5206\u6570"), DataModel.getMLS("itemScience", "\u79d1\u5b66\u8bb0\u6570"), DataModel.getMLS("itemText", "\u6587\u672c"), DataModel.getMLS("itemSpecial", "\u7279\u6b8a"), DataModel.getMLS("itemCustom", "\u81ea\u5b9a\u4e49")};
        static final String[] dateTexts;
        static final String[] timeTexts;
        static final String[] fractionTexts;
        static final String[] specialTexts;
        static final String[] currencyTexts;
        static final String[] cardTypes;
        private static final String[] currencySymbols;
        private static final String groupSepPattern;
        private static final String numberReg;
        private static final String redPattern;
        private static final String redPattern1;
        private static final String generalPattern;
        private static final String[] numRegs;
        private static final String[] groupNumRegs;
        private static final String[] currencyRegs;
        private static final String accountReg;
        private static final String[] datePatterns;
        private static final String[] timePatterns;
        private static final String percentReg;
        private static final String[] fractionPatterns;
        private static final String scienceReg;
        private static final String textPattern;
        private static final String[] specialPatterns;
        private StyleAttributes _sa;
        private String _pattern;
        private int _type;
        private String _zeroStr;
        private int decNums;
        private int currencyIndex;
        private boolean hasGroupSep;
        private int negativeIndex;
        private int dateIndex;
        private int timeIndex;
        private int fractionIndex;
        private int specialIndex;

        static String getMLS(String key, String defaultValue) {
            return LazyStyleDesigner.getMLS(key, defaultValue);
        }

        static final String getGeneral() {
            return generalPattern;
        }

        static final String getGeneralDate() {
            return datePatterns[0];
        }

        static final String getGeneralPercent() {
            return "0%";
        }

        static final String getGeneralScience() {
            return "0.00E00";
        }

        static final String getGeneralTime() {
            return "h:mm";
        }

        static final String getGeneralCurrency(String currencySymbol) {
            StringBuilder sb = new StringBuilder("#,##0.00;[red](#,##0.00)");
            sb.insert(sb.indexOf("(") + 1, currencySymbol);
            sb.insert(0, currencySymbol);
            return sb.toString();
        }

        int getType() {
            return this._type;
        }

        void setType(int type) {
            if (this._type != type) {
                this._type = type;
                if (this._type >= 0) {
                    this.generatePattern();
                }
            }
        }

        int getDecNums() {
            return this.decNums;
        }

        void setDecNums(int num) {
            if (num != this.decNums) {
                this.decNums = num;
                if (this._type == 1 || this._type == 2 || this._type == 3 || this._type == 6 || this._type == 8) {
                    this.generatePattern();
                }
            }
        }

        int getCurrencyIndex() {
            return this.currencyIndex;
        }

        void setCurrencyIndex(int i) {
            if (i != this.currencyIndex) {
                this.currencyIndex = i;
                if (this._type == 2 || this._type == 3) {
                    this.generatePattern();
                }
            }
        }

        boolean hasGroupSep() {
            return this.hasGroupSep;
        }

        void setHasGroupSep(boolean b) {
            if (this.hasGroupSep != b) {
                this.hasGroupSep = b;
                if (this._type == 1) {
                    this.generatePattern();
                }
            }
        }

        String getZeroString() {
            return this._zeroStr;
        }

        void setZeroString(String str) {
            this._zeroStr = str;
            if (this._type == 1 || this._type == 2) {
                this.generatePattern();
            }
        }

        int getNegativeIndex() {
            return this.negativeIndex;
        }

        void setNegativeIndex(int i) {
            if (i != this.negativeIndex) {
                this.negativeIndex = i;
                if (this._type == 1 || this._type == 2) {
                    this.generatePattern();
                }
            }
        }

        int getDateIndex() {
            return this.dateIndex;
        }

        void setDateIndex(int i) {
            if (i != this.dateIndex) {
                this.dateIndex = i;
                if (this._type == 4) {
                    this.generatePattern();
                }
            }
        }

        int getTimeIndex() {
            return this.timeIndex;
        }

        void setTimeIndex(int i) {
            if (i != this.timeIndex) {
                this.timeIndex = i;
                if (this._type == 5) {
                    this.generatePattern();
                }
            }
        }

        int getFractionIndex() {
            return this.fractionIndex;
        }

        void setFractionIndex(int i) {
            if (i != this.fractionIndex) {
                this.fractionIndex = i;
                if (this._type == 7) {
                    this.generatePattern();
                }
            }
        }

        int getSpecialIndex() {
            return this.specialIndex;
        }

        void setSpecialIndex(int i) {
            if (i != this.specialIndex) {
                this.specialIndex = i;
                if (this._type == 10) {
                    this.generatePattern();
                }
            }
        }

        DataModel(String pattern) {
            this.initDefaults();
            this.applyPattern(pattern);
        }

        DataModel() {
            this.initDefaults();
        }

        String getPattern() {
            return this._pattern;
        }

        void setRelatedSA(StyleAttributes sa) {
            this._sa = sa;
        }

        private void setPattern(String pattern) {
            this._pattern = pattern;
            if (this._sa != null) {
                Object old = this._sa.get(ShareStyleAttributes.NUMBER_FORMAT);
                this._sa.setNumberFormat(this._pattern);
                if (old instanceof String && StringUtil.isEmptyString((String)((String)old)) && this._pattern.equalsIgnoreCase(generalPattern)) {
                    this._sa.clearDirtyFlag(ShareStyleAttributes.NUMBER_FORMAT);
                }
            }
        }

        void applyPattern(String pattern) {
            if (StringUtil.isEmptyString((String)pattern)) {
                pattern = generalPattern;
            }
            this._zeroStr = "";
            pattern = pattern.toLowerCase(Locale.ENGLISH);
            this.setPattern(pattern);
            if (this.initAsGeneral(pattern)) {
                return;
            }
            if (this.initAsNumber(pattern)) {
                return;
            }
            if (this.initAsCurrency(pattern)) {
                return;
            }
            if (this.initAsAccount(pattern)) {
                return;
            }
            if (this.initAsDate(pattern)) {
                return;
            }
            if (this.initAsTime(pattern)) {
                return;
            }
            if (this.initAsPercent(pattern)) {
                return;
            }
            if (this.initAsFraction(pattern)) {
                return;
            }
            if (this.initAsScience(pattern)) {
                return;
            }
            if (this.initAsText(pattern)) {
                return;
            }
            if (this.initAsSpecial(pattern)) {
                return;
            }
            if (this.initAsCustom(pattern)) {
                return;
            }
        }

        private boolean initAsGeneral(String pattern) {
            if (generalPattern.equalsIgnoreCase(pattern)) {
                this._type = 0;
                return true;
            }
            return false;
        }

        private boolean initAsNumber(String pattern) {
            String[] strs = pattern.split(";");
            if (strs.length > 3 || strs.length < 2) {
                return false;
            }
            if (strs.length == 3) {
                this._zeroStr = strs[2];
            }
            pattern = strs[0] + ';' + strs[1];
            for (int i = numRegs.length - 1; i >= 0; --i) {
                boolean b1 = pattern.matches(numRegs[i]);
                boolean b2 = pattern.matches(groupNumRegs[i]);
                if (!b1 && !b2) continue;
                int t1 = pattern.indexOf(46);
                int t2 = pattern.indexOf(59);
                int t3 = pattern.lastIndexOf(46);
                int t4 = pattern.lastIndexOf(48);
                if (t1 == t3 && t1 >= 0) {
                    return false;
                }
                if (t1 == -1) {
                    this.negativeIndex = i;
                    this.decNums = 0;
                    this.hasGroupSep = b2;
                    this._type = 1;
                    return true;
                }
                if (t2 - t1 - 1 != t4 - t3) {
                    return false;
                }
                this.negativeIndex = i;
                this.decNums = t4 - t3;
                this.hasGroupSep = b2;
                this._type = 1;
                return true;
            }
            return false;
        }

        private boolean initAsCurrency(String pattern) {
            String[] strs = pattern.split(";");
            if (strs.length > 4 || strs.length < 2) {
                return false;
            }
            if (strs.length == 3) {
                this._zeroStr = strs[2];
            }
            pattern = strs[0] + ';' + strs[1];
            for (int i = currencyRegs.length - 1; i >= 0; --i) {
                if (!pattern.matches(currencyRegs[i])) continue;
                int t1 = pattern.indexOf(46);
                int t2 = pattern.indexOf(59);
                int t3 = pattern.lastIndexOf(46);
                int t4 = pattern.lastIndexOf(48);
                if (t1 == t3 && t1 >= 0) {
                    return false;
                }
                if (t1 == -1) {
                    this.negativeIndex = i;
                    this.decNums = 0;
                    this._type = 1;
                    return true;
                }
                if (t2 - t1 - 1 != t4 - t3) {
                    return false;
                }
                int t5 = pattern.indexOf(35);
                String currSymbol = pattern.substring(0, t5);
                if (pattern.lastIndexOf(currSymbol) == 0) {
                    return false;
                }
                this.negativeIndex = i;
                this.decNums = t4 - t3;
                this.currencyIndex = this.getCurrencyIndex(currSymbol);
                this._type = 2;
                return true;
            }
            return false;
        }

        private boolean initAsAccount(String pattern) {
            if (pattern.matches(accountReg)) {
                int dec2;
                int t1 = pattern.indexOf(46);
                int t2 = pattern.indexOf(59);
                int t3 = pattern.indexOf(46, t2 + 1);
                int t4 = pattern.indexOf(59, t2 + 1);
                int dec1 = t1 == -1 || t1 > t2 ? 0 : t2 - t1 - 1;
                if (dec1 != (dec2 = t3 == -1 || t3 > t4 ? 0 : t4 - t3 - 1)) {
                    return false;
                }
                int t7 = pattern.indexOf(42);
                int t8 = pattern.indexOf(42, t7 + 1);
                int t9 = pattern.indexOf(42, t8 + 1);
                String c1 = pattern.substring(0, t7);
                String c2 = pattern.substring(t2 + 1, t8);
                String c3 = pattern.substring(t4 + 1, t9);
                if (!c1.equalsIgnoreCase(c2) || !c1.equalsIgnoreCase(c3)) {
                    return false;
                }
                this._type = 3;
                this.decNums = dec1;
                this.currencyIndex = this.getCurrencyIndex(c1);
                return true;
            }
            return false;
        }

        private int getCurrencyIndex(String symbol) {
            for (int i = currencySymbols.length - 1; i >= 0; --i) {
                if (!currencySymbols[i].equalsIgnoreCase(symbol)) continue;
                return i;
            }
            return -1;
        }

        private boolean initAsDate(String pattern) {
            for (int i = datePatterns.length - 1; i >= 0; --i) {
                if (!datePatterns[i].equalsIgnoreCase(pattern)) continue;
                this.dateIndex = i;
                this._type = 4;
                return true;
            }
            return false;
        }

        private boolean initAsTime(String pattern) {
            for (int i = timePatterns.length - 1; i >= 0; --i) {
                if (!timePatterns[i].equalsIgnoreCase(pattern)) continue;
                this.timeIndex = i;
                this._type = 5;
                return true;
            }
            return false;
        }

        private boolean initAsPercent(String pattern) {
            if (pattern.matches(percentReg)) {
                this._type = 6;
                this.decNums = pattern.length() == 2 ? 0 : pattern.length() - 3;
                return true;
            }
            return false;
        }

        private boolean initAsFraction(String pattern) {
            for (int i = fractionPatterns.length - 1; i >= 0; --i) {
                if (!fractionPatterns[i].equalsIgnoreCase(pattern)) continue;
                this.fractionIndex = i;
                this._type = 7;
                return true;
            }
            return false;
        }

        private boolean initAsScience(String pattern) {
            if (pattern.matches(scienceReg)) {
                this._type = 8;
                this.decNums = pattern.length() == 4 ? 0 : pattern.length() - 5;
                return true;
            }
            return false;
        }

        private boolean initAsText(String pattern) {
            if (textPattern.equals(pattern)) {
                this._type = 9;
                return true;
            }
            return false;
        }

        private boolean initAsSpecial(String pattern) {
            for (int i = specialPatterns.length - 1; i >= 0; --i) {
                if (!specialPatterns[i].equalsIgnoreCase(pattern)) continue;
                this.specialIndex = i;
                this._type = 10;
                return true;
            }
            return false;
        }

        private boolean initAsCustom(String pattern) {
            this._type = 11;
            return true;
        }

        private void initDefaults() {
            this.setPattern(generalPattern);
            this._type = 0;
            this.decNums = 2;
            this.currencyIndex = 0;
            this.hasGroupSep = false;
            this.negativeIndex = 3;
            this.dateIndex = 0;
            this.timeIndex = 0;
            this.fractionIndex = 0;
            this.specialIndex = 0;
        }

        private void generatePattern() {
            switch (this._type) {
                case 0: {
                    this.setPattern(this.toGeneralPattern());
                    break;
                }
                case 1: {
                    this.setPattern(this.toNumberPattern());
                    break;
                }
                case 2: {
                    this.setPattern(this.toCurrencyPattern());
                    break;
                }
                case 3: {
                    this.setPattern(this.toAccountPattern());
                    break;
                }
                case 4: {
                    this.setPattern(this.toDatePattern());
                    break;
                }
                case 5: {
                    this.setPattern(this.toTimePattern());
                    break;
                }
                case 6: {
                    this.setPattern(this.toPercentPattern());
                    break;
                }
                case 7: {
                    this.setPattern(this.toFractionPattern());
                    break;
                }
                case 8: {
                    this.setPattern(this.toSciencePattern());
                    break;
                }
                case 9: {
                    this.setPattern(this.toTextPattern());
                    break;
                }
                case 10: {
                    this.setPattern(this.toSpecialPattern());
                    break;
                }
                case 11: {
                    break;
                }
                default: {
                    this.setPattern(generalPattern);
                }
            }
        }

        private boolean hasNegativeSign() {
            return this.negativeIndex >= 3;
        }

        private boolean hasBracket() {
            return this.negativeIndex <= 1;
        }

        private boolean isRed() {
            return this.negativeIndex % 2 == 0;
        }

        private String toNumberPattern() {
            StringBuffer sb = new StringBuffer();
            if (this.hasGroupSep) {
                sb.append("#,##");
            }
            sb.append('0');
            if (this.decNums > 0) {
                sb.append('.');
            }
            for (int i = this.decNums - 1; i >= 0; --i) {
                sb.append('0');
            }
            StringBuffer sb2 = new StringBuffer();
            if (this.isRed()) {
                sb2.append("[Red]");
            }
            if (this.hasNegativeSign()) {
                sb2.append('-');
            }
            if (this.hasBracket()) {
                sb2.append('(');
            }
            sb2.append(sb);
            if (this.hasBracket()) {
                sb2.append(')');
            }
            sb.append(';');
            sb.append(sb2);
            if (!StringUtil.isEmptyString((String)this._zeroStr)) {
                sb.append(';');
                sb.append(this._zeroStr);
            }
            return sb.toString();
        }

        private String toCurrencyPattern() {
            boolean oldHasGS = this.hasGroupSep;
            this.hasGroupSep = true;
            String str = this.toNumberPattern();
            String symbol = currencySymbols[this.currencyIndex];
            StringBuilder sb = new StringBuilder();
            sb.append(symbol);
            sb.append(str);
            if (this.hasNegativeSign()) {
                sb.insert(sb.indexOf("-#"), symbol);
            } else {
                sb.insert(sb.lastIndexOf("#,"), symbol);
            }
            this.hasGroupSep = oldHasGS;
            return sb.toString();
        }

        private String toSpecialPattern() {
            return specialPatterns[this.specialIndex];
        }

        private String toTextPattern() {
            return textPattern;
        }

        private String toSciencePattern() {
            StringBuilder sb = new StringBuilder();
            sb.append('0');
            if (this.decNums > 0) {
                sb.append('.');
            }
            for (int i = this.decNums - 1; i >= 0; --i) {
                sb.append('0');
            }
            sb.append("E00");
            return sb.toString();
        }

        private String toFractionPattern() {
            return fractionPatterns[this.fractionIndex];
        }

        private String toPercentPattern() {
            StringBuilder sb = new StringBuilder();
            sb.append('0');
            if (this.decNums > 0) {
                sb.append('.');
            }
            for (int i = this.decNums - 1; i >= 0; --i) {
                sb.append('0');
            }
            sb.append('%');
            return sb.toString();
        }

        private String toAccountPattern() {
            String symbol = currencySymbols[this.currencyIndex];
            StringBuffer sb = new StringBuffer();
            sb.append(symbol);
            sb.append("* #,##0");
            if (this.decNums > 0) {
                sb.append('.');
            }
            for (int i = this.decNums - 1; i >= 0; --i) {
                sb.append('0');
            }
            sb.append(';');
            StringBuffer sb2 = new StringBuffer();
            sb2.append(sb);
            sb2.insert(symbol.length() + 2, '-');
            sb.append(sb2);
            sb.append(symbol);
            sb.append("* -");
            sb.append(';');
            sb.append('@');
            return sb.toString();
        }

        private String toGeneralPattern() {
            return generalPattern;
        }

        private String toDatePattern() {
            return datePatterns[this.dateIndex];
        }

        private String toTimePattern() {
            return timePatterns[this.timeIndex];
        }

        public static boolean isSpecialFormat(String format) {
            for (int i = specialPatterns.length - 1; i >= 0; --i) {
                if (!specialPatterns[i].equalsIgnoreCase(format)) continue;
                return true;
            }
            return false;
        }

        static {
            cardTypes = new String[]{"general", "number", "number", "number", "date", "time", "number", "fraction", "number", "text", "special", "custom"};
            currencySymbols = new String[]{" ", "\uffe5", "$", "\"US$\"", "\u20ac", "\u00a3"};
            currencyTexts = new String[]{" ", "\uffe5", "$", "US$", "\u20ac", "\u00a3"};
            StringBuilder sb = new StringBuilder();
            groupSepPattern = "#,##";
            numberReg = "(0|0(.0){1}[0]*){1}";
            redPattern = "\\[red\\]";
            redPattern1 = "\\[" + CtrlCommonUIMessages.getMLS("red", "\u7ea2\u8272") + "\\]";
            generalPattern = CtrlCommonUIMessages.getMLS("gCommonFormat", "G/\u901a\u7528\u683c\u5f0f");
            numRegs = new String[8];
            sb.delete(0, sb.length());
            sb.append(numberReg);
            sb.append(';');
            sb.append(redPattern);
            sb.append('\\');
            sb.append('(');
            sb.append(numberReg);
            sb.append('\\');
            sb.append(')');
            DataModel.numRegs[0] = sb.toString();
            sb.delete(0, sb.length());
            sb.append(numberReg);
            sb.append(';');
            sb.append(redPattern1);
            sb.append('\\');
            sb.append('(');
            sb.append(numberReg);
            sb.append('\\');
            sb.append(')');
            DataModel.numRegs[6] = sb.toString();
            sb.delete(0, sb.length());
            sb.append(numberReg);
            sb.append(';');
            sb.append('\\');
            sb.append('(');
            sb.append(numberReg);
            sb.append('\\');
            sb.append(')');
            DataModel.numRegs[1] = sb.toString();
            sb.delete(0, sb.length());
            sb.append(numberReg);
            sb.append(';');
            sb.append(redPattern);
            sb.append(numberReg);
            DataModel.numRegs[2] = sb.toString();
            sb.delete(0, sb.length());
            sb.append(numberReg);
            sb.append(';');
            sb.append(redPattern1);
            sb.append(numberReg);
            DataModel.numRegs[7] = sb.toString();
            sb.delete(0, sb.length());
            sb.append(numberReg);
            sb.append(';');
            sb.append('-');
            sb.append(numberReg);
            DataModel.numRegs[3] = sb.toString();
            sb.delete(0, sb.length());
            sb.append(numberReg);
            sb.append(';');
            sb.append(redPattern);
            sb.append('-');
            sb.append(numberReg);
            DataModel.numRegs[4] = sb.toString();
            sb.delete(0, sb.length());
            sb.append(numberReg);
            sb.append(';');
            sb.append(redPattern1);
            sb.append('-');
            sb.append(numberReg);
            DataModel.numRegs[5] = sb.toString();
            groupNumRegs = new String[8];
            sb.delete(0, sb.length());
            sb.append(groupSepPattern);
            sb.append(numberReg);
            sb.append(';');
            sb.append(redPattern);
            sb.append('\\');
            sb.append('(');
            sb.append(groupSepPattern);
            sb.append(numberReg);
            sb.append('\\');
            sb.append(')');
            DataModel.groupNumRegs[0] = sb.toString();
            sb.delete(0, sb.length());
            sb.append(groupSepPattern);
            sb.append(numberReg);
            sb.append(';');
            sb.append(redPattern1);
            sb.append('\\');
            sb.append('(');
            sb.append(groupSepPattern);
            sb.append(numberReg);
            sb.append('\\');
            sb.append(')');
            DataModel.groupNumRegs[6] = sb.toString();
            sb.delete(0, sb.length());
            sb.append(groupSepPattern);
            sb.append(numberReg);
            sb.append(';');
            sb.append('\\');
            sb.append('(');
            sb.append(groupSepPattern);
            sb.append(numberReg);
            sb.append('\\');
            sb.append(')');
            DataModel.groupNumRegs[1] = sb.toString();
            sb.delete(0, sb.length());
            sb.append(groupSepPattern);
            sb.append(numberReg);
            sb.append(';');
            sb.append(redPattern);
            sb.append(groupSepPattern);
            sb.append(numberReg);
            DataModel.groupNumRegs[2] = sb.toString();
            sb.delete(0, sb.length());
            sb.append(groupSepPattern);
            sb.append(numberReg);
            sb.append(';');
            sb.append(redPattern1);
            sb.append(groupSepPattern);
            sb.append(numberReg);
            DataModel.groupNumRegs[7] = sb.toString();
            sb.delete(0, sb.length());
            sb.append(groupSepPattern);
            sb.append(numberReg);
            sb.append(';');
            sb.append('-');
            sb.append(groupSepPattern);
            sb.append(numberReg);
            DataModel.groupNumRegs[3] = sb.toString();
            sb.delete(0, sb.length());
            sb.append(groupSepPattern);
            sb.append(numberReg);
            sb.append(';');
            sb.append(redPattern);
            sb.append('-');
            sb.append(groupSepPattern);
            sb.append(numberReg);
            DataModel.groupNumRegs[4] = sb.toString();
            sb.delete(0, sb.length());
            sb.append(groupSepPattern);
            sb.append(numberReg);
            sb.append(';');
            sb.append(redPattern1);
            sb.append('-');
            sb.append(groupSepPattern);
            sb.append(numberReg);
            DataModel.groupNumRegs[5] = sb.toString();
            currencyRegs = new String[6];
            String[] regSymbols = new String[]{" ", "\uffe5", "\\$", "\"us\\$\"", "\u20ac", "\u00a3"};
            sb = new StringBuilder();
            sb.append('(');
            for (int i = 5; i >= 1; --i) {
                sb.append(regSymbols[i]);
                sb.append('|');
            }
            sb.append(regSymbols[0]);
            sb.append(')');
            sb.append('{');
            sb.append('1');
            sb.append('}');
            String currencySymbReg = sb.toString();
            sb = new StringBuilder(groupNumRegs[0]);
            sb.insert(sb.indexOf("(#") + 1, currencySymbReg);
            sb.insert(0, currencySymbReg);
            DataModel.currencyRegs[0] = sb.toString();
            sb = new StringBuilder(groupNumRegs[1]);
            sb.insert(sb.indexOf("(#") + 1, currencySymbReg);
            sb.insert(0, currencySymbReg);
            DataModel.currencyRegs[1] = sb.toString();
            sb = new StringBuilder(groupNumRegs[2]);
            sb.insert(sb.indexOf("]#") + 1, currencySymbReg);
            sb.insert(0, currencySymbReg);
            DataModel.currencyRegs[2] = sb.toString();
            sb = new StringBuilder(groupNumRegs[3]);
            sb.insert(sb.indexOf(";") + 1, currencySymbReg);
            sb.insert(0, currencySymbReg);
            DataModel.currencyRegs[3] = sb.toString();
            sb = new StringBuilder(groupNumRegs[4]);
            sb.insert(sb.indexOf(";") + 1, currencySymbReg);
            sb.insert(0, currencySymbReg);
            DataModel.currencyRegs[4] = sb.toString();
            sb = new StringBuilder(groupNumRegs[5]);
            sb.insert(sb.indexOf(";") + 1, currencySymbReg);
            sb.insert(0, currencySymbReg);
            DataModel.currencyRegs[5] = sb.toString();
            sb = new StringBuilder();
            sb.append(currencySymbReg).append('\\').append('*').append('[').append('\\').append('s').append(']').append('?').append(groupSepPattern).append(numberReg).append(';');
            sb.append(currencySymbReg).append('\\').append('*').append('[').append('\\').append('s').append(']').append('?').append('-').append(groupSepPattern).append(numberReg).append(';');
            sb.append(currencySymbReg).append('\\').append('*').append('[').append('\\').append('s').append('-').append(']').append('+').append(';');
            sb.append('@');
            accountReg = sb.toString();
            datePatterns = QingConstellationUntrans.DATA_PATTERN;
            dateTexts = QingConstellationUntrans.DATA_TEXTS;
            timePatterns = QingConstellationUntrans.TIME_PATTERNS;
            timeTexts = QingConstellationUntrans.TIME_TEXTS;
            percentReg = numberReg + "%";
            fractionPatterns = new String[]{"?/?", "??/??", "???/???", "?/2", "?/4", "?/8", "??/16", "?/10", "??/100"};
            fractionTexts = new String[]{DataModel.getMLS("fractionOne", "\u5206\u6bcd\u4e3a\u4e00\u4f4d\u65701/4"), DataModel.getMLS("fractionTwo", "\u5206\u6bcd\u4e3a\u4e24\u4f4d\u657021/25"), DataModel.getMLS("fractionTree", "\u5206\u6bcd\u4e3a\u4e09\u4f4d\u6570312/943"), DataModel.getMLS("fractionFour", "\u4ee52\u4e3a\u5206\u6bcd1/2"), DataModel.getMLS("fractionFive", "\u4ee54\u4e3a\u5206\u6bcd2/4"), DataModel.getMLS("fractionSix", "\u4ee58\u4e3a\u5206\u6bcd4/8"), DataModel.getMLS("fractionSeven", "\u4ee516\u4e3a\u5206\u6bcd8/16"), DataModel.getMLS("fractionEight", "\u4ee510\u4e3a\u5206\u6bcd3/10"), DataModel.getMLS("fractionNine", "\u767e\u5206\u4e4b\u51e030/100")};
            scienceReg = numberReg + "e00";
            textPattern = "@";
            specialPatterns = new String[]{"000000", CtrlCommonUIMessages.getMLS("dbNum1Format", "[DBNum1]G/\u901a\u7528\u683c\u5f0f"), CtrlCommonUIMessages.getMLS("dbNum2Format", "[DBNum2]G/\u901a\u7528\u683c\u5f0f"), "[Dollar]0.00;[Dollar](" + CtrlCommonUIMessages.getMLS("negative", "\u8d1f\u6570") + ")0.00", "[Eur]0.00;[Eur](" + CtrlCommonUIMessages.getMLS("negative", "\u8d1f\u6570") + ")0.00", "[Rmb]0.00;[Rmb](" + CtrlCommonUIMessages.getMLS("negative", "\u8d1f\u6570") + ")0.00"};
            specialTexts = new String[]{DataModel.getMLS("postalcode", "\u90ae\u653f\u7f16\u7801"), DataModel.getMLS("ChineseLowercase", "\u4e2d\u6587\u5c0f\u5199\u6570\u5b57"), DataModel.getMLS("ChineseUppercase", "\u4e2d\u6587\u5927\u5199\u6570\u5b57"), DataModel.getMLS("ChineseUSDStyle", "\u4e2d\u6587\u7f8e\u5143\u6837\u5f0f"), DataModel.getMLS("ChineseEURStyle", "\u4e2d\u6587\u6b27\u5143\u6837\u5f0f"), DataModel.getMLS("ChineseRMBStyle", "\u4e2d\u6587\u4eba\u6c11\u5e01\u6837\u5f0f")};
        }
    }

    private class ActionHandler
    implements ListSelectionListener,
    ChangeListener,
    ActionListener,
    FocusListener,
    DocumentListener {
        private boolean sync = false;

        private ActionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Object o = e.getSource();
            if (o == DigitFormatPane.this.typeList) {
                int type = DigitFormatPane.this.typeList.getSelectedIndex();
                DigitFormatPane.this.model.setType(type);
                if (type == -1) {
                    DigitFormatPane.this.cardLayout.show((Container)DigitFormatPane.this.paneCard, DataModel.cardTypes[0]);
                    return;
                }
                DigitFormatPane.this.cardLayout.show((Container)DigitFormatPane.this.paneCard, DataModel.cardTypes[type]);
                DigitFormatPane.this.groupSepCheck.setVisible(false);
                DigitFormatPane.this.currencyComb.getParent().setVisible(false);
                DigitFormatPane.this.negativeLBC.setVisible(false);
                DigitFormatPane.this._zeroLBC.setVisible(false);
                if (type == 1) {
                    int i = DigitFormatPane.this.model.getNegativeIndex();
                    DigitFormatPane.this.initNegativeList(DigitFormatPane.this.model.getDecNums(), DigitFormatPane.this.model.hasGroupSep());
                    DigitFormatPane.this.negativeList.setSelectedIndex(i);
                    DigitFormatPane.this.groupSepCheck.setVisible(true);
                    DigitFormatPane.this.negativeLBC.setVisible(true);
                    DigitFormatPane.this._zeroLBC.setVisible(true);
                } else if (type == 2) {
                    int i = DigitFormatPane.this.model.getNegativeIndex();
                    DigitFormatPane.this.initNegativeList(DigitFormatPane.this.model.getDecNums(), true);
                    DigitFormatPane.this.negativeList.setSelectedIndex(i);
                    DigitFormatPane.this.currencyComb.getParent().setVisible(true);
                    DigitFormatPane.this.negativeLBC.setVisible(true);
                    DigitFormatPane.this._zeroLBC.setVisible(true);
                } else if (type == 3) {
                    DigitFormatPane.this.currencyComb.getParent().setVisible(true);
                } else if (type == 11) {
                    DigitFormatPane.this.customText.setText(DigitFormatPane.this.model.getPattern());
                }
            } else if (o == DigitFormatPane.this.fractionList) {
                DigitFormatPane.this.model.setFractionIndex(DigitFormatPane.this.fractionList.getSelectedIndex());
            } else if (o == DigitFormatPane.this.dateList) {
                DigitFormatPane.this.model.setDateIndex(DigitFormatPane.this.dateList.getSelectedIndex());
            } else if (o == DigitFormatPane.this.timeList) {
                DigitFormatPane.this.model.setTimeIndex(DigitFormatPane.this.timeList.getSelectedIndex());
            } else if (o == DigitFormatPane.this.specialList) {
                DigitFormatPane.this.model.setSpecialIndex(DigitFormatPane.this.specialList.getSelectedIndex());
            } else if (o == DigitFormatPane.this.negativeList && !this.sync) {
                DigitFormatPane.this.model.setNegativeIndex(DigitFormatPane.this.negativeList.getSelectedIndex());
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource() == DigitFormatPane.this.decimalSpn) {
                this.sync = true;
                int dec = Integer.parseInt(DigitFormatPane.this.decimalSpn.getValue().toString());
                DigitFormatPane.this.model.setDecNums(dec);
                int i = DigitFormatPane.this.negativeList.getSelectedIndex();
                DigitFormatPane.this.initNegativeList(DigitFormatPane.this.model.getDecNums(), DigitFormatPane.this.typeList.getSelectedIndex() == 2 ? true : DigitFormatPane.this.model.hasGroupSep());
                DigitFormatPane.this.negativeList.setSelectedIndex(i);
                this.sync = false;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o = e.getSource();
            if (o == DigitFormatPane.this.groupSepCheck) {
                this.sync = true;
                DigitFormatPane.this.model.setHasGroupSep(DigitFormatPane.this.groupSepCheck.isSelected());
                int i = DigitFormatPane.this.negativeList.getSelectedIndex();
                DigitFormatPane.this.initNegativeList(DigitFormatPane.this.model.getDecNums(), DigitFormatPane.this.model.hasGroupSep());
                DigitFormatPane.this.negativeList.setSelectedIndex(i);
                this.sync = false;
            } else if (o == DigitFormatPane.this.currencyComb) {
                DigitFormatPane.this.model.setCurrencyIndex(DigitFormatPane.this.currencyComb.getSelectedIndex());
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            Object o = e.getSource();
            if (o == DigitFormatPane.this.customText && !DigitFormatPane.this.model.getPattern().equalsIgnoreCase(DigitFormatPane.this.customText.getText())) {
                DigitFormatPane.this._sa.setNumberFormat(DigitFormatPane.this.customText.getText());
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            DigitFormatPane.this.model.setZeroString(DigitFormatPane.this.addQuote(DigitFormatPane.this._zeroField.getText()));
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            DigitFormatPane.this.model.setZeroString(DigitFormatPane.this.addQuote(DigitFormatPane.this._zeroField.getText()));
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            DigitFormatPane.this.model.setZeroString(DigitFormatPane.this.addQuote(DigitFormatPane.this._zeroField.getText()));
        }
    }
}

