/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.GlobalLocator;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.util.render.TextRender;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.StyleDesignerUtil;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.packing.IStylePane;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDComboColor;
import com.kingdee.cosmic.ctrl.swing.KDFontChooser;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.event.FontChangeEvent;
import com.kingdee.cosmic.ctrl.swing.event.FontChangeListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class FontPane
extends KDPanel
implements IStylePane {
    private static final Logger logger = LogUtil.getPackageLogger(FontPane.class);
    private static final long serialVersionUID = 1586696141557569830L;
    private StyleAttributes sa;
    KDLabelContainer lbcColor;
    private KDFontChooser ftcFont = new KDFontChooser();
    private KDComboColor cbcFontColor = new KDComboColor(1, true);
    private KDCheckBox chkStrikethrought = new KDCheckBox();
    private KDCheckBox chkUnderline = new KDCheckBox();
    private PreviewPanel panPreview = new PreviewPanel();
    private boolean flagIsShowValueFireMe;

    public FontPane() {
        this.initCompoments();
        this.installCompoments();
        this.installListener();
        this.addUsedColorPersistence(this.cbcFontColor);
    }

    @Override
    public void setSA(StyleAttributes sa) {
        this.flagIsShowValueFireMe = true;
        this.sa = sa;
        this.syncStyle4Paint();
        this.showValue();
        this.flagIsShowValueFireMe = false;
    }

    public void setEnableUnderline(boolean b) {
        this.chkUnderline.setEnabled(b);
    }

    public void setEnableStrikethrought(boolean b) {
        this.chkStrikethrought.setEnabled(b);
    }

    private void syncStyle4Paint() {
        StyleAttributes saTo = StyleDesignerUtil.getSa4Paint();
        StyleDesignerUtil.copyAttr(this.sa, saTo, StyleAttributes.FONT_NAME);
        StyleDesignerUtil.copyAttr(this.sa, saTo, StyleAttributes.FONT_ITALIC);
        StyleDesignerUtil.copyAttr(this.sa, saTo, StyleAttributes.FONT_BOLD);
        StyleDesignerUtil.copyAttr(this.sa, saTo, StyleAttributes.FONT_UNDERLINE);
        StyleDesignerUtil.copyAttr(this.sa, saTo, StyleAttributes.FONT_SIZE);
        StyleDesignerUtil.copyAttr(this.sa, saTo, StyleAttributes.FONT_WEIGHT);
        StyleDesignerUtil.copyAttr(this.sa, saTo, StyleAttributes.FONT_STRIKETHROUGH);
        StyleDesignerUtil.copyAttr(this.sa, saTo, StyleAttributes.FONT_COLOR);
        StyleDesignerUtil.refreshStyle4Paint();
    }

    private void initCompoments() {
        this.ftcFont.setViewType(2);
        this.chkStrikethrought.setSwitch(false);
        this.chkUnderline.setSwitch(false);
    }

    private void installCompoments() {
        this.lbcColor = new KDLabelContainer((JComponent)this.cbcFontColor);
        this.lbcColor.setBoundLabelText(this.getMLS("color", "\u989c\u8272"));
        this.lbcColor.setBoundLabelAlignment(8);
        this.chkStrikethrought.setText(this.getMLS("strikethrough", "\u5220\u9664\u7ebf"));
        this.chkUnderline.setText(this.getMLS("underline", "\u4e0b\u5212\u7ebf"));
        KDPanel panPreviewTitle = new KDPanel(null);
        panPreviewTitle.setBorder((Border)new TitledBorder(BorderFactory.createEtchedBorder(), this.getMLS("titlePreview", CtrlCommonUIMessages.getMLS("titlePreview", "\u9884\u89c8"))));
        panPreviewTitle.setOpaque(false);
        panPreviewTitle.add((Component)((Object)this.panPreview));
        this.panPreview.setOpaque(true);
        this.panPreview.setBackground(Color.WHITE);
        this.panPreview.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        KDPanel panSpecial = new KDPanel(null);
        panSpecial.setBorder((Border)new TitledBorder(BorderFactory.createEtchedBorder(), this.getMLS("titleSpecial", CtrlCommonUIMessages.getMLS("titleSpecial", "\u7279\u6b8a\u6548\u679c"))));
        panSpecial.setOpaque(false);
        panSpecial.add((Component)this.chkStrikethrought);
        panSpecial.add((Component)this.chkUnderline);
        this.chkStrikethrought.setBounds(10, 25, 100, 20);
        this.chkUnderline.setBounds(10, 50, 100, 20);
        this.add((Component)this.ftcFont);
        this.add((Component)this.lbcColor);
        this.add((Component)panSpecial);
        this.add((Component)panPreviewTitle);
        this.setLayout(null);
        int fcHeight = this.ftcFont.getPreferredSize().height;
        int fcWidth = this.ftcFont.getPreferredSize().width;
        this.ftcFont.setBounds(8, 8, fcWidth, fcHeight);
        int y = fcHeight + 11;
        this.lbcColor.setBoundLabelLength(19);
        this.lbcColor.setBounds(10, y, 120, 40);
        panSpecial.setBounds(10, y + 50, 120, 80);
        panPreviewTitle.setBounds(140, y + 10, 305, 120);
        int tempX = 10;
        int tempY = 20;
        int tempW = panPreviewTitle.getWidth() - 20;
        int tempH = panPreviewTitle.getHeight() - 30;
        this.panPreview.setBounds(tempX, tempY, tempW, tempH);
    }

    public Dimension getPreferredSize() {
        return new Dimension(454, 292);
    }

    private void installListener() {
        ActionHandler actionHandler = new ActionHandler();
        this.chkStrikethrought.addActionListener((ActionListener)actionHandler);
        this.chkUnderline.addActionListener((ActionListener)actionHandler);
        ChangeHandler changeHandler = new ChangeHandler();
        this.ftcFont.getSelectionModel().addChangeListener((FontChangeListener)changeHandler);
        this.cbcFontColor.getSelectionModel().addChangeListener(changeHandler);
    }

    private void addUsedColorPersistence(KDComboColor cbc) {
        cbc.addUsedColorPersistence(new KDComboColor.IUsedColorPersistence(){

            public void save(LinkedList<Color> usedColorList) {
                IXmlElement root = XmlUtil.createNode((String)"UsedColors");
                IXmlElement UsedColor = XmlUtil.createNode((String)"UsedColor");
                StringBuilder colorsStr = new StringBuilder();
                for (Color color : usedColorList) {
                    colorsStr.append(color.getRGB()).append(",");
                }
                UsedColor.addCData(colorsStr.toString());
                root.addChild(UsedColor);
                String filePth = GlobalLocator.getInstance().getHomeDir() + "\\UsedColor.xml";
                try {
                    XmlUtil.saveFile((IXmlElement)root, (File)new File(FilenameUtils.normalize((String)filePth)));
                }
                catch (IOException e) {
                    logger.error((Object)"err", (Throwable)e);
                }
            }

            public LinkedList<Color> load() {
                String filePth = GlobalLocator.getInstance().getHomeDir() + File.separator + "UsedColor.xml";
                LinkedList<Color> usedColorList = new LinkedList<Color>();
                File f = new File(FilenameUtils.normalize((String)filePth));
                if (f.exists() && f.isFile()) {
                    try {
                        IXmlElement root = XmlUtil.loadRootElementFromFile((File)new File(FilenameUtils.normalize((String)filePth)));
                        if (root.getChild("UsedColor") != null && root.getChild("UsedColor").getText() != "") {
                            String colorStr = root.getChild("UsedColor").getText();
                            String[] color = colorStr.split(",");
                            for (int i = 0; i < color.length; ++i) {
                                if (!StringUtil.isNumber((String)color[i])) continue;
                                Color c = new Color(Integer.parseInt(color[i]));
                                usedColorList.add(c);
                            }
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)"err", (Throwable)e);
                    }
                    catch (XmlParsingException e) {
                        logger.error((Object)"err", (Throwable)e);
                    }
                }
                return usedColorList;
            }
        });
    }

    private void showValue() {
        String fontName = null;
        int fontSize = -1;
        int fontStyle = -1;
        if (!this.sa.isUnsureValue(StyleAttributes.FONT_NAME)) {
            fontName = this.sa.getFontName();
        }
        if (!this.sa.isUnsureValue(StyleAttributes.FONT_SIZE)) {
            fontSize = this.sa.getFontSize();
        }
        if (!this.sa.isUnsureValue(StyleAttributes.FONT_BOLD) && !this.sa.isUnsureValue(StyleAttributes.FONT_ITALIC)) {
            fontStyle = 0;
            if (this.sa.isBold()) {
                ++fontStyle;
            }
            if (this.sa.isItalic()) {
                fontStyle += 2;
            }
        }
        this.ftcFont.setSelectionFontWithUnsure(fontName, fontStyle, fontSize);
        if (this.sa.isUnsureValue(StyleAttributes.FONT_COLOR)) {
            this.cbcFontColor.setColor(null);
        } else {
            this.cbcFontColor.setColor(this.sa.getFontColor());
        }
        if (this.sa.isUnsureValue(StyleAttributes.FONT_STRIKETHROUGH)) {
            this.chkStrikethrought.setSelected(64);
        } else {
            this.chkStrikethrought.setSelected(this.sa.isStrikeThrough());
        }
        if (this.sa.isUnsureValue(StyleAttributes.FONT_UNDERLINE)) {
            this.chkUnderline.setSelected(64);
        } else {
            this.chkUnderline.setSelected(this.sa.isUnderline());
        }
    }

    private String getMLS(String key, String defaultValue) {
        return CtrlCommonUIMessages.getMLS(key, defaultValue);
    }

    private void repaintPreview() {
        StyleDesignerUtil.refreshStyle4Paint();
        this.panPreview.repaint();
    }

    public KDComboColor getCbcFontColor() {
        return this.cbcFontColor;
    }

    public KDLabelContainer getLbcFontColor() {
        return this.lbcColor;
    }

    private class PreviewPanel
    extends KDPanel {
        private static final long serialVersionUID = 1L;
        private TextRender tr;
        private Rectangle rect;

        public PreviewPanel() {
            this.tr = new TextRender(FontPane.this.getMLS("previewString", "\u8f7b\u62a5\u8868"), StyleDesignerUtil.getStyle4Paint());
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (FontPane.this.sa.isUnsureValue(StyleAttributes.FONT_COLOR) || FontPane.this.sa.isUnsureValue(StyleAttributes.FONT_STRIKETHROUGH) || FontPane.this.sa.isUnsureValue(StyleAttributes.FONT_UNDERLINE) || FontPane.this.sa.isUnsureValue(StyleAttributes.FONT_NAME) || FontPane.this.sa.isUnsureValue(StyleAttributes.FONT_SIZE) || FontPane.this.sa.isUnsureValue(StyleAttributes.FONT_BOLD) || FontPane.this.sa.isUnsureValue(StyleAttributes.FONT_ITALIC)) {
                return;
            }
            if (this.rect == null) {
                this.rect = new Rectangle(this.getWidth(), this.getHeight());
            }
            this.tr.setCellStyle(StyleDesignerUtil.getStyle4Paint());
            this.tr.draw(g, this.rect);
        }
    }

    private class ChangeHandler
    implements ChangeListener,
    FontChangeListener {
        private ChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (FontPane.this.flagIsShowValueFireMe) {
                return;
            }
            if (e.getSource().equals(FontPane.this.cbcFontColor.getSelectionModel()) && FontPane.this.cbcFontColor.getColor() != null) {
                FontPane.this.sa.setFontColor(FontPane.this.cbcFontColor.getColor());
                StyleDesignerUtil.getSa4Paint().setFontColor(FontPane.this.cbcFontColor.getColor());
                FontPane.this.repaintPreview();
            }
        }

        public void fontChanged(FontChangeEvent e) {
            if (FontPane.this.flagIsShowValueFireMe) {
                return;
            }
            if (e.getSource().equals(FontPane.this.ftcFont.getSelectionModel())) {
                if (e.isChange(FontChangeEvent.Name_Changed)) {
                    FontPane.this.sa.setFontName(FontPane.this.ftcFont.getFontFamily());
                    StyleDesignerUtil.getSa4Paint().setFontName(FontPane.this.ftcFont.getFontFamily());
                }
                if (e.isChange(FontChangeEvent.Size_Changed)) {
                    FontPane.this.sa.setFontSize(FontPane.this.ftcFont.getFontSize());
                    StyleDesignerUtil.getSa4Paint().setFontSize(FontPane.this.ftcFont.getFontSize());
                }
                if (e.isChange(FontChangeEvent.Style_Changed)) {
                    FontPane.this.sa.setBold(FontPane.this.ftcFont.isFontBold());
                    FontPane.this.sa.setItalic(FontPane.this.ftcFont.isFontItalic());
                    StyleDesignerUtil.getSa4Paint().setBold(FontPane.this.ftcFont.isFontBold());
                    StyleDesignerUtil.getSa4Paint().setItalic(FontPane.this.ftcFont.isFontItalic());
                }
                FontPane.this.repaintPreview();
            }
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FontPane.this.flagIsShowValueFireMe) {
                return;
            }
            Object source = e.getSource();
            if (source.equals(FontPane.this.chkStrikethrought)) {
                FontPane.this.sa.setStrikeThrough(FontPane.this.chkStrikethrought.isSelected());
                StyleDesignerUtil.getSa4Paint().setStrikeThrough(FontPane.this.chkStrikethrought.isSelected());
                FontPane.this.repaintPreview();
            } else if (source.equals(FontPane.this.chkUnderline)) {
                FontPane.this.sa.setUnderline(FontPane.this.chkUnderline.isSelected());
                StyleDesignerUtil.getSa4Paint().setUnderline(FontPane.this.chkUnderline.isSelected());
                FontPane.this.repaintPreview();
            }
        }
    }
}

