/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.res.tool.java.parser.visitor;

import com.kingdee.cosmic.ctrl.res.tool.java.parser.syntaxtree.NodeToken;
import com.kingdee.cosmic.ctrl.res.tool.java.parser.visitor.DepthFirstVisitor;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;

public class TreeDumper
extends DepthFirstVisitor {
    protected PrintWriter out;
    private int curLine = 1;
    private int curColumn = 1;
    private boolean startAtNextToken = false;
    private boolean printSpecials = true;

    public TreeDumper() {
        this.out = new PrintWriter(System.out, true);
    }

    public TreeDumper(Writer o) {
        this.out = new PrintWriter(o, true);
    }

    public TreeDumper(OutputStream o) {
        this.out = new PrintWriter(o, true);
    }

    public void flushWriter() {
        this.out.flush();
    }

    public void printSpecials(boolean b) {
        this.printSpecials = b;
    }

    public void startAtNextToken() {
        this.startAtNextToken = true;
    }

    public void resetPosition() {
        this.curColumn = 1;
        this.curLine = 1;
    }

    @Override
    public void visit(NodeToken n) {
        if (n.beginLine == -1 || n.beginColumn == -1) {
            this.printToken(n.tokenImage);
            return;
        }
        if (this.printSpecials && n.numSpecials() > 0) {
            Enumeration e = n.specialTokens.elements();
            while (e.hasMoreElements()) {
                this.visit((NodeToken)e.nextElement());
            }
        }
        if (this.startAtNextToken) {
            this.curLine = n.beginLine;
            this.curColumn = 1;
            this.startAtNextToken = false;
            if (n.beginColumn < this.curColumn) {
                this.out.println();
            }
        }
        if (n.beginLine < this.curLine) {
            throw new IllegalStateException("at token \"" + n.tokenImage + "\", n.beginLine = " + Integer.toString(n.beginLine) + ", curLine = " + Integer.toString(this.curLine));
        }
        if (n.beginLine == this.curLine && n.beginColumn < this.curColumn) {
            throw new IllegalStateException("at token \"" + n.tokenImage + "\", n.beginColumn = " + Integer.toString(n.beginColumn) + ", curColumn = " + Integer.toString(this.curColumn));
        }
        if (this.curLine < n.beginLine) {
            this.curColumn = 1;
            while (this.curLine < n.beginLine) {
                this.out.println();
                ++this.curLine;
            }
        }
        while (this.curColumn < n.beginColumn) {
            this.out.print(" ");
            ++this.curColumn;
        }
        this.printToken(n.tokenImage);
    }

    private void printToken(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\n') {
                ++this.curLine;
                this.curColumn = 1;
            } else {
                ++this.curColumn;
            }
            this.out.print(s.charAt(i));
        }
        this.out.flush();
    }
}

