/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.res.tool.java.stat;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.res.tool.java.stat.JavaFileBean;
import com.kingdee.cosmic.ctrl.res.tool.java.stat.JavaFileStatInfo;
import com.kingdee.cosmic.ctrl.res.tool.java.stat.visitor.PKClassVisitor;
import com.kingdee.cosmic.ctrl.res.tool.java.stat.visitor.SystemIOStatementVisitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class StatSystemIOFile
extends JPanel {
    private static final Logger log = LogUtil.getPackageLogger(StatSystemIOFile.class);
    private static final String CONFIG_FILE = "statIO.properties";
    private static final ThreadLocal<DateFormat> sdf = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm");
        }
    };
    private boolean scaning = false;
    private JTextArea txtOut = new JTextArea();
    private JButton btnStat = new JButton("StatIO");
    private JTextField txtpath = new JTextField(50);
    private Properties pros = new Properties();

    public StatSystemIOFile() {
        this.initUI();
    }

    private void initUI() {
        String scan_path;
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new FlowLayout(0, 5, 5));
        topPanel.add(new JLabel(CtrlCommonUIMessages.getMLS("sourcePathColon", "\u6e90\u7801\u8def\u5f84\uff1a")));
        topPanel.add(this.txtpath);
        topPanel.add(this.btnStat);
        this.add((Component)topPanel, "North");
        this.add((Component)new JScrollPane(this.txtOut), "Center");
        this.btnStat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        String path = StatSystemIOFile.this.txtpath.getText().trim();
                        if (path.length() > 0) {
                            FileOutputStream fos = null;
                            try {
                                StatSystemIOFile.this.scaning = true;
                                StatSystemIOFile.this.btnStat.setEnabled(false);
                                StatSystemIOFile.this.pros.setProperty("scan_path", path);
                                fos = new FileOutputStream(StatSystemIOFile.CONFIG_FILE);
                                StatSystemIOFile.this.pros.save(fos, null);
                                StatSystemIOFile.statIO(path);
                            }
                            catch (Exception e) {
                                e.printStackTrace(System.out);
                            }
                            finally {
                                if (fos != null) {
                                    try {
                                        fos.close();
                                    }
                                    catch (IOException e) {
                                        log.info((Object)"error", (Throwable)e);
                                    }
                                }
                                StatSystemIOFile.this.btnStat.setEnabled(true);
                                StatSystemIOFile.this.scaning = false;
                            }
                        }
                    }
                }.start();
            }
        });
        PrintStream ps = new PrintStream(new ByteArrayOutputStream(){

            @Override
            public synchronized void write(byte[] b, int off, int len) {
                if (StatSystemIOFile.this.txtOut.getLineCount() > 500 && StatSystemIOFile.this.scaning) {
                    try {
                        int offset = StatSystemIOFile.this.txtOut.getLineEndOffset(StatSystemIOFile.this.txtOut.getLineCount() / 2 - 1);
                        StatSystemIOFile.this.txtOut.setText(StatSystemIOFile.this.txtOut.getText().substring(offset));
                    }
                    catch (Exception e) {
                        StatSystemIOFile.this.txtOut.setText(null);
                    }
                }
                SwingUtilities.invokeLater(new PrintMsgRunnable(new String(b, off, len)));
            }
        });
        System.setOut(ps);
        System.setErr(ps);
        try (FileInputStream fis = new FileInputStream(CONFIG_FILE);){
            this.pros.load(fis);
            scan_path = this.pros.getProperty("scan_path", "W:\\workspace\\Ctrl-CommonUI\\src");
        }
        catch (Exception e) {
            scan_path = "W:\\workspace\\Ctrl-CommonUI\\src";
        }
        this.txtpath.setText(scan_path);
        this.txtOut.setEditable(false);
        this.txtOut.setText(CtrlCommonUIMessages.getMLS("sourceCodeStatistics", "\u7edf\u8ba1java\u6e90\u7801System.(out|err).print(ln)\u7684\u8f93\u51fa\uff0c\u5ffd\u7565main\u65b9\u6cd5\u90e8\u5206\u3002"));
    }

    public static void center(Window w) {
        Dimension dd = Toolkit.getDefaultToolkit().getScreenSize();
        w.setLocation((dd.width - w.getWidth()) / 2, (dd.height - w.getHeight()) / 2);
    }

    public static JFrame run(Component c, String title) {
        JFrame f = new JFrame();
        f.setTitle(title);
        f.getContentPane().setLayout(new BorderLayout());
        f.getContentPane().add(c, "Center");
        f.setSize(800, 600);
        StatSystemIOFile.center(f);
        f.setDefaultCloseOperation(2);
        f.setVisible(true);
        return f;
    }

    public static JavaFileStatInfo scan(String fileName) throws Exception {
        System.out.println("Scan... " + fileName);
        JavaFileBean jfb = new JavaFileBean(fileName);
        if (!jfb.withError()) {
            jfb.accept(new PKClassVisitor());
            jfb.accept(new SystemIOStatementVisitor(false, "SystemIOUtil.println($)"));
            jfb.finishAccept();
        }
        return jfb.getJavaFileStatInfo();
    }

    private static JavaFileStatInfo[] scanPath(String path) throws Exception {
        List list = StatSystemIOFile.getJavaFileNameList(path);
        int listSize = list.size();
        ArrayList<JavaFileStatInfo> infoList = new ArrayList<JavaFileStatInfo>(listSize);
        int n = listSize;
        for (int i = 0; i < n; ++i) {
            infoList.add(StatSystemIOFile.scan((String)list.get(i)));
        }
        JavaFileStatInfo[] infos = new JavaFileStatInfo[infoList.size()];
        infoList.toArray(infos);
        return infos;
    }

    private static List getJavaFileNameList(String path) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        File f = new File(FilenameUtils.normalize((String)path));
        if (f.isDirectory()) {
            File[] fs = f.listFiles();
            for (int i = 0; i < fs.length; ++i) {
                list.addAll(StatSystemIOFile.getJavaFileNameList(fs[i].getAbsolutePath()));
            }
        } else if (path.endsWith(".java")) {
            list.add(path);
        }
        return list;
    }

    private static String getModelName(String pk) {
        char[] chs = pk.toCharArray();
        StringBuilder sb = new StringBuilder(chs.length);
        int dotCount = 0;
        for (char ch : chs) {
            if (ch == '.') {
                ++dotCount;
            }
            if (dotCount == 5) break;
            sb.append(ch);
        }
        return sb.toString();
    }

    public static void statIO(String f) throws Exception {
        JavaFileStatInfo[] fs = StatSystemIOFile.scanPath(f);
        StringBuffer s = new StringBuffer();
        int fcount = 0;
        int count = 0;
        TreeMap<String, int[]> authorMap = new TreeMap<String, int[]>();
        TreeMap<String, int[]> modelMap = new TreeMap<String, int[]>();
        for (int i = 0; i < fs.length; ++i) {
            int[] vv;
            String author;
            JavaFileStatInfo ff = fs[i];
            if (ff.getOtherWarningList().size() <= 0) continue;
            ++fcount;
            count += ff.getOtherWarningList().size();
            String string = author = ff.getAuthor() == null ? "unknow" : ff.getAuthor();
            if (authorMap.get(author) != null) {
                vv = (int[])authorMap.get(author);
                vv[0] = vv[0] + 1;
                vv[1] = vv[1] + ff.getOtherWarningList().size();
            } else {
                vv = new int[]{1, ff.getOtherWarningList().size()};
            }
            authorMap.put(author, vv);
            String model = StatSystemIOFile.getModelName(ff.getPK());
            if (modelMap.get(model) != null) {
                vv = (int[])modelMap.get(model);
                vv[0] = vv[0] + 1;
                vv[1] = vv[1] + ff.getOtherWarningList().size();
            } else {
                vv = new int[]{1, ff.getOtherWarningList().size()};
            }
            modelMap.put(model, vv);
            s.append(String.format("\r\n\u2605%1$s.%2$s\r\n%3$s=%4$s, %5$s=%6$s, %7$s=%8$s", ff.getPK(), ff.getCL(), CtrlCommonUIMessages.getMLS("author", "\u4f5c\u8005"), author, CtrlCommonUIMessages.getMLS("createdTime", "\u521b\u5efa\u65f6\u95f4"), ff.getCreateDate(), CtrlCommonUIMessages.getMLS("outputLocation", "\u8f93\u51fa\u5904"), ff.getListFormatString(ff.getOtherWarningList(), true)));
        }
        s.append(String.format("\r\n\r\n\u2605%1$s: %2$d, %3$s: %4$d\r\n\r\n\u2605%5$s", CtrlCommonUIMessages.getMLS("fileCount3", "\u6587\u4ef6\u6570"), fcount, CtrlCommonUIMessages.getMLS("blockCount", "\u6e90\u7801\u5757\u6570"), count, CtrlCommonUIMessages.getMLS("moduleStatistics", "\u6a21\u5757\u7edf\u8ba1\u5217\u8868(\u6587\u4ef6\u6570,\u5757\u6570)")));
        for (Map.Entry model : modelMap.entrySet()) {
            int[] vv = (int[])model.getValue();
            s.append("\r\n\t").append(model.getKey()).append("\t=").append(vv[0]).append(",").append(vv[1]);
        }
        s.append("\r\n\r\n\u2605");
        s.append(CtrlCommonUIMessages.getMLS("authorStatistics", "\u4f5c\u8005\u7edf\u8ba1\u5217\u8868(\u6587\u4ef6\u6570,\u5757\u6570)"));
        for (Map.Entry author : authorMap.entrySet()) {
            int[] vv = (int[])author.getValue();
            s.append("\r\n\t").append(author.getKey()).append("\t=").append(vv[0]).append(",").append(vv[1]);
        }
        System.out.println(s);
        String of = f.replace('\\', '/');
        String[] ss = of.split("/");
        if (ss.length >= 2) {
            of = ss[ss.length - 2] + "_" + ss[ss.length - 1];
        }
        of = of.replace(':', '_');
        of = "statIO_" + of + ".txt";
        try (BufferedWriter br = new BufferedWriter(new FileWriter(FilenameUtils.normalize((String)of)));){
            br.write("#" + sdf.get().format(new Date()) + "  " + f + "\r\n");
            br.write(s.toString());
            br.flush();
            System.out.println("Scan completed!");
        }
    }

    public static void main(String[] args) throws Exception {
        StatSystemIOFile.run(new StatSystemIOFile(), "StatIO");
    }

    class PrintMsgRunnable
    implements Runnable {
        String msg;

        PrintMsgRunnable(String aMsg) {
            this.msg = aMsg;
        }

        @Override
        public void run() {
            if (StatSystemIOFile.this.scaning) {
                StatSystemIOFile.this.txtOut.append(this.msg);
                StatSystemIOFile.this.txtOut.setCaretPosition(StatSystemIOFile.this.txtOut.getDocument().getLength());
            }
        }
    }
}

