/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.res.tool.java.stat.visitor;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.res.tool.java.parser.syntaxtree.MethodDeclaration;
import com.kingdee.cosmic.ctrl.res.tool.java.parser.syntaxtree.Node;
import com.kingdee.cosmic.ctrl.res.tool.java.parser.syntaxtree.NodeToken;
import com.kingdee.cosmic.ctrl.res.tool.java.stat.BaseVisitor;

public class SystemIOStatementVisitor
extends BaseVisitor {
    private boolean refactory = false;
    private String pattern;

    public SystemIOStatementVisitor() {
        this(false, null);
    }

    public SystemIOStatementVisitor(boolean refactory, String pattern) {
        this.refactory = refactory;
        this.pattern = pattern;
    }

    @Override
    public void visit(NodeToken n) {
        if (n != null && n.kind == 128) {
            NodeToken first = n;
            NodeToken buf = n;
            if ("System".equals(buf.tokenImage) && (buf = this.bean.nextToken(buf)) != null && buf.kind == 78 && (buf = this.bean.nextToken(buf)) != null && buf.kind == 128 && ("out".equals(buf.tokenImage) || "err".equals(buf.tokenImage)) && (buf = this.bean.nextToken(buf)) != null && buf.kind == 78 && (buf = this.bean.nextToken(buf)) != null && buf.kind == 128 && buf.tokenImage.startsWith("print") && !this.isMainMethod(this.searchParentMethod(first))) {
                StringBuilder src = new StringBuilder();
                int k = buf.endLine;
                for (int i = first.beginLine - 1; i < k; ++i) {
                    src.append(this.bean.getLine(i));
                    if (i >= k - 1) continue;
                    src.append("\r\n");
                }
                if (this.refactory) {
                    StringBuilder src2 = new StringBuilder();
                    if (first.beginLine == buf.endLine) {
                        int lineIndex = first.beginLine - 1;
                        String line = this.bean.getLine(lineIndex);
                        line = line.substring(first.beginColumn + 1) + this.pattern + line.substring(buf.endColumn + 1);
                        this.bean.setLine(lineIndex, line);
                    }
                }
                String str = src.toString();
                this.info.addOtherWarningList(String.format(CtrlCommonUIMessages.getMLS("fileLineAndColumn", "[{0}] {1}\u884c,{2}\u5217{3}"), "System IO", first.beginLine, first.beginColumn, str), null);
            }
        }
    }

    private boolean isMainMethod(MethodDeclaration m) {
        if (m != null) {
            NodeToken t;
            NodeToken buf = t = m.methodDeclarator.nodeToken;
            if ("main".equals(t.tokenImage) && this.bean.preTokenWith(t, "void")) {
                buf = this.bean.preToken(t);
                boolean matchPrefix = false;
                if (this.bean.preTokenWith(buf, "static")) {
                    if (this.bean.preTokenWith(buf = this.bean.preToken(buf), "public")) {
                        matchPrefix = true;
                    }
                } else if (this.bean.preTokenWith(buf, "public") && this.bean.preTokenWith(buf = this.bean.preToken(buf), "static")) {
                    matchPrefix = true;
                }
                if (matchPrefix && this.bean.nextTokenWith(t, "(") && this.bean.nextTokenWith(buf = this.bean.nextToken(t), "String") && this.bean.nextTokenWith(buf = this.bean.nextToken(buf), "[") && this.bean.nextTokenWith(buf = this.bean.nextToken(buf), "]")) {
                    return true;
                }
            }
        }
        return false;
    }

    private MethodDeclaration searchParentMethod(NodeToken n) {
        for (Node p = n.getParent(); p != null; p = p.getParent()) {
            if (p.getClass() != MethodDeclaration.class) continue;
            return (MethodDeclaration)p;
        }
        n.getParent();
        return null;
    }

    @Override
    public void finishVisit() {
    }
}

