/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.res.tool.resscan;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.res.BaseResource;
import com.kingdee.cosmic.ctrl.res.tool.resscan.CNItem;
import com.kingdee.cosmic.ctrl.res.tool.resscan.CNSScanOption;
import com.kingdee.cosmic.ctrl.res.tool.resscan.ItemEntity;
import com.kingdee.cosmic.ctrl.res.tool.resscan.LineChar;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class CNScanner {
    private static Logger logger = LogUtil.getLogger(CNScanner.class);
    private static final ThreadLocal<DateFormat> sdf = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    private static Map xmlFormatCache = new HashMap();

    public static void scanFile(String sourceFile, String outPros, String preFix) throws Exception {
        System.out.println("\u626b\u63cf\u6e90\u6587\u4ef6:\t" + sourceFile);
        System.out.println("\u8f93\u51fa\u8d44\u6e90\u5c5e\u6027\u6587\u4ef6:\t" + outPros + ", \u5c5e\u6027\u524d\u7f00=" + preFix);
        System.out.println("\u5f00\u59cb\u626b\u63cf...");
        System.out.println("\t\u7f16\u53f7 \t\u884c\u53f7:\u5217\u53f7 \u786c\u7f16\u7801(\u6c49)\t\u8fde\u6709\u5de6\u5b57\u7b26\u4e32 \u8fde\u6709\u53f3\u5b57\u7b26\u4e32 ");
        CNItem ci = CNScanner.analyseSrc(sourceFile);
        TreeSet<String> ts = new TreeSet<String>();
        int m = ci.getItemCount();
        for (int i = 0; i < m; ++i) {
            ItemEntity ie = ci.getItem(i);
            System.out.println("\t" + (i + 1) + " \t" + ie);
            ts.add(ie.getValue());
        }
        preFix = preFix == null || preFix.trim().length() == 0 ? "" : preFix.trim() + '_';
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(FilenameUtils.normalize((String)outPros))));){
            bw.write("#SRC: " + CNScanner.getFileName(sourceFile));
            bw.newLine();
            bw.write("#RES: " + CNScanner.getFileName(outPros));
            bw.newLine();
            bw.write("#" + sdf.get().format(new Date()));
            bw.newLine();
            int i = 1;
            Iterator iter = ts.iterator();
            while (iter.hasNext()) {
                bw.newLine();
                bw.write(preFix + "res" + i + " =" + (String)iter.next());
                ++i;
            }
            bw.flush();
        }
    }

    public static void reFile(String getResPattern, String[] addedImportClasses, String sourceFile, String outSource, String fromRes) throws Exception {
        Map resMap = CNScanner.loadResource(fromRes);
        System.out.println("\u91cd\u6784\u6e90\u6587\u4ef6: " + sourceFile + "\n\t--> " + outSource);
        System.out.println("\t1)\u53c2\u8003\u5c5e\u6027\u8d44\u6e90\u6587\u4ef6: " + fromRes);
        System.out.println("\t2)\u8d44\u6e90\u83b7\u53d6\u65b9\u6cd5\u6a21\u677f: " + getResPattern);
        CNScanner.reFile(getResPattern, addedImportClasses, sourceFile, outSource, resMap);
    }

    public static void reFile(String getResPattern, String[] addedImportClasses, String sourceFile, String outSource, Map resMap) throws Exception {
        Throwable throwable;
        CNItem ci = CNScanner.analyseSrc(sourceFile);
        StringBuilder sb = new StringBuilder(4096);
        try {
            throwable = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(FilenameUtils.normalize((String)sourceFile))));){
                String line;
                int lineNo = 0;
                boolean hasAddImport = false;
                while ((line = br.readLine()) != null) {
                    int i;
                    String pk;
                    ++lineNo;
                    if (!hasAddImport && (pk = line.toLowerCase(Locale.ENGLISH)).startsWith("package ") && pk.endsWith(";")) {
                        sb.append(line).append("\r\n\r\n");
                        if (addedImportClasses != null && addedImportClasses.length > 0) {
                            int m = addedImportClasses.length;
                            for (i = 0; i < m; ++i) {
                                sb.append("import ").append(addedImportClasses[i]).append(";\r\n");
                            }
                        }
                        hasAddImport = true;
                        continue;
                    }
                    List itemList = ci.getItemsByLineNo(lineNo);
                    int n = itemList.size();
                    if (n == 0) {
                        sb.append(line);
                    } else {
                        int end = 0;
                        for (i = 0; i < n; ++i) {
                            ItemEntity ie = (ItemEntity)itemList.get(i);
                            if (ie.hasLeft) {
                                sb.append(line.substring(end, ie.colFrom - 1));
                                sb.append("\"+");
                            } else {
                                sb.append(line.substring(end, ie.colFrom - 2));
                            }
                            sb.append(getResPattern.replaceAll("\\$\\{key\\}", (String)resMap.get(ie.getValue())));
                            if (ie.hasRight) {
                                sb.append("+\"");
                                end = ie.colFrom + ie.len - 1;
                                continue;
                            }
                            end = ie.colFrom + ie.len;
                        }
                        sb.append(line.substring(end));
                    }
                    sb.append("\r\n");
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            logger.error((Object)"", (Throwable)e);
        }
        try {
            throwable = null;
            try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(FilenameUtils.normalize((String)outSource))));){
                bw.write(sb.toString());
                bw.flush();
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    public static String buildProperties(Map resMap, String outRes) throws Exception {
        String res;
        String pk;
        String pkRes;
        String path;
        String f = outRes.replace('\\', '/');
        int i = f.lastIndexOf(47);
        if (i != -1) {
            path = f.substring(0, i);
            pkRes = f.substring(i + 1);
        } else {
            path = "";
            pkRes = f;
        }
        i = pkRes.lastIndexOf(46);
        if (i != -1) {
            pk = pkRes.substring(0, i);
            res = pkRes.substring(i + 1);
        } else {
            pk = "";
            res = pkRes;
        }
        path = path + '/' + pk.replace('.', '/');
        new File(FilenameUtils.normalize((String)path)).mkdirs();
        String prosFile0 = path + '/' + res + "_.properties";
        String prosFile1 = path + '/' + res + "_en.properties";
        String prosFile2 = path + '/' + res + "_zh_CN.properties";
        String prosFile3 = path + '/' + res + "_zh_TW.properties";
        TreeSet s = new TreeSet(resMap.keySet());
        try (BufferedWriter bw0 = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(FilenameUtils.normalize((String)prosFile0))));
             BufferedWriter bw1 = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(FilenameUtils.normalize((String)prosFile1))));
             BufferedWriter bw2 = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(FilenameUtils.normalize((String)prosFile2))));
             BufferedWriter bw3 = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(FilenameUtils.normalize((String)prosFile3))));){
            String tempDate = sdf.get().format(new Date());
            bw0.write("# can be edit then merge me. " + tempDate);
            bw1.write("# en " + tempDate);
            bw2.write("# zh_CN " + tempDate);
            bw3.write("# zh_TW " + tempDate);
            bw0.newLine();
            bw1.newLine();
            bw2.newLine();
            bw3.newLine();
            bw0.newLine();
            bw1.newLine();
            bw2.newLine();
            bw3.newLine();
            for (String key : s) {
                String[] vs = (String[])resMap.get(key);
                bw0.write(key + "=" + vs[1]);
                bw1.write('#' + vs[1]);
                bw1.newLine();
                bw1.write(key + "=" + vs[0]);
                bw2.write(key + "=" + vs[1]);
                bw3.write(key + "=" + vs[2]);
                bw0.newLine();
                bw1.newLine();
                bw2.newLine();
                bw3.newLine();
            }
            bw0.flush();
            bw1.flush();
            bw2.flush();
            bw3.flush();
        }
        CNScanner.native2ascii(prosFile2);
        CNScanner.native2ascii(prosFile3);
        String resClass = path + '/' + res + ".java";
        StringBuilder sb = new StringBuilder();
        String baseClass = BaseResource.class.getName();
        sb.append("package ").append(pk).append(";\r\n\r\n").append("import ").append(baseClass).append(";\r\n\r\n").append("/**\r\n *  For locate resource.\r\n */\r\n").append("public class ").append(res).append(" extends ").append(baseClass.substring(baseClass.lastIndexOf(46) + 1)).append("{\r\n\r\n").append("\tpublic static String getString(String key){\r\n").append("\t\treturn getString(").append(res).append(".class,key);\r\n").append("\t}\r\n").append("}\r\n");
        try (BufferedWriter bwrc = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(FilenameUtils.normalize((String)resClass))));){
            bwrc.write(sb.toString());
            bwrc.flush();
        }
        return path;
    }

    private static void native2ascii(String s) throws IOException {
        s = s.replace('/', '\\');
        String o = s + '~';
        Process p = Runtime.getRuntime().exec("cmd /c native2ascii " + s + " " + o);
        try {
            p.waitFor();
            File of = new File(FilenameUtils.normalize((String)o));
            if (of.exists()) {
                if (!new File(FilenameUtils.normalize((String)s)).delete()) {
                    logger.warn((Object)"\u6587\u4ef6\u5220\u9664\u5931\u8d25");
                }
                if (!of.renameTo(new File(FilenameUtils.normalize((String)s)))) {
                    logger.warn((Object)"\u6587\u4ef6\u91cd\u547d\u540d\u5931\u8d25");
                }
            } else {
                p = Runtime.getRuntime().exec("cmd /c w:/jdk/bin/native2ascii " + s + " " + o);
                p.waitFor();
                of = new File(FilenameUtils.normalize((String)o));
                if (of.exists()) {
                    if (!new File(FilenameUtils.normalize((String)s)).delete()) {
                        logger.warn((Object)"\u6587\u4ef6\u5220\u9664\u5931\u8d25");
                    }
                    if (!of.renameTo(new File(FilenameUtils.normalize((String)s)))) {
                        logger.warn((Object)"\u6587\u4ef6\u91cd\u547d\u540d\u5931\u8d25");
                    }
                } else {
                    System.err.println(CtrlCommonUIMessages.getMLS("native2asciiFailure", "[\u6267\u884cnative2ascii\u5931\u8d25]\u8bf7\u624b\u5de5\u8f6c\u6362\u6587\u4ef6") + s);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"err", (Throwable)e);
        }
    }

    public static String buildBOSRes(Map resMap, String outRes) throws Exception {
        String res;
        String pk;
        String pkRes;
        String path;
        String f = outRes.replace('\\', '/');
        int i = f.lastIndexOf(47);
        if (i != -1) {
            path = f.substring(0, i);
            pkRes = f.substring(i + 1);
        } else {
            path = "";
            pkRes = f;
        }
        i = pkRes.lastIndexOf(46);
        if (i != -1) {
            pk = pkRes.substring(0, i);
            res = pkRes.substring(i + 1);
        } else {
            pk = "";
            res = pkRes;
        }
        path = path + '/' + pk.replace('.', '/');
        new File(FilenameUtils.normalize((String)path)).mkdirs();
        String bosFile = path + '/' + res + ".resource";
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(FilenameUtils.normalize((String)bosFile))));){
            bw.write("<?xml version=\"1.0\" encoding=\"GBK\"?>");
            bw.write("\n<i18nResource xmlns=\"com.kingdee.bos.metadata\">");
            bw.write("\n\t<package>" + pk + "</package>");
            bw.write("\n\t<name>" + res + "</name>");
            bw.write("\n\t<alias>i18nResource[" + pkRes + "].alias</alias>");
            bw.write("\n\t<description>i18nResource[" + pkRes + "].description</description>");
            bw.write("\n\t<className>" + pkRes + "</className>");
            bw.write("\n\t<resourceItems>");
            TreeSet s = new TreeSet(resMap.keySet());
            for (String key : s) {
                bw.write("\n\t\t<resourceItem>");
                bw.write("\n\t\t\t<name>" + key + "</name>");
                bw.write("\n\t\t\t<value>i18nResource[" + pkRes + "].resourceItems.resourceItem[" + CNScanner.maskXMLFormat(key) + "].value</value>");
                bw.write("\n\t\t</resourceItem>");
            }
            bw.write("\n\t</resourceItems>");
            bw.write("\n\t<resource>");
            bw.write("\n\t\t<rs key=\"i18nResource[" + pkRes + "].alias\">");
            bw.write("\n\t\t\t<lang locale=\"en_US\" value=\"\" />");
            bw.write("\n\t\t\t<lang locale=\"zh_CN\" value=\"\" />");
            bw.write("\n\t\t\t<lang locale=\"zh_TW\" value=\"\" />");
            bw.write("\n\t\t</rs>");
            String description = CtrlCommonUIMessages.getMLS("doNotModifyAutogeneratedFile", "\u8be5\u6587\u4ef6\u7531CNSCanner\u81ea\u52a8\u4ea7\u751f\uff0c\u8bf7\u4e0d\u8981\u624b\u5de5\u4fee\u6539\u539f\u6709\u540d\u79f0\u3002@") + sdf.get().format(new Date());
            bw.write("\n\t\t<rs key=\"i18nResource[" + pkRes + "].description\">");
            bw.write("\n\t\t\t<lang locale=\"en_US\" value=\"\" />");
            bw.write("\n\t\t\t<lang locale=\"zh_CN\" value=\"" + description + "\" />");
            bw.write("\n\t\t\t<lang locale=\"zh_TW\" value=\"\" />");
            bw.write("\n\t\t</rs>");
            for (String key : s) {
                String[] vs = (String[])resMap.get(key);
                bw.write("\n\t\t<rs key=\"i18nResource[" + pkRes + "].resourceItems.resourceItem[" + CNScanner.maskXMLFormat(key) + "].value\">");
                bw.write("\n\t\t\t<lang locale=\"en_US\" value=\"" + CNScanner.maskXMLFormat(vs[0]) + "\" />");
                bw.write("\n\t\t\t<lang locale=\"zh_CN\" value=\"" + CNScanner.maskXMLFormat(vs[1]) + "\" />");
                bw.write("\n\t\t\t<lang locale=\"zh_TW\" value=\"" + CNScanner.maskXMLFormat(vs[2]) + "\" />");
                bw.write("\n\t\t</rs>");
            }
            bw.write("\n\t</resource>");
            bw.write("\n</i18nResource>");
            bw.flush();
        }
        return bosFile;
    }

    private static String maskXMLFormat(String key) {
        if (key == null) {
            return null;
        }
        String v = (String)xmlFormatCache.get(key);
        if (v == null) {
            v = key.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;");
            xmlFormatCache.put(key, v);
        }
        return v;
    }

    private static String getFileName(String value) {
        String f = value.replace('\\', '/');
        int i = f.lastIndexOf(47);
        if (i >= 0) {
            return f.substring(i + 1);
        }
        return value;
    }

    private static Map loadResource(String fromRes) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(FilenameUtils.normalize((String)fromRes))));){
            String line;
            int i = 0;
            while ((line = br.readLine()) != null) {
                if (line.length() == 0 || line.startsWith("#") || (i = line.indexOf(61)) < 0) continue;
                String value = line.substring(0, i).trim();
                String key = line.substring(i + 1);
                String old = map.put(key, value);
                if (old == null) continue;
                System.out.println("Warning: has duplicate resource value line \"" + old + "\"");
            }
        }
        catch (IOException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return map;
    }

    public static List analyseSrcPath(String path, String filePattern, PrintWriter pw) throws Exception {
        pw.println("Scan path=" + path);
        pw.flush();
        List list = CNScanner.analyseSrcPath(new File(FilenameUtils.normalize((String)path)), filePattern);
        pw.println(CtrlCommonUIMessages.getMLS("scannedFileCount", "\u626b\u63cf\u6587\u4ef6\u6570=") + list.size());
        pw.println(String.format("[%1$s]\t%2$s \t%3$s:%4$s %5$s", CtrlCommonUIMessages.getMLS("resultDisplayFormat", "\u663e\u793a\u7ed3\u679c\u683c\u5f0f"), CtrlCommonUIMessages.getMLS("number", "\u7f16\u53f7"), CtrlCommonUIMessages.getMLS("lineNumber", "\u884c\u53f7"), CtrlCommonUIMessages.getMLS("columnNumber", "\u5217\u53f7"), CtrlCommonUIMessages.getMLS("hardcodedText", "\u786c\u7f16\u7801(\u6c49)")));
        pw.flush();
        CNItem ci = null;
        int m = 0;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ci = (CNItem)list.get(i);
            if (ci.getItemCount() <= 0) continue;
            CNScanner.dumpCNItem(ci, ++m, pw);
        }
        return list;
    }

    private static void dumpCNItem(CNItem ci, int no, PrintWriter pw) {
        pw.println("[" + no + "] " + ci.getFile() + " (" + ci.getItemCount() + ')');
        int m = ci.getItemCount();
        for (int i = 0; i < m; ++i) {
            ItemEntity ie = ci.getItem(i);
            pw.println("\t" + (i + 1) + " \t" + ie.toString2());
        }
        pw.flush();
    }

    private static List analyseSrcPath(File f, String filePattern) throws Exception {
        ArrayList<CNItem> list = new ArrayList<CNItem>();
        if (f.isDirectory()) {
            File[] fs = f.listFiles();
            int n = fs.length;
            for (int i = 0; i < n; ++i) {
                list.addAll(CNScanner.analyseSrcPath(fs[i], filePattern));
            }
        } else {
            String filename = f.getAbsolutePath();
            if (filename.matches(filePattern)) {
                System.out.println(filename);
                list.add(CNScanner.analyseSrc(filename));
            }
        }
        return list;
    }

    private static CNItem analyseSrc(String sourceFile) throws Exception {
        CNItem ci = new CNItem();
        ci.setFile(sourceFile);
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(FilenameUtils.normalize((String)sourceFile))));){
            String line;
            int n = 0;
            int lineNo = 0;
            boolean inComment = false;
            boolean skipLine = false;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                ++lineNo;
                skipLine = false;
                LineChar lc = new LineChar(line);
                n += line.length();
                while (!skipLine && !lc.eof()) {
                    char ch = lc.next();
                    if (!inComment && CNScanner.isCN(ch, sb.length() > 0)) {
                        boolean hasLeft = lc.pos() >= 2 && '\"' == lc.getChar(-2) ? lc.pos() >= 3 && '\\' == lc.getChar(-3) : true;
                        sb.append(ch);
                        while (!lc.eof() && CNScanner.isCN(ch = lc.next(), sb.length() > 0)) {
                            sb.append(ch);
                        }
                        boolean hasRight = !lc.eof() && '\"' != lc.getChar(-1);
                        int colFrom = lc.pos() - sb.length();
                        ci.addItem(lineNo, colFrom, sb.toString(), hasLeft, hasRight);
                        sb.setLength(0);
                        continue;
                    }
                    switch (ch) {
                        case '/': {
                            if (lc.eof()) break;
                            if ('/' == lc.getNext()) {
                                skipLine = true;
                                break;
                            }
                            if ('*' != lc.getNext()) break;
                            inComment = true;
                            lc.next();
                            break;
                        }
                        case '*': {
                            if (lc.eof() || '/' != lc.getNext()) break;
                            inComment = false;
                            lc.next();
                        }
                    }
                }
                if (!CNSScanOption.isFullString) continue;
                List ciList = ci.getItemsByLineNo(lineNo);
                int m = ciList.size();
                for (int i = 0; i < m; ++i) {
                    ItemEntity e = (ItemEntity)ciList.get(i);
                    CNScanner.matchFullString(e, line);
                }
                CNScanner.combineLineItemEntity(ciList, ci);
            }
        }
        return ci;
    }

    private static void matchFullString(ItemEntity e, String line) {
        char ch;
        int i;
        int begin = e.colFrom - 1;
        int end = e.colFrom - 1 + e.len;
        char[] chs = line.toCharArray();
        if (e.hasLeft) {
            for (i = begin - 1; i >= 0; --i) {
                ch = chs[i];
                if (ch == '\"' && (i <= 0 || chs[i - 1] != '\\')) {
                    e.hasLeft = false;
                    break;
                }
                --begin;
            }
        }
        if (e.hasRight) {
            int n = chs.length;
            for (i = end; i < n; ++i) {
                ch = chs[i];
                if (ch == '\"' && (i <= 0 || chs[i - 1] != '\\')) {
                    e.hasRight = false;
                    break;
                }
                ++end;
            }
        }
        e.colFrom = begin + 1;
        e.len = end - begin;
        e.value = line.substring(begin, end);
    }

    private static void combineLineItemEntity(List es, CNItem ci) {
        int lastPos = -1;
        int n = es.size();
        for (int i = 0; i < n; ++i) {
            ItemEntity e = (ItemEntity)es.get(i);
            if (i == 0) {
                lastPos = e.colFrom;
                continue;
            }
            if (e.colFrom == lastPos) {
                ci.remove(e);
                continue;
            }
            lastPos = e.colFrom;
        }
    }

    private static boolean isCN(char ch, boolean withPreCN) {
        boolean b;
        boolean bl = b = ch >= '\u4e00' && ch <= '\u9fa5' || "\uff01\uff0c\u3002\uff1f\uff1a\u201c\u201d\u2018\u2019\uff0b\uff0d\u00d7\u00f7\u3001\u3010\u3011\u300e\u300f\uff5e".indexOf(ch) != -1;
        if (!b && withPreCN) {
            return ",.:;!?-_ \u3000".indexOf(ch) != -1;
        }
        return b;
    }
}

