/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.res.tool.resscan;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.res.tool.resscan.CNItem;
import com.kingdee.cosmic.ctrl.res.tool.resscan.ItemEntity;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class JavaFileFormator {
    private static final Logger logger = LogUtil.getPackageLogger(JavaFileFormator.class);
    static SimpleAttributeSet lineNoAttr = new SimpleAttributeSet();
    static SimpleAttributeSet itemTagAttr = new SimpleAttributeSet();
    static SimpleAttributeSet defaultAttr = new SimpleAttributeSet();
    private static Map lineNoCache;

    private static void addDocAttr(List list, int offset, int length, AttributeSet s) {
        list.add(new Object[]{offset, length, s});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showCNFile(CNItem ci, final JTextPane jt) {
        try {
            jt.setIgnoreRepaint(true);
            jt.setEnabled(false);
            jt.setText(null);
            try (BufferedReader br = new BufferedReader(new FileReader(FilenameUtils.normalize((String)ci.getFile())));){
                String line;
                int n = 1;
                String buf = null;
                int len = 0;
                int firstLocatePos = 0;
                Set lineNoSet = ci.getLineNoSet();
                StringBuilder sb = new StringBuilder();
                final ArrayList attrList = new ArrayList();
                while ((line = br.readLine()) != null) {
                    if (lineNoSet.contains(n)) {
                        buf = JavaFileFormator.getLineNo(n, 4);
                        sb.append(buf);
                        JavaFileFormator.addDocAttr(attrList, len, buf.length(), itemTagAttr);
                        int base = len += buf.length();
                        sb.append(line).append('\n');
                        len += line.length() + 1;
                        List lineItems = ci.getItemsByLineNo(n);
                        int m = lineItems.size();
                        for (int i = 0; i < m; ++i) {
                            ItemEntity ie = (ItemEntity)lineItems.get(i);
                            JavaFileFormator.addDocAttr(attrList, base + ie.colFrom - 1, ie.len, itemTagAttr);
                        }
                        if (firstLocatePos == 0) {
                            firstLocatePos = len;
                        }
                    } else {
                        buf = JavaFileFormator.getLineNo(n, 4);
                        sb.append(buf);
                        len += buf.length();
                        sb.append(line).append('\n');
                        len += line.length() + 1;
                    }
                    ++n;
                }
                jt.setText(sb.toString());
                jt.setCaretPosition(firstLocatePos);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StyledDocument sd = jt.getStyledDocument();
                        int m = attrList.size();
                        for (int i = 0; i < m; ++i) {
                            Object[] s = (Object[])attrList.get(i);
                            sd.setCharacterAttributes((Integer)s[0], (Integer)s[1], (AttributeSet)s[2], true);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error((Object)"err", (Throwable)e);
        }
        finally {
            jt.setEnabled(true);
            jt.setIgnoreRepaint(false);
        }
    }

    private static String getLineNo(int no, int fullLength) {
        Integer n = no;
        if (!lineNoCache.containsKey(n)) {
            String SPACE = "                         ";
            String s = String.valueOf(no);
            int len = fullLength - s.length();
            if (len < 0) {
                len = 0;
            }
            lineNoCache.put(n, "                         ".substring(0, len) + s + "|  ");
        }
        return (String)lineNoCache.get(n);
    }

    static {
        int fontSize = 15;
        String family = CtrlCommonMessages.getMLS((String)"yahei", (String)"\u5fae\u8f6f\u96c5\u9ed1");
        StyleConstants.setFontFamily(lineNoAttr, family);
        StyleConstants.setFontSize(lineNoAttr, fontSize);
        StyleConstants.setForeground(lineNoAttr, Color.GRAY);
        StyleConstants.setFontFamily(itemTagAttr, family);
        StyleConstants.setFontSize(itemTagAttr, fontSize);
        StyleConstants.setForeground(itemTagAttr, new Color(0xFF0000));
        StyleConstants.setFontFamily(defaultAttr, family);
        StyleConstants.setFontSize(defaultAttr, fontSize);
        StyleConstants.setForeground(defaultAttr, Color.BLACK);
        lineNoCache = new HashMap();
    }
}

