/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.res.tool.webmine.pl.complie.visitor;

import com.kingdee.cosmic.ctrl.res.tool.webmine.pl.complie.syntaxtree.MatchedPattern;
import com.kingdee.cosmic.ctrl.res.tool.webmine.pl.complie.syntaxtree.Node;
import com.kingdee.cosmic.ctrl.res.tool.webmine.pl.complie.syntaxtree.NodeListInterface;
import com.kingdee.cosmic.ctrl.res.tool.webmine.pl.complie.syntaxtree.NodeToken;
import com.kingdee.cosmic.ctrl.res.tool.webmine.pl.complie.visitor.DepthFirstVisitor;
import com.kingdee.cosmic.ctrl.res.tool.webmine.pl.complie.visitor.FormatCommand;
import com.kingdee.cosmic.ctrl.res.tool.webmine.pl.complie.visitor.TreeFormatterException;
import java.util.Enumeration;
import java.util.Vector;

public class TreeFormatter
extends DepthFirstVisitor {
    private Vector cmdQueue = new Vector();
    private boolean lineWrap;
    private int wrapWidth;
    private int indentAmt;
    private int curLine = 1;
    private int curColumn = 1;
    private int curIndent = 0;

    public TreeFormatter() {
        this(3, 0);
    }

    public TreeFormatter(int indentAmt, int wrapWidth) {
        this.indentAmt = indentAmt;
        this.wrapWidth = wrapWidth;
        this.lineWrap = wrapWidth > 0;
    }

    protected void processList(NodeListInterface n) {
        this.processList(n, null);
    }

    protected void processList(NodeListInterface n, FormatCommand cmd) {
        Enumeration e = n.elements();
        while (e.hasMoreElements()) {
            ((Node)e.nextElement()).accept(this);
            if (cmd == null || !e.hasMoreElements()) continue;
            this.cmdQueue.addElement(cmd);
        }
    }

    protected FormatCommand force() {
        return this.force(1);
    }

    protected FormatCommand force(int i) {
        return new FormatCommand(0, i);
    }

    protected FormatCommand indent() {
        return this.indent(1);
    }

    protected FormatCommand indent(int i) {
        return new FormatCommand(1, i);
    }

    protected FormatCommand outdent() {
        return this.outdent(1);
    }

    protected FormatCommand outdent(int i) {
        return new FormatCommand(2, i);
    }

    protected FormatCommand space() {
        return this.space(1);
    }

    protected FormatCommand space(int i) {
        return new FormatCommand(3, i);
    }

    protected void add(FormatCommand cmd) {
        this.cmdQueue.addElement(cmd);
    }

    @Override
    public void visit(NodeToken n) {
        Enumeration e = this.cmdQueue.elements();
        block6: while (e.hasMoreElements()) {
            FormatCommand cmd = (FormatCommand)e.nextElement();
            switch (cmd.getCommand()) {
                case 0: {
                    this.curLine += cmd.getNumCommands();
                    this.curColumn = this.curIndent + 1;
                    continue block6;
                }
                case 1: {
                    this.curIndent += this.indentAmt * cmd.getNumCommands();
                    continue block6;
                }
                case 2: {
                    if (this.curIndent < this.indentAmt) continue block6;
                    this.curIndent -= this.indentAmt * cmd.getNumCommands();
                    continue block6;
                }
                case 3: {
                    this.curColumn += cmd.getNumCommands();
                    continue block6;
                }
            }
            throw new TreeFormatterException("Invalid value in command queue.");
        }
        this.cmdQueue.removeAllElements();
        if (n.numSpecials() > 0) {
            e = n.specialTokens.elements();
            while (e.hasMoreElements()) {
                NodeToken special = (NodeToken)e.nextElement();
                this.placeToken(special, this.curLine, this.curColumn);
                this.curLine = special.endLine + 1;
            }
        }
        this.placeToken(n, this.curLine, this.curColumn);
        this.curLine = n.endLine;
        this.curColumn = n.endColumn;
    }

    private void placeToken(NodeToken n, int line, int column) {
        int length = n.tokenImage.length();
        if (!this.lineWrap || n.tokenImage.indexOf(10) != -1 || column + length <= this.wrapWidth) {
            n.beginColumn = column;
        } else {
            ++line;
            n.beginColumn = column = this.curIndent + this.indentAmt + 1;
        }
        n.beginLine = line;
        for (int i = 0; i < length; ++i) {
            if (n.tokenImage.charAt(i) == '\n' && i < length - 1) {
                ++line;
                column = 1;
                continue;
            }
            ++column;
        }
        n.endLine = line;
        n.endColumn = column;
    }

    @Override
    public void visit(MatchedPattern n) {
        n.nodeToken.accept(this);
    }
}

