/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.export;

import com.kingdee.cosmic.ctrl.common.util.UnitConverter;
import com.kingdee.cosmic.ctrl.kdf.export.KDTables2KDSBookVO;
import com.kingdee.cosmic.ctrl.kdf.form.Page;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootParser;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootRow;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSBook;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSCell;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSMergeBlock;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSRow;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSSheet;
import com.kingdee.cosmic.ctrl.kdf.table.IBlock;
import com.kingdee.cosmic.ctrl.kdf.table.ICell;
import com.kingdee.cosmic.ctrl.kdf.table.IColumn;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTCell;
import com.kingdee.cosmic.ctrl.kdf.table.KDTColumns;
import com.kingdee.cosmic.ctrl.kdf.table.KDTHead;
import com.kingdee.cosmic.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTPrintManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTRange;
import com.kingdee.cosmic.ctrl.kdf.table.KDTRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.KDTableHelper;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.print.KDPrinter;
import com.kingdee.cosmic.ctrl.print.util.KDPrinterUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class KDTables2KDSBook {
    public static final int MAX_VALUE = 65536;
    private static KDTables2KDSBook instance = null;

    private KDTables2KDSBook() {
    }

    public static KDTables2KDSBook getInstance() {
        if (instance == null) {
            instance = new KDTables2KDSBook();
        }
        return instance;
    }

    public KDSBook exportKDTablesToKDSBook(KDTables2KDSBookVO[] tablesVO, boolean isToMultiSheet, boolean isNewSheet) throws Exception {
        if (tablesVO == null || tablesVO.length == 0) {
            return null;
        }
        if (isToMultiSheet) {
            if (isNewSheet) {
                return this.exportKDT2KDS2(tablesVO);
            }
            return this.exportKDT2KDS1(tablesVO);
        }
        if (isNewSheet) {
            return this.exportKDT2KDS4(tablesVO);
        }
        return this.exportKDT2KDS3(tablesVO);
    }

    public KDSBook exportKDT2KDS1(KDTables2KDSBookVO[] tableVO) throws Exception {
        if (tableVO == null || tableVO.length == 0) {
            return null;
        }
        KDSBook book = new KDSBook("kdtable export");
        int i = 0;
        int iLen = tableVO.length;
        int iBeginRow = 0;
        int iEndRow = 0;
        int iTableCount = 0;
        String sSheetName = "";
        for (i = 0; i < iLen; ++i) {
            KDTable table = tableVO[i].getKDTable();
            iTableCount = this.getRowCount(table);
            iBeginRow = 0;
            iEndRow = iTableCount > 65536 ? 65536 : iTableCount;
            sSheetName = this.getTableName(tableVO[i]);
            KDSSheet sheet = null;
            sheet = this.exportKDTable2KDSheet(tableVO[i], iBeginRow, iEndRow, book, true, sSheetName);
            book.addSheet(null, sheet);
        }
        return book;
    }

    public KDSBook exportKDT2KDS2(KDTables2KDSBookVO[] tableVO) throws Exception {
        if (tableVO == null || tableVO.length == 0) {
            return null;
        }
        KDSBook book = new KDSBook("kdtable export");
        int i = 0;
        int j = 0;
        int iLen = tableVO.length;
        int iSheetCount = 0;
        int iYu = 0;
        int iBeginRow = 0;
        int iEndRow = 0;
        int iTableCount = 0;
        String sSheetName = "";
        int iSheetIndex = 0;
        for (i = 0; i < iLen; ++i) {
            KDTable table = tableVO[i].getKDTable();
            iTableCount = this.getRowCount(table);
            KDSSheet sheet = null;
            if (iTableCount < 65536) {
                iBeginRow = 0;
                iEndRow = iTableCount;
                sSheetName = this.getTableName(tableVO[i]);
                sheet = this.exportKDTable2KDSheet(tableVO[i], iBeginRow, iEndRow, book, true, sSheetName);
                book.addSheet(null, sheet);
                ++iSheetIndex;
                continue;
            }
            iSheetCount = iTableCount / 65536;
            iYu = iTableCount % 65536;
            for (j = 0; j < iSheetCount; ++j) {
                iBeginRow = j * 65536;
                iEndRow = j == iSheetCount - 1 ? iBeginRow + iYu : (j + 1) * 65536;
                sSheetName = this.getTableName(tableVO[i]) + iSheetIndex;
                sheet = j == 0 ? this.exportKDTable2KDSheet(tableVO[i], iBeginRow, iEndRow, book, true, sSheetName) : this.exportKDTable2KDSheet(tableVO[i], iBeginRow, iEndRow, book, false, sSheetName);
                book.addSheet(null, sheet);
                ++iSheetIndex;
            }
        }
        return book;
    }

    public KDSBook exportKDT2KDS3(KDTables2KDSBookVO[] tableVO) throws Exception {
        if (tableVO == null || tableVO.length == 0) {
            return null;
        }
        KDSBook book = new KDSBook("kdtable export");
        int i = 0;
        int j = 0;
        int iLen = tableVO.length;
        int iSheetCount = 0;
        int iYu = 0;
        int iBeginRow = 0;
        int iEndRow = 0;
        int iTableCount = 0;
        String sSheetName = "";
        int iSheetIndex = 0;
        KDSSheet mergeSheet = null;
        boolean bMerge = true;
        int iMergeRowCount = 0;
        block0: for (i = 0; i < iLen; ++i) {
            KDTable table = tableVO[i].getKDTable();
            if (i == 0) {
                sSheetName = this.getTableName(tableVO[i]);
                mergeSheet = new KDSSheet(book, sSheetName);
            }
            iTableCount = this.getRowCount(table);
            KDSSheet sheet = null;
            if (iTableCount < 65536) {
                iBeginRow = 0;
                iEndRow = iTableCount;
                sheet = this.exportKDTable2KDSheet(tableVO[i], iBeginRow, iEndRow, book, true, sSheetName);
                iMergeRowCount = mergeSheet.getRowCount();
                bMerge = this.mergeKDSheet(mergeSheet, sheet);
                this.mergeBlock(mergeSheet, sheet, iMergeRowCount);
                if (!bMerge) break;
                ++iSheetIndex;
                continue;
            }
            iSheetCount = iTableCount / 65536;
            iYu = iTableCount % 65536;
            for (j = 0; j < iSheetCount; ++j) {
                iBeginRow = j * 65536;
                iEndRow = j == iSheetCount - 1 ? iBeginRow + iYu : (j + 1) * 65536;
                sSheetName = "sheet" + iSheetIndex;
                sheet = j == 0 ? this.exportKDTable2KDSheet(tableVO[i], iBeginRow, iEndRow, book, true, sSheetName) : this.exportKDTable2KDSheet(tableVO[i], iBeginRow, iEndRow, book, false, sSheetName);
                bMerge = this.mergeKDSheet(mergeSheet, sheet);
                if (!bMerge) continue block0;
                ++iSheetIndex;
            }
        }
        book.addSheet(null, mergeSheet);
        return book;
    }

    public KDSBook exportKDT2KDS4(KDTables2KDSBookVO[] tableVO) throws Exception {
        if (tableVO == null || tableVO.length == 0) {
            return null;
        }
        KDSBook book = new KDSBook("kdtable export");
        int i = 0;
        int k = 0;
        int iLen = tableVO.length;
        int iBeginRow = 0;
        int iEndRow = 0;
        int iTableCount = 0;
        String sSheetName = "";
        int iSheetIndex = 0;
        int iMergeRowCount = 0;
        int mergeSheetCount = this.calcMergeSheet(tableVO);
        KDSSheet[] mergeSheet = new KDSSheet[mergeSheetCount];
        for (i = 0; i < iLen; ++i) {
            KDTable table = tableVO[i].getKDTable();
            iTableCount = this.getRowCount(table);
            iBeginRow = 0;
            iEndRow = 0;
            while (iEndRow != iTableCount) {
                if (mergeSheet[iSheetIndex] == null) {
                    sSheetName = this.getTableName(tableVO[i]);
                    mergeSheet[iSheetIndex] = new KDSSheet(book, sSheetName);
                }
                iMergeRowCount = mergeSheet[iSheetIndex].getRowCount();
                KDSSheet sheet = null;
                iBeginRow = iEndRow;
                if ((iEndRow = iBeginRow + 65536 - iMergeRowCount) > iTableCount) {
                    iEndRow = iTableCount;
                }
                sSheetName = "sheet" + i + iSheetIndex;
                sheet = this.exportKDTable2KDSheet(tableVO[i], iBeginRow, iEndRow, book, true, sSheetName);
                iMergeRowCount = mergeSheet[iSheetIndex].getRowCount();
                this.mergeKDSheet(mergeSheet[iSheetIndex], sheet);
                this.mergeBlock(mergeSheet[iSheetIndex], sheet, iMergeRowCount);
                iMergeRowCount = mergeSheet[iSheetIndex].getRowCount();
                if (iMergeRowCount < 65536) continue;
                ++iSheetIndex;
            }
        }
        for (k = 0; k < mergeSheetCount; ++k) {
            book.addSheet(null, mergeSheet[k]);
        }
        return book;
    }

    public int calcMergeSheet(KDTables2KDSBookVO[] tableVO) {
        int mergeSheetCount = 0;
        int mergeRowCount = 0;
        for (int i = 0; i < tableVO.length; ++i) {
            mergeRowCount += this.getRowCount(tableVO[i].getKDTable());
        }
        mergeSheetCount = mergeRowCount / 65536;
        if (mergeRowCount % 65536 != 0) {
            ++mergeSheetCount;
        }
        if (mergeSheetCount == 0) {
            ++mergeSheetCount;
        }
        return mergeSheetCount;
    }

    public boolean mergeKDSheet(KDSSheet mergeSheet, KDSSheet sheet) {
        int iSheetRowCount;
        if (mergeSheet == null || sheet == null) {
            return false;
        }
        boolean bReturnValue = true;
        int iMergeRowCount = mergeSheet.getRowCount();
        if (iMergeRowCount + (iSheetRowCount = sheet.getRowCount()) > 65536) {
            iSheetRowCount = 65536 - iMergeRowCount;
            bReturnValue = false;
        }
        int iSheetColCount = sheet.getColumnCount();
        for (int i = 0; i < iSheetRowCount; ++i) {
            KDSRow row = sheet.getRow(i, false);
            if (row == null) continue;
            mergeSheet.getRows().setRowHeight(i + iMergeRowCount, row.getHeight());
            for (int j = 0; j < iSheetColCount; ++j) {
                KDSCell cell = sheet.getCell(i, j, false);
                if (cell == null) continue;
                ShareStyleAttributes ssa = null;
                ssa = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{cell.getSSA(), row.getSSA()});
                mergeSheet.setCell(i + iMergeRowCount, j, cell.getValue(), null, ssa);
            }
        }
        return bReturnValue;
    }

    public int calcHeaderCellIndex(int colCount, int index, int headerCellSize) {
        int cellIndex = 0;
        cellIndex = headerCellSize == 1 ? colCount / 2 : (colCount <= headerCellSize ? index : (index == 0 ? 0 : (index == headerCellSize - 1 ? colCount - 1 : this.calcHeaderCellIndex1(colCount, index, headerCellSize))));
        return cellIndex;
    }

    public int calcHeaderCellIndex1(int colCount, int index, int headerCellSize) {
        int cellIndex = 0;
        int midIndex = 0;
        int beginIndex = 0;
        int endIndex = headerCellSize;
        int colBeginIndex = 0;
        int colEndIndex = colCount;
        int colMidIndex = 0;
        while (beginIndex <= endIndex) {
            midIndex = (beginIndex + endIndex) / 2;
            colMidIndex = (colBeginIndex + colEndIndex) / 2;
            if (index == midIndex) {
                cellIndex = colMidIndex;
                break;
            }
            if (index < midIndex) {
                endIndex = midIndex - 1;
                colEndIndex = colMidIndex - 1;
                continue;
            }
            beginIndex = midIndex + 1;
            colBeginIndex = colMidIndex + 1;
        }
        if (cellIndex == 0) {
            cellIndex = colMidIndex;
        }
        return cellIndex;
    }

    public int calcMaxHeadFootCellCount(HeadFootModel headFootModel, int colCount) {
        int maxCellCount = 0;
        if (headFootModel == null) {
            return 0;
        }
        HeadFootRow headFootRow = null;
        List rowList = headFootModel.getRowList();
        int headFootRowCount = rowList.size();
        for (int i = 0; i < headFootRowCount; ++i) {
            String[] headFootCell;
            headFootRow = (HeadFootRow)rowList.get(i);
            if (headFootRow == null || (headFootCell = headFootRow.getText().split("&\\|")).length <= maxCellCount) continue;
            maxCellCount = headFootCell.length;
        }
        if (maxCellCount < colCount) {
            maxCellCount = colCount;
        }
        return maxCellCount;
    }

    public KDSSheet exportKDTable2KDSheet(KDTables2KDSBookVO tableVO, int beginRow, int endRow, KDSBook book, boolean haveExportHead, String sheetName) {
        ShareStyleAttributes ssa;
        int colIndex;
        if (!this.checkData(tableVO, beginRow, endRow, book, sheetName)) {
            return null;
        }
        KDSSheet sheet = null;
        KDTable table = tableVO.getKDTable();
        boolean isWithHead = tableVO.getWithHead();
        boolean isWithIndexColumn = tableVO.getWithIndexColumn();
        boolean isWithHiddenCol = tableVO.getWithHiddenCol();
        boolean isWithHeaderFooter = tableVO.getWithHeaderFooter();
        int rowCount = this.getRowCount(table);
        KDTRange range = new KDTRange();
        range.add(new KDTBlock(beginRow, 0, endRow, 0, 2));
        sheet = new KDSSheet(book, sheetName);
        int headRowCount = table.getHeadRowCount();
        int colCount = table.getIOManager().getTableColumnCount();
        int headerRowCount = 0;
        if (isWithHeaderFooter) {
            HeadFootModel headFootModel = null;
            KDTPrintManager printManager = table.getPrintManager();
            Page page = printManager.getHeader();
            if (page != null) {
                headFootModel = HeadFootParser.parseHeadFootPage2Model((Page)page);
            }
            if (headFootModel != null) {
                HeadFootRow headFootRow = null;
                List rowList = headFootModel.getRowList();
                int headerCellSize = 0;
                String headerCellText = "";
                headerRowCount = rowList.size();
                int headerCellIndex = 0;
                ArrayList variantTextList = null;
                String variantText = "";
                String variantValue = null;
                int maxColCount = 0;
                maxColCount = this.calcMaxHeadFootCellCount(headFootModel, colCount);
                for (int i = 0; i < headerRowCount; ++i) {
                    headFootRow = (HeadFootRow)rowList.get(i);
                    if (headFootRow == null) continue;
                    String[] headerCell = headFootRow.getText().split("&\\|");
                    headerCellSize = headerCell.length;
                    for (int j = 0; j < headerCellSize; ++j) {
                        headerCellIndex = this.calcHeaderCellIndex(maxColCount, j, headerCellSize);
                        headerCellText = headerCell[j];
                        if (headerCellText.indexOf("&[") != -1) {
                            variantTextList = KDPrinterUtils.parseVariantText((String)headerCellText);
                            StringBuilder stringBuilder = new StringBuilder();
                            for (int k = 0; k < variantTextList.size(); ++k) {
                                variantText = (String)variantTextList.get(k);
                                if (variantText.startsWith("&[")) {
                                    variantText = variantText.substring(variantText.indexOf("&[") + 2);
                                    variantValue = KDPrinterUtils.parseVariant((KDPrinter)printManager.getNewPrintManager().getPrinter(), (String)variantText);
                                    stringBuilder.append(variantValue);
                                    continue;
                                }
                                stringBuilder.append(variantText);
                            }
                            headerCellText = stringBuilder.toString();
                        }
                        ShareStyleAttributes ssa2 = null;
                        ssa2 = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{headFootRow.getSA(), headFootRow.getSA()});
                        sheet.setCell(i, headerCellIndex, (Object)headerCellText, null, ssa2);
                    }
                }
            }
        }
        boolean[] colOutputMark = new boolean[colCount];
        for (int i = 0; i < colCount; ++i) {
            colOutputMark[i] = isWithHiddenCol ? true : !this.isColumnHidden(table, i);
        }
        int colBeginIndex = isWithIndexColumn ? 1 : 0;
        int rowBeginIndex = 0;
        if (isWithHeaderFooter) {
            rowBeginIndex = isWithHead ? headerRowCount + headRowCount : headerRowCount;
        } else if (isWithHead) {
            rowBeginIndex = headRowCount;
        }
        if (isWithHead && haveExportHead) {
            KDTHead head = table.getHead();
            for (int i = 0; i < headRowCount; ++i) {
                KDTRow row = head.getRow(i);
                sheet.getRows().setRowHeight(i + headerRowCount, (float)UnitConverter.px2mm((int)head.getRowHeight(i)));
                colIndex = colBeginIndex;
                for (int j = 0; j < colCount; ++j) {
                    boolean tempB;
                    KDTCell cell;
                    if (!colOutputMark[j] || (cell = row.getCell(j)) == null) continue;
                    KDTMergeBlock block = cell.getMergeBlock();
                    boolean bl = tempB = block != null && (i != block.getTop() || j != block.getLeft());
                    if (tempB) {
                        cell = head.getRow(block.getTop()).getCell(block.getLeft());
                    }
                    if (cell != null) {
                        ssa = null;
                        ssa = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{cell.getSSA(), row.getSSA(), table.getHeadSSA()});
                        sheet.setCell(i + headerRowCount, colIndex, cell.getValue(), null, ssa);
                    }
                    ++colIndex;
                }
            }
        }
        KDTColumns cols = table.getColumns();
        if (isWithIndexColumn) {
            sheet.getColumns().setColumnWidth(0, (float)UnitConverter.px2mm((int)table.getIndexColumn().getWidth()));
        }
        colIndex = colBeginIndex;
        for (int i = 0; i < colCount; ++i) {
            if (!colOutputMark[i]) continue;
            sheet.getColumns().setColumnWidth(colIndex, (float)UnitConverter.px2mm((int)cols.getColumnWidth(i)));
            ++colIndex;
        }
        int rowIndex = rowBeginIndex;
        block7: for (IBlock block : range) {
            int top = block.getTop();
            int bottom = block.getBottom();
            if (block.getMode() != 1 && block.getMode() != 8 && block.getMode() != 2) break;
            if (block.getMode() == 8) {
                top = 0;
                bottom = rowCount - 1;
            }
            for (int i = top; i <= bottom; ++i) {
                IRow row;
                if (isWithIndexColumn) {
                    ssa = table.getIndexColumn().getSsa();
                    sheet.setCell(rowIndex, 0, (Object)String.valueOf(i + 1), null, ssa);
                }
                if ((row = table.getRow(i)) == null) continue block7;
                sheet.setRowHeight(rowIndex, (float)UnitConverter.px2mm((int)row.getHeight()));
                colIndex = colBeginIndex;
                for (int j = 0; j < colCount; ++j) {
                    KDTMergeBlock mergeBlock;
                    if (!colOutputMark[j]) continue;
                    ICell cell = row.getCell(j);
                    if (cell != null && (mergeBlock = cell.getMergeBlock()) != null && i != mergeBlock.getTop() && j != mergeBlock.getLeft()) {
                        cell = table.getCell(mergeBlock.getTop(), mergeBlock.getLeft());
                    }
                    ShareStyleAttributes ssa3 = null;
                    Object value = null;
                    String formula = null;
                    String text = null;
                    if (cell != null) {
                        ssa3 = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{cell.getKDTCell().getSSA(), row.getKDTRow().getSSA(), cols.getColumn(j).getSSA(), table.getSSA()});
                        value = this.getCellValue(table, cell, ssa3, i, j);
                        formula = cell.getExpressions();
                        text = table.getCellDisplayText(cell);
                    } else {
                        ssa3 = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{table.getBlankCellSSA(), row.getKDTRow().getSSA(), table.getColumns().getColumn(j).getSSA(), table.getSSA()});
                    }
                    if (formula != null && !(formula = formula.trim()).equals("") && formula.charAt(0) == '=') {
                        formula = formula.substring(1);
                    }
                    sheet.setCell(rowIndex, colIndex, value, formula, ssa3, text);
                    ++colIndex;
                }
                ++rowIndex;
            }
        }
        if (isWithHead && haveExportHead) {
            Iterator it = table.getHeadMergeManager().getMergeBlockList().iterator();
            while (it.hasNext()) {
                KDTMergeBlock kdtBlock = this.transBlock((KDTMergeBlock)it.next(), colOutputMark, 0, isWithIndexColumn);
                if (kdtBlock == null) continue;
                sheet.getMerges().addMerge(kdtBlock.getTop() + headerRowCount, kdtBlock.getLeft(), kdtBlock.getBottom() + headerRowCount, kdtBlock.getRight());
            }
        }
        sheet = this.transformMergeWhenMutiSelect(table, range, sheet, isWithHead, haveExportHead, headerRowCount);
        int tempRowCount = sheet.getExpandedRows();
        int footerRowCount = 0;
        if (isWithHeaderFooter) {
            HeadFootModel headFootModel = null;
            KDTPrintManager printManager = table.getPrintManager();
            Page page = printManager.getFooter();
            if (page != null) {
                headFootModel = HeadFootParser.parseHeadFootPage2Model((Page)page);
            }
            if (headFootModel != null) {
                HeadFootRow headFootRow = null;
                List rowList = headFootModel.getRowList();
                int footerCellSize = 0;
                String footerCellText = "";
                footerRowCount = rowList.size();
                int footerCellIndex = 0;
                ArrayList variantTextList = null;
                String variantText = "";
                String variantValue = null;
                int maxColCount = 0;
                maxColCount = this.calcMaxHeadFootCellCount(headFootModel, colCount);
                for (int i = 0; i < footerRowCount; ++i) {
                    headFootRow = (HeadFootRow)rowList.get(i);
                    if (headFootRow == null) continue;
                    String[] footerCell = headFootRow.getText().split("&\\|");
                    footerCellSize = footerCell.length;
                    for (int j = 0; j < footerCellSize; ++j) {
                        footerCellIndex = this.calcHeaderCellIndex(maxColCount, j, footerCellSize);
                        footerCellText = footerCell[j];
                        if (footerCellText.indexOf("&[") != -1) {
                            variantTextList = KDPrinterUtils.parseVariantText((String)footerCellText);
                            footerCellText = "";
                            StringBuilder sb = new StringBuilder();
                            for (int k = 0; k < variantTextList.size(); ++k) {
                                variantText = (String)variantTextList.get(k);
                                if (variantText.startsWith("&[")) {
                                    variantText = variantText.substring(variantText.indexOf("&[") + 2);
                                    variantValue = KDPrinterUtils.parseVariant((KDPrinter)printManager.getNewPrintManager().getPrinter(), (String)variantText);
                                    sb.append(variantValue);
                                    continue;
                                }
                                sb.append(variantText);
                            }
                            footerCellText = sb.toString();
                        }
                        ShareStyleAttributes ssa4 = null;
                        ssa4 = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{headFootRow.getSA(), headFootRow.getSA()});
                        sheet.setCell(i + tempRowCount, footerCellIndex, (Object)footerCellText, null, ssa4);
                    }
                }
            }
        }
        return sheet;
    }

    public boolean checkData(KDTables2KDSBookVO tableVO, int beginRow, int endRow, KDSBook book, String sheetName) {
        if (tableVO == null || book == null || sheetName == null) {
            return false;
        }
        KDTable table = tableVO.getKDTable();
        if (table == null) {
            return false;
        }
        int iRowCount = this.getRowCount(table);
        return beginRow >= 0 && beginRow <= endRow && endRow - beginRow <= 65536 && endRow <= iRowCount;
    }

    private boolean isColumnHidden(KDTable table, int colIndex) {
        IColumn col = table.getColumn(colIndex);
        if (col != null) {
            return col.getStyleAttributes().isHided();
        }
        return true;
    }

    private KDTMergeBlock transBlock(KDTMergeBlock block, boolean[] colOutputMark, int headRowCount, boolean isWithIndexColumn) {
        int i;
        int left;
        KDTMergeBlock newBlock = new KDTMergeBlock();
        newBlock.setBottom(block.getBottom() + headRowCount);
        newBlock.setTop(block.getTop() + headRowCount);
        newBlock.setLeft(block.getLeft());
        newBlock.setRight(block.getRight());
        int right = newBlock.getRight();
        for (left = newBlock.getLeft(); left <= right && !colOutputMark[left]; ++left) {
        }
        while (right >= left && !colOutputMark[right]) {
            --right;
        }
        int left2 = left;
        int right2 = right;
        for (i = 0; i < left; ++i) {
            if (colOutputMark[i]) continue;
            --left2;
            --right2;
        }
        for (i = left; i < right; ++i) {
            if (colOutputMark[i]) continue;
            --right2;
        }
        newBlock.setLeft(left2);
        newBlock.setRight(right2);
        if (isWithIndexColumn) {
            int left3 = newBlock.getLeft();
            int right3 = newBlock.getRight();
            newBlock.setLeft(++left3);
            newBlock.setRight(++right3);
        }
        if (left2 > right2) {
            return null;
        }
        if (left2 == right2 && block.getTop() == block.getBottom()) {
            return null;
        }
        return newBlock;
    }

    private KDSSheet transformMergeWhenMutiSelect(KDTable table, KDTRange range, KDSSheet sheet, boolean isWithHead, boolean haveExportHead, int headerRowCount) {
        List blockList = table.getMergeManager().getMergeBlockList();
        Iterator itRange = range.iterator();
        int rTop = -1;
        int rBottom = -1;
        int headHeight = 0;
        if (isWithHead && haveExportHead) {
            headHeight = table.getHeadRowCount();
        }
        rTop = rTop + headHeight + 1;
        rBottom += headHeight;
        while (itRange.hasNext()) {
            IBlock block = (IBlock)itRange.next();
            int top = block.getTop();
            int bottom = block.getBottom();
            int height = bottom - top + 1;
            rBottom += height;
            for (IBlock mergeBlock : blockList) {
                if (mergeBlock.getTop() < top && mergeBlock.getBottom() < top || mergeBlock.getTop() > bottom && mergeBlock.getBottom() > bottom) continue;
                int mTop = mergeBlock.getTop();
                int mLeft = mergeBlock.getLeft();
                int mBottom = mergeBlock.getBottom();
                int mRight = mergeBlock.getRight();
                if (mergeBlock.getTop() >= top && mergeBlock.getBottom() >= bottom) {
                    mBottom = bottom;
                } else if (mergeBlock.getTop() < top && mergeBlock.getBottom() > bottom) {
                    mTop = top;
                    mBottom = bottom;
                } else if (mergeBlock.getTop() < top && mergeBlock.getBottom() < bottom) {
                    mTop = top;
                }
                if ((mBottom = rBottom - (bottom - mBottom)) - (mTop = rTop + (mTop - top)) == 0 && mRight - mLeft == 0) continue;
                sheet.getMerges().addMerge(mTop + headerRowCount, mLeft, mBottom + headerRowCount, mRight);
            }
            rTop += height;
        }
        return sheet;
    }

    private KDSSheet mergeBlock(KDSSheet mergeSheet, KDSSheet sheet, int beginRow) {
        for (KDSMergeBlock kdsBlock : sheet.getMerges()) {
            if (kdsBlock == null) continue;
            mergeSheet.getMerges().addMerge(kdsBlock.getRow2() - kdsBlock.getWidth() + beginRow, kdsBlock.getCol2() - kdsBlock.getHeight(), kdsBlock.getRow2(), kdsBlock.getCol2());
        }
        return null;
    }

    public int getRowCount(KDTable table) {
        int rowCount = -1;
        int pageCount = 0;
        int pageFirstRecord = 0;
        int curPage = 0;
        if (table.getIOManager().isExpandedOnly()) {
            rowCount = table.getExpandedRowCount();
        } else {
            pageCount = table.getDataRequestManager().getPageRowCount();
            rowCount = table.getRowCount();
            while (rowCount == -1) {
                pageFirstRecord = pageCount * curPage;
                IRow row = table.getRow(pageFirstRecord);
                rowCount = table.getRowCount();
                if (row == null) break;
                ++curPage;
            }
            if (rowCount == -1) {
                rowCount = 0;
            }
        }
        return rowCount;
    }

    Object getCellValue(KDTable table, ICell cell, ShareStyleAttributes ssa, int rowIndex, int cellIndex) {
        String nf = ssa.getNumberFormat();
        if (nf != null && nf.startsWith("@") && nf.length() > 1) {
            return table.getCellDisplayValue(cell);
        }
        return KDTableHelper.getCellDisplayValue2(table, rowIndex, cellIndex);
    }

    private String getTableName(KDTables2KDSBookVO tableVO) {
        String tableName = tableVO.getTableName();
        if (!(tableName != null && !tableName.equals("") || (tableName = tableVO.getKDTable().getName()) != null && !tableName.equals("") || (tableName = tableVO.getKDTable().getID()) != null && !tableName.equals(""))) {
            tableName = "sheet";
        }
        return tableName;
    }
}

