/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.servertable;

import com.kingdee.cosmic.ctrl.common.util.CollectionUtil;
import com.kingdee.cosmic.ctrl.kdf.servertable.KDTCell;
import com.kingdee.cosmic.ctrl.kdf.servertable.KDTDataStyle;
import com.kingdee.cosmic.ctrl.kdf.servertable.KDTMark;
import com.kingdee.cosmic.ctrl.kdf.servertable.MacroInfo;
import java.util.ArrayList;
import java.util.List;

class KDTRow
implements Cloneable {
    protected int height = -1;
    protected KDTDataStyle dataStyle;
    protected MacroInfo macroInfo;
    protected int mark = 13312;
    protected ArrayList cells;

    public KDTRow() {
        this(0);
    }

    public Object clone() {
        KDTRow row = new KDTRow();
        row.height = this.height;
        row.dataStyle = this.dataStyle == null ? null : (KDTDataStyle)this.dataStyle.clone();
        row.macroInfo = this.macroInfo == null ? null : (MacroInfo)this.macroInfo.clone();
        row.mark = this.mark;
        for (int i = 0; i < this.cells.size(); ++i) {
            KDTCell cell = (KDTCell)this.cells.get(i);
            if (cell != null) {
                row.cells.add(cell.clone());
                continue;
            }
            row.cells.add(null);
        }
        return row;
    }

    public KDTRow(int size) {
        this.cells = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            this.cells.add(null);
        }
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isMergeable() {
        return KDTMark.isMergeable(this.mark);
    }

    public void setMergeable(boolean newValue) {
        this.mark = KDTMark.setMergeable(this.mark, newValue);
    }

    public boolean isResizeable() {
        return KDTMark.isResizeable(this.mark);
    }

    public void setResizeable(boolean newValue) {
        this.mark = KDTMark.setResizeable(this.mark, newValue);
    }

    public boolean isStat() {
        return KDTMark.isStat(this.mark);
    }

    public void setStat(boolean newValue) {
        this.mark = KDTMark.setStat(this.mark, newValue);
    }

    public boolean isChange() {
        return KDTMark.isChange(this.mark);
    }

    public void setChange(boolean newValue) {
        this.mark = KDTMark.setChange(this.mark, newValue);
    }

    public int getTreeLevel() {
        return KDTMark.getTreeLevel(this.mark);
    }

    public void setTreeLevel(int treeLevel) {
        this.mark = KDTMark.setTreeLevel(this.mark, treeLevel);
    }

    public boolean isCollapse() {
        return KDTMark.isCollapse(this.mark);
    }

    public void setCollapse(boolean newValue) {
        this.mark = KDTMark.setCollapse(this.mark, newValue);
    }

    public KDTCell addCell() {
        KDTCell cell = new KDTCell();
        return this.addCell(this.cells.size(), cell);
    }

    public KDTCell addCell(KDTCell cell) {
        return this.addCell(this.cells.size(), cell);
    }

    public KDTCell addCell(int cellIndex) {
        KDTCell cell = new KDTCell();
        return this.addCell(cellIndex, cell);
    }

    public KDTCell addCell(int cellIndex, KDTCell cell) {
        if (cellIndex >= 0 && cellIndex <= this.cells.size()) {
            this.cells.add(cellIndex, cell);
        } else if (cellIndex > this.cells.size()) {
            CollectionUtil.resizeList((List)this.cells, (int)(cellIndex + 1));
            this.cells.add(cellIndex, cell);
        }
        return cell;
    }

    public KDTCell setCell(int cellIndex, KDTCell cell) {
        if (cellIndex >= 0 && cellIndex < this.cells.size()) {
            this.cells.set(cellIndex, cell);
        } else if (cellIndex >= this.cells.size()) {
            CollectionUtil.resizeList((List)this.cells, (int)(cellIndex + 1));
            this.cells.set(cellIndex, cell);
        }
        return cell;
    }

    public void removeCell(int cellIndex) {
        if (cellIndex < 0 || cellIndex >= this.cells.size()) {
            return;
        }
        this.cells.remove(cellIndex);
    }

    public void exchangeCell(int cellIndex1, int cellIndex2) {
    }

    public KDTCell getCell(int cellIndex) {
        if (cellIndex < 0 || cellIndex >= this.cells.size()) {
            return null;
        }
        return (KDTCell)this.cells.get(cellIndex);
    }

    public ArrayList getCells() {
        return this.cells;
    }

    public KDTDataStyle getDataStyle() {
        return this.dataStyle;
    }

    public void setDataStyle(KDTDataStyle dataStyle) {
        this.dataStyle = dataStyle;
    }

    public Object getUserObject() {
        if (this.dataStyle != null) {
            return this.dataStyle.getUserObject();
        }
        return null;
    }

    public void setUserObject(Object object) {
        if (this.dataStyle == null) {
            this.dataStyle = new KDTDataStyle();
        }
        this.dataStyle.setUserObject(object);
    }

    public String getExpressions() {
        if (this.macroInfo != null) {
            return this.macroInfo.getExpressions();
        }
        return null;
    }

    public void setExpressions(String expressions) {
        if (this.macroInfo == null) {
            this.macroInfo = new MacroInfo();
        }
        this.macroInfo.setExpressions(expressions);
    }

    public boolean isEmpty() {
        if (this.height != -1 || this.getExpressions() != null || this.getUserObject() != null) {
            return false;
        }
        if (this.cells != null && this.cells.size() > 0) {
            for (KDTCell cell : this.cells) {
                if (cell == null || cell.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }
}

