/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.servertable;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.util.ObjectUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDTableMessages;
import com.kingdee.cosmic.ctrl.kdf.expr.TableRelations;
import com.kingdee.cosmic.ctrl.kdf.servertable.ICell;
import com.kingdee.cosmic.ctrl.kdf.servertable.IColumn;
import com.kingdee.cosmic.ctrl.kdf.servertable.IRow;
import com.kingdee.cosmic.ctrl.kdf.servertable.IRows;
import com.kingdee.cosmic.ctrl.kdf.servertable.KDTCell;
import com.kingdee.cosmic.ctrl.kdf.servertable.KDTRow;
import com.kingdee.cosmic.ctrl.kdf.servertable.KDTable;
import com.kingdee.cosmic.ctrl.kdf.util.file.IXmlTrans;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDF;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDFXmlReader;
import java.util.List;

public final class KDTableXmlTrans
implements IXmlTrans {
    private KDTable table;
    private TableRelations tableRelations;

    public IXmlElement writeToNode(Object obj, KDF kdf) {
        if (!(obj instanceof KDTable)) {
            throw new IllegalArgumentException(CtrlKDTableMessages.getMLS("KDTableSerializerAcceptsOnlyKDTableType", "KDTable\u7684\u5e8f\u5217\u5316\u5668\u53ea\u80fd\u63a5\u53d7KDTable\u7c7b\u578b\u7684\u53c2\u6570"));
        }
        this.table = (KDTable)obj;
        return this.out(kdf);
    }

    public Object readFromNode(IXmlElement ele, KDF kdf) {
        return this.readFromNode(ele, kdf.getReader());
    }

    public Object readFromNode(IXmlElement ele, KDFXmlReader reader) {
        this.table = new KDTable();
        this.table.getScriptManager().setRelationsObject(this.getTableRelations());
        this.parse(ele);
        return this.table;
    }

    IXmlElement out(KDF kdf) {
        if (null == kdf) {
            throw new IllegalArgumentException(CtrlKDTableMessages.getMLS("KDTableSerializationMethodRequiresNonNullParam", "KDTable\u5e8f\u5217\u5316\u65b9\u6cd5\u9700\u8981\u975e\u7a7a\u7684\u53c2\u6570\uff1akdf"));
        }
        IXmlElement nodeKDTable = XmlUtil.createNode((String)"Table");
        if (this.isEmptyString(this.table.getID())) {
            this.table.setID(KDF.getDefaultID());
        }
        this.setNodeAttribute(nodeKDTable, "id", this.table.getID());
        IXmlElement nodeDataStyles = XmlUtil.createNode((String)"DataStyles");
        nodeKDTable.addChild(nodeDataStyles);
        IXmlElement nodeSheet = XmlUtil.createNode((String)"Sheet");
        nodeKDTable.addChild(nodeSheet);
        this.buildSheet(nodeSheet);
        return nodeKDTable;
    }

    private void buildSheet(IXmlElement nodeSheet) {
        nodeSheet.setAttribute("name", "NotSupportedInThisVersion");
        IXmlElement nodeTable = XmlUtil.createNode((String)"Table");
        this.buildTable(nodeTable);
        nodeSheet.addChild(nodeTable);
        IXmlElement nodeOptions = XmlUtil.createNode((String)"SheetOptions");
        this.buildSheetOptions(nodeOptions);
        nodeSheet.addChild(nodeOptions);
    }

    private void buildSheetOptions(IXmlElement nodeOptions) {
        IXmlElement nodeGridLine = XmlUtil.createNode((String)"GridLine");
        this.setNodeAttribute(nodeGridLine, "headVertical", this.table.isVerticalHeadGridLineVisible() ? "true" : "false");
        this.setNodeAttribute(nodeGridLine, "headHorizon", this.table.isHorizonHeadGridLineVisible() ? "true" : "false");
        this.setNodeAttribute(nodeGridLine, "bodyVertical", this.table.isVerticalGridLineVisible() ? "true" : "false");
        this.setNodeAttribute(nodeGridLine, "bodyHorizon", this.table.isHorizonGridLineVisible() ? "true" : "false");
        nodeOptions.addChild(nodeGridLine);
    }

    private void buildTable(IXmlElement nodeTable) {
        String value;
        this.setTableAttributes(nodeTable);
        IXmlElement nodeColGroup = XmlUtil.createNode((String)"ColumnGroup");
        nodeTable.addChild(nodeColGroup);
        IXmlElement nodeHead = XmlUtil.createNode((String)"Head");
        this.buildNodeHead(nodeHead);
        nodeTable.addChild(nodeHead);
        IXmlElement nodeBody = XmlUtil.createNode((String)"Body");
        nodeTable.addChild(nodeBody);
        Object uo = this.table.getUserObject();
        if (uo != null && (value = ObjectUtil.objectToString((Object)uo)) != null) {
            IXmlElement nodeUO = XmlUtil.createNode((String)"UserObject");
            nodeUO.addCData(value);
            nodeTable.addChild(nodeUO);
        }
    }

    private void setTableAttributes(IXmlElement nodeTable) {
        this.setNodeAttribute(nodeTable, "rowHeight", String.valueOf(this.table.getDefaultRowHeight()));
        this.setNodeAttribute(nodeTable, "headRowHeight", String.valueOf(this.table.getDefaultHeadRowHeight()));
        this.setNodeAttribute(nodeTable, "columnWidth", String.valueOf(this.table.getDefaultColumnWidth()));
    }

    private void setNodeAttribute(IXmlElement node, String attrName, String value) {
        if (StringUtil.isEmptyString((String)attrName) || StringUtil.isEmptyString((String)value)) {
            return;
        }
        node.setAttribute(attrName, value);
    }

    private void buildNodeHead(IXmlElement nodeHead) {
        this.buildRowsNode(nodeHead, this.table.getHead(), this.table.getHeadRowCount());
    }

    private void buildRowsNode(IXmlElement nodeRows, IRows rows, int rowCount) {
        for (int i = 0; i < rowCount; ++i) {
            IXmlElement nodeRow = XmlUtil.createNode((String)"Row");
            this.buildRow(nodeRow, rows.getRow(i));
            nodeRows.addChild(nodeRow);
        }
    }

    private void buildRow(IXmlElement nodeRow, KDTRow row) {
        String str;
        this.setNodeAttribute(nodeRow, "mergeable", String.valueOf(row.isMergeable()));
        this.setNodeAttribute(nodeRow, "resizeable", String.valueOf(row.isResizeable()));
        this.setNodeAttribute(nodeRow, "height", String.valueOf(row.getHeight()));
        int size = row.getCells().size();
        for (int i = 0; i < size; ++i) {
            IXmlElement nodeCell = XmlUtil.createNode((String)"Cell");
            this.buildCell(nodeCell, row.getCell(i));
            nodeRow.addChild(nodeCell);
        }
        Object obj = row.getUserObject();
        if (obj != null && (str = ObjectUtil.objectToString((Object)obj)) != null) {
            IXmlElement nodeUO = XmlUtil.createNode((String)"UserObject");
            nodeUO.addCData(str);
            nodeRow.addChild(nodeUO);
        }
    }

    private void buildCell(IXmlElement nodeCell, KDTCell cell) {
        IXmlElement node;
        if (null == cell || cell.isEmpty()) {
            return;
        }
        String value = ObjectUtil.objectToString((Object)cell.getValue());
        if (value != null) {
            node = XmlUtil.createNode((String)"Value");
            node.addCData(value);
            nodeCell.addChild(node);
        }
        if ((value = ObjectUtil.objectToString((Object)cell.getUserObject())) != null) {
            node = XmlUtil.createNode((String)"UserObject");
            node.addCData(value);
            nodeCell.addChild(node);
        }
        if (!this.isEmptyString(value = cell.getExpressions())) {
            node = XmlUtil.createNode((String)"Expression");
            node.addCData(value);
            nodeCell.addChild(node);
        }
    }

    void parse(IXmlElement nodeKDTable) {
        boolean autoRun = this.table.isScriptAutoRun();
        this.table.setScriptAutoRun(false);
        String id = nodeKDTable.getAttribute("id");
        if (!this.isEmptyString(id)) {
            this.table.setID(id);
        }
        IXmlElement nodeTable = null;
        try {
            nodeTable = nodeKDTable.getChild("Sheet").getChild("Table");
        }
        catch (Exception e) {
            return;
        }
        if (nodeTable == null) {
            return;
        }
        this.fillTable(nodeTable);
        IXmlElement nodeSheetOptions = nodeKDTable.getChild("Sheet").getChild("SheetOptions");
        if (null != nodeSheetOptions) {
            this.fillSheetOptions(nodeSheetOptions);
        }
        this.table.setScriptAutoRun(autoRun);
    }

    private void fillSheetOptions(IXmlElement nodeSheetOptions) {
        IXmlElement nodeGridLine = nodeSheetOptions.getChild("GridLine");
        this.parseGridLine(nodeGridLine);
        IXmlElement nodeMerges = nodeSheetOptions.getChild("MergeBlocks");
        this.parseMergeBlocks(nodeMerges);
    }

    private void parseMergeBlocks(IXmlElement nodeMerges) {
        if (null == nodeMerges) {
            return;
        }
    }

    private void parseGridLine(IXmlElement nodeGridLine) {
        if (null == nodeGridLine) {
            return;
        }
        String sVal = nodeGridLine.getAttribute("headVertical");
        this.table.setVerticalHeadGridLineVisible(this.getBooleanFromString(sVal));
        sVal = nodeGridLine.getAttribute("headHorizon");
        this.table.setHorizonHeadGridLineVisible(this.getBooleanFromString(sVal));
        sVal = nodeGridLine.getAttribute("bodyVertical");
        this.table.setVerticalGridLineVisible(this.getBooleanFromString(sVal));
        sVal = nodeGridLine.getAttribute("bodyHorizon");
        this.table.setHorizonGridLineVisible(this.getBooleanFromString(sVal));
    }

    private boolean isEmptyString(String value) {
        return null == value || value.trim().equals("");
    }

    private boolean getBooleanFromString(String s) {
        return s != null && (s.equalsIgnoreCase("true") || s.equals("1"));
    }

    private void fillTable(IXmlElement nodeTable) {
        Object uo;
        this.fillTableAttributes(this.table, nodeTable);
        IXmlElement e = nodeTable.getChild("ColumnGroup");
        if (e != null) {
            this.fillColumns(e);
        }
        if ((e = nodeTable.getChild("Head")) != null) {
            this.fillHead(e);
        }
        if ((e = nodeTable.getChild("Body")) != null) {
            this.fillBody(e);
        }
        if ((e = nodeTable.getChild("UserObject")) != null && (uo = ObjectUtil.stringToObject((String)e.getText())) != null) {
            this.table.setUserObject(uo);
        }
    }

    private void fillColumns(IXmlElement e) {
        List list1 = e.searchChildren("Column");
        for (int i = 0; i < list1.size(); ++i) {
            IXmlElement colNode = (IXmlElement)list1.get(i);
            this.fillColAttributes(i, colNode);
        }
    }

    private void fillHead(IXmlElement e) {
        int i;
        List list1 = e.searchChildren("Row");
        IRow[] rows = new IRow[list1.size()];
        for (i = 0; i < rows.length; ++i) {
            rows[i] = this.table.addHeadRow(i);
        }
        for (i = 0; i < rows.length; ++i) {
            IRow row = rows[i];
            IXmlElement rowNode = (IXmlElement)list1.get(i);
            this.fillRowAttributes(row, rowNode);
            List list2 = rowNode.searchChildren("Cell");
            for (int j = 0; j < list2.size(); ++j) {
                ICell cell;
                IXmlElement cellNode = (IXmlElement)list2.get(j);
                int cellIndex = j;
                String value = cellNode.getAttribute("index");
                if (!this.isEmptyString(value)) {
                    cellIndex = Integer.parseInt(value);
                }
                if ((cell = row.getCell(cellIndex)) == null) continue;
                this.fillCellAttributes(cell, cellNode);
            }
        }
    }

    private void fillBody(IXmlElement e) {
        List list1 = e.searchChildren("Row");
        for (int i = 0; i < list1.size(); ++i) {
            IRow row = this.table.addRow(i);
            IXmlElement rowNode = (IXmlElement)list1.get(i);
            this.fillRowAttributes(row, rowNode);
            List list2 = rowNode.searchChildren("Cell");
            for (int j = 0; j < list2.size(); ++j) {
                IXmlElement cellNode = (IXmlElement)list2.get(j);
                ICell cell = row.getCell(j);
                if (cell == null) continue;
                this.fillCellAttributes(cell, cellNode);
            }
        }
    }

    private void fillTableAttributes(KDTable objTable, IXmlElement objXml) {
        String attVal = objXml.getAttribute("columnWidth");
        if (!this.isEmptyString(attVal)) {
            objTable.setDefaultColumnWidth(Integer.parseInt(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("headRowHeight"))) {
            objTable.setDefaultHeadRowHeight(Integer.parseInt(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("rowHeight"))) {
            objTable.setDefaultRowHeight(Integer.parseInt(attVal));
        }
        attVal = objXml.getAttribute("selectMode");
    }

    private void fillColAttributes(int colIndex, IXmlElement objXml) {
        Object uo;
        IXmlElement e;
        IColumn col = this.table.addColumn(colIndex);
        if (col == null) {
            return;
        }
        String attVal = objXml.getAttribute("width");
        if (!this.isEmptyString(attVal)) {
            col.setWidth(Integer.parseInt(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("key"))) {
            col.setKey(attVal);
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("mergeable"))) {
            col.setMergeable(this.getBooleanFromString(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("resizeable"))) {
            col.setResizeable(this.getBooleanFromString(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("moveable"))) {
            col.setMoveable(this.getBooleanFromString(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("group"))) {
            col.setGroup(this.getBooleanFromString(attVal));
        }
        if ((e = objXml.getChild("UserObject")) != null && (uo = ObjectUtil.stringToObject((String)e.getText())) != null) {
            col.setUserObject(uo);
        }
    }

    private void fillRowAttributes(IRow objTable, IXmlElement objXml) {
        Object uo;
        IXmlElement e;
        String attVal = objXml.getAttribute("height");
        if (!this.isEmptyString(attVal)) {
            objTable.setHeight(Integer.parseInt(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("mergeable"))) {
            objTable.setMergeable(this.getBooleanFromString(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("resizeable"))) {
            objTable.setResizeable(this.getBooleanFromString(attVal));
        }
        if ((e = objXml.getChild("UserObject")) != null && (uo = ObjectUtil.stringToObject((String)e.getText())) != null) {
            objTable.setUserObject(uo);
        }
    }

    private void fillCellAttributes(ICell objCell, IXmlElement objXml) {
        String attVal;
        Object obj;
        if (objXml.getChildren().size() == 0) {
            String attVal2 = objXml.getText();
            if (attVal2 != null) {
                objCell.setValue(attVal2);
            }
            return;
        }
        IXmlElement node = objXml.getChild("UserObject");
        if (node != null && (obj = ObjectUtil.stringToObject((String)(attVal = node.getText()))) != null) {
            objCell.getKDTCell().setUserObject(obj);
        }
        if ((node = objXml.getChild("Expression")) != null && !this.isEmptyString(attVal = node.getText())) {
            objCell.setExpressions(attVal);
        }
        if ((node = objXml.getChild("Value")) != null) {
            attVal = node.getText();
            obj = ObjectUtil.stringToObject((String)attVal);
            if (obj != null) {
                objCell.getKDTCell().setValue(obj);
            } else if (attVal != null) {
                objCell.getKDTCell().setValue(attVal);
            }
        }
    }

    private TableRelations getTableRelations() {
        if (this.tableRelations == null) {
            this.tableRelations = new TableRelations();
        }
        return this.tableRelations;
    }
}

