/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.kdf.table.IBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.util.style.Border;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import javax.swing.JComponent;

public class BasicView
extends JComponent {
    private static final long serialVersionUID = 1360768700053773644L;
    public static final int TOP = 1;
    public static final int LEFT = 2;
    public static final int BOTTOM = 4;
    public static final int RIGHT = 8;
    public static final int TOP_LEFT = 3;
    public static final int TOP_RIGHT = 9;
    public static final int BOTTOM_LEFT = 6;
    public static final int BOTTOM_RIGHT = 12;
    public static final int VIEW_BODY = 1;
    public static final int VIEW_HEAD = 2;
    public static final int VIEW_INDEXCOLUMN = 3;
    public static final int VIEW_CORNER = 4;
    protected int viewType = 0;
    protected int index;
    protected KDTable table;

    public BasicView(KDTable table) {
        this(table, 0);
    }

    public BasicView(KDTable table, int index) {
        this.table = table;
        this.index = index;
        this.init();
    }

    private void init() {
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public Rectangle getCellRectangle(int rowIndex, int colIndex) {
        return null;
    }

    public Object clone() {
        BasicView view = new BasicView(this.table, this.index);
        return view;
    }

    protected void drawTopBorder(Graphics2D g, Rectangle rect, Style style) {
        Border border = null;
        if (style != null) {
            border = style.getBorder(Styles.Position.TOP);
        }
        if (border == null || border.isNull()) {
            return;
        }
        Stroke oldStroke = g.getStroke();
        int left = rect.x;
        int top = rect.y - 1;
        int right = rect.x + rect.width - 1;
        g.setColor(border.getColor());
        g.setStroke(border.getStroke());
        g.drawLine(left, top, right, top);
        g.setStroke(oldStroke);
    }

    protected void drawLeftBorder(Graphics2D g, Rectangle rect, Style style) {
        Border border = null;
        if (style != null) {
            border = style.getBorder(Styles.Position.LEFT);
        }
        if (border == null || border.isNull()) {
            return;
        }
        Stroke oldStroke = g.getStroke();
        int top = rect.y;
        int bottom = rect.y + rect.height - 1;
        int left = rect.x - 1;
        g.setColor(border.getColor());
        g.setStroke(border.getStroke());
        g.drawLine(left, top, left, bottom);
        g.setStroke(oldStroke);
    }

    protected void drawBottomBorder(Graphics2D g, Rectangle rect, Style style) {
        this.drawBottomBorder(g, rect, style, false);
    }

    protected void drawBottomBorder(Graphics2D g, Rectangle rect, Style style, boolean veritcalLine) {
        Border border = null;
        if (style != null) {
            border = style.getBorder(Styles.Position.BOTTOM);
        }
        if (border == null || border.isNull()) {
            if (veritcalLine || this.table.isVerticalGridLineVisible()) {
                int left = rect.x;
                int top = rect.y + rect.height - 1;
                int right = rect.x + rect.width - 1;
                g.setColor(this.table.getGridLineColor());
                g.drawLine(left, top, right, top);
            }
            return;
        }
        Stroke oldStroke = g.getStroke();
        int weight = border.getLineStyle().getWidth();
        if (weight > 1) {
            --weight;
        }
        int left = rect.x;
        int top = rect.y + rect.height - weight;
        int right = rect.x + rect.width - 1;
        g.setColor(border.getColor());
        g.setStroke(border.getStroke());
        g.drawLine(left, top, right, top);
        g.setStroke(oldStroke);
    }

    protected void drawRightBorder(Graphics2D g, Rectangle rect, Style style) {
        this.drawRightBorder(g, rect, style, false);
    }

    protected void drawRightBorder(Graphics2D g, Rectangle rect, Style style, boolean horizonLine) {
        Border border = null;
        if (style != null) {
            border = style.getBorder(Styles.Position.RIGHT);
        }
        if (border == null || border.isNull()) {
            if (horizonLine || this.table.isHorizonGridLineVisible()) {
                int top = rect.y;
                int bottom = rect.y + rect.height - 1;
                int left = rect.x + rect.width - 1;
                g.setColor(this.table.getGridLineColor());
                g.drawLine(left, top, left, bottom);
            }
            return;
        }
        Stroke oldStroke = g.getStroke();
        int weight = border.getLineStyle().getWidth();
        if (weight > 1) {
            --weight;
        }
        int top = rect.y;
        int bottom = rect.y + rect.height - 1;
        int left = rect.x + rect.width - weight;
        g.setColor(border.getColor());
        g.setStroke(border.getStroke());
        g.drawLine(left, top, left, bottom);
        g.setStroke(oldStroke);
    }

    public void scroll(IBlock oldPage, IBlock newPage) {
    }

    public void accommodateDelta(int col, int dela) {
    }

    public void setWidthsFromPreferredWidths(boolean inverse) {
    }

    public int getActiveHeight() {
        return 0;
    }

    public int getActiveWidth() {
        return 0;
    }

    public void updateBounds() {
    }

    public int getViewType() {
        return this.viewType;
    }
}

