/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.common.GlobalLocator;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDTableMessages;
import com.kingdee.cosmic.ctrl.kdf.table.KDTIOManager;
import com.kingdee.cosmic.ctrl.kdf.table.ProgramElement;
import com.kingdee.cosmic.ctrl.kdf.table.ProgramList;
import com.kingdee.cosmic.ctrl.kdf.table.ProgramProgress;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.MessageDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class DefaultProgressImpl
extends KDDialog
implements KDTIOManager.ProgressListener {
    private static final Logger logger = LogUtil.getPackageLogger(DefaultProgressImpl.class);
    public static final long serialVersionUID = 0L;
    private KDScrollPane scroll;
    private ProgramList containerList;
    private KDButton abort;
    private KDButton openDir;
    private KDLabel tipLabel;
    private int total;
    private String dirPath;
    private boolean userAborted = false;
    private boolean allCompleted = false;
    private Thread exportThread;

    static final String getTranslating() {
        return CtrlKDTableMessages.getMLS("translating", "\u5bfc\u51fa\u4e2d...");
    }

    static final String getComplete() {
        return CtrlKDTableMessages.getMLS("complete", "\u5b8c\u6210");
    }

    static final String getWaiting() {
        return CtrlKDTableMessages.getMLS("waiting", "\u7b49\u5f85\u4e2d...");
    }

    static final String getAborted() {
        return CtrlKDTableMessages.getMLS("aborted", "\u5f02\u5e38\u7ec8\u6b62.");
    }

    static final String getExportText1() {
        return CtrlKDTableMessages.getMLS("exportText1", "\u5bfc\u51fa\u8fdb\u884c\u4e2d(\u603b\u4efb\u52a1\u6570\u91cf:");
    }

    static final String getExportText2() {
        return CtrlKDTableMessages.getMLS("exportText2", ")");
    }

    static final String getExportFinished() {
        return CtrlKDTableMessages.getMLS("exportFinished", "\u5bfc\u51fa\u5168\u90e8\u5b8c\u6210.");
    }

    static final String getExportState() {
        return CtrlKDTableMessages.getMLS("exportState", " \u5f53\u524d\u6b63\u5728\u5bfc\u51fa:");
    }

    public DefaultProgressImpl(Frame parent, String dirPath) {
        super(parent);
        this.init(parent, dirPath);
    }

    public DefaultProgressImpl(Dialog parent, String dirPath) {
        super(parent);
        this.init(parent, dirPath);
    }

    public DefaultProgressImpl(String dirPath) {
        this.init(null, dirPath);
    }

    @Override
    public void updateConnectTime() {
        this.startTask(null);
    }

    private void init(Window parent, String dirPath) {
        this.dirPath = dirPath;
        this.setModal(true);
        this.init();
        this.initCompoenet(parent);
        this.initListener();
    }

    private void initCompoenet(Window parent) {
        this.setFocusTraversalKeysEnabled(false);
        this.abort = new KDButton(CtrlKDTableMessages.getMLS("interruptedExport", "\u4e2d\u65ad\u5bfc\u51fa"));
        this.abort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DefaultProgressImpl.this.allCompleted) {
                    if (DefaultProgressImpl.this.userAborted) {
                        DefaultProgressImpl.this.setUserAborted(true);
                    } else if (MessageDialog.show((Component)((Object)DefaultProgressImpl.this), (Object)CtrlKDTableMessages.getMLS("terminateExportWillCloseDialog", "\u7ec8\u6b62\u5bfc\u51fa\u5c06\u5173\u95ed\u5bf9\u8bdd\u6846!\n\u5c06\u5728\u5bfc\u51fa\u5b8c\u5f53\u524d\u6587\u4ef6\u4e4b\u540e\u4e2d\u65ad.\n\u662f\u5426\u4e2d\u65ad\u5bfc\u51fa?"), (String)CtrlKDTableMessages.getMLS("infoTips", "\u4fe1\u606f\u63d0\u793a"), (int)0) == 0) {
                        DefaultProgressImpl.this.setUserAborted(true);
                    }
                } else if (DefaultProgressImpl.this.allCompleted && DefaultProgressImpl.this.isVisible()) {
                    DefaultProgressImpl.this.display(false);
                }
            }
        });
        this.openDir = new KDButton(CtrlKDTableMessages.getMLS("openFolder", "\u6253\u5f00\u6587\u4ef6\u5939"));
        this.openDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DefaultProgressImpl.openDir(DefaultProgressImpl.this.dirPath);
                }
                catch (IOException ex) {
                    MessageDialog.show((Component)((Object)DefaultProgressImpl.this), (Object)CtrlKDTableMessages.getMLS("openFileFailed2", "\u6253\u5f00\u6587\u4ef6\u5939\u5931\u8d25!"), (String)CtrlKDTableMessages.getMLS("tipsInfo", "\u63d0\u793a\u4fe1\u606f"), (int)2);
                }
            }
        });
        this.scroll.setPreferredSize(new Dimension(350, 250));
        this.tipLabel = new KDLabel();
        this.tipLabel.setText(DefaultProgressImpl.getExportText1() + CtrlKDTableMessages.getMLS("unknown", "\u672a\u77e5") + DefaultProgressImpl.getExportText2());
        this.add((Component)this.scroll);
        this.add((Component)this.tipLabel);
        this.add((Component)this.abort);
        this.add((Component)this.openDir);
        this.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void layoutContainer(Container parent) {
                Dimension size = DefaultProgressImpl.this.scroll.getPreferredSize();
                int x = parent.getX() + parent.getWidth() / 2 - size.width / 2;
                int y = parent.getY() + parent.getHeight() / 2 - size.height / 2;
                DefaultProgressImpl.this.tipLabel.setBounds(x, y - 20, 350, 19);
                DefaultProgressImpl.this.scroll.setBounds(x, y, size.width, size.height);
                size = DefaultProgressImpl.this.abort.getPreferredSize();
                x = parent.getX() + parent.getWidth() / 2 - size.width / 2;
                y = DefaultProgressImpl.this.scroll.getY() + DefaultProgressImpl.this.scroll.getHeight() + 5;
                DefaultProgressImpl.this.abort.setBounds(x - 80, y, size.width - 20, size.height);
                DefaultProgressImpl.this.openDir.setBounds(x + 80, y, size.width - 20, size.height);
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return null;
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return null;
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }
        });
    }

    private void init() {
        this.setTitle(CtrlKDTableMessages.getMLS("exportProgress", "\u5bfc\u51fa\u8fdb\u5ea6"));
        this.containerList = new ProgramList();
        this.scroll = new KDScrollPane((Component)this.containerList);
        this.setSize(460, 350);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(0);
    }

    @Override
    public void setExportThread(Thread exportThread) {
        this.exportThread = exportThread;
    }

    @Override
    public void display(boolean b) {
        try {
            if (!b) {
                this.dispose();
            } else {
                this.setVisible(b);
            }
        }
        catch (Exception ex) {
            this.setVisible(false);
            this.dispose();
            logger.error((Object)"err", (Throwable)ex);
        }
    }

    public void paintComponents(Graphics g) {
        super.paintComponents(g);
    }

    @Override
    public void stopTask(Object key, String absoluteFilePath) {
        this.containerList.stopTask(key, absoluteFilePath);
    }

    @Override
    public void startTask(Object key) {
        if (key == null) {
            return;
        }
        this.containerList.startTask(key);
        this.tipLabel.setText(DefaultProgressImpl.getExportText1() + (this.total == 0 ? CtrlKDTableMessages.getMLS("unknown", "\u672a\u77e5") : String.valueOf(this.total)) + DefaultProgressImpl.getExportText2() + DefaultProgressImpl.getExportState() + key);
    }

    public void abortTask(Object key) {
        ProgramElement ele = this.containerList.getElementByName(key);
        ele.setStatus(DefaultProgressImpl.getAborted());
    }

    @Override
    public void allCompleted() {
        this.repaint();
        this.allCompleted = true;
        this.tipLabel.setText(DefaultProgressImpl.getExportFinished());
        this.abort.setText(CtrlKDTableMessages.getMLS("exportCompleted", "\u5bfc\u51fa\u5b8c\u6210"));
        this.abort.setToolTipText(CtrlKDTableMessages.getMLS("exitExportInterface", "\u79bb\u5f00\u5bfc\u51fa\u754c\u9762"));
        if (!this.userAborted) {
            MessageDialog.show((Component)((Object)this), (Object)CtrlKDTableMessages.getMLS("exportAllComplete", "\u5bfc\u51fa\u5168\u90e8\u5b8c\u6210!\n\u5efa\u8bae\u91cd\u65b0\u6253\u5f00\u672c\u5355\u636e\u4ee5\u8fdb\u884c\u6d4f\u89c8."), (String)CtrlKDTableMessages.getMLS("tipsInfo", "\u63d0\u793a\u4fe1\u606f"), (int)-1, (int)1);
        } else if (MessageDialog.show((Component)((Object)this), (Object)CtrlKDTableMessages.getMLS("interruptExportSuccess", "\u4e2d\u65ad\u5bfc\u51fa\u6210\u529f!\n\u662f\u5426\u5173\u95ed\u5bfc\u51fa\u754c\u9762?"), (String)CtrlKDTableMessages.getMLS("infoTips", "\u4fe1\u606f\u63d0\u793a"), (int)0) == 0) {
            this.display(false);
        }
        try {
            this.containerList.revalidate();
        }
        catch (Throwable th) {
            logger.error((Object)"err", th);
        }
    }

    @Override
    public void addTask(Object taskName) {
        ProgramProgress progress = new ProgramProgress((Component)((Object)this));
        ProgramElement ele = new ProgramElement(taskName, progress);
        this.containerList.addElement(ele);
    }

    @Override
    public void setTaskNumber(int taskNumber) {
        this.total = taskNumber;
        this.tipLabel.setText(DefaultProgressImpl.getExportText1() + this.total + DefaultProgressImpl.getExportText2());
    }

    private void initListener() {
        this.containerList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ProgramElement ele;
                Object value = DefaultProgressImpl.this.containerList.getSelectedValue();
                if (e.getClickCount() == 2 && value instanceof String && (ele = DefaultProgressImpl.this.containerList.getElementByName(value)).getStatus().equals(DefaultProgressImpl.getComplete())) {
                    try {
                        DefaultProgressImpl.openFileInExcel(ele.getAbsoluteFilePath());
                    }
                    catch (IOException ex) {
                        MessageDialog.show((Component)((Object)DefaultProgressImpl.this), (Object)CtrlKDTableMessages.getMLS("openFileFailed", "\u6253\u5f00\u6587\u4ef6\u5931\u8d25\n\u8bf7\u53c2\u8003\u65e5\u5fd7\u4ee5\u83b7\u53d6\u66f4\u591a\u4fe1\u606f"), (String)CtrlKDTableMessages.getMLS("tipsInfo", "\u63d0\u793a\u4fe1\u606f"), (int)-1);
                        logger.error((Object)"err", (Throwable)ex);
                    }
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!DefaultProgressImpl.this.allCompleted) {
                    if (DefaultProgressImpl.this.userAborted) {
                        DefaultProgressImpl.this.setUserAborted(true);
                    } else if (MessageDialog.show((Component)((Object)DefaultProgressImpl.this), (Object)CtrlKDTableMessages.getMLS("closeDialogWillTerminateExport", CtrlKDTableMessages.getMLS("closeDialogWillTerminateExport2", "\u5173\u95ed\u5bf9\u8bdd\u6846\u5c06\u7ec8\u6b62\u5bfc\u51fa!\n\u5c06\u5728\u5bfc\u51fa\u5b8c\u5f53\u524d\u6587\u4ef6\u4e4b\u540e\u4e2d\u65ad.\n\u662f\u5426\u4e2d\u65ad\u5bfc\u51fa?")), (String)CtrlKDTableMessages.getMLS("infoTips", "\u4fe1\u606f\u63d0\u793a"), (int)0) == 0) {
                        DefaultProgressImpl.this.setUserAborted(true);
                    }
                } else {
                    DefaultProgressImpl.this.dispose();
                }
            }
        });
    }

    private static void openFileInExcel(String file) throws IOException {
        File f = GlobalLocator.getInstance().locateResourceFile("/client/LanchFile.bat");
        if (f == null) {
            throw new IOException();
        }
        Runtime.getRuntime().exec("\"" + f.getAbsolutePath() + "\" \"excel\" \"" + file + "\"");
    }

    private static void openDir(String dirPath) throws IOException {
        File f = GlobalLocator.getInstance().locateResourceFile("/client/LanchFile.bat");
        if (f == null) {
            throw new IOException();
        }
        Runtime.getRuntime().exec("\"" + f.getAbsolutePath() + "\" \"explorer\" \"" + dirPath + "\"");
    }

    @Override
    public boolean isUserAborted() {
        return this.userAborted;
    }

    private void setUserAborted(boolean userAborted) {
        if (this.userAborted) {
            MessageDialog.show((Component)((Object)this), (Object)CtrlKDTableMessages.getMLS("requestedToInterruptExport", "\u5df2\u7ecf\u53d1\u8d77\u4e2d\u65ad\u5bfc\u51fa\u8bf7\u6c42,\u5c06\u5728\u5f53\u524d\u6587\u4ef6\u5bfc\u51fa\u5b8c\u6210\u4e4b\u540e\u7ec8\u6b62\u672c\u6b21\u5bfc\u51fa!"), (String)CtrlKDTableMessages.getMLS("infoTips", "\u4fe1\u606f\u63d0\u793a"), (int)2);
        }
        this.userAborted = userAborted;
    }
}

