/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.kdf.table.IBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;

public class KDTBlock
implements IBlock,
Comparable<KDTBlock> {
    protected int left;
    protected int right;
    protected int top;
    protected int bottom;
    protected int mode;

    public KDTBlock() {
    }

    public KDTBlock(int top, int left, int bottom, int right) {
        this(top, left, bottom, right, 1);
    }

    public KDTBlock(int top, int left, int bottom, int right, int mode) {
        this.left = left;
        this.right = right;
        this.top = top;
        this.bottom = bottom;
        this.mode = mode;
    }

    @Override
    public int getBottom() {
        return this.top > this.bottom ? this.top : this.bottom;
    }

    @Override
    public int getLeft() {
        return this.left < this.right ? this.left : this.right;
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public int getRight() {
        return this.left > this.right ? this.left : this.right;
    }

    @Override
    public int getTop() {
        return this.top < this.bottom ? this.top : this.bottom;
    }

    @Override
    public void setBottom(int bottom) {
        this.bottom = bottom;
    }

    @Override
    public void setLeft(int left) {
        this.left = left;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
    }

    @Override
    public void setRight(int right) {
        this.right = right;
    }

    @Override
    public void setTop(int top) {
        this.top = top;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KDTBlock)) {
            return false;
        }
        KDTBlock block = (KDTBlock)obj;
        if (this.getMode() == block.getMode()) {
            switch (this.getMode()) {
                case 1: {
                    if (this.getLeft() != block.getLeft() || this.getRight() != block.getRight() || this.getTop() != block.getTop() || this.getBottom() != block.getBottom()) break;
                    return true;
                }
                case 2: {
                    if (this.getTop() != block.getTop() || this.getBottom() != block.getBottom()) break;
                    return true;
                }
                case 4: {
                    if (this.getLeft() != block.getLeft() || this.getRight() != block.getRight()) break;
                    return true;
                }
                case 8: {
                    return true;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 2 * result + this.getLeft();
        result = 2 * result + this.getRight();
        result = 2 * result + this.getTop();
        result = 2 * result + this.getBottom();
        result = 2 * result + this.getMode();
        return result;
    }

    @Override
    public boolean contains(int x, int y) {
        boolean result = false;
        switch (this.getMode()) {
            case 1: {
                if (y < this.getTop() || y > this.getBottom() || x < this.getLeft() || x > this.getRight()) break;
                result = true;
                break;
            }
            case 2: {
                if (y < this.getTop() || y > this.getBottom()) break;
                result = true;
                break;
            }
            case 4: {
                if (x < this.getLeft() || x > this.getRight()) break;
                result = true;
                break;
            }
            case 8: {
                result = true;
                break;
            }
        }
        return result;
    }

    public void order() {
        int temp;
        if (this.top > this.bottom) {
            temp = this.top;
            this.top = this.bottom;
            this.bottom = temp;
        }
        if (this.left > this.right) {
            temp = this.left;
            this.left = this.right;
            this.right = temp;
        }
    }

    public static IBlock change(KDTable table, IBlock selectBlock) {
        if (selectBlock.getMode() == 1) {
            return selectBlock;
        }
        int maxRow = table.getRowCount();
        int maxCol = table.getColumnCount();
        if (selectBlock.getMode() == 4) {
            selectBlock.setBottom(maxRow - 1);
            selectBlock.setRight(selectBlock.getRight());
        } else if (selectBlock.getMode() == 2) {
            selectBlock.setBottom(selectBlock.getBottom());
            selectBlock.setRight(maxCol - 1);
        } else if (selectBlock.getMode() == 8) {
            selectBlock.setTop(0);
            selectBlock.setLeft(0);
            selectBlock.setBottom(maxRow - 1);
            selectBlock.setRight(maxCol - 1);
        }
        selectBlock.setMode(1);
        return selectBlock;
    }

    @Override
    public int compareTo(KDTBlock o) {
        return this.top - o.getTop();
    }
}

