/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.kdf.table.KDTAbstractAction;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTVertical;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import java.awt.event.ActionEvent;

public class KDTPageChangeAction
extends KDTAbstractAction {
    private static final long serialVersionUID = 2483274330416769327L;
    public static final short DIR_UP = 0;
    public static final short DIR_DOWN = 1;
    private short dirCode;
    private boolean extend;

    public KDTPageChangeAction(KDTable table, short dirCode, boolean extend) {
        super(table);
        this.dirCode = dirCode;
        this.extend = extend;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.table.getEditManager().stopEditing();
        KDTSelectManager selectMan = this.table.getSelectManager();
        int verticalIndex = this.table.getViewManager().getVerticalIndex(selectMan.getActiveViewIndex());
        KDTVertical vertical = this.table.getLayoutManager().getVertical(verticalIndex);
        if (!this.extend) {
            if (!this.canTravel(vertical)) {
                return;
            }
            int firstIndex = 0;
            firstIndex = this.dirCode == 0 ? vertical.getFirstOfLastPage() : vertical.getFirstOfNextPage();
            int rowOffset = selectMan.getActiveRowIndex() - vertical.getFirst();
            vertical.scrollToPosition(firstIndex);
            int rowIndex = rowOffset + firstIndex;
            if (rowIndex > vertical.getLast2()) {
                rowIndex = vertical.getLast2();
            }
            int colIndex = selectMan.getActiveColumnIndex();
            if (rowIndex < 0) {
                rowIndex = 0;
            }
            selectMan.select(rowIndex, colIndex, rowIndex, colIndex);
        } else {
            int firstIndex = 0;
            int blockIndex = selectMan.getBlockIndexActiveCellIn();
            KDTSelectBlock block = (KDTSelectBlock)selectMan.getBlocks().get(blockIndex);
            int endRowIndex = block.getEndRow();
            selectMan.savePrevBlockCopy(block);
            firstIndex = this.dirCode == 0 ? vertical.getFirstOfLastPage() : vertical.getFirstOfNextPage();
            int rowOffset = endRowIndex - vertical.getFirst();
            if (firstIndex == vertical.getFirst()) {
                endRowIndex = firstIndex == 0 ? 0 : this.table.getRowCount1() - 1;
            } else {
                vertical.scrollToPosition(firstIndex);
                endRowIndex = rowOffset + firstIndex;
            }
            if (endRowIndex > vertical.getLast2()) {
                endRowIndex = vertical.getLast2();
            }
            KDTSelectBlock sb = new KDTSelectBlock();
            sb.setTop(block.getBeginRow());
            sb.setLeft(block.getBeginCol());
            sb.setBottom(endRowIndex);
            sb.setRight(block.getEndCol());
            sb.setMode(1);
            selectMan.set(blockIndex, sb, false);
        }
    }

    private boolean canTravel(KDTVertical vertical) {
        if (!this.isOnlySingleCellBolck()) {
            return true;
        }
        if (this.dirCode == 0 && vertical.getFirst() <= 0) {
            return false;
        }
        return this.dirCode != 1 || vertical.getLast() < this.table.getRowCount1() - 1;
    }

    private boolean isOnlySingleCellBolck() {
        if (this.table.getSelectManager().getBlocks().size() != 1) {
            return false;
        }
        KDTSelectBlock block = this.table.getSelectManager().get();
        return block.getBeginCol() == block.getEndCol() && block.getBeginRow() == block.getEndRow();
    }
}

