/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.kdf.table.KDTBody;
import com.kingdee.cosmic.ctrl.kdf.table.KDTRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTTreeColumnEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTTreeColumnListener;
import com.kingdee.cosmic.ctrl.kdf.util.render.CellTreeRenderer;
import com.kingdee.cosmic.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributesChangeEvent;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributesChangeListener;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;

public class KDTTreeColumn {
    private KDTable table;
    private KDTBody body;
    private IBasicRender renderer;
    private Style style = Styles.getDefaultStyle();
    private ShareStyleAttributes ssa = Styles.getEmptySSA();
    private int levelWidth = 13;
    private int depth;
    private int orientation = 0;
    StyleAttributesListener saListener = new StyleAttributesListener();

    public KDTTreeColumn(KDTable table) {
        this.table = table;
        this.body = table.getBody();
        KDTable.printDebugInfo("KDTTreeColumn-begin" + (System.currentTimeMillis() - KDTable.beginDate));
        KDTable.printDebugInfo("KDTTreeColumn-end" + (System.currentTimeMillis() - KDTable.beginDate));
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int i) {
        this.orientation = i;
    }

    public IBasicRender getRenderer() {
        if (this.renderer == null) {
            this.renderer = new CellTreeRenderer();
        }
        return this.renderer;
    }

    public void setRenderer(IBasicRender renderer) {
        this.renderer = renderer;
    }

    public StyleAttributes getStyleAttributes() {
        StyleAttributes sa = Styles.getSA((ShareStyleAttributes)this.ssa);
        sa.append((ShareStyleAttributes)this.style, false);
        sa.setOwner((Object)this);
        sa.setListener((StyleAttributesChangeListener)this.saListener);
        return sa;
    }

    Style getStyle() {
        return this.style;
    }

    void setStyle(Style style) {
        this.style = style;
    }

    ShareStyleAttributes getSSA() {
        return this.ssa;
    }

    void setSSA(ShareStyleAttributes ssa) {
        this.ssa = ssa;
    }

    int getRowHeight(int rowIndex) {
        return this.body.getRowHeight(rowIndex);
    }

    int getTreeLevel(int rowIndex) {
        KDTRow row = this.body.getRow2(rowIndex);
        return row == null ? -1 : row.getTreeLevel();
    }

    public int getLevelWidth() {
        return this.levelWidth;
    }

    public void setLevelWidth(int levelWidth) {
        this.levelWidth = levelWidth;
    }

    public int getWidth() {
        if (this.depth == 0) {
            return 0;
        }
        return this.depth * this.levelWidth + 6;
    }

    int getTreeIconType(int rowIndex) {
        if (this.isLeft(rowIndex)) {
            return 0;
        }
        if (this.body.getRow2(rowIndex).isCollapse()) {
            return 1;
        }
        return 2;
    }

    boolean isLeft(int rowIndex) {
        int level = this.body.getRow2(rowIndex).getTreeLevel();
        int nextIndex = this.orientation == 0 ? rowIndex + 1 : rowIndex - 1;
        KDTRow row = this.body.getRow(nextIndex);
        int nextLevel = row == null ? 0 : row.getTreeLevel();
        return level >= nextLevel;
    }

    void treeClick(int rowIndex) {
        if (this.isLeft(rowIndex)) {
            return;
        }
        boolean refresh = this.table.isRefresh();
        this.table.setRefresh(false);
        KDTRow row = this.body.getRow(rowIndex);
        boolean collapse = row.isCollapse();
        if (collapse) {
            row.setCollapse(false);
            this.doExpand(rowIndex);
        } else {
            this.doCollapse(rowIndex);
        }
        this.table.setRefresh(refresh);
        KDTTreeColumnEvent e = new KDTTreeColumnEvent(this.table, rowIndex, row.isCollapse(), row.getTreeLevel());
        this.fireStatusChange(e);
        this.table.repaint();
    }

    public void addKDTTreeColumnListener(KDTTreeColumnListener l) {
        this.table.getListenerList().add(KDTTreeColumnListener.class, l);
    }

    public void removeKDTTreeColumnListener(KDTTreeColumnListener l) {
        this.table.getListenerList().remove(KDTTreeColumnListener.class, l);
    }

    void fireStatusChange(KDTTreeColumnEvent e) {
        Object[] listeners = this.table.getListenerList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KDTTreeColumnListener.class) continue;
            ((KDTTreeColumnListener)listeners[i + 1]).statusChange(e);
        }
    }

    void doCollapse(int rowIndex) {
        KDTRow row = this.body.getRow(rowIndex);
        int level = row.getTreeLevel();
        boolean collapse = true;
        row.setCollapse(collapse);
        if (this.orientation == 0) {
            int nextIndex = rowIndex;
            while ((row = this.body.getRow(++nextIndex)) != null && row.getTreeLevel() > level) {
                this.table.getRow(nextIndex).getStyleAttributes().setHided(collapse);
            }
        } else {
            int nextIndex = rowIndex;
            while ((row = this.body.getRow(--nextIndex)) != null && row.getTreeLevel() > level) {
                this.table.getRow(nextIndex).getStyleAttributes().setHided(collapse);
            }
        }
    }

    void doExpand(int rowIndex) {
        KDTRow row = this.body.getRow(rowIndex);
        int level = row.getTreeLevel();
        boolean collapse = row.isCollapse();
        if (collapse) {
            return;
        }
        int nextIndex = rowIndex;
        if (this.orientation == 0) {
            while (true) {
                int nextLevel;
                int n = nextLevel = (row = this.body.getRow(++nextIndex)) == null ? -1 : row.getTreeLevel();
                if (nextLevel > level) {
                    if (nextLevel != level + 1) continue;
                    this.table.getRow(nextIndex).getStyleAttributes().setHided(false);
                    this.doExpand(nextIndex);
                    continue;
                }
                break;
            }
        } else {
            while (true) {
                int nextLevel;
                int n = nextLevel = (row = this.body.getRow(--nextIndex)) == null ? -1 : row.getTreeLevel();
                if (nextLevel <= level) break;
                if (nextLevel != level + 1) continue;
                this.table.getRow(nextIndex).getStyleAttributes().setHided(false);
                this.doExpand(nextIndex);
            }
        }
    }

    class StyleAttributesListener
    implements StyleAttributesChangeListener {
        StyleAttributesListener() {
        }

        public void changeStyleAttributes(StyleAttributesChangeEvent event) {
            StyleAttributes sa = event.getSA();
            KDTTreeColumn.this.ssa = Styles.getSSA((StyleAttributes)sa);
            KDTTreeColumn.this.style = Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{KDTTreeColumn.this.ssa});
            if (KDTTreeColumn.this.table.isRefresh()) {
                KDTTreeColumn.this.table.getViewManager().getView(1, 0).repaint();
            }
        }
    }
}

