/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDTableMessages;
import com.kingdee.cosmic.ctrl.kdf.form.Page;
import com.kingdee.cosmic.ctrl.kdf.printprovider.ScaleFactor;
import com.kingdee.cosmic.ctrl.kdf.table.TablePrintSet;
import com.kingdee.cosmic.ctrl.kdf.table.TablePrintSets;
import com.kingdee.cosmic.ctrl.kdf.util.file.IXmlTrans;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDF;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDFXmlReader;
import com.kingdee.cosmic.ctrl.print.config.xml.AbstractPrintAttributeTranslate;
import java.util.List;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;

public final class KDTablePrintSetXmlTrans
implements IXmlTrans {
    private KDF kdf;
    public static String TABLEPRINTS_NODENAME = "TablePrintSets";
    public static String TABLEPRINT_NODENAME = "TablePrintSet";
    public static String TABLEPRINT_NODESERVICENAME = "printerName";
    public static String TABLEPRINT_NODETABLESETUP = "tableSetup";
    public static String TABLEPRINT_NODEATTRIBUTESET = "attributeSet";

    public IXmlElement writeToNode(Object obj, KDF kdf) {
        if (obj instanceof TablePrintSets) {
            return this.outTablePrintSets(kdf);
        }
        throw new IllegalArgumentException(CtrlKDTableMessages.getMLS("TablePrintSetsSerializerAcceptsOnlyTablePrintSetsType", "TablePrintSets\u7684\u5e8f\u5217\u5316\u5668\u53ea\u80fd\u63a5\u53d7TablePrintSets\u7c7b\u578b\u7684\u53c2\u6570"));
    }

    private IXmlElement outTablePrintSets(KDF kdf) {
        TablePrintSets sets = (TablePrintSets)kdf.getTablePrintSets();
        if (sets.isEmpty()) {
            return null;
        }
        this.kdf = kdf;
        IXmlElement nodePrints = XmlUtil.createNode((String)TABLEPRINTS_NODENAME);
        Object[] setArray = sets.getTablePrintSets();
        for (int i = 0; i < setArray.length; ++i) {
            TablePrintSet set = (TablePrintSet)setArray[i];
            IXmlElement nodePrint = this.outTablePrintSet(set);
            nodePrints.addChild(nodePrint);
        }
        return nodePrints;
    }

    private IXmlElement outTablePrintSet(TablePrintSet set) {
        IXmlElement nodePrint = XmlUtil.createNode((String)TABLEPRINT_NODENAME);
        nodePrint.setAttribute("id", set.getTableID());
        if (set.getHeaderID() != null) {
            nodePrint.setAttribute("headerid", set.getHeaderID());
        }
        if (set.getFooterID() != null) {
            nodePrint.setAttribute("footerid", set.getFooterID());
        }
        this.outPrinter(set, nodePrint);
        this.outTableSetup(set, nodePrint);
        this.outPrintAttributes(set, nodePrint);
        return nodePrint;
    }

    private void outPrintAttributes(TablePrintSet set, IXmlElement nodePrint) {
        AttributeSet aset = set.getAttributeSet();
        if (aset == null) {
            return;
        }
        IXmlElement nodeAttributeSet = XmlUtil.createNode((String)TABLEPRINT_NODEATTRIBUTESET);
        nodePrint.addChild(nodeAttributeSet);
        Attribute[] attriArray = aset.toArray();
        for (int i = 0; i < attriArray.length; ++i) {
            Attribute attri = attriArray[i];
            IXmlElement printAttributeNode = KDTablePrintSetXmlTrans.outPrintAttribute(attri);
            nodeAttributeSet.addChild(printAttributeNode);
        }
    }

    private void outTableSetup(TablePrintSet set, IXmlElement nodePrint) {
        int tablePrintSetup = set.getTablePrintSetup();
        if (tablePrintSetup != -1) {
            IXmlElement nodeTablePrinSetup = XmlUtil.createNode((String)TABLEPRINT_NODETABLESETUP);
            nodeTablePrinSetup.addCData("" + tablePrintSetup);
            nodePrint.addChild(nodeTablePrinSetup);
        }
    }

    private void outPrinter(TablePrintSet set, IXmlElement nodePrint) {
        String printername = set.getPrintServiceName();
        if (!StringUtil.isEmptyString((String)printername)) {
            IXmlElement nodePrintServiceName = XmlUtil.createNode((String)TABLEPRINT_NODESERVICENAME);
            nodePrintServiceName.addCData(printername);
            nodePrint.addChild(nodePrintServiceName);
        }
    }

    private Object readTablePrintSetsFromNode(IXmlElement ele, KDFXmlReader reader2) {
        TablePrintSets tablePrintSets = new TablePrintSets();
        List children = ele.getChildren();
        for (IXmlElement e : children) {
            Page[] footers;
            Page[] headers;
            TablePrintSet set = this.readTablePrintSetFromNode(e, reader2);
            tablePrintSets.addTablePrintSet(set);
            Page header = this.kdf.getHeader(set != null ? set.getHeaderID() : null);
            if (header == null && (headers = this.kdf.getHeaders()).length > 0) {
                header = headers[0];
            }
            if (set == null) continue;
            set.setHeader(header);
            Page footer = this.kdf.getFooter(set.getFooterID());
            if (header == null && (footers = this.kdf.getFooters()).length > 0) {
                footer = footers[0];
            }
            set.setFooter(footer);
        }
        return tablePrintSets;
    }

    private TablePrintSet readTablePrintSetFromNode(IXmlElement e, KDFXmlReader reader2) {
        AttributeSet set;
        IXmlElement attributeSetNode;
        IXmlElement tableSetupNode;
        String name = e.getName();
        if (!name.equals(TABLEPRINT_NODENAME)) {
            return null;
        }
        IXmlElement printerNode = e.getChild(TABLEPRINT_NODESERVICENAME);
        String id = e.getAttribute("id");
        TablePrintSet tablePrintSet = new TablePrintSet(id);
        String headerid = e.getAttribute("headerid");
        String footerid = e.getAttribute("footerid");
        tablePrintSet.setHeaderID(headerid);
        tablePrintSet.setFooterID(footerid);
        if (printerNode != null) {
            tablePrintSet.setPrintServiceName(printerNode.getText());
        }
        if ((tableSetupNode = e.getChild(TABLEPRINT_NODETABLESETUP)) != null) {
            tablePrintSet.setTablePrintSetup(Integer.parseInt(tableSetupNode.getText()));
        }
        if ((attributeSetNode = e.getChild(TABLEPRINT_NODEATTRIBUTESET)) != null && (set = this.readAttributeSetFromNode(attributeSetNode)) != null) {
            tablePrintSet.setAttributeSet(set);
        }
        return tablePrintSet;
    }

    public Object readFromNode(IXmlElement ele, KDF kdf) {
        this.kdf = kdf;
        if (TABLEPRINTS_NODENAME.equals(ele.getName())) {
            return this.readTablePrintSetsFromNode(ele, kdf.getReader());
        }
        return null;
    }

    private static IXmlElement outPrintAttribute(Attribute attri) {
        Class<? extends Attribute> category = attri.getCategory();
        IXmlElement nodeAttribute = XmlUtil.createNode((String)attri.getName());
        if (category == Copies.class) {
            nodeAttribute.addCData("" + ((Copies)attri).getValue());
        } else if (category == JobName.class) {
            nodeAttribute.addCData(((JobName)attri).getValue());
        } else if (category == ScaleFactor.class) {
            nodeAttribute.addCData("" + ((ScaleFactor)attri).getFactor());
        } else if (category == PageRanges.class) {
            int[][] members = ((PageRanges)attri).getMembers();
            nodeAttribute.setAttribute("min", "" + members[0][0]);
            nodeAttribute.setAttribute("max", "" + members[0][1]);
        } else if (category == OrientationRequested.class) {
            nodeAttribute.addCData("" + ((OrientationRequested)attri).getValue());
        } else if (category == MediaPrintableArea.class) {
            nodeAttribute.setAttribute("units", "1000");
            nodeAttribute.setAttribute("x", "" + ((MediaPrintableArea)attri).getX(1000));
            nodeAttribute.setAttribute("y", "" + ((MediaPrintableArea)attri).getY(1000));
            nodeAttribute.setAttribute("width", "" + ((MediaPrintableArea)attri).getWidth(1000));
            nodeAttribute.setAttribute("height", "" + ((MediaPrintableArea)attri).getHeight(1000));
        } else if (category == Chromaticity.class) {
            nodeAttribute.addCData("" + ((Chromaticity)attri).getValue());
        } else if (category == Media.class) {
            nodeAttribute.addCData("" + ((Media)attri).getValue());
        } else if (category == Sides.class) {
            nodeAttribute.addCData("" + ((Sides)attri).getValue());
        } else if (category == RequestingUserName.class) {
            nodeAttribute.addCData("" + ((RequestingUserName)attri).getValue());
        } else if (category == SheetCollate.class) {
            nodeAttribute.addCData("" + ((SheetCollate)attri).getValue());
        }
        return nodeAttribute;
    }

    private AttributeSet readAttributeSetFromNode(IXmlElement attributeSetNode) {
        List children = attributeSetNode.getChildren();
        HashPrintRequestAttributeSet set = new HashPrintRequestAttributeSet();
        int length = children.size();
        for (int i = 0; i < length; ++i) {
            IXmlElement childElement = (IXmlElement)children.get(i);
            Attribute attri = KDTablePrintSetXmlTrans.readAttributeFromNode(childElement);
            if (attri == null) continue;
            set.add(attri);
        }
        return set;
    }

    private static Attribute readAttributeFromNode(IXmlElement childElement) {
        String name = childElement.getName();
        Attribute attri = new Copies(1);
        if (attri.getName().equals(name)) {
            attri = new Copies(Integer.parseInt(childElement.getText()));
        } else if (new JobName("", null).getName().equals(name)) {
            attri = new JobName(childElement.getText(), null);
        } else if (new ScaleFactor(1.0f).getName().equals(name)) {
            attri = new ScaleFactor(Float.parseFloat(childElement.getText()));
        } else if (new PageRanges(1).getName().equals(name)) {
            String minV = childElement.getAttribute("min");
            int min = Integer.parseInt(minV);
            String maxV = childElement.getAttribute("max");
            int max = Integer.parseInt(maxV);
            attri = new PageRanges(min, max);
        } else if (OrientationRequested.PORTRAIT.getName().equals(name)) {
            int value = Integer.parseInt(childElement.getText());
            attri = OrientationRequested.PORTRAIT.getValue() == value ? OrientationRequested.PORTRAIT : OrientationRequested.LANDSCAPE;
        } else if (new MediaPrintableArea(0, 0, 3, 3, 1000).getName().equals(name)) {
            String units = childElement.getAttribute("units");
            String x = childElement.getAttribute("x");
            String y = childElement.getAttribute("y");
            String width = childElement.getAttribute("width");
            String height = childElement.getAttribute("height");
            attri = new MediaPrintableArea(Float.parseFloat(x), Float.parseFloat(y), Float.parseFloat(width), Float.parseFloat(height), Integer.parseInt(units));
        } else if (Chromaticity.COLOR.getName().equals(name)) {
            int value = Integer.parseInt(childElement.getText());
            attri = Chromaticity.COLOR.getValue() == value ? Chromaticity.COLOR : Chromaticity.MONOCHROME;
        } else if (MediaSizeName.ISO_A4.getName().equals(name)) {
            attri = AbstractPrintAttributeTranslate.getMediaSizeNameByValue((IXmlElement)childElement);
        } else if (Sides.DUPLEX.getName().equals(name)) {
            int value = Integer.parseInt(childElement.getText());
            attri = KDTablePrintSetXmlTrans.getSidesByValue(value);
        } else if (new RequestingUserName("", null).getName().equals(name)) {
            attri = new RequestingUserName(childElement.getText(), null);
        } else if (SheetCollate.COLLATED.getName().equals(name)) {
            int value = Integer.parseInt(childElement.getText());
            attri = SheetCollate.COLLATED.getValue() == value ? SheetCollate.COLLATED : SheetCollate.UNCOLLATED;
        }
        return attri;
    }

    private static Attribute getSidesByValue(int value) {
        if (Sides.DUPLEX.getValue() == value) {
            return Sides.DUPLEX;
        }
        if (Sides.ONE_SIDED.getValue() == value) {
            return Sides.ONE_SIDED;
        }
        if (Sides.TUMBLE.getValue() == value) {
            return Sides.TUMBLE;
        }
        if (Sides.TWO_SIDED_LONG_EDGE.getValue() == value) {
            return Sides.TWO_SIDED_LONG_EDGE;
        }
        if (Sides.TWO_SIDED_SHORT_EDGE.getValue() == value) {
            return Sides.TWO_SIDED_SHORT_EDGE;
        }
        return null;
    }
}

