/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.common.util.ObjectUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.table.ICell;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.SAXBasicTableHandler;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SAXCellHandler
extends SAXBasicTableHandler {
    private static final int NONE = 0;
    private static final int VALUE = 1;
    private static final int FORMAT_VALUE = 2;
    private static final int USEROBJECT = 3;
    private static final int EXPRESSION = 4;
    private static final int TEXT = 5;
    int cellIndex = 0;
    private ICell objCell;
    private int subNode = 0;
    private String valueType = null;
    private String text = null;
    private String content = null;

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        if ("t:Cell".equals(qName)) {
            int index = this.cellIndex;
            String value = attrs.getValue("t:index");
            if (!StringUtil.isEmptyString((String)value)) {
                this.cellIndex = index = Integer.parseInt(value);
            }
            IRow row = null;
            ICell cell = null;
            if (index < this.table.getColumnCount()) {
                if (this.parent instanceof IRow) {
                    row = (IRow)this.parent;
                    cell = row.getCell(index);
                }
                if (cell != null && this.kdf.isStyle()) {
                    ShareStyleAttributes colssa;
                    ShareStyleAttributes tblssa;
                    if (row.getRowType() == 0) {
                        tblssa = this.getTable().getHeadSSA();
                        colssa = Styles.getEmptySSA();
                    } else {
                        tblssa = this.getTable().getSSA();
                        colssa = this.getTable().getColumn(index).getKDTColumn().getSSA();
                    }
                    this.fillCellAttributes(cell, attrs, tblssa, row.getKDTRow().getSSA(), colssa);
                }
            }
            this.objCell = cell;
            this.subNode = 5;
        } else if ("t:Value".equals(qName)) {
            this.subNode = 1;
            this.content = null;
            this.valueType = attrs.getValue("t:type");
        } else if ("t:FormattedValue".equals(qName)) {
            this.subNode = 2;
            this.content = null;
            this.valueType = attrs.getValue("t:type");
        } else if ("t:UserObject".equals(qName) && this.kdf.isUserObject()) {
            this.subNode = 3;
            this.content = null;
            this.valueType = attrs.getValue("t:type");
        } else if ("t:Expression".equals(qName)) {
            this.subNode = 4;
            this.content = null;
        } else {
            this.subNode = 0;
            this.content = null;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.subNode == 0) {
            return;
        }
        String attVal = new String(ch, start, length);
        this.content = this.content == null ? attVal : this.content + attVal;
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        String attVal = this.content;
        this.content = null;
        if (this.subNode == 5) {
            this.text = attVal;
        } else {
            this.text = null;
            if (this.objCell != null) {
                switch (this.subNode) {
                    case 1: {
                        if ("string".equalsIgnoreCase(this.valueType)) {
                            if (StringUtil.isEmptyString((String)attVal)) {
                                this.objCell.getKDTCell().setValue(null);
                                break;
                            }
                            this.objCell.getKDTCell().setValue(attVal);
                            break;
                        }
                        Object obj = ObjectUtil.stringToObject((String)attVal);
                        if (obj != null) {
                            if (obj instanceof String && StringUtil.isEmptyString((String)((String)obj))) {
                                this.objCell.getKDTCell().setValue(null);
                                break;
                            }
                            this.objCell.getKDTCell().setValue(obj);
                            break;
                        }
                        if (attVal == null) break;
                        if (StringUtil.isEmptyString((String)attVal)) {
                            this.objCell.getKDTCell().setValue(null);
                            break;
                        }
                        this.objCell.getKDTCell().setValue(attVal);
                        break;
                    }
                    case 2: {
                        if ("string".equalsIgnoreCase(this.valueType)) {
                            if (attVal == null) break;
                            this.objCell.getKDTCell().setFormattedValue(attVal);
                            break;
                        }
                        Object obj = ObjectUtil.stringToObject((String)attVal);
                        if (obj == null) break;
                        this.objCell.getKDTCell().setFormattedValue(obj);
                        break;
                    }
                    case 3: {
                        if ("string".equalsIgnoreCase(this.valueType)) {
                            if (attVal == null) break;
                            this.objCell.getKDTCell().setUserObject(attVal);
                            break;
                        }
                        Object obj = ObjectUtil.stringToObject((String)attVal);
                        if (obj == null) break;
                        this.objCell.getKDTCell().setUserObject(obj);
                        break;
                    }
                    case 4: {
                        if (StringUtil.isEmptyString((String)attVal)) break;
                        this.objCell.setExpressions(attVal);
                        break;
                    }
                }
            }
        }
        super.endElement(namespaceURI, sName, qName);
        if ("t:Cell".equals(qName)) {
            if (!StringUtil.isEmptyString((String)this.text)) {
                this.objCell.setValue(this.text);
            }
            ++this.cellIndex;
            this.objCell = null;
        }
        this.subNode = 0;
        this.valueType = null;
    }

    private void fillCellAttributes(ICell objCell, Attributes attrs, ShareStyleAttributes tableSSA, ShareStyleAttributes rowSSA, ShareStyleAttributes colSSA) {
        ShareStyleAttributes ssa = null;
        ShareStyleAttributes fssa = null;
        String attVal = attrs.getValue("t:styleID");
        if (!StringUtil.isEmptyString((String)attVal)) {
            ssa = this.getKDF().getStyleAttributes(attVal.trim());
            objCell.getKDTCell().setSSA(ssa);
        }
        if (!StringUtil.isEmptyString((String)(attVal = attrs.getValue("t:formattedStyleID")))) {
            fssa = this.getKDF().getStyleAttributes(attVal.trim());
            objCell.getKDTCell().setFormattedSSA(ssa);
        }
        if (ssa != null) {
            if (fssa != null) {
                objCell.getKDTCell().setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{fssa, ssa, rowSSA, colSSA, tableSSA}));
            } else {
                objCell.getKDTCell().setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, rowSSA, colSSA, tableSSA}));
            }
        }
    }
}

