/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.common.util.ObjectUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.SAXBasicTableHandler;
import com.kingdee.cosmic.ctrl.kdf.table.SAXCellHandler;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SAXRowHandler
extends SAXBasicTableHandler {
    int rowIndex = 0;
    private boolean bUserObject = false;

    public SAXRowHandler() {
        this.handlerMap = new HashMap();
        this.handlerMap.put("t:Cell", new SAXCellHandler());
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        if ("t:Row".equals(qName)) {
            this.initCellHandler();
            IRow row = null;
            if (this.isHead()) {
                row = this.getTable().addHeadRow();
            } else if (this.isBody()) {
                row = this.getTable().addRow();
            }
            this.current = row;
            if (row == null) {
                return;
            }
            ShareStyleAttributes ssa = this.getTable().getHeadSSA();
            this.fillRowAttributes(row, attrs, ssa);
        } else {
            super.startElement(namespaceURI, sName, qName, attrs);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.bUserObject) {
            String s = new String(ch, start, length);
            Object uo = ObjectUtil.stringToObject((String)s);
            if (uo != null) {
                this.getTable().getRow(this.rowIndex).setUserObject(uo);
            }
        } else {
            super.characters(ch, start, length);
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        super.endElement(namespaceURI, sName, qName);
        if ("t:UserObject".equals(qName)) {
            this.bUserObject = false;
        } else if ("t:Row".equals(qName)) {
            ++this.rowIndex;
            this.current = null;
        } else if ("t:Cell".equals(qName)) {
            this.currentHandler = null;
        }
    }

    private void fillRowAttributes(IRow objTable, Attributes attrs, ShareStyleAttributes fatherSSA) {
        String attVal = attrs.getValue("t:height");
        if (!StringUtil.isEmptyString((String)attVal)) {
            objTable.setHeight(Integer.parseInt(attVal));
        }
        if (!StringUtil.isEmptyString((String)(attVal = attrs.getValue("t:mergeable")))) {
            objTable.setMergeable(StringUtil.getBooleanFromString((String)attVal));
        }
        if (!StringUtil.isEmptyString((String)(attVal = attrs.getValue("t:resizeable")))) {
            objTable.setResizeable(StringUtil.getBooleanFromString((String)attVal));
        }
        if (!StringUtil.isEmptyString((String)(attVal = attrs.getValue("t:styleID")))) {
            ShareStyleAttributes ssa = this.getKDF().getStyleAttributes(attVal.trim());
            objTable.getKDTRow().setSSA(ssa);
            objTable.getKDTRow().setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, fatherSSA}));
        }
    }

    void initCellHandler() {
        Object obj = this.handlerMap.get("t:Cell");
        if (obj instanceof SAXCellHandler) {
            ((SAXCellHandler)obj).cellIndex = 0;
        }
    }

    boolean isHead() {
        return this.parent instanceof Integer && (Integer)this.parent == 0;
    }

    boolean isBody() {
        return this.parent instanceof Integer && (Integer)this.parent == 1;
    }
}

