/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table.component;

import com.kingdee.cosmic.ctrl.kdf.table.component.SelectComponent;
import com.kingdee.cosmic.ctrl.kdf.table.component.SelectComponentUI;
import com.kingdee.cosmic.ctrl.kdf.table.icons.ResourceManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.plaf.ComponentUI;

public class BasicSelectComponentUI
extends SelectComponentUI {
    protected static final ImageIcon ICON_ENABLE = ResourceManager.getImageIcon("selectcomponent_enable.gif");
    protected static final ImageIcon ICON_DISABLE = ResourceManager.getImageIcon("selectcomponent_disable.gif");
    private SelectComponent selectComp;
    private JButton btnIcon;
    private JTextField editor;
    private ActionListener btnAction;
    private KeyListener keyHandler;

    public static ComponentUI createUI(JComponent c) {
        return new BasicSelectComponentUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.selectComp = (SelectComponent)c;
        this.installComponents();
        this.installListeners();
        this.selectComp.setLayout(new SelectCompLayoutManager());
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.selectComp = null;
    }

    void installListeners() {
        this.btnAction = new ButtonAction();
        this.keyHandler = new KeyHandler();
        this.editor.addKeyListener(this.keyHandler);
        this.btnIcon.addActionListener(this.btnAction);
    }

    void uninstallListeners() {
        this.btnIcon.removeActionListener(this.btnAction);
        this.editor.removeKeyListener(this.keyHandler);
        this.btnAction = null;
        this.keyHandler = null;
    }

    void installComponents() {
        this.btnIcon = this.selectComp.getButton();
        this.btnIcon.setIcon(ICON_ENABLE);
        this.btnIcon.setDisabledIcon(ICON_DISABLE);
        this.editor = this.selectComp.getEditor();
        this.selectComp.add(this.editor);
        this.selectComp.add(this.btnIcon);
    }

    void uninstallComponents() {
        this.selectComp.removeAll();
        this.btnIcon = null;
        this.editor = null;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(120, 22);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    protected Rectangle rectangleForCurrentValue() {
        int width = this.selectComp.getWidth();
        int height = this.selectComp.getHeight();
        Insets insets = this.selectComp.getInsets();
        int buttonSize = height - (insets.top + insets.bottom);
        if (this.btnIcon != null) {
            buttonSize = this.btnIcon.getWidth();
        }
        if (this.selectComp.getComponentOrientation().isLeftToRight()) {
            return new Rectangle(insets.left, insets.top, width - (insets.left + insets.right + buttonSize), height - (insets.top + insets.bottom));
        }
        return new Rectangle(insets.left + buttonSize, insets.top, width - (insets.left + insets.right + buttonSize), height - (insets.top + insets.bottom));
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (118 == e.getKeyCode()) {
                BasicSelectComponentUI.this.selectComp.openOppositeWindow();
            }
        }
    }

    class ButtonAction
    implements ActionListener {
        ButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicSelectComponentUI.this.selectComp.openOppositeWindow();
        }
    }

    public class SelectCompLayoutManager
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return parent.getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return parent.getMinimumSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            SelectComponent cb = (SelectComponent)parent;
            int width = cb.getWidth();
            int height = cb.getHeight();
            Insets insets = cb.getInsets();
            int buttonSize = height - (insets.top + insets.bottom);
            if (BasicSelectComponentUI.this.btnIcon != null) {
                if (cb.getComponentOrientation().isLeftToRight()) {
                    BasicSelectComponentUI.this.btnIcon.setBounds(width - (insets.right + buttonSize), insets.top, buttonSize, buttonSize);
                } else {
                    BasicSelectComponentUI.this.btnIcon.setBounds(insets.left, insets.top, buttonSize, buttonSize);
                }
            }
            if (BasicSelectComponentUI.this.editor != null) {
                Rectangle cvb = BasicSelectComponentUI.this.rectangleForCurrentValue();
                BasicSelectComponentUI.this.editor.setBounds(cvb);
            }
        }
    }
}

